<?php defined( 'ABSPATH' ) || exit; ?>

<script>
var autoConfirm = '<?php echo esc_attr(self::$public_options['_dlr_auto_confirm']); ?>';
</script>

<div id="dlr-login" class="tabcontent active">
<?php 

if( !isset($_POST['dlr-checkCode-forget']) || get_transient('wrongCode') == true ): 
?>    	    
<form 
method="post" 
action="" 
autocomplete="off" 
id="checkConfirm"
onsubmit="return confirmValidate();"
>

	<div class="dlr-login-input">
	    
	    <label class="dlr-login-text" for="codeBox1">
		    <span class="star">*</span>
		    <?php echo __('Enter the code sent to your mobile', 'dlr'); ?>
		</label>
	    
		<div class="dlr-login-input-field-wrapper confirmCode">
		    
		    <input name="userCode" id="userCode" type="hidden" value="" />
		    
			<?php 
			$codes = esc_attr(get_option('_dlr_number_of_codes', 4));
			for ( $i=0; $i<$codes; $i++ ):
				$form_width = self::$public_options['_dlr_form_width'];
				$margin = $codes * 8;
				$width = $form_width - 50 - $margin;
				$style = 'width: '.($width/$codes).'px;height: '.($width/$codes).'px';
				?>
				<input class="codeBox" style="<?php echo $style; ?>" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" id="codeBox<?php echo ($i+1); ?>" onkeypress="repeatCodeAgain()" <?php if($i==0) echo 'autofocus'; ?> type="tel" maxlength="1" onkeyup="onKeyUpEvent(<?php echo ($i+1); ?>, event)" onfocus="onFocusEvent(<?php echo ($i+1); ?>)"/>
				<?php
			endfor;
			?>
			
			<input name="codeMobile" type="hidden" id="codeMobile" />
			
		</div>

	</div>
	<?php 
	if(get_transient('wrongCode')) {
	    echo '<div id="code-alert" class="code-alert">'.__('The code entered is incorrect.', 'dlr').'</div>';
	    set_transient('wrongCode', false);
	}
	?>
	<div class="login-register-alert"></div>

	<button 
		   type="submit" 
		   id="continueCode" 
		   name="dlr-checkCode-forget" 
		   class="dlr-login-button"
	>
	    <div class="lds-ellipsis" id="confirm-loader"><div></div><div></div><div></div><div></div></div>
        
        <span id="confirm-continue"><?php echo __('Next', 'dlr'); ?></span>
	</button>
	<div id="endTimeCode">
	    <?php echo __('Your time is up', 'dlr'); ?>
	</div>
	
	<span id="time">--:--</span>

</form>

<form
method="post"
action=""
onsubmit="return repeatValidate();"
id="dlr-repeat-form"
></form>
<script>
        var mobile = localStorage.getItem('dlr-mobile');
        document.getElementById('codeMobile1').value = localStorage.getItem('dlr-mobile');
        document.getElementById('codeMobile').value = localStorage.getItem('dlr-mobile');
    </script>
</div>

<?php 
else: 
	require dirname(__FILE__) . '/new-pass.php';
endif;