<?php
defined('ABSPATH') or die;
if(self::$public_options['_dlr_display_header'] == 1 ) get_header();
$referrer = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : home_url();
if ( isset($_COOKIE['dlrback']) ) 
{
	$urll = $_COOKIE['dlrback'];
}
else {
	setcookie('dlrback', $referrer, time()+10000);
	$urll = $referrer;
}
?>
<!DOCTYPE html>
<html dir="rtl">
    
    <head>
      <meta name="viewport" content="width=device-width, initial-scale=1">
      <meta charset="utf-8">
      <title><?php echo __('Login/Register', 'dlr'); ?></title>
      <link rel="stylesheet" href="<?php echo DLR_BASE_URL . 'public/css/dlr-public.css' ?>" />
      <script>
          var sendAgainBtnValue = '<?php echo __("Resend the code", "dlr"); ?>';
      </script>
	  <?php echo self::dlr_js_errors(); ?>
      <link rel="shortcut icon" href="<?php echo esc_attr(self::$public_options['_dlr_favicon']); ?>" type="image/icon">

	  <?php if(!is_rtl()): ?>
      <link rel="preconnect" href="https://fonts.googleapis.com">
      <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
      <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400&display=swap" rel="stylesheet">
	  <?php endif; ?>

      <?php echo '<style>'.esc_attr(self::$public_options['_dlr_extra_style']).'</style>';?>

	  <?php echo self::dlr_public_font(); ?>
      
      <?php 
      if( self::$public_options['_dlr_background_image'] !== '' ) {
          echo '<style>#dlr-box{border: 2px solid #fff; box-shadow: 0px 4px 31px 18px #1217391f;}</style>';
          
      }
      if( self::$public_options['_dlr_button_image'] == 1 ) {
          echo '<style> .dlr-login-button { background:url('.esc_attr(self::$public_options["_dlr_background_image"]).'), '.esc_attr(self::$public_options["_dlr_color"]).' !important; background-position: center center !important;}</style>';
      }else {
          echo '<style>.dlr-login-button {background:'.esc_attr(self::$public_options["_dlr_color"]).'}</style>';
      }
      
      if( self::$public_options['_dlr_design_type'] == 'classic' )
      {
          ?>
          <style>
          #dlr-header #dlr-tab {
            border: none !important;
            max-width: 100% !important;
            margin: 0 !important;
            border-radius: 0 !important;
            box-shadow: none !important;
          }
          #dlr-box {
            border-radius: 15px !important;
            overflow: hidden !important;
          }
          #dlr-header-wrapper {
            margin-bottom: 15px !important;
          }
          #dlr-header {
              margin-bottom: 14px !important;
          }
          .dlr-login-input-field {
            border-radius: 8px !important;
            border: 1px solid #bbb !important;
          }
          .dlr-login-button {
              border-radius: 8px !important;
          }
          .login-register-alert, .register-register-alert, .recovery-alert, .forceLogin {
              border-radius: 5px !important;
          }
          </style>
          <?php
      } 

	  echo '<style>#dlr-box {width: '.esc_attr(self::$public_options['_dlr_form_width']).'px !important;}</style>';

      if( esc_attr(self::$public_options['_dlr_dark_mode_status']) == 1 )
        echo '<link rel="stylesheet" href="'. DLR_BASE_URL .'public/css/dlr-dark.css" />';
        
      if( is_rtl() )
        echo '<link rel="stylesheet" href="'. DLR_BASE_URL .'public/css/dlr-rtl-public.css" />';
        
        
      if(   esc_attr(self::$public_options['_dlr_google_captcha_in_login_form']) == 1 || 
            esc_attr(self::$public_options['_dlr_google_captcha_in_register_form']) == 1 || 
            esc_attr(self::$public_options['_dlr_google_captcha_in_recovery_form']) == 1 )
            {
          $lang = is_rtl() ? '?hl=fa' : '';
          echo '<script src="https://www.google.com/recaptcha/api.js'.$lang.'" async defer></script>';
      }
      ?>
    </head>
   
    <body 
    style="<?php echo 'background-image:url('. esc_attr(self::$public_options['_dlr_background_image']).')' ; ?>"
    class="<?php if( esc_attr(self::$public_options['_dlr_dark_mode_status']) == 1 ) echo 'dark'; ?>">

	<!-- js varianles -->
	<input type="hidden" id="_dlr_auto_confirm" value="<?php echo esc_attr(self::$public_options['_dlr_auto_confirm']); ?>" />
	<input type="hidden" id="_dlr_number_of_codes" value="<?php echo esc_attr(get_option('_dlr_number_of_codes', 4)); ?>" />
	<input type="hidden" id="_dlr_resend_time" value="<?php echo esc_attr(get_option('_dlr_resend_code_time', 120)); ?>" />

	<?php 
	if ( esc_attr(self::$public_options['_dlr_display_return_back_btn']) == 1 ) : 
	?>
	<a class="dlr_return_back" href="<?php echo $urll; ?>">
	<span>→</span>
	<?php echo esc_attr(self::$public_options['_dlr_return_back_btn_text']); ?>
	</a>
	<?php endif; ?>
        
        <style>
            .tablinks.active{
            	background: <?php echo esc_attr(self::$public_options['_dlr_color_tab']); ?> !important;
            	color: #fff !important;
            }
        </style>
       
    <main>
      
        <div id="dlr-box">
      
            <div id="dlr-header-wrapper">
    
                <header id="dlr-header">
                    
                	<?php if( ! isset( $_GET['type'] ) ): ?>
                	
                	<div id="dlr-tab">
                	    
                		<?php if( self::is_login_active() ): ?>
                		    <button type="button" id="dlr_login_tab" class="tablinks active" onclick="openTab(event, 'dlr-login')">
                		        <?php
                		        if( esc_attr(self::$public_options['_dlr_register_status']) == 1 || esc_attr(self::$public_options['_dlr_register_in_login_form']) != 1 ):
                		            echo __('Login', 'dlr');
                		        else:
                		            echo __('Login/Register', 'dlr');
                		        endif;
                		        ?>
                		    </button>
                		<?php endif;?>
                		
                		<?php if( esc_attr(self::$public_options['_dlr_register_status']) == 1 ): ?>
                		    <button type="button" id="dlr_register_tab" class="tablinks <?php if( ! self::is_login_active() ) { echo 'active'; } ?>" onclick="openTab(event, 'dlr-register')"><?php echo __('Register', 'dlr'); ?></button>
                		<?php endif;?>
                		
                	</div>
                	
                	<?php else: ?>
                	
                		<div class="set_code">
                		    
                			<span> 
                			<?php echo self::dlr_form_title(); ?> 
                			</span>
                			
                			<a href="<?php echo self::backArrowUrl(); ?>" id="dlr-back-icon">
                				<svg width="19px" viewBox="0 0 48 48"><path d="M44,26H2a2,2,0,0,1,0-4H44A2,2,0,0,1,44,26Z" fill="#3ec2bd"/>
                				    <path d="M28,43a2,2,0,0,1-1.41-3.41L42.19,24,26.62,8.43A2,2,0,0,1,29.44,5.6l17,17A2,2,0,0,1,47,24a2.07,2.07,0,0,1-.59,1.44l-17,17A2,2,0,0,1,28,43Z" fill="#3ec2bd"/>
                				</svg> 
                			</a>
                			
                		</div>
                		
                	<?php endif; ?>
                
                </header>
                
                <?php  if( self::$public_options['_dlr_logo'] !== false && self::$public_options['_dlr_logo'] !== null && self::$public_options['_dlr_logo'] !== '' ): ?>
                <a href="<?php echo bloginfo('url'); ?>">
                	<img class="skip-lazy" src="<?php echo esc_attr(self::$public_options['_dlr_logo']); ?>">
                </a>
                <?php endif; 
				
				if( isset($_GET['action']) && $_GET['action']=='block' ) 
				{
					echo '<div id="code-alert" class="code-alert code-alert-block">';
						echo __("Your access to this site is restricted. Please contact the site administrator.", "dlr");
					echo '</div>';
				}
				
				?>
            </div>