<?php defined( 'ABSPATH' ) || exit; ?>

<form 
autocomplete="off"
method="post" 
action="?type=changepass" 
id="dlr-login-form"
onsubmit="return forgetPassValidate();"
type="search"
>

	<script>
	function forgetPassValidate()
	{
		const newpass = document.querySelector('#newPass').value;
		const newpassagain = document.querySelector('#newPassAgain').value;

		const errorBox = document.querySelector('.login-register-alert');

		if( newpass != newpassagain )
		{ 
			errorBox.innerHTML = error8;
			errorBox.setAttribute('style', 'display: block !important');
			return false;
		}

		<?php if ( self::$public_options['_dlr_password_rules_ten_character'] ): ?>
		if( newpass.length < 10 )
		{ 
			errorBox.innerHTML = error9;
			errorBox.setAttribute('style', 'display: block !important');
			return false;
		}
		<?php endif; ?>
		
		<?php if ( self::$public_options['_dlr_password_rules_one_letter'] ): ?>
		if ( !newpass.match(/[a-zA-Z]+/) )
		{
			errorBox.innerHTML = error10;
			errorBox.setAttribute('style', 'display: block !important');
			return false;
		}
		<?php endif; ?>

		<?php if ( self::$public_options['_dlr_password_rules_one_specials'] ): ?>
		if ( !newpass.match(/[$@#&!_]+/) ) 
		{
			errorBox.innerHTML = error11;
			errorBox.setAttribute('style', 'display: block !important');
			return false;
		}
		<?php endif; ?>
	}
	</script>

	<div class="dlr-login-input">
		
		<?php 
		if(isset($_GET['status']) && $_GET['status']==0) 
		{
			echo '<div id="code-alert" class="code-alert">
			'. __('No user was found with this mobile number', 'dlr').' 
			<span id="not_registered" onclick="openRegister(event)">
			'. __('Register', 'dlr').'
			</span></div>';
		}
		?>
		
		<label class="dlr-login-text" for="newPass">
			<span class="star">*</span>
			<?php echo __('Enter your new password', 'dlr'); ?>
		</label>
		
		<div class="dlr-login-input-field-wrapper">
			<input 
			autocomplete="off" 
			name="newPass" 
			type="password"
			value="<?php if( isset($_GET['status']) && $_GET['status']==0 ) echo get_transient('dlr_mobile'); ?>"
			class="loginMobile dlr-login-input-field ltr"
			id="newPass"
			onkeypress="loginMobileKeyPress()"
			required
			/>
		</div>

		<br>

		<label class="dlr-login-text" for="newPassAgain">
			<span class="star">*</span>
			<?php echo __('Enter your new password again', 'dlr'); ?>
		</label>
		
		<div class="dlr-login-input-field-wrapper">
			<input 
			autocomplete="off" 
			name="newPassAgain" 
			type="password"
			value="<?php if( isset($_GET['status']) && $_GET['status']==0 ) echo get_transient('dlr_mobile'); ?>"
			class="loginMobile dlr-login-input-field ltr" 
			id="newPassAgain"
			onkeypress="forgetPassKeyPress()"
			required
			/>
		</div>
		
	</div>
	
	<div class="login-register-alert"><?php echo __('Please enter your mobile number', 'dlr'); ?></div>

	<div class="forget_pass_rules">
		<ul>
			<?php if ( self::$public_options['_dlr_password_rules_ten_character'] ): ?>
			<li>
				<span class="dlr_check check_length">✓</span> 
				<?php echo __('Password must be at least ten characters long', 'dlr'); ?>
			</li>
			<?php endif; ?>

			<?php if ( self::$public_options['_dlr_password_rules_one_letter'] ): ?>
			<li>
				<span class="dlr_check check_letter">✓</span> 
				<?php echo __('Includes English lowercase and uppercase letters', 'dlr'); ?>
			</li>
			<?php endif; ?>

			<?php if ( self::$public_options['_dlr_password_rules_one_specials'] ): ?>
			<li>
				<span class="dlr_check check_special">✓</span> 
				<?php echo __('Include a special character such as @ or # or * or & or _', 'dlr'); ?>
			</li>
			<?php endif; ?>
		</ul>
	</div>

	<script>
	document.querySelector('#newPass').addEventListener('input',(e)=>
	{
		change_pass()
    });

	document.querySelector('#newPassAgain').addEventListener('input',(e)=>
	{
		change_pass()
    });

	function change_pass()
	{
		var newpass = document.querySelector('#newPass').value;
		var newpassagain = document.querySelector('#newPassAgain').value;

		if( newpass != newpassagain )
		{ 
		    document.querySelector('.check_same').style.display= 'none';
		}else {
			document.querySelector('.check_same').style.display= 'inline-block';
		}
	}
	
	</script>
	
	<?php 
		if( esc_attr(self::$public_options['_dlr_google_captcha_in_login_form']) == 1 ) {
			echo '<div class="g-recaptcha" data-callback="activeLogin" data-sitekey="'.esc_attr(self::$public_options['_dlr_google_recaptchav2_site_key']).'"></div>';
			$disabled = 'disabled="disabled"';
			
			echo '<script>function activeLogin(){document.querySelector("#dlr-login-btn").disabled=false;}</script>';
		}else {
			$disabled = '';
		}
	?>

	<input type="hidden" name="_dlr_mobits" value="newpass" />
	
	<input 
	id="dlr-login-btn"
	type="submit" 
	class="dlr-login-button" 
	name="dlr-change-password" 
	value="<?php 
	if( esc_attr(self::$public_options['_dlr_register_status']) == 1 || esc_attr(self::$public_options['_dlr_register_in_login_form']) != 1 ):
		echo __('Change password', 'dlr');
	else:
		echo __('Continue', 'dlr');
	endif;
	
	?>"
	<?php echo $disabled; ?>
	>
	
	<?php if(isset($_GET['hash'])) echo '<input type="hidden" name="dlr_recovery_hash" value="'.$hash.'" />'; ?>
</form>