<?php defined( 'ABSPATH' ) || exit; ?>

<div id="dlr-recovery">
    
    <form 
    method="post" 
    action="?type=login" 
    autocomplete="off" 
    id="loginForm" 
    onsubmit="return validateMyFormRecovery();"
    >
        
		<div class="dlr-login-input">
		    
		    <?php
        	if ( isset( $_GET['action'] ) && $_GET['action'] == '-1' && isset($_GET['err']) ) 
			{
				switch ( $_GET['err'] )
				{
					case 0:
						$error = __('The entered mobile number is already available.', 'dlr');
						break;
					case 1:
						$error = __('No user was found with this email or username', 'dlr');
						break;
					case 2:
						$error = __('The password entered is incorrect.', 'dlr');
						break;
					case 3:
						$error = __('No user was found with this email', 'dlr');
						break;
					case 4:
						$error = __('Your details is invalid', 'dlr');
						break;
					default:
						$error = 'NO ERROR';
				}
				
        	    echo '<div id="code-alert" class="code-alert">'.$error.'</div>';
        	}
        	?>
		    
		    <label class="dlr-login-text" for="dlr-login-input-name-field">
			    <span class="star">*</span>
			    <?php echo __('Email or Username', 'dlr'); ?>
			</label>
		    
			<div class="dlr-login-input-field-wrapper">
				<input 
				name="username"
				type="search"
				autofocus
				autocomplete="off"
				value="<?php echo isset($_GET['action']) && $_GET['action'] == -1 ? $_COOKIE['mobits_username'] : ''; ?>"
				onkeypress="registerNameKeyPress()" 
				class="dlr-login-input-field registerName ltr" 
				id="dlr-login-input-name-field"
				/>
			</div>
			
		</div>
       
		<div class="dlr-login-input">
            
            <label class="dlr-login-text" for="dlr-login-input-password-field">
			    <span class="star">*</span>
			    <?php echo __('Password', 'dlr'); ?>
			</label>
			
			<div class="dlr-login-input-field-wrapper">
				<input 
				name="password"  
				type="password"
				autocomplete="off"
				onkeypress="registerMobileKeyPress()" 
				class="dlr-login-input-field registerMobile ltr" 
				id="dlr-login-input-password-field"
				value="<?php echo isset($_GET['action']) && $_GET['action'] == -1 ? $_COOKIE['mobits_password'] : ''; ?>"
				/>
			</div>
			
		</div>
		
		<div class="dlr-login-input">
            
            <label class="dlr-login-text" for="dlr-login-input-mobile2-field">
			    <span class="star">*</span>
			    <?php echo __('Mobile Number', 'dlr'); ?>
			</label>
			
			<div class="dlr-login-input-field-wrapper">
				<input 
				name="mobile"  
				type="<?php echo self::isMobile() ? 'number' : 'search' ?>"
				autocomplete="off"
				onkeypress="registerMobileKeyPress()" 
				class="dlr-login-input-field registerMobile ltr" 
				id="dlr-login-input-mobile2-field"
				value="<?php echo isset($_GET['action']) && $_GET['action'] == -1 ? $_COOKIE['mobits_number'] : ''; ?>"
				/>
			</div>
			
		</div>
		
		<div class="recovery-alert"><?php echo __('Please enter your mobile number', 'dlr'); ?></div>
		
		<script>
		function onRecaptchaSuccess3(){document.querySelector("#dlr-recovery-btn").disabled=false;}
		function onRecaptchaResponseExpiry3(){document.querySelector("#dlr-recovery-btn").disabled=true;}
		</script>

		<?php 
		$disabled = '';
		if( esc_attr(self::$public_options['_dlr_google_captcha_in_recovery_form']) == 1 ) : ?>
			<div
			class="g-recaptcha"
			data-sitekey="<?php echo esc_attr(self::$public_options['_dlr_google_recaptchav2_site_key']) ?>"
			data-callback="onRecaptchaSuccess3"
			data-expired-callback="onRecaptchaResponseExpiry3"
			data-error-callback="onRecaptchaError"
			>
			</div>
		<?php 
		$disabled = 'disabled="disabled"';
		endif; ?>
		
		<input 
		id="dlr-recovery-btn"
		value="<?php echo __('Recovery', 'dlr'); ?>"
		name="dlr-recovery" 
		type="submit" 
		class="dlr-login-button" 
		<?php echo $disabled; ?>
		/>

		<input type="hidden" name="_dlr_mobits" value="recovery" />
	
	</form>
    	    
</div>