<?php 
defined( 'ABSPATH' ) || exit;

if( esc_attr(self::$public_options['_dlr_register_status']) == 1 ):
?>

<div id="dlr-register" class="tabcontent <?php if( ! self::is_login_active() ) { echo 'active'; } ?>">

	<script>
		function validateMyFormRegister()
		{
			const name 		= element_exists('.registerName');
			const mobile 	= element_exists('.registerMobile');
			const email 	= element_exists('.registerEmail');
			
			const errorBox = document.querySelector('.register-register-alert');
			
			if( name && name.value == '' )
			{ 
				errorBox.innerHTML = error13;
				errorBox.setAttribute('style', 'display: block !important');
				return false;
			}
			
			if(document.querySelector('#dlr-login-input-username-field')){
			const usernameMain = document.querySelector('#dlr-login-input-username-field').value;
				
			if( usernameMain == '' )
				{ 
					errorBox.innerHTML = error14;
					errorBox.setAttribute('style', 'display: block !important');
					return false;
				}

				if( usernameMain.length < 6 )
				{ 
					errorBox.innerHTML = error15;
					errorBox.setAttribute('style', 'display: block !important');
					return false;
				}
			}
			
			if( mobile )
			{ 
				if( mobile.value == '' )
				{
					errorBox.innerHTML = error2;
					errorBox.setAttribute('style', 'display: block !important');
					return false;
				}
				
				if( mobile.value.length !== 11 || ! /(\+98|0|98|0098)?([ ]|-|[()]){0,2}9[0-9]([ ]|-|[()]){0,2}(?:[0-9]([ ]|-|[()]){0,2}){8}/.test(fixNumbers(mobile.value)) )
				{
					errorBox.innerHTML = error5;
					errorBox.setAttribute('style', 'display: block !important');
					return false;
				}
			}
			
			if ( email ) 
			{
				<?php if ( self::$public_options['_dlr_email_field_required_in_register'] ): ?>
				if( email.value == '' )
				{ 
					errorBox.innerHTML = error3;
					errorBox.setAttribute('style', 'display: block !important');
					return false;
				}
				<?php endif; ?>
				 
				if( email.value!='' && !/\S+@\S+\.\S+/.test(email.value) )
				{
					errorBox.innerHTML = error6;
					errorBox.setAttribute('style', 'display: block !important');
					return false;
				}
			}
		
			localStorage.setItem('dlr-mobile', mobile.value);
			
			var current = Number (Math.round(+new Date()/1000) );
			
			if ( ! localStorage.getItem('dlr-start') ) 
			{
				localStorage.setItem('dlr-start', current );
			}
			else 
			{
				var dlr_start = Number( localStorage.getItem('dlr-start') );
				
				if( current - dlr_start > resendTime ) 
				{
					localStorage.setItem('dlr-start', current );
				}
			}

			<?php if ( self::$public_options['_dlr_password_rules_required'] ): ?>
			var pass = document.querySelector('#dlr-password').value;
			if( pass == '' )
			{ 
				errorBox.innerHTML = error7;
				errorBox.setAttribute('style', 'display: block !important');
				return false;
			}
			<?php endif; ?>

			<?php if ( self::$public_options['_dlr_password_rules_ten_character'] ): ?>
			if( pass.length < 10 )
			{ 
				errorBox.innerHTML = error9;
				errorBox.setAttribute('style', 'display: block !important');
				return false;
			}
			<?php endif; ?>

			<?php if ( self::$public_options['_dlr_password_rules_one_letter'] ): ?>
			if ( !pass.match(/[a-zA-Z]+/) ) 
			{
				errorBox.innerHTML = error10;
				errorBox.setAttribute('style', 'display: block !important');
				return false;
			}
			<?php endif; ?>

			<?php if ( self::$public_options['_dlr_password_rules_one_specials'] ): ?>
			if ( !pass.match(/[$@#&!_]+/) ) 
			{
				errorBox.innerHTML = error11;
				errorBox.setAttribute('style', 'display: block !important');
				return false;
			}
			<?php endif; ?>

			return true;
		}
	</script>

    <form 
    method="post" 
    action="?type=register" 
    autocomplete="off" 
    id="loginForm" 
    onsubmit="return validateMyFormRegister();"
    >

		<?php
		if( isset($_GET['action']) && $_GET['action']=='isemail' ) 
		{
			echo '<div id="code-alert" class="code-alert">
			'. __('User with entered email is available. Please use another email.', 'dlr').'</div>';
		}
		?>

		<?php if(self::$public_options['_dlr_name_field_in_register_status'] == 1): ?>
		<div class="dlr-login-input">
		    
		    <label class="dlr-login-text" for="dlr-login-input-name-field">
			    <span class="star">*</span>
			    <?php 
				if ( self::$public_options['_dlr_name_field_in_register_status'] && self::$public_options['_dlr_family_field_in_register_status'] ) {
					echo __('First name', 'dlr');
				}
				else {
					echo __('First name and last name', 'dlr');
				}
				?>
			</label>
		    
			<div class="dlr-login-input-field-wrapper">
				<input 
				name="regName"
				type="search"
				autofocus
				value="<?php echo isset($_GET['action']) && $_GET['action'] == 'isemail' && isset($_COOKIE['mobits_name']) ? $_COOKIE['mobits_name'] : ''; ?>"
				autocomplete="off"
				onkeypress="registerNameKeyPress()" 
				class="dlr-login-input-field registerName" 
				id="dlr-login-input-name-field"
				/>
			</div>
			
		</div>
		<?php endif; ?>

		<?php if(self::$public_options['_dlr_family_field_in_register_status'] == 1): ?>
		<div class="dlr-login-input">
		    
		    <label class="dlr-login-text" for="dlr-login-input-family-field">
			    <span class="star">*</span>
			    <?php echo __('Last name', 'dlr'); ?>
			</label>
		    
			<div class="dlr-login-input-field-wrapper">
				<input 
				name="regFamily"
				type="search"
				autofocus
				value="<?php echo isset($_GET['action']) && $_GET['action'] == 'isemail' && isset($_COOKIE['mobits_family']) ? $_COOKIE['mobits_family'] : ''; ?>"
				autocomplete="off"
				onkeypress="registerNameKeyPress()" 
				class="dlr-login-input-field registerName" 
				id="dlr-login-input-family-field"
				/>
			</div>
			
		</div>
		<?php endif; ?>
		
		<div class="dlr-login-input">
            
            <label class="dlr-login-text" for="dlr-login-input-mobile2-field">
			    <span class="star">*</span>
			    <?php echo __('Mobile number', 'dlr'); ?>
			</label>
			
			<div class="dlr-login-input-field-wrapper">
				<input 
				name="regMobile"  
				type="<?php echo self::isMobile() ? 'number' : 'search' ?>"
				autocomplete="off"
				onkeypress="registerMobileKeyPress()" 
				class="dlr-login-input-field registerMobile ltr" 
				id="dlr-login-input-mobile2-field"
				value="<?php if ( isset($_COOKIE['mobits_number']) ) { echo (isset($_GET['status']) && $_GET['status'] == 0 && isset($_GET['input']) && $_GET['input'] == 'mobile' ) || (isset($_GET['action']) && $_GET['action'] == 'nouser' && $_GET['input'] == 'mobile') || isset($_GET['action']) && $_GET['action'] == 'isemail' ? $_COOKIE['mobits_number'] : ''; }?>"
			    oninput="if(this.value.length>11) this.value=value.substr(0, value.length - 1)"
				/>
			</div>
			
		</div>

		<?php if ( self::$public_options['_dlr_email_field_in_register_status'] == 1 ): ?>
		<div class="dlr-login-input">
            
            <label class="dlr-login-text" for="dlr-login-input-email-field">

				<?php if ( self::$public_options['_dlr_email_field_required_in_register'] ): ?>
			    	<span class="star">*</span>
				<?php endif; ?>

			    <?php echo __('Email', 'dlr'); ?>
			</label>
			
			<div class="dlr-login-input-field-wrapper">
				<input 
				name="regEmail"  
				type="search"
				autocomplete="off"
				onkeypress="registerMobileKeyPress()" 
				class="dlr-login-input-field registerEmail ltr" 
				id="dlr-login-input-email-field"
				value="<?php echo (isset($_GET['status']) && $_GET['status'] == 0 && $_GET['input'] == 'email' ) || (isset($_GET['action']) && $_GET['action'] == 'nouser' && $_GET['input'] == 'email') || isset($_GET['action']) && $_GET['action'] == 'isemail' ? get_transient('dlr_mobile') : ''; ?>"
				/>
			</div>
			
		</div>
		<?php endif; ?>

		<?php if( self::$public_options['_dlr_password_field_in_register_status'] ): ?>
		<div class="dlr-login-input">
            
            <label class="dlr-login-text" for="dlr-password">

			    <?php if ( self::$public_options['_dlr_password_rules_required'] ): ?>
					<span class="star">*</span> 
				<?php endif; ?>

			    <?php echo __('Password', 'dlr'); ?>
			</label>
			
			<div class="dlr-login-input-field-wrapper">
				<input 
				name="regMobilePassword"  
				type="password"
				autocomplete="off"
				onkeypress="registerMobileKeyPress()" 
				class="dlr-login-input-field ltr" 
				id="dlr-password"
				value=""
				/>
			</div>
			
		</div>

		<div class="forget_pass_rules">
			<ul>
				<?php if ( self::$public_options['_dlr_password_rules_ten_character'] ): ?>
				<li>
					<span class="dlr_check check_length">✓</span> 
					<?php echo __('Password must be at least ten characters long', 'dlr'); ?>
				</li>
				<?php endif; ?>

				<?php if ( self::$public_options['_dlr_password_rules_one_letter'] ): ?>
				<li>
					<span class="dlr_check check_letter">✓</span> 
					<?php echo __('Includes English lowercase and uppercase letters', 'dlr'); ?>
				</li>
				<?php endif; ?>

				<?php if ( self::$public_options['_dlr_password_rules_one_specials'] ): ?>
				<li>
					<span class="dlr_check check_special">✓</span> 
					<?php echo __('Include a special character such as @ or # or * or & or _', 'dlr'); ?>
				</li>
				<?php endif; ?>
			</ul>
		</div>

		<script>
		document.querySelector('#dlr-password').addEventListener('input',(e)=>
		{
			change_pass();
		});

		function change_pass()
		{
			var pass = document.querySelector('#dlr-password').value;

			if( pass.length > 9 )
			{ 
				document.querySelector('.check_length').style.display= 'inline-block';
			}else {
				document.querySelector('.check_length').style.display= 'none';
			}

			if ( pass.match(/[a-zA-Z]+/) ) 
			{
				document.querySelector('.check_letter').style.display= 'inline-block';
			}else {
				document.querySelector('.check_letter').style.display= 'none';
			}

			if ( pass.match(/[$@#&!_]+/) ) 
			{
				document.querySelector('.check_special').style.display= 'inline-block';
			}else {
				document.querySelector('.check_special').style.display= 'none';
			}
		}
	
	</script>

		<?php endif; ?>

		<div class="register-register-alert"><?php echo __('Please enter your mobile number', 'dlr'); ?></div>

		<?php do_action('dlr_register_form_after_mobile_input'); ?>

		<?php do_action('dlr_before_register_form_button'); ?>

		<?php 
		$disabled = '';
		if( esc_attr(self::$public_options['_dlr_google_captcha_in_register_form']) == 1 ) : 
		?>
			<script>
			function onRecaptchaSuccess2(){document.querySelector("#dlr-register-btn").disabled=false;}
			function onRecaptchaResponseExpiry2(){document.querySelector("#dlr-register-btn").disabled=true;}
			</script>

			<div
			class="g-recaptcha"
			data-sitekey="<?php echo esc_attr(self::$public_options['_dlr_google_recaptchav2_site_key']) ?>"
			data-callback="onRecaptchaSuccess2"
			data-expired-callback="onRecaptchaResponseExpiry2"
			data-error-callback="onRecaptchaError"
			>
			</div>
		<?php 
		$disabled = 'disabled="disabled"';
		endif; ?>
		
		<input 
		id="dlr-register-btn"
		value="<?php echo __('Register', 'dlr'); ?>"
		name="dlr-register" 
		type="submit" 
		class="dlr-login-button" 
		<?php echo $disabled; ?>
		/>

		<input type="hidden" name="_dlr_mobits" value="register" />
		
		<?php if( esc_attr(self::$public_options['_dlr_recovery_status']) == 1 ): ?>
		<div>
		    <a href="?type=recovery" class="do_login_with_eu">
		        <?php echo __('Already registered by email or username?', 'dlr'); ?>
		    </a>
		</div>
		<?php endif; ?>
	</form>

	<?php do_action('dlr_after_register_form'); ?>
	
</div>
<?php endif; ?>