<?php 
defined('ABSPATH') || die;

class DeleteMobits
{
	function __construct()
	{
		$this->delete_options();
		$this->delete_tables();
		$this->delete_crons();
	}

	function delete_options()
	{
		if ( get_option("_dlr_delete_mobits_data") != 1 ) return;

		$options = [
			'_dlr_page_slug',
			'_dlr_recovery_status',
			'_dlr_limit_wrong_code',
			'_dlr_resend_code_time',
			'_dlr_update_notice_in_admin_bar',
			'_dlr_font_global',
			'_dlr_public_font',
			'_dlr_admin_font',
			'_dlr_display_header',
			'_dlr_display_footer',
			'_display_mobits_menu',
			'_dlr_number_of_codes',
			'_dlr_forget_password',
			'_dlr_login_status',
			'_dlr_login_with_password_status',
			'_dlr_register_in_login_form',
			'_dlr_last_login',
			'_dlr_login_with_mobile',
			'_dlr_login_with_email',
			'_dlr_forget_password_email',
			'_dlr_register_status',
			'_dlr_password_field_in_register_status',
			'_dlr_name_field_in_register_status',
			'_dlr_family_field_in_register_status',
			'_dlr_email_field_in_register_status',
			'_dlr_password_rules_required',
			'_dlr_password_rules_ten_character',
			'_dlr_password_rules_one_letter',
			'_dlr_password_rules_one_specials',
			'_dlr_redirect_previous_page',
			'_dlr_redirect_url',
			'_dlr_redirect_logout',
			'_dlr_auto_confirm',
			'_dlr_login_force_all',
			'_dlr_admin_login_redirect',
			'_dlr_redirect_new_user_to_register_form',
			'_dlr_redirect_by_role_role',
			'_dlr_redirect_by_role_address',
			'_dlr_logo',
			'_dlr_favicon',
			'_dlr_background_image',
			'_dlr_description',
			'_dlr_color',
			'_dlr_color_tab',
			'_dlr_form_width',
			'_dlr_extra_style',
			'_dlr_dark_mode_status',
			'_dlr_design_type',
			'_dlr_button_image',
			'_dlr_sms_service',
			'_dlr_sms_melipayamak_username',
			'_dlr_sms_melipayamak_password',
			'_dlr_sms_melipayamak_theme',
			'_dlr_sms_smsir_secretKey',
			'_dlr_sms_ippanel_username',
			'_dlr_sms_ippanel_password',
			'_dlr_sms_ippanel_from',
			'_dlr_sms_ippanel_theme',
			'_dlr_sms_smsir_appKey',
			'_dlr_sms_smsir_theme',
			'_dlr_display_melipayamak_remain',
			'_dlr_display_ippanel_remain',
			'_dlr_display_smsir_remain',
			'_dlr_webservice_reports',
			'_dlr_sms_payamresan_accessKey',
			'_dlr_sms_payamresan_theme',
			'_dlr_support_digits',
			'_dlr_support_woocommerce',
			'_dlr_google_captcha_in_login_form',
			'_dlr_google_captcha_in_register_form',
			'_dlr_google_captcha_in_recovery_form',
			'_dlr_google_recaptchav2_site_key',
			'_dlr_redirect_my_account',
			'_dlr_redirect_checkout',
			'_dlr_save_mobile_in_woocommerce',
			'_dlr_save_name_in_woocommerce',
			'_dlr_save_family_in_woocommerce',
			'_dlr_checkout_notif',
			'_dlr_review_author',
			'_dlr_export_csv',
			'_dlr_webservice_reports',
			'_dlr_wrong_code_reports',
			'dlr_li3nce',
			'_dlr_customer_pending_sms_status',
			'_dlr_customer_pending_sms_body',
			'_dlr_customer_processing_sms_status',
			'_dlr_customer_processing_sms_body',
			'_dlr_customer_onhold_sms_status',
			'_dlr_customer_onhold_sms_body',
			'_dlr_customer_completed_sms_status',
			'_dlr_customer_completed_sms_body',
			'_dlr_customer_cancelled_sms_status',
			'_dlr_customer_cancelled_sms_body',
			'_dlr_customer_refunded_sms_status',
			'_dlr_customer_refunded_sms_body',
			'_dlr_customer_failed_sms_status',
			'_dlr_customer_failed_sms_body',
			'_dlr_customer_draft_sms_status',
			'_dlr_customer_draft_sms_body',
			'_dlr_display_return_back_btn',
			'_dlr_return_back_btn_text',
			'_dlr_support_sms_service',
			'_dlr_sms_smsir_sender',
			'_dlr_sms_melipayamak_sender',
			'_dlr_sms_payamresan_sender',
			'_dlr_sms_kavenegar_apikey',
			'_dlr_sms_kavenegar_theme',
			'_dlr_welcome_sms_status',
			'_dlr_welcome_sms_body'
		];

		foreach ( $options as $option )
		{
			delete_option($option);
		}
	}

	function delete_tables ()
	{
		if ( get_option("_dlr_delete_mobits_data") != 1 ) return;

		global $wpdb;

		$codes_table 		= $wpdb->prefix . "dlr_activation";
		$send_sms_table 	= $wpdb->prefix . "dlr_send_sms";
		$wrong_codes_table 	= $wpdb->prefix . "dlr_wrong_codes";
		$blocked_mobile_numbers_table = $wpdb->prefix . "dlr_blocked_mobile_numbers";

    	$wpdb->query( "DROP TABLE IF EXISTS $codes_table" );
		$wpdb->query( "DROP TABLE IF EXISTS $send_sms_table" );
		$wpdb->query( "DROP TABLE IF EXISTS $wrong_codes_table" );
		$wpdb->query( "DROP TABLE IF EXISTS $blocked_mobile_numbers_table" );

		delete_option("_dlr_delete_mobits_data");
	}

	function delete_crons ()
	{
		wp_clear_scheduled_hook( 'delete_extra_code_cron' );
	}
}

new DeleteMobits();