<?php
function zhakethub_ionCube_check()
{
    $min_loader_version="11";
    if (!extension_loaded('ionCube Loader') ||  !function_exists('ioncube_loader_version') || version_compare(ioncube_loader_version(),$min_loader_version,'<')){
        if (!extension_loaded('ionCube Loader') || !function_exists('ioncube_loader_version')){
            return sprintf(__('We detect you do not have ionCube loader , please call to your host service to install ionCube loader version to upper than %d','zhaket-smart-hub'),$min_loader_version);
        }

        return sprintf(__('We detect you do not have ionCube loader or it is too old , please call to your host service to update ionCube loader version to upper than %d','zhaket-smart-hub'),$min_loader_version);

    }
    return true;
}

function zhakethub_php_check(){
    if(!version_compare(phpversion(),"7.4",'>='))
        return __('We detect your server php version is to old, this plugin need php version 7.4 to up.  please call to your host service to update php','zhaket-smart-hub');
    return true;
}

function zhakethub_need_update(){
    if ( current_user_can( 'update_plugins' ) ) {
        $url = wp_nonce_url( self_admin_url( 'update.php?action=upgrade-plugin&plugin=' . ZHAKET_SMART_HUB_PLUGIN_SLUG ), 'upgrade-plugin_' . ZHAKET_SMART_HUB_PLUGIN_SLUG );
    }else{
        $url=admin_url('plugins.php').'#zhaket-smart-hub-update';
    }
    return sprintf( esc_html__('We detect your "smart hub" is out of date. You cannot use this ability until update plugin %s','zhaket-smart-hub'),'<a class="button button-primary" href="'.$url.'">'.esc_html__('Update Now','zhaket-smart-hub').'</a>');
}

function zhaketHub_dependency_check(){
    $php_check = zhakethub_php_check();
    $ioncube_check = zhakethub_ionCube_check();
    if($php_check !== true || $ioncube_check !== true){
        $error = [];
        if($php_check !== true)
            $error[]= $php_check;
        if($ioncube_check !== true)
            $error[]= $ioncube_check;
        return implode('<hr>',$error);
    }
    return true;
}
