<?php
/*
 * Plugin Name: SmartHub
 * Plugin URI: https://www.zhaket.com/web/smart-hub
 * Description: The first and only smart and secure WordPress hub to bypass sanctions and quickly connect to WordPress services
 * Author: alireza azami
 * Author URI: https://www.zhaket.com/
 * Version: 1.1.4
 * Requires at least: 5.0
 * Requires PHP: 7.4
 * Text Domain: zhaket-smart-hub
 * Domain Path: /languages
*/


defined('ABSPATH') || exit ("no access");



define('ZHAKET_SMART_HUB_FILE', __FILE__);
define('ZHAKET_SMART_HUB_PLUGIN_SLUG', 'zhaket-smart-hub/smart-hub.php');
define('ZHAKET_SMART_HUB_DIR', plugin_dir_path(ZHAKET_SMART_HUB_FILE));
define('ZHAKET_SMART_HUB_URL', plugin_dir_url(ZHAKET_SMART_HUB_FILE));
define('ZHAKET_SMART_HUB_ASSETS_URL', ZHAKET_SMART_HUB_URL.'assets/');
$zhaket_smart_hub_ver= '1.1.4';
define('ZHAKET_SMART_HUB_VER', $zhaket_smart_hub_ver);

define('ZHAKET_SMART_HUB_REJECTED_FILE', WP_CONTENT_DIR . '/uploads/smart-hub/rejected.txt');
define('ZHAKET_SMART_HUB_REQUESTS_FILE', WP_CONTENT_DIR . '/uploads/smart-hub/requests.txt');
define('ZHAKET_SMART_HUB_PROXY_FILE', WP_CONTENT_DIR . '/uploads/smart-hub/proxy.txt');


function zhaket_smart_hub_reset_options()
{
    delete_option('zhaket_smart_hub_upgrade');
    delete_option('zhaket_smart_hub_last_key_path');
    delete_transient('zhaket_smart_hub_proxy_error');
    delete_transient('upgrade_zhaket_smart_hub');
    delete_site_transient('update_plugins');
    delete_transient('upgrade_zhaket_smart_hub_time');
}

register_activation_hook(ZHAKET_SMART_HUB_FILE, function () {
    zhaket_smart_hub_reset_options();
    if (!file_exists(ZHAKET_SMART_HUB_REJECTED_FILE)){
        mkdir(dirname(ZHAKET_SMART_HUB_REJECTED_FILE),0755,true);
    }
    if (!file_exists(ZHAKET_SMART_HUB_REJECTED_FILE)) {
        file_put_contents(ZHAKET_SMART_HUB_REJECTED_FILE, 'a:0:{}');
    }
    if (!file_exists(ZHAKET_SMART_HUB_REQUESTS_FILE)) {
        file_put_contents(ZHAKET_SMART_HUB_REQUESTS_FILE, 'a:0:{}');
    }
});

register_deactivation_hook(ZHAKET_SMART_HUB_FILE, function () {
    zhaket_smart_hub_reset_options();
    if (file_exists(ZHAKET_SMART_HUB_PROXY_FILE)) {
        @unlink(ZHAKET_SMART_HUB_PROXY_FILE);
    }
});


if (get_option('zhaket_smart_hub_version',false) !== ZHAKET_SMART_HUB_VER) {
    zhaket_smart_hub_reset_options();
    update_option('zhaket_smart_hub_version', ZHAKET_SMART_HUB_VER);
}

add_action( 'plugins_loaded', function() {
    $lang_dir = basename(ZHAKET_SMART_HUB_DIR).'/languages/';
    load_plugin_textdomain( 'zhaket-smart-hub', false, $lang_dir );
});

require_once 'check-dependency.php';
if (zhaketHub_dependency_check()!==true){
    add_action('admin_notices', function (){printf('<div class="notice notice-error notice-alt"> <p>%s</p> </div>',zhaketHub_dependency_check());},1);
    return;
}

if (get_option('zhaket_smart_hub_upgrade', false) ==='on'){
   if (!isset($_GET['action']) || (isset($_GET['action']) && !in_array($_GET['action'],['upload-plugin','upgrade-plugin']))) {
       add_action('admin_notices', function (){printf('<div class="update-message notice notice-warning notice-alt"> <p>%s</p> </div>',zhakethub_need_update());},1);
   }
}


require_once __DIR__.'/App/vendor/autoload.php';
\Zhaket\SmartHub\Main::getInstance();

