<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;
get_header();

azin_wrapper_start();
?>
        
<div class="row main<?php side_type(); ?>" id="main" <?php if ( azin_opt( 'site_schema' ) ) { ?>itemscope itemtype="https://schema.org/Blog" <?php } ?>>

    <article class="col-12 single-con">
        
        <div class="alert alert-warning alert-dismissible anot" role="alert">
            <strong>
                <span class="fal fa-bell" aria-hidden="true"></span>
                <?php _e( 'Page Not Found! To find the desired file or post, go to the search section or the site menu.', 'azin-file' ); ?>
            </strong>
        </div>
        <div class="col-12 block-title">
            <h4>
                <span class="fal fa-info-circle" aria-hidden="true"></span>
                <?php _e( 'You may want to see the following!', 'azin-file' ); ?>
            </h4>
        </div>

        <div class="row">
            <section class="col-md-4 col-12 ncon">
                <div class="nproduct">
                    <h2 class="ntitle">
                        <?php _e( 'Latest products', 'azin-file' ); ?>
                    </h2>
                    <ul>
                    <?php
                    if ( az_woo() ) {
                        $posts = get_posts( 'orderby=date&numberposts=10&post_type=product' );
                    } else {
                        $posts = get_posts( 'orderby=date&numberposts=10&post_type=download' );
                    }
                    foreach ( $posts as $post ) { ?>
                        <li>
                        <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" <?php azin_link_target() ?>>
                        <?php the_title(); ?>
                        </a>
                        </li>
                    <?php } ?>
                    </ul>
                </div>
            </section>

            <section class="col-md-4 col-12 ncon">
                <div class="nproduct">
                    <h2 class="ntitle">
                        <?php _e( 'Random Products', 'azin-file' ); ?>
                    </h2>
                    <ul>
                        <?php
                        if ( az_woo() ) {
                            $posts = get_posts( 'orderby=rand&numberposts=10&post_type=product' );
                        } else {
                            $posts = get_posts( 'orderby=rand&numberposts=10&post_type=download' );
                        }
                        foreach ( $posts as $post ) { ?>
                        <li>
                            <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" <?php azin_link_target() ?>>
                            <?php the_title(); ?>
                            </a>
                        </li>
                        <?php } ?>
                    </ul>
                </div>
            </section>

            <section class="col-md-4 col-12 ncon">
                <div class="nproduct">
                    <h2 class="ntitle">
                        <?php _e( 'Latest Posts', 'azin-file' ); ?>
                    </h2>
                    <ul>
                        <?php
                        $posts = get_posts( 'orderby=date&numberposts=10' );
                        foreach ( $posts as $post ) { ?>
                            <li>
                                <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" <?php azin_link_target() ?>>
                                <?php the_title(); ?>
                                </a>
                            </li>
                        <?php } ?>
                    </ul>
                </div>
            </section>
        </div>

    </article>

</div>

<?php
azin_wrapper_end();

get_footer();