<?php
/**
 * Shortcode: Download History - [download_history]
 *
 * @package EDD
 * @category Template
 *
 * @since 3.0 Uses new `edd_get_orders()` function and associated helpers.
 *            Checks status on individual order items when determining download link visibility.
 */

if ( ! empty( $_GET['edd-verify-success'] ) ) : ?>
	<p class="edd-account-verified edd_success">
		<?php esc_html_e( 'Your account has been successfully verified!', 'azin-file' ); ?>
	</p>
	<?php
endif;
/**
 * This template is used to display the download history of the current user.
 */
$customer = edd_get_customer_by( 'user_id', get_current_user_id() );
$page     = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;

if ( ! empty( $customer ) ) {
	$orders = edd_get_orders(
		array(
			'customer_id' => $customer->id,
			'number'      => 20,
			'offset'      => 20 * ( intval( $page ) - 1 ),
			'type'        => 'sale',
		)
	);
} else {
	$orders = array();
}

if ( $orders ) :
	do_action( 'edd_before_download_history' ); ?>
	<div id="accordion" class="azin-download-accordion">
		<?php $downloadNumber = 1; ?>
		<?php
		foreach ( $orders as $order ) :
			foreach ( $order->get_items() as $key => $item ) :

			// Skip over Bundles. Products included with a bundle will be displayed individually
			if ( edd_is_bundled_product( $item->product_id ) ) {
				continue;
			}
			
			if ( azin_opt( 'course_user_panel' ) && azin_is_course( $item->product_id ) )
				break;
			?>
			<div class="card">
				<?php
				$price_id       = $item->price_id;
				// Get price ID of product with variable prices included in Bundle
					if ( ! empty( $download['in_bundle'] ) && edd_has_variable_prices( $download['id'] ) ) {
						$price_id = edd_get_bundle_item_price_id( $download['id'] );
					}
					$download_files = edd_get_download_files( $item->product_id, $price_id );
				$name           = $item->product_name;

				//do_action( 'edd_download_history_row_start', $order->id, $item->product_id );
				?>
				<div class="card-header" id="heading<?php echo $downloadNumber; ?>">
				<h5 class="mb-0">
					<button class="btn btn-link" data-toggle="collapse" data-target="#collapse<?php echo $downloadNumber; ?>" aria-expanded="true" aria-controls="collapse<?php echo $downloadNumber; ?>">
					<?php
					echo get_the_post_thumbnail( $item->product_id, apply_filters( 'edd_checkout_image_size', array( 64,64 ) ) );

						//if ( $download['product_url'] ) {
							//echo '<a href="' . esc_url( $download['product_url'] ) . '">' . esc_html( $download['product_name'] ) . '</a>';
						//} else {
							echo esc_html( $name );
						//}
					?>
					</button>
				</h5>
				</div>

				<div id="collapse<?php echo $downloadNumber; ?>" class="collapse" aria-labelledby="heading<?php echo $downloadNumber; ?>" data-parent="#accordion">
				<div class="card-body azin-accordion-body">

				<?php 

				if ( azin_opt( 'show_downloads_fields' ) && ! empty ( azin_opt( 'downloads_fields' ) ) ) {
					$id = $item->product_id;
					$count = count ( azin_opt( 'downloads_fields' ) );
					$i = 0;
					foreach( azin_opt( 'downloads_fields' ) as $field ) {
						$title = '';
						$icon  = '';
						$value = '';
						if ( $i++ > $count ) break;
						switch ( $field ) {
							case 'field-one':
								$title = azin_opt( 'fone' );
								$icon = ( ! empty ( azin_opt( 'fone_icon' ) ) ? azin_opt( 'fone_icon' ) : 'fa-file-alt' );
								$value = rwmb_meta( 'file_fone', '', $id );
								break;
							case 'field-two':
								$title = azin_opt( 'ftwo' );
								$icon = ( ! empty ( azin_opt( 'ftwo_icon' ) ) ? azin_opt( 'ftwo_icon' ) : 'fa-save' );
								$value = rwmb_meta( 'file_ftwo', '', $id );
								break;
							case 'field-three':
								$title = azin_is_course( $id ) && ! azin_opt( 'edit_fthree' ) ? __( 'Teacher', 'azin-file' ) : azin_opt( 'fthree' );
								$icon = azin_opt( 'fthree_icon' );
								if ( azin_opt( 'edit_fthree' ) ) { 
									$value = rwmb_meta( 'file_fthree', '', $id );
								} else {
									$author_id = get_post_field( 'post_author', $id );
									$value = get_the_author_meta( 'display_name', $author_id );
								}
								break;
							case 'field-four':
								$title = azin_opt( 'ffour' );
								$icon = azin_opt( 'ffour_icon' );
								if ( azin_opt( 'edit_ffour' ) ) {
									$value = rwmb_meta( 'file_ffour', '', $id );
								} else {
									$value = get_the_date( 'j F Y', $id ); 
								}
								break;
							case 'field-five':
								$title = azin_opt( 'ffive' );
								$icon = ( ! empty ( azin_opt( 'ffive_icon' ) ) ? azin_opt( 'ffive_icon' ) : 'fa-folder-open' );
								if ( azin_opt( 'edit_ffive' ) ) {
									$value = rwmb_meta( 'file_ffive', '', $id );
								} else {
									$sep = ( is_rtl() ? '، ' : ', ' );
									$term_obj_list = get_the_terms( $id, 'download_category' );
									$value = join( $sep, wp_list_pluck( $term_obj_list, 'name') );
								}
								break;
							case 'field-six':
								$title = azin_opt( 'fsix' );
								$icon  = azin_opt( 'fsix_icon' );
								if ( azin_opt( 'edit_fsix' ) ) {
									$value = rwmb_meta( 'file_fsix', '', $id );
								} else {
									$value = getPostViews( $id );
								}
								break;
							case 'field-dcount':
								$title = azin_is_course( $id ) && ! azin_opt( 'edit_dcount' ) ? __( 'Number of students', 'azin-file' ) : azin_opt( 'dcount_title' );
								$icon  = azin_opt( 'dcount_icon' );
								if ( azin_opt( 'edit_dcount' ) ) {
									$value = rwmb_meta( 'file_dcount', '', $id );
								} else {
									$dcount_download = new EDD_Download( $id );
									$count = $dcount_download->get_sales();
									$value = $count . __( ' Sales', 'azin-file' );
								}
								break;
							case 'field-modified':
								$title = azin_opt( 'modified_date_title' );
								$icon  = azin_opt( 'modified_date_icon' );
								if ( azin_opt( 'edit_modified_date' ) ) {
									$value = rwmb_meta( 'file_modified_date', '', $id );
								} else {
									$value = get_the_modified_time( 'j F Y', $id );
								}
								break;
						} 
						
						if ( ! empty ( $title ) && ! empty ( $value ) ) {
						?>
						<div class="col-12 col-md-6 col-xl-4 azin-accordion-extra azin-downloads-field-<?php echo $i ?>">
							<i class="fa <?php echo $icon ?>" aria-hidden="true"></i>
							<?php echo $title . ': ' . $value; ?>
						</div>
					<?php
						}
					}
				}
				?>

					<?php if ( ! edd_no_redownload() ) : ?>

					<?php

					if ( $item->is_deliverable() ) :

						if ( $download_files ) :

							echo '<ul class="azin-download-list col-12">';

							foreach ( $download_files as $filekey => $file ) :

								$download_url = edd_get_download_file_url( $order->payment_key, $order->email, $filekey, $item->product_id, $price_id );
								?>

								<li>
									<a href="<?php echo esc_url( $download_url ); ?>">
										<?php echo edd_get_file_name( $file ); ?>
									</a>
								</li>

								<?php
								do_action( 'edd_download_history_download_file', $filekey, $file, $item, $order );
							endforeach;
							echo '</ul>';

						else :
							esc_html_e( 'No downloadable files found.', 'azin-file' );
						endif; // End if payment complete

					else : ?>
					<span class="edd_download_payment_status">
								<?php
								printf(
									/* translators: the order item's status. */
									esc_html__( 'Status: %s', 'azin-file' ),
									esc_html( edd_get_status_label( $item->status ) )
								);
								?>
							</span>
							<?php
					endif; // End if $download_files
					?>

					<?php endif; ?>

				</div>
				</div>

			</div>
			<?php $downloadNumber++; ?>
		<?php
			endforeach;
		endforeach;
		if ( $downloadNumber == 1 ) { ?>
			<div class="edd-no-downloads alert alert-info">
				<?php _e( 'You have not purchased any products.', 'azin-file' ); ?>
			</div>
		<?php
		} ?>
	</div>
	<?php
	if ( ! empty( $customer->id ) ) {
		$count = edd_count_orders(
			array(
				'customer_id' => $customer->id,
				'type'        => 'sale',
			)
		);
		echo edd_pagination(
			array(
				'type'  => 'download_history',
				'total' => ceil( $count / 20 ), // 20 items per page
			)
		);
	}
	?>
	<?php do_action( 'edd_after_download_history' ); ?>
<?php else : ?>
	<p class="edd-no-downloads"><?php esc_html_e( 'You have not purchased any downloads', 'azin-file' ); ?></p>
<?php endif; ?>
