<div class="fes-vendor-dashboard-con">
<?php
    $user = get_current_user_id();
	$products = EDD_FES()->vendors->get_all_products( $user);
	$pending = EDD_FES()->vendors->get_all_products_count( get_current_user_id(), 'pending' );
	$approved = EDD_FES()->vendors->get_all_products_count( get_current_user_id(), 'publish' );
    if ( EDD_FES()->integrations->is_commissions_active() ) {
	$unpaid_commission = edd_currency_filter( eddc_get_unpaid_totals( get_current_user_id() ) );
    }
	$sales = 0;
	$earnings = 0;

	if ( ! empty( $products) ) { 
		foreach ( $products as $product) : 
		$sales+= $product['sales']; 
		endforeach;
	} 
	$message = $sales . __( ' Sales', 'azin-file' );
?>

<?php
$vendor_announcement = EDD_FES()->helper->get_option( 'fes-dashboard-notification', '' );
if ( $vendor_announcement ) : ?>
	<div id="fes-vendor-announcements" class="alert alert-info">
		<?php echo apply_filters( 'fes_dashboard_content', do_shortcode( $vendor_announcement ) ); ?>
	</div>
<?php endif; ?>


<?php if ( EDD_FES()->integrations->is_commissions_active() ) { ?>
<div class="account-overview-wrapper">
<div class="account-overview">
	<ul class="azin-dashboard-stats row">

		<li class="col-lg-3 col-md-6 col-12">
			<div class="azin-dashboard-stat-con azin-dashboard-green shadow-box">
                <i class="fal fa-money-bill-alt" aria-hidden="true"></i>    
                <span class="col azin-stats-con d-flex">
                    <span class="azin-dashboard-stats-count"><?php echo wp_kses( edd_currency_filter( eddc_get_paid_totals( get_current_user_id() ) ), wp_kses_allowed_html( 'post' ) ); ?></span>
                    <span class="azin-dashboard-stats-title"><?php _e( 'Total paid', 'azin-file' ); ?></span>
                </span>
            </div>
		</li>

		<li class="col-lg-3 col-md-6 col-12">
			<div class="azin-dashboard-stat-con azin-dashboard-yellow shadow-box">
                <i class="fal fa-dollar-sign" aria-hidden="true"></i>    
                <span class="col azin-stats-con d-flex">
                    <span class="azin-dashboard-stats-count"><?php echo wp_kses( $unpaid_commission, wp_kses_allowed_html( 'post' ) ); ?></span>
                    <span class="azin-dashboard-stats-title"><?php _e( 'Unpaid', 'azin-file' ); ?></span>
                </span>
            </div>
		</li>

		<li class="col-lg-3 col-md-6 col-12">
			<div class="azin-dashboard-stat-con azin-dashboard-blue shadow-box">
                <i class="fal fa-upload" aria-hidden="true"></i>    
                <span class="col azin-stats-con d-flex">
                    <span class="azin-dashboard-stats-count"><?php echo esc_html( $approved ); ?></span>
                    <span class="azin-dashboard-stats-title"><?php _e( 'Published', 'azin-file' ); ?></span>
                </span>
            </div>
		</li>
		
		<li class="col-lg-3 col-md-6 col-12">
			<div class="azin-dashboard-stat-con azin-dashboard-red shadow-box">
                <i class="fal fa-clock" aria-hidden="true"></i>    
                <span class="col azin-stats-con d-flex">
                    <span class="azin-dashboard-stats-count"><?php echo esc_html( $pending ) ?></span>
                    <span class="azin-dashboard-stats-title"><?php _e( 'Pending', 'azin-file' ); ?></span>
                </span>
            </div>
		</li>
	</ul>

</div>
</div>
<?php } else {  ?>
	<div class="alert comm-alert alert-info">
		<?php _e( 'Install and activate the EDD Commission plugin to fully view the vendors panel.', 'azin-file' ); ?>
	</div>
<?php } ?>

<div id="fes-vendor-store-link">
	<?php echo EDD_FES()->vendors->get_vendor_store_url_dashboard(); ?>
</div>

<div class="fes-comments-wrap">
	<table id="fes-comments-table" class="table table-striped">
		<tr>
			<th class="col-author fes-comments-table-authors-column"><?php  _e( 'Author', 'azin-file' ); ?></th>
			<th class="col-content fes-comments-table-content-column"><?php  _e( 'Comment', 'azin-file' ); ?></th>
		</tr>
		<?php echo EDD_FES()->dashboard->render_comments_table( 10 ); ?>
	</table>
</div>
</div>