<div class="fes-vendor-dashboard-con">
<?php global $products; ?>
<h3 class="fes-headers" id="fes-products-page-title"><?php echo EDD_FES()->helper->get_product_constant_name( $plural = true, $uppercase = true ) ?></h3>
<?php echo EDD_FES()->dashboard->product_list_status_bar(); ?>

<table class="table fes-table table-condensed  table-striped" id="fes-product-list">
	<thead>
		<tr>
			<th><?php _e( 'Image', 'azin-file' ); ?></th>
			<th><?php _e( 'Name', 'azin-file' ); ?></th>
			<th><?php _e( 'Status', 'azin-file' ); ?></th>
			<th><?php _e( 'Price', 'azin-file' ); ?></th>
			<th><?php _e( 'Purchases', 'azin-file' ) ?></th>
			<th><?php _e( 'Actions', 'azin-file' ) ?></th>
			<th><?php _e( 'Date', 'azin-file' ); ?></th>
			<?php do_action( 'fes-product-table-column-title' ); ?>
		</tr>
	</thead>
	<tbody>
		<?php
		if ( count( $products ) > 0 ) {
			foreach ( $products as $product ) : ?>
				<tr>
					<td class = "fes-product-list-td"><?php echo get_the_post_thumbnail( $product->ID, array( 100, 100 ) ); ?></td>
					<td class = "fes-product-list-td"><?php echo EDD_FES()->dashboard->product_list_title( $product->ID ); ?></td>
					<td class = "fes-product-list-td"><?php echo EDD_FES()->dashboard->product_list_status( $product->ID ); ?></td>
					<td class = "fes-product-list-td"><?php echo EDD_FES()->dashboard->product_list_price( $product->ID ); ?></td>
					<td class = "fes-product-list-td"><?php echo EDD_FES()->dashboard->product_list_sales_esc( $product->ID ); ?></td>
					<td class = "fes-product-list-td"><?php EDD_FES()->dashboard->product_list_actions( $product->ID ); ?></td>
					<td class = "fes-product-list-td"><?php echo EDD_FES()->dashboard->product_list_date( $product->ID ); ?></td>
					<?php do_action( 'fes-product-table-column-value', $product ); ?>
				</tr>
			<?php
			endforeach;
		} else {
			echo '<tr><td colspan="7" class = "fes-product-list-td" >' . sprintf( _x( 'No %s found', 'FES lowercase plural setting for download', 'azin-file' ), EDD_FES()->helper->get_product_constant_name( $plural = true, $uppercase = false ) ) . '</td></tr>';
		}
		?>
	</tbody>
</table>
<?php EDD_FES()->dashboard->product_list_pagination(); ?>
</div>