<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Demo Website: https://azinfile.i-design.ir/
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

//Theme's Languages
add_action( 'after_setup_theme', 'azin_localisation' );
function azin_localisation() {
    function azin_localised( $locale ) {
        if ( isset( $_GET['l'] ) ) {
            return sanitize_key( $_GET['l'] );
        }
        return $locale;
    }
    add_filter( 'locale', 'azin_localised' );
    load_theme_textdomain( 'azin-file', get_template_directory() . '/languages' );
}

//Theme constants
if ( ! defined( 'AZ_URI' ) )
	define( 'AZ_URI', get_template_directory_uri() );

if ( ! defined( 'AZ_DIR' ) )
	define( 'AZ_DIR', get_template_directory() );

//Theme version
if ( ! defined( 'AZ_VER' ) )
	define( 'AZ_VER', '5.3.1' );

//Load theme setting's framework
if ( ! class_exists( 'ReduxFramework' ) && file_exists(dirname(__FILE__) . '/includes/ReduxCore/framework.php' ) )
    require_once( dirname(__FILE__) . '/includes/ReduxCore/framework.php' );

if ( ! isset( $redux_demo) && file_exists(dirname(__FILE__) . '/includes/admin-panel-config.php' ) )
    require_once( dirname(__FILE__) . '/includes/admin-panel-config.php' );

//Init theme setting variable
Redux::init( 'az_data' );

//Azin Get Options
if ( ! function_exists( 'azin_opt' ) ) {
	function azin_opt( $option_name, $arg_name = null ) {
        global $az_data;
        if ( ! empty ( $arg_name ) && isset( $az_data [ $option_name ][ $arg_name ] ) ) {
            return $az_data [ $option_name ][ $arg_name ];
        } elseif ( isset( $az_data [ $option_name ] ) ) {
            return $az_data [ $option_name ];
        } else{
            return;
        }
	}
}

//azin_active_elpro
function azin_active_elpro() {
    if ( is_plugin_active( 'elementor-pro/elementor-pro.php' ) || class_exists ( 'Header_Footer_Elementor' ) ) {
        return true;
    } else {
        return false;
    }
}

//Include theme files
require_once AZ_DIR . '/meta-box/meta-box.php';
require_once AZ_DIR . '/includes/az-meta-box.php';
require_once AZ_DIR . '/includes/recaptchalib.php';
require_once AZ_DIR . '/includes/azin-course.php';
require_once AZ_DIR . '/includes/d-sidebar.php';
require_once AZ_DIR . '/includes/views.php';
require_once AZ_DIR . '/includes/dynamic_style.php';
require_once AZ_DIR . '/includes/breadcrumbs.php';
require_once AZ_DIR . '/includes/azrating.php';
require_once AZ_DIR . '/includes/menu-icon.php';
require_once AZ_DIR . '/includes/widget-icon/widget-icon.php';

if ( azin_opt( 'mega_style' ) == 'second') {
    require_once AZ_DIR . '/includes/yamm-s.php';
} else {
    require_once AZ_DIR . '/includes/yamm.php';
}

require_once AZ_DIR . '/includes/mmenu_walker.php';
require_once AZ_DIR . '/includes/ajax-login.php';
require_once AZ_DIR . '/includes/thumbnail-upscale.php';
require_once AZ_DIR . '/includes/fa-cheets.php';

if( ! function_exists('yoast_breadcrumb') && ! class_exists('RankMath') )
    require_once AZ_DIR . '/includes/visual-term-description-editor/visual-term-description-editor.php';

if ( azin_opt( 'ajax_search' ) )
    require_once AZ_DIR . '/includes/searchwp-live-ajax-search/searchwp-live-ajax-search.php';

require_once AZ_DIR . '/plugins/plugin.php';
require_once ABSPATH . 'wp-admin/includes/plugin.php';

//Include theme widgets files
require_once AZ_DIR . '/includes/widgets/simple-link-list-widget/simple-link-list-widget.php';
require_once AZ_DIR . '/includes/widgets/az-add-product.php';
require_once AZ_DIR . '/includes/widgets/az-product-help.php';
require_once AZ_DIR . '/includes/widgets/az-product-tags.php';
require_once AZ_DIR . '/includes/widgets/random-post.php';
require_once AZ_DIR . '/includes/widgets/recent-post.php';
require_once AZ_DIR . '/includes/widgets/epay.php';
require_once AZ_DIR . '/includes/widgets/logo-namad.php';
require_once AZ_DIR . '/includes/widgets/fnews.php';
require_once AZ_DIR . '/includes/widgets/image-banner.php';
require_once AZ_DIR . '/includes/widgets/wauthor.php';

if ( azin_opt( 'product_badges' ) ) 
    require_once AZ_DIR . '/includes/widgets/az-product-badges.php';


if ( az_woo() ) {
    require_once AZ_DIR . '/includes/woo.php';
    require_once AZ_DIR . '/includes/widgets/woo/az-woo-product-attr.php';
    require_once AZ_DIR . '/includes/widgets/woo/woo-recent-downloads.php';
    require_once AZ_DIR . '/includes/widgets/woo/woo-random-downloads.php';
    require_once AZ_DIR . '/includes/widgets/woo/woo-viewed-downloads.php';
    require_once AZ_DIR . '/includes/widgets/woo/woo-most-saled.php';
    require_once AZ_DIR . '/includes/widgets/woo/woo-special-prod.php';
    if ( azin_opt( 'ajax_add' ) && get_option( 'woocommerce_enable_ajax_add_to_cart' ) === 'yes' && get_option( 'woocommerce_cart_redirect_after_add' ) === 'no' ) {
        require_once AZ_DIR . '/includes/woo/ajax-add.php';
    }
} elseif ( class_exists( 'Easy_Digital_Downloads' ) ) {
    require_once AZ_DIR . '/includes/edd.php';
    require_once AZ_DIR . '/includes/widgets/edd-recent-downloads.php';
    require_once AZ_DIR . '/includes/widgets/edd-random-downloads.php';
    require_once AZ_DIR . '/includes/widgets/edd-most-saled.php';
    require_once AZ_DIR . '/includes/widgets/edd-special-prod.php';
    require_once AZ_DIR . '/includes/fes.php';
}

require_once AZ_DIR . '/includes/single-product-func.php';
require_once AZ_DIR . '/includes/single-post-func.php';
require_once AZ_DIR . '/includes/footer-codes.php';
require_once AZ_DIR . '/includes/header-codes.php';
require_once AZ_DIR . '/includes/prod-hover-btns.php';
require_once AZ_DIR . '/includes/shortcodes.php';

//Register Elementor Widgets
if ( did_action( 'elementor/loaded' ) )
    require_once AZ_DIR . '/includes/elementor.php';

if ( azin_opt( 'change_user_avatar' ) )
    require_once AZ_DIR . '/includes/user-avatar.php';

//Add theme's styles
add_action( 'wp_enqueue_scripts', 'azin_styles' );
function azin_styles() {
    
    if ( is_rtl() ) {
        wp_register_style('azin-boot-rtl', AZ_URI . '/css/bootstrap-rtl.min.css', array(), AZ_VER );
        wp_enqueue_style('azin-boot-rtl');
    } else {
        wp_register_style('azin-boot', AZ_URI . '/css/bootstrap.min.css', array(), AZ_VER );
        wp_enqueue_style('azin-boot'); 
    }

    wp_register_style( 'azin-fa', AZ_URI . '/css/fontawesome.min.css', array(), AZ_VER );
    wp_enqueue_style( 'azin-fa' );

    wp_register_style( 'azin-style', AZ_URI . '/style.css', array(), AZ_VER );
    wp_enqueue_style( 'azin-style' );

    if ( ! azin_opt( 'custom_font' ) ) {
        wp_register_style('azin-font', AZ_URI . '/css/'.azin_opt( 'theme_font' ).'.css', array() , AZ_VER );
        wp_enqueue_style('azin-font');
    }

    if ( azin_opt( 'full_width_style' ) ) {
        wp_register_style( 'azin-full', AZ_URI . '/css/full-width.css', array() , AZ_VER );
        wp_enqueue_style( 'azin-full' );
    }

    if ( az_woo() ) {
        wp_register_style( 'azin-woo', AZ_URI . '/css/woo.css', array(), AZ_VER );
        wp_enqueue_style( 'azin-woo' );
    }

    if ( az_woo() && class_exists( 'WeDevs_Dokan' ) ) {
        wp_register_style( 'azin-dokan', AZ_URI . '/css/dokan.css', array(), AZ_VER );
        wp_enqueue_style( 'azin-dokan' );
    }

    if ( ! is_rtl() ) {
        wp_register_style('azin-style-ltr', AZ_URI . '/css/ltr.css', array(), AZ_VER );
        wp_enqueue_style('azin-style-ltr');
    }
}

//Register Elementor Panel styles
if ( did_action( 'elementor/loaded' ) ) {
    add_action( 'elementor/editor/before_enqueue_scripts', function () {
        wp_register_style( 'el-style', AZ_URI . '/css/elementor.css', array(), AZ_VER );
        wp_enqueue_style( 'el-style' );
        wp_register_style( 'az-awe', AZ_URI . '/css/fontawesome.min.css', array(), AZ_VER );
        wp_enqueue_style( 'az-awe' );
    } );
}

add_action( 'init', 'azin_js' );
//Add theme's JS
function azin_js() {
    if ( is_admin() ) {
        return;
    }
    wp_enqueue_script( 'azin-js-boot', AZ_URI . '/js/bootstrap.min.js', array( 'jquery' ), AZ_VER, true );
    wp_enqueue_script( 'azin-js-main', AZ_URI . '/js/main.js', array( 'jquery' ), AZ_VER, true );
    wp_enqueue_script( 'azin-js-owl', AZ_URI . '/js/owl-carousel.js', array( 'jquery' ), AZ_VER, true );
    wp_enqueue_script( 'azin-js-theme', AZ_URI . '/js/theme.js', array( 'jquery' ), AZ_VER, true );
    wp_register_script( 'azin-add-cart-ajax', AZ_URI . '/js/add-cart-ajax.js', array( 'jquery' ), AZ_VER, true );
    wp_register_script( 'azin-easy-ticker', AZ_URI . '/js/jquery.easy-ticker.min.js', array( 'jquery' ), AZ_VER, true);
}

//Register navigation menu
register_nav_menus(array(
    'primary' => __( 'Main menu', 'azin-file' ),
    'footer' => __( 'Footer menu', 'azin-file' ),
    'header' => __( 'Header menu', 'azin-file' ),
) );

if ( azin_opt( 'replace_user_menu' ) ) {
    register_nav_menus( array(
        'user_menu'   => __( 'User menu', 'azin-file' ),
    ) );
}

if ( azin_opt( 'replace_mobile_menu' ) ) {
    register_nav_menus( array(
        'mobile_menu'   => __( 'Mobile Menu', 'azin-file' ),
    ) );
}

//Check site direction is RTL
function azin_rtl() {
    if (is_rtl()) {
        echo 'true';
    } else {
        echo 'false';
    }
}

function az_woo() {
    if ( class_exists( 'WooCommerce' ) && azin_opt( 'woo_mode' ) ) {
        return true;
    } else {
        return false;
    }
}

add_action( 'admin_notices', 'azin_woo_notice' );
function azin_woo_notice() {
    if ( class_exists( 'WooCommerce' ) && ! azin_opt( 'woo_mode' ) ) {
        ?>
        <div class="notice notice-error is-dismissible">
            <ul>
                <?php
                _e( 'It seems that you have installed the WooCommerce plugin, but the WooCommerce mode in the Azinfile template settings is not activated. If you intend to use the WooCommerce mode of Azinfile template, be sure to activate the WooCommerce mode option from the Appearance > Template settings > WooCommerce settings.', 'azin-file' );
                ?>
            </ul>
        </div>
        <?php
    }
}

//Wordpress page navigation
function wp_pagination() {
    global $wp_query;
    $big = 999999999;
    $page_format = paginate_links(array(
        'base'       => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big) )),
        'format'     => '?paged=%#%',
        'current'    => max(1, get_query_var( 'paged' ) ),
        'total'      => $wp_query->max_num_pages,
        'prev_text'  => '<i aria-hidden="true" class="fal fa-angle-right "></i>',
        'next_text'  => '<i aria-hidden="true" class="fal fa-angle-left "></i>',
        'type'       => 'array'
    ) );
    if ( is_array( $page_format) ) {
        $paged = ( get_query_var( 'paged' ) == 0) ? 1 : get_query_var( 'paged' );
        echo '<ul>';
        foreach ( $page_format as $page) {
            echo "<li>$page</li>";
        }
        echo '</ul>';
    }
}

//Wordpress product navigation
function wp_product_pagination() {
    global $products;
    $big = 999999999;
    $page_format = paginate_links(array(
'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big) )),
'format' => '?paged=%#%',
'current' => max(1, get_query_var( 'paged' ) ),
'total' => $products->max_num_pages,
'prev_text'    => '<i aria-hidden="true" class="fal fa-angle-right "></i>',
    'next_text'    => '<i aria-hidden="true" class="fal fa-angle-left "></i>',
'type'  => 'array'
) );
    if ( is_array( $page_format) ) {
        $paged = ( get_query_var( 'paged' ) == 0) ? 1 : get_query_var( 'paged' );
        echo '<ul>';
        foreach ( $page_format as $page) {
            echo "<li>$page</li>";
        }
        echo '</ul>';
    }
}

// Add Theme Support
add_action( 'after_setup_theme', 'azin_support' );
function azin_support() {
    add_theme_support('title-tag');
    add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption', 'style', 'script' ) );
    add_theme_support('automatic-feed-links');
    if ( az_woo() ) {
        add_theme_support( 'woocommerce' );
    }
    add_theme_support( 'rank-math-breadcrumbs' );
    add_theme_support( 'header-footer-elementor' );
    add_theme_support('post-thumbnails');

    // Add Thumbnail Theme Support
    if ( azin_opt( 'custom_thumb' ) ) {
        add_image_size( 'single-download', azin_opt( 'custom_thumb_width' ), azin_opt( 'custom_thumb_height' ), true);
    } elseif ( azin_opt( 'square_thumb' ) ) {
        add_image_size( 'single-download', 472, 472, true);
    } else {
        add_image_size( 'single-download', 472, 267, true);
    }

    //Product page custom thumbnail
    if ( azin_opt( 'product_custom_thumb' ) ) {
        add_image_size( 'single-download-s', azin_opt( 'product_custom_thumb_width' ), azin_opt( 'product_custom_thumb_height' ), true);
    }

    if ( azin_opt( 'post_custom_thumb' ) ) {
        add_image_size( 'single-post', azin_opt( 'post_custom_thumb_width' ), azin_opt( 'post_custom_thumb_height' ), true);
    } 

    add_image_size( 'widget-img', 64, 64, true);
}

//Add dashboard font
add_action( 'admin_init', 'azin_dashboard_font' );
function azin_dashboard_font() {
    wp_enqueue_style( 'azin-dashboard-font', AZ_URI . '/css/'. azin_opt( 'theme_font' ) .'.css', array()  );
}

//Add dashboard font style
add_action('admin_head', 'azin_admin_head');
function azin_admin_head() {
    if ( ! azin_opt( 'change_dashboard_font' ) )
        return;
    ?>
    <style type="text/css">
        body.rtl #wpadminbar a,.rtl #wpadminbar,#wpadminbar,body {font-family: sans !important}
        .rtl #wpadminbar * {font-family: sans}
        h1,h2,h3,h4,h5,h6 {font-family: sans-m !important}
    </style>
    <?php
}

// Fontawesome dashboard
function fontawesome_dashboard() {
    wp_enqueue_style( 'az-fontawesome', AZ_URI .'/css/fontawesome.min.css' );
    wp_enqueue_style('irico-az-admin', AZ_URI . '/css/ir-icons.css');
}
add_action( 'admin_init', 'fontawesome_dashboard' );

//Loads admin-side menu-icon scripts and styles
function admin_menu_icon_styles( $page) {
    if ( $page == 'nav-menus.php' || $page == 'widgets.php' ) {
        wp_enqueue_style( 'select2', AZ_URI . '/includes/select2.min.css' );
        wp_enqueue_style( 'menu-icon-admin-style', AZ_URI . '/includes/menu-icon-admin.css' );
        wp_enqueue_script( 'my_s2', AZ_URI . '/includes/select2.min.js' );
        wp_enqueue_script( 'my_s1', AZ_URI . '/includes/select2.js' );
    }
}
    
add_action( 'admin_enqueue_scripts', 'admin_menu_icon_styles' );
function redux_custom_styles( $page) {
    wp_enqueue_style( 'redux-custom-style', AZ_URI .'/includes/redux.css' );
}
add_action( 'admin_enqueue_scripts', 'redux_custom_styles' );

if ( get_option( 'show_on_front' ) == 'posts' ) {
add_filter( 'pre_get_posts', 'my_get_posts' );
}
   
function my_get_posts( $query) {
    
    if ( is_home() && $query->is_main_query() ) {
        if ( azin_opt( 'main_type_post' ) ) {
            $query->set( 'post_type', 'post' );
        } else {
            if ( az_woo() ) {
                $query->set( 'post_type', 'product' );
            } else {
                $query->set( 'post_type', 'download' );
            }
        }
    }

    return $query;
}

\df43c400e76b0605df8e658815fb2a::fdedda26b18535789c();
function tj_tag_cloud_limit( $args) {    
    // Check if taxonomy option of the widget is set to tags
    if ( isset( $args['taxonomy'] ) ) {
        $args['number'] = azin_opt( 'tag_number' ); // Number of tags to show
    }
    return $args;
}
     
// unregister all widgets
 function unregister_default_widgets() {
     unregister_widget( 'WP_Widget_Links' );
     unregister_widget( 'WP_Widget_Search' );
     unregister_widget( 'WP_Widget_Recent_Posts' );
     unregister_widget( 'Twenty_Eleven_Ephemera_Widget' );
 }
  add_action( 'widgets_init', 'unregister_default_widgets', 11);

/** remove redux menu under the tools **/
add_action( 'admin_menu', 'remove_redux_menu', 12 );
function remove_redux_menu() {
    remove_submenu_page( 'tools.php', 'redux-about' );
}

//Replace video cover by post thumbnail
if ( azin_opt( 'show_vcover_thumb' ) ) {
    add_shortcode( 'video', 'azin_video_cover' );
}
function azin_video_cover( $attr, $content='' ) {
    if ( ! isset( $attr['poster'] ) && has_post_thumbnail() ) {
        $poster = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
        $attr['poster'] = $poster['0'];
    }
    return wp_video_shortcode( $attr, $content);
}

//Add role name to comment author's name
add_filter( 'get_comment_author', 'azin_get_comment_author', 10, 3);
function azin_get_comment_author( $author, $comment_ID, $comment) {
    $post = get_post();
    $download_id = get_the_ID();
    $user_id = $comment->user_id;
    if ( get_post_type() == 'download' && azin_opt( 'show_scomm' ) && ! is_admin() ) {
        if (user_can( $user_id, 'manage_options' ) ) {
            $author = $author . '<span class="comment-admin">'.azin_opt( 'text_admin' ).'</span>';
        } elseif ( $post->post_author == $comment->user_id) {
            $author = $author . '<span class="comment-seller">'.azin_opt( 'text_seller' ).'</span>';
        } elseif ( edd_has_user_purchased( $user_id, $download_id) ) {
            $author = $author . '<span class="comment-buyer">'.azin_opt( 'text_customer' ).'</span>';
        } else {
            $author = $author;
        }
    }
    if ( get_post_type() == 'post' && azin_opt( 'show_scomm' ) && !is_admin() ) {
        if (user_can( $user_id, 'manage_options' ) ) {
            $author = $author . '<span class="comment-admin">'.azin_opt( 'text_admin' ).'</span>';
        }
    }
    
    return $author;
}

//remove_admin_bar
add_action( 'after_setup_theme', 'azin_remove_admin_bar' );
function azin_remove_admin_bar() {
    if ( ! azin_opt( 'show_abar' ) )
        return;
    if ( ( current_user_can( 'edit_posts' ) && azin_opt( 'show_abar_editor' ) ) || ( current_user_can( 'administrator' ) && azin_opt( 'show_abar_admin' ) ) ) {
        add_filter( 'show_admin_bar', '__return_true' );
    } else {
        add_filter( 'show_admin_bar', '__return_false' );
    }
}

function posticon( $p_id ) {
    $posticon = ( rwmb_meta( 'file_p_type', '', $p_id ) != '' ? rwmb_meta( 'file_p_type', '', $p_id ) : 'download' );
    if ( ! rwmb_meta( 'file_coming', '', $p_id) ) {
        $price = azin_is_free( $p_id  ) ? azin_opt( 'text_dl' ) : azin_opt( 'text_buy' );
    } else {
        $price = azin_opt( 'text_coming_soon' );
    }
    $posticon = str_replace( 'cfa fa-', '', $posticon );
    echo '<i class="fal fa-'. $posticon .'"></i> '. $price;
}

//Product and Posts Image Size
function p_img() {
    if ( has_post_thumbnail() ) {
        the_post_thumbnail( 'single-download' );
    } else {
        echo '<img width="472" height="267" src="'.esc_url( get_template_directory_uri() ).'/images/thumb.png" alt="'.the_title_attribute( 'echo=0' ).'" class="post-tumb"/>';
    }
}

//Posts Custom Image Size
function pc_img() {
    if ( has_post_thumbnail() ) {
        the_post_thumbnail( 'single-post' );
    } else {
        echo '<img width="472" height="267" src="'.esc_url( get_template_directory_uri() ).'/images/thumb.png" alt="'.the_title_attribute( 'echo=0' ).'" class="post-tumb"/>';
    }
}

//add_classes_to_linked_images
if ( azin_opt( 'slide_img' ) ) {
    add_filter( 'the_content', 'add_classes_to_linked_images', 100, 1);
}
function add_classes_to_linked_images( $html ) {
    $classes = 'timg';

    $patterns = array();
    $replacements = array();
    $patterns[0] = '/<a(?![^>]*class)([^>]*)>\s*<img([^>]*)>\s*<\/a>/'; //matches img tag wrapped in anchor tag where anchor tag has no existing classes
    $replacements[0] = '<a\1 class="' . $classes . '"><img\2></a>';
    $html = preg_replace( $patterns, $replacements, $html);
    return $html;
}

//Filter the except length to 20 words.
add_filter( 'excerpt_length', 'wpdocs_custom_excerpt_length', 999);
function wpdocs_custom_excerpt_length( $length) {
    return 22;
}

function wpdocs_excerpt_more( $more ) {
	return '...';
}
add_filter( 'excerpt_more', 'wpdocs_excerpt_more' );

//page or post sidebar setting
function p_sidebar( $id ) {
    
    $class = '';
    $side_type = rwmb_meta( 'file_wside', '', $id);
    if ( $side_type == 1 || $side_type == 'noside' ) {
        $class = 'wside col-12';
    } elseif ( $side_type == 'rside' ) {
        $class = 'col-lg-9 col-12 right-side';
    } elseif ( $side_type == 'lside' ) {
        $class = 'col-lg-9 col-12';
    } else {
        if ( azin_opt( 'side_type' ) == 2 ) {
            $class = 'col-lg-9 col-12 right-side';
        } else {
            $class = 'col-lg-9 col-12';
        }
    }
    
    return $class;
}

//Updating the subscriber role
$subscriber_role = get_role( 'subscriber' );

if ( $subscriber_role ) {
    // Adding a new capability to role
    $subscriber_role->add_cap( 'view_ticket' );
    $subscriber_role->add_cap( 'create_ticket' );
    $subscriber_role->add_cap( 'close_ticket' );
    $subscriber_role->add_cap( 'reply_ticket' );
    $subscriber_role->add_cap( 'attach_files' );
}

$customer_role = get_role( 'customer' );

if ( $customer_role ) {
    // Adding a new capability to role
    $customer_role->add_cap( 'view_ticket' );
    $customer_role->add_cap( 'create_ticket' );
    $customer_role->add_cap( 'close_ticket' );
    $customer_role->add_cap( 'reply_ticket' );
    $customer_role->add_cap( 'attach_files' );
}

$seller_role = get_role( 'seller' );

if ( $seller_role ) {
    // Adding a new capability to role
    $seller_role->add_cap( 'view_ticket' );
    $seller_role->add_cap( 'create_ticket' );
    $seller_role->add_cap( 'close_ticket' );
    $seller_role->add_cap( 'reply_ticket' );
    $seller_role->add_cap( 'attach_files' );
}

if ( class_exists( 'Affiliate_WP' ) ) {
    add_filter( 'page_template', 'affiliate_page_template' );
    function affiliate_page_template( $page_template )
    {
        global $post;
        $post_id = $post->ID;
        if ( $post_id === (int)affwp_get_affiliate_area_page_id() ) {
            $page_template = get_stylesheet_directory() . '/affiliate-area.php';
        }
        return $page_template;
    }
}

if ( class_exists( 'Awesome_Support' ) ) {
    add_filter( 'page_template', 'ticket_page_template' );
    function ticket_page_template( $page_template)
    {
        global $post;
        $ticket_id = wpas_get_option( 'ticket_list' );
        $ticket_submit_id = wpas_get_option( 'ticket_submit' );
        if ( is_array( $ticket_submit_id) ) {
            $ticket_submit = $ticket_submit_id[0];
        } else {
            $ticket_submit = $ticket_submit_id;
        }
        $post_id = $post->ID;
        if (( $post_id === (int)$ticket_id) || ( $post_id === (int)$ticket_submit) ) {
            $page_template = get_stylesheet_directory() . '/tickets.php';
        }
        return $page_template;
    }
}

//azin_breadcrumb
function azin_bread() {
    
    $page_bread = rwmb_meta( 'file_bread', '', get_the_ID() );
    if ( azin_opt( 'show_bread' ) && !azin_opt( 'bread_style_two' ) && !is_front_page() && !$page_bread) { ?>
        <div class="row">
            <div class="col-12">
                <?php
                if ( function_exists( 'yoast_breadcrumb' ) ) {
                    $breadcrumbs_enabled = WPSEO_Options::get( 'breadcrumbs-enable', false );
                }
                if ( azin_opt( 'bread_crumbs_sync' ) && function_exists( 'yoast_breadcrumb' ) && $breadcrumbs_enabled ) {
                    yoast_breadcrumb( '<p class="breadcrumbs" id="breadcrumbs">','</p>' );
                } elseif ( azin_opt( 'bread_crumbs_sync' ) && function_exists( 'rank_math_the_breadcrumbs' ) ) {
                    echo '<div class="breadcrumbs" id="breadcrumbs">';
                    rank_math_the_breadcrumbs();
                    echo '</div>';
                } elseif ( az_woo() ) {
                    woocommerce_breadcrumb();
                } else {
                    breadcrumb();
                }
                ?>
            </div>
        </div>
    <?php }
}

//azin_bread_two
function azin_bread_two( $id ) {
    
    $page_bread = rwmb_meta( 'file_bread', '', $id );
    if ( ! $page_bread ) { ?>
        <div class="container-fluid bread-crumbs">
            <div class="container">
                <div class="row">
                    <div class="col-12 bread-page-title">
                        <h1 <?php if ( azin_opt( 'site_schema' ) ) { ?>itemprop="name headline"<?php } ?>> 
                            <?php

                                if ( class_exists( 'WeDevs_Dokan' ) && dokan_is_store_page() ) {
                                    $store_user   = get_userdata( get_query_var( 'author' ) );
                                    $store_info   = dokan_get_store_info( $store_user->ID );
                                    echo $store_info ['store_name'];
                                } elseif ( is_archive() ) {
                                    echo get_the_archive_title();
                                } else {
                                    azin_wp_title( '', true, '' );
                                }

                            ?>
                        </h1>
                        <?php
                            if ( azin_opt( 'bread_count_prod' ) && ( is_search() || is_tax( 'download_category' ) || is_tax( 'product_cat' ) || is_tax( 'download_tag' ) || is_tax( 'product_tag' ) ) ) {
                                global $wp_query;
                                $product_counts = $wp_query->found_posts;
                                $pcounts = sprintf( __( 'Number of products: %1$s', 'azin-file' ), $product_counts );
                                echo '<div class="az-products-count">' . $pcounts . '</div>';
                            }
                        ?>
                    </div>
                    <div class="col-12 bread-st-two">
                        <?php
                        
                            if ( function_exists( 'yoast_breadcrumb' ) ) {
                                $breadcrumbs_enabled = WPSEO_Options::get( 'breadcrumbs-enable', false );
                            }

                            if ( azin_opt( 'bread_crumbs_sync' ) && function_exists( 'yoast_breadcrumb' ) && $breadcrumbs_enabled ) {
                                yoast_breadcrumb( '<p class="breadcrumbs" id="breadcrumbs">','</p>' );
                            } elseif ( azin_opt( 'bread_crumbs_sync' ) && function_exists( 'rank_math_the_breadcrumbs' ) ) {
                                echo '<div class="breadcrumbs" id="breadcrumbs">';
                                rank_math_the_breadcrumbs();
                                echo '</div>';
                            } elseif ( az_woo() ) {
                                woocommerce_breadcrumb();
                            } else {
                                breadcrumb();
                            }
                        ?>
                    </div>

                    <?php if ( ! is_archive() && ! is_page() && ! is_home() ) { ?>

                        <div class="col-12 bread-extra">

                        <?php if ( ! azin_opt( 'show_pre_prod_btn_under' ) ) { ?>
                        <?php if ( rwmb_meta( 'file_pre' , '',  $id ) != '' ) { ?>
                            <a href="<?php echo rwmb_meta(  'file_pre' , '',  $id ); ?>" data-title="<?php echo azin_opt( 'text_pre' ); ?>" target="_blank">
                                <span class="pre-btn" data-toggle="tooltip" data-placement="top" title="<?php echo azin_opt( 'text_pre' ); ?>">
                                    <i class="<?php echo azin_opt( 'pre_prod_btn_icon' ); ?>"></i>
                                    <span class="pre-text">
                                        <?php echo azin_opt( 'text_pre' ); ?>
                                    </span>
                                </span>
                            </a>
                        <?php } ?>
                        <?php } ?>


                        <?php //Like Button 
                        if ( azin_opt( 'product_like_btn' ) ) { ?>

                            <?php if ( is_single() && 'product' == get_post_type() && class_exists('YITH_WCWL') ) { ?>
                                <span class="azin-like-product-single" data-toggle="tooltip" data-placement="top"  title="<?php _e( 'Add to Wishlist', 'azin-file'); ?>">
                                    <?php echo preg_replace("/<img[^>]+\>/i", " ", do_shortcode('[yith_wcwl_add_to_wishlist product_id="'. $id .'" icon="fa-heart" already_in_wishslist_text="" product_added_text="" label="" browse_wishlist_text=""]') ); ?>
                                </span>
                            <?php } elseif ( is_single() && 'download' == get_post_type() && class_exists('EDD_Wish_Lists') ) { ?>
                                <span class="azin-like-product-single" data-toggle="tooltip" data-placement="top"  title="<?php _e( 'Add to Wishlist', 'azin-file'); ?>">
                                    <?php edd_wl_load_wish_list_link( $id ); ?>
                                </span>
                            <?php } ?>

                        <?php } 
                        //Like Button ?>


                        
                        <?php if ( is_single() ) { 
                            if ( azin_opt( 'social_share' ) ) { ?>
                            <span tabindex="0" class="share-btn" data-toggle="modal" data-target="#shareModal">
                                <i class="fal fa-share-alt" data-toggle="tooltip" data-placement="top" title="<?php _e( 'Share', 'azin-file' ) ?>"></i>
                            </span>
                        <?php }
                        } ?>

                        <?php if ( is_single() && 'product' == get_post_type() ) { ?>

                            <?php if ( function_exists("waproduct_add_star_rating") && ( azin_opt( 'star_rating' ) ) ) { ?>
                                <div class="rating">
                                    <?php waproduct_add_star_rating( $id ); ?>
                                </div>
                            <?php } ?>

                        <?php } elseif ( is_single() && ( 'download' == get_post_type() || 'post' == get_post_type() ) ) { ?>

                            <?php if ( function_exists("az_star_ratings") && ( azin_opt( 'star_rating' ) ) ) { ?>
                                <div class="rating">
                                    <?php echo az_star_ratings( $id ); ?>
                                </div>
                            <?php } ?>

                        <?php } ?>

                        </div>

                    <?php } ?>
                    
                </div>
            </div>
        </div>
<?php }
}

//Sidbar type
function side_type() {
    
    $side_type = rwmb_meta( 'file_wside', '', get_the_ID() );
    if ( ( $side_type == '' || $side_type == 'dside' ) && azin_opt( 'side_type' ) == 2 ) {
        $side_type = 'rside ';
    } elseif ( $side_type == 'rside' ) {
        $side_type = 'rside';
    }
    echo ' ' . $side_type . ' ';
}

//azin_date
function azin_date() {
    if( ! is_rtl() ) {
        echo date( 'l, j F Y' );
    } elseif ( function_exists( 'eng_number' ) ) {
		echo parsidate( 'l، j F Y' );
	} elseif ( function_exists( 'wp_date' ) ) {
		echo wp_date( 'l، j F Y' );
	} elseif ( function_exists( 'jdate' ) ) {
        echo jdate( 'l، j F Y' );
    } elseif ( function_exists( 'wpp_jdate' ) ) {
        echo wpp_jdate( 'l، j F Y' );
    } else {
		echo date( 'l، j F Y' );
	}
}

//get_jdate_publish_time
function get_jdate_publish_time() {
	$greg_date = get_post_time( 'j F Y' );
    $timestamp = strtotime( $greg_date);
    if ( function_exists( 'eng_number' ) ) {
		echo parsidate( 'j F Y', $timestamp);
	} elseif ( function_exists( 'wp_date' ) ) {
        echo wp_date( 'j F Y', $timestamp);
    } elseif ( function_exists( 'jdate' ) ) {
        echo jdate( 'j F Y', $timestamp);
    } else {
		echo $greg_date;
	}
}

function get_jdate_publish_time_two( $arg ) {

    if ( empty ( $arg ) )
        return;

	$greg_date = get_post_time('j F Y');
    $timestamp = strtotime( $greg_date );

    if (defined( 'PW_VERSION' ) && PW_VERSION >= '4.0.0'){
        $date = get_the_date( $arg );
    } elseif( function_exists( 'jdate' ) ){
		$date = jdate( $arg, $timestamp );
	} elseif( function_exists( 'parsidate' ) ){
        $date = parsidate( $arg, $timestamp );
    } elseif( function_exists( 'wpp_jdate' ) ){
        $date = wpp_jdate( $arg, $timestamp );
    } elseif( function_exists( 'wp_date' ) ){
        $date = wp_date( $arg, $timestamp );
    } else {
		$date = $greg_date;
	}

    return $date;
}

//azin_register_date
function azin_register_date( $author ) {
    $user_reg = strtotime( get_the_author_meta( 'user_registered', $author ) );
    if ( function_exists( 'wp_date' ) ) {
		echo wp_date( 'Y/m/d', $user_reg, null );
    } elseif ( function_exists( 'eng_number' ) ) {
		echo parsidate( 'Y/m/d', get_the_author_meta( 'user_registered', $author ), $lang='per' );
	} else {
		echo date( 'Y/m/d' );
	}
}

// Get post primary category
function get_post_primary_category( $post_id, $term='category', $return_all_categories=false ) {
    $return = array();

    if (class_exists('WPSEO_Primary_Term') ){
        // Show Primary category by Yoast if it is enabled & set
        $wpseo_primary_term = new WPSEO_Primary_Term( $term, $post_id );
        $primary_term = get_term($wpseo_primary_term->get_primary_term() );

        if (!is_wp_error($primary_term) ){
            $return['primary_category'] = $primary_term;
        }
    }

    if (empty($return['primary_category'] ) || $return_all_categories) {
        $categories_list = get_the_terms($post_id, $term);

        if (empty($return['primary_category'] ) && !empty($categories_list) ){
            $return['primary_category'] = $categories_list[0];  //get the first category
        }
        if ( $return_all_categories){
            $return['all_categories'] = array();

            if (!empty($categories_list) ){
                foreach($categories_list as &$category){
                    $return['all_categories'][] = $category->term_id;
                }
            }
        }
    }
    return $return;
}

//get seller store seller url
function get_store_url( $id) {
    $seller_id  = get_user_by( 'id', $id );
    $vendor = dokan()->vendor->get( $seller_id );

    return  $vendor->get_shop_url();
}

//azin_archive_title
add_filter( 'get_the_archive_title', 'azin_archive_title' );
function azin_archive_title( $title ) {
    if ( is_category() ) {
        $title = single_cat_title( '', false );
    } elseif ( is_tag() ) {
        $title = single_tag_title( '', false );
    } elseif ( is_author() ) {
        $title = '<span class="vcard">' . get_the_author() . '</span>';
    } elseif ( is_post_type_archive() ) {
        $title = post_type_archive_title( '', false );
    } elseif ( is_tax() ) {
        $title = single_term_title( '', false );
    }
  
    return $title;
}

//Change wp-admin logo
add_action( 'login_head', 'azin_login_logo' );
function azin_login_logo() {
    if ( ! azin_opt( 'login_logo_switch' ) )
        return;
    echo '<style type="text/css">
    h1 a {background-image: url( '. azin_to_https( azin_opt( 'site_logo_retina', 'url' ) ) .' ) !important;
    width: 280px!important;
    height: 120px!important;
    background-size: contain!important;
    margin-bottom: 0px!important;
    }
    </style>';
}

add_filter( 'login_headerurl', 'azin_login_headerurl', 10, 2 );
function azin_login_headerurl() {
    return esc_url( home_url() );
}
    

if ( ! function_exists( 'rwmb_meta' ) ) {
    function rwmb_meta( $key, $args = '', $post_id = null ) {
        return false;
    }
}

//azin_search_form
function azin_search_form( $class, $id, $ajax, $sid ) {
    
    $is_ajax = ( ( azin_opt( 'ajax_search' ) && $ajax === true ) ? ' data-swplive="true"' : '' ); ?>

    <form role="search" method="get" id="<?php echo $id; ?>" class="<?php echo $class; ?>" action="<?php echo esc_url( home_url() ); ?>">
        <div class="input-group input-group-lg ajax-search-wrapper">

            <?php if ( azin_opt( 'search_type' ) && ! azin_opt( 'search_cat' ) ) {
                $product_ptype = ( az_woo() ? 'product' : 'download' ); ?>
                <span class="input-group-before s-select">
                    <select aria-label="Post type" name="post_type">
                        
                    <?php if ( azin_opt( 'replace_product_post' ) ) { ?>
                        <option value="post">
                            <?php echo azin_opt( 'text_blog' ); ?>
                        </option>

                        <option value="<?php echo $product_ptype; ?>">
                                <?php echo azin_opt( 'text_shop' ); ?>
                        </option>
                    <?php } else { ?>
                        <option value="<?php echo $product_ptype; ?>">
                                <?php echo azin_opt( 'text_shop' ); ?>
                        </option>

                        <option value="post">
                            <?php echo azin_opt( 'text_blog' ); ?>
                        </option>
                    <?php } ?>

                    </select>
                </span>
            <?php } else { ?>
                <?php if ( az_woo() ) { ?>
                    <input type="hidden" value="product" name="post_type">
                <?php } else {  ?>
                    <input type="hidden" value="download" name="post_type">
                <?php } ?>
            <?php } ?>

            <?php 

                if ( azin_opt( 'search_cat' ) ) {

                    $product_taxonomy = ( az_woo() ? 'product_cat' : 'download_category' );

                    $args = array (
                        'taxonomy'    => $product_taxonomy,
                        'hide_empty'  => true,
                        'show_count'   => 0,
                        'hierarchical' => 1,
                        'show_option_all' => __( 'Category', 'azin-file' ),
                        'value_field' => 'slug',
                        'name' => 'product_cat',
                        'class' => 'product_cat',
                        'echo' => 0
                    );

                    if ( azin_opt( 'search_cat_sort' ) ) {
                        $args['orderby'] = 'name';
                        $args['order'] = 'ASC';
                    }

                    if ( azin_opt( 'search_cat_parent' ) ) {
                        $args['parent'] = 0;
                    }

                    if ( ! empty ( azin_opt( 'search_cat_cats' ) ) ) {
                        $args['exclude'] = azin_opt( 'search_cat_cats' );
                    }

                    if ( azin_opt( 'search_cat_hierarchical' ) ) {
                        $args['hierarchical'] = 1;
                    }

                    $categories = wp_dropdown_categories( $args );

                    if ( ! empty( $categories ) && ! is_wp_error( $categories ) ) {
                        ?>
                        <div class="input-group-before s-select">
                            <?php echo $categories; ?>
                        </div>
                    <?php } 
                }
            ?>

            <input autocomplete="off"<?php echo $is_ajax; ?>aria-label="Search" type="text" name="s" class="form-control msh<?php if ( !azin_opt( 'search_type' ) ) { ?> sntype<?php } ?>" placeholder="<?php echo azin_opt( 'text_search' ); ?>" required>

            <span class="input-group-append">
                <button type="submit" aria-label="Search" id="searchsubmith" class="btn btn-search"><i class="fal fa-search"></i></button>
            </span>
        </div>
    </form>
<?php
}

//azin_wrapper_start
function azin_wrapper_start() {
    
    if ( azin_opt( 'show_bread' ) && azin_opt( 'bread_style_two' ) && ! is_front_page() )
        azin_bread_two( get_the_ID() );
	?>

	<div class="container-fluid main-con">
        <main class="container main-container">
    <?php  

    azin_bread();

    if ( azin_opt( 'show_head_down' ) && is_single() )
        az_header_banner();
}

//azin_wrapper_end
function azin_wrapper_end() {
	?>
        </main>
    </div>
	<?php
}

//Remove URL filed from comment form
add_filter('comment_form_default_fields', 'website_remove' );
function website_remove( $fields ) {

    if ( ! azin_opt( 'comment_remove_url' ) )
        return $fields;

    if ( isset( $fields['url'] ) )
        unset( $fields['url'] );

    return $fields;
}

//Remove Cookie filed from comment form
if ( azin_opt( 'comment_remove_cookie' ) ) {
    remove_action( 'set_comment_cookies', 'wp_set_comment_cookies' );
}

/* Convert hexdec color string to rgb(a) string */
if ( !function_exists( 'hex2rgba' ) ) {
    function hex2rgba( $hex, $alpha = '' ) {
        $hex = str_replace( "#", "", $hex );
        if ( strlen( $hex ) == 3 ) {
            $r = hexdec( substr( $hex, 0, 1 ) . substr( $hex, 0, 1 ) );
            $g = hexdec( substr( $hex, 1, 1 ) . substr( $hex, 1, 1 ) );
            $b = hexdec( substr( $hex, 2, 1 ) . substr( $hex, 2, 1 ) );
        } else {
            $r = hexdec( substr( $hex, 0, 2 ) );
            $g = hexdec( substr( $hex, 2, 2 ) );
            $b = hexdec( substr( $hex, 4, 2 ) );
        }
        $rgb = $r . ',' . $g . ',' . $b;
    
        if ( '' == $alpha ) {
            return $rgb;
        } else {
            $alpha = floatval( $alpha );
    
            return 'rgba(' . $rgb . ',' . $alpha . ' )';
        }
    }
}

//Azinfile banner image
function azin_bnr_image( $args ) {
    $img_src       = $args['img_src'];
    $img_link_url  = $args['img_link_url'];
    $img_title     = $args['img_title'];
    $link_target   = ( ! empty ( $args['link_target'] ) ? $args['link_target'] : '' );
    $link_rel      = ( ! empty ( $args['link_rel'] ) ? $args['link_rel'] : '' );
    $hover_effect  = $args['hover_effect'];
    $hover_title   = $args['hover_title'];
    $image_width   = $args['image_width'];
    $image_height  = $args['image_height'];
    $image_height  = $args['image_height'];
    $not_on_mobile = $args['not_on_mobile'] ? ' hidden-mobile' : '';
    $custom_class  = $args['custom_class'];
?>
    <div class="bnr-image shadow-box <?php echo $hover_effect . $custom_class . $not_on_mobile; ?>">
            <a href="<?php echo $img_link_url; ?>" title="<?php echo $img_title; ?>"<?php echo $link_target . $link_rel; ?>>
				<?php if( $hover_title === 'yes' ) { ?>
					<span class="bnr-hover-title">
						<span>
							<?php echo $img_title; ?>
						</span>
					</span>
				<?php } ?>
                <img src="<?php echo $img_src; ?>" alt="<?php echo $img_title; ?>" width="<?php echo $image_width; ?>" height="<?php echo $image_height; ?>">
            </a>
    </div>
<?php
}

//Azinfile banner code
function azin_bnr_code( $args ) {
    $bnr_code      = $args['bnr_code'];
    $not_on_mobile = $args['not_on_mobile'] ? ' hidden-mobile' : '';
    $custom_class  = $args['custom_class'];
?>
    <div class="bnr-code <?php echo $custom_class . $not_on_mobile; ?>">
        <?php echo do_shortcode( $bnr_code ); ?>       
    </div>
<?php
}

//Azin WP Title
function azin_wp_title( $sep = '&raquo;', $display = true, $seplocation = '' ) {
    global $wp_locale;
 
    $m        = get_query_var( 'm' );
    $year     = get_query_var( 'year' );
    $monthnum = get_query_var( 'monthnum' );
    $day      = get_query_var( 'day' );
    $search   = get_query_var( 's' );
    $title    = '';
 
    $t_sep = '%WP_TITLE_SEP%'; // Temporary separator, for accurate flipping, if necessary.
 
    // If there is a post.
    if ( is_single() || ( is_home() && ! is_front_page() ) || ( is_page() && ! is_front_page() ) ) {
        $title = single_post_title( '', false );
    }
 
    // If there's a post type archive.
    if ( is_post_type_archive() ) {
        $post_type = get_query_var( 'post_type' );
        if ( is_array( $post_type ) ) {
            $post_type = reset( $post_type );
        }
        $post_type_object = get_post_type_object( $post_type );
        if ( ! $post_type_object->has_archive ) {
            $title = post_type_archive_title( '', false );
        }
    }
 
    // If there's a category or tag.
    if ( is_category() || is_tag() ) {
        $title = single_term_title( '', false );
    }
 
    // If there's a taxonomy.
    if ( is_tax() ) {
        $term = get_queried_object();
        if ( $term ) {
            $tax   = get_taxonomy( $term->taxonomy );
            $title = single_term_title( $tax->labels->name . $t_sep, false );
        }
    }
 
    // If there's an author.
    if ( is_author() && ! is_post_type_archive() ) {
        $author = get_queried_object();
        if ( $author ) {
            $title = $author->display_name;
        }
    }
 
    // Post type archives with has_archive should override terms.
    if ( is_post_type_archive() && $post_type_object->has_archive ) {
        $title = post_type_archive_title( '', false );
    }
 
    // If there's a month.
    if ( is_archive() && ! empty( $m ) ) {
        $my_year  = substr( $m, 0, 4 );
        $my_month = $wp_locale->get_month( substr( $m, 4, 2 ) );
        $my_day   = (int) substr( $m, 6, 2 );
        $title    = $my_year . ( $my_month ? $t_sep . $my_month : '' ) . ( $my_day ? $t_sep . $my_day : '' );
    }
 
    // If there's a year.
    if ( is_archive() && ! empty( $year ) ) {
        $title = $year;
        if ( ! empty( $monthnum ) ) {
            $title .= $t_sep . $wp_locale->get_month( $monthnum );
        }
        if ( ! empty( $day ) ) {
            $title .= $t_sep . zeroise( $day, 2 );
        }
    }
 
    // If it's a search.
    if ( is_search() ) {
        /* translators: 1: Separator, 2: Search query. */
        $title = sprintf( __( 'Search Results %1$s %2$s' ), $t_sep, strip_tags( $search ) );
    }
 
    // If it's a 404 page.
    if ( is_404() ) {
        $title = __( 'Page not found' );
    }
 
    $prefix = '';
    if ( ! empty( $title ) ) {
        $prefix = " $sep ";
    }
 
    /**
     * Filters the parts of the page title.
     *
     * @since 4.0.0
     *
     * @param string[] $title_array Array of parts of the page title.
     */
    $title_array = apply_filters( 'wp_title_parts', explode( $t_sep, $title ) );
 
    // Determines position of the separator and direction of the breadcrumb.
    if ( 'right' === $seplocation ) { // Separator on right, so reverse the order.
        $title_array = array_reverse( $title_array );
        $title       = implode( " $sep ", $title_array ) . $prefix;
    } else {
        $title = $prefix . implode( " $sep ", $title_array );
    }
 
    /**
     * Filters the text of the page title.
     *
     * @since 2.0.0
     *
     * @param string $title       Page title.
     * @param string $sep         Title separator.
     * @param string $seplocation Location of the separator ('left' or 'right').
     */
    //$title = apply_filters( 'wp_title', $title, $sep, $seplocation );
 
    // Send it out.
    if ( $display ) {
        echo $title;
    } else {
        return $title;
    }
}

// define the edd_cart_item callback 
add_filter( 'edd_cart_item', 'az_filter_edd_cart_item', 10, 2 ); 
function az_filter_edd_cart_item( $item, $id ) { 
    $item_image = get_the_post_thumbnail( $id, 'widget-img' );
    $item_link = get_permalink( $id );
    $output = str_replace( '{item_image}', $item_image, $item );
    $output = str_replace( '{item_link}', $item_link, $output );
    return $output;
};

//Azin add body classes
add_filter( 'body_class','azin_body_classes' );
function azin_body_classes( $classes ) {

    //Check RTL Or LTR
    $classes[] = ( is_rtl() ? 'rtl' : 'ltr' );
    //Full Width Style
    $classes[] = ( azin_opt( 'full_width_style' ) ? 'az-wide-layout' : 'az-box-layout' );
    //Add body class for category widget
    $classes[] = ( azin_opt( 'open_cat_widget' ) ? 'azin-open-cat' : '' );
    //Woocommerce Or EDD Mode
    $classes[] = ( az_woo() ? 'azin-woocommerce' : 'azin-edd' );
    //Square Widget Images
    $classes[] = ( azin_opt( 'square_widget' ) ? 'azin-square-widget' : 'azin-circle-widget' );
    //Add body class for mobile bar
    $classes[] = ( azin_opt( 'show_mobile_bar' ) ? 'azin-bbar' : '' );
    //Add body class for course page
    $classes[] = ( azin_is_course( get_the_ID() ) ? 'azin-course-page' : '' );
    //Add free price class to product page
    $classes[] = ( is_singular( array( 'product', 'download' ) ) && azin_is_free( get_the_ID() ) ? 'azin-free-product' : '' );

    return $classes;
}

//az_show_side_mobile
function az_show_side_mobile() {
    if ( is_singular( array( 'product', 'download' ) ) && azin_opt( 'product_style_two' ) )
        return;

    if ( !azin_opt( 'show_side_mobile' ) )
        return ' hidden-sm hidden-xs hidden-mobile';
}

//Azin Replace Http to Https
function azin_to_https( $url ){
    if( is_ssl() ){
        $url = str_replace( "http://", "https://", $url );
    }
    return $url;
}

//Get terms link
function azin_get_term_links( $term_tax, $term_ids ) {
    
    if ( is_array( $term_ids ) )
    {	
        $term_tax_link = ( $term_tax == 'category' ? 'cat' : $term_tax );
        $term_tax_link = ( $term_tax == 'post_tag' ? 'tag' : $term_tax );
        if( count( $term_ids ) == 1 ) {
            $term_link = get_term_link( (int)$term_ids[0], $term_tax );
        } else {
            $term_link = get_home_url() . '/?'.$term_tax_link.'=';
            foreach( $term_ids as $id ) {
                $term = get_term( $id, $term_tax );
                $slug = $term->slug;
                $term_link .= $slug . ',';
            }
        }
    } else {
		$term_link = get_term_link( (int)$term_ids, $term_tax );
    }
    
    if ( is_wp_error ( $term_link ) ) {
		return '';
	} else {
		return $term_link;
	}
}

//Disable RSS Feeds in WordPress
function azin_disable_feed() {
    $site_url = get_bloginfo('url');
    wp_die( sprintf( __( 'No feed available,please visit our <a href="%s">homepage</a>!', 'azin-file' ), $site_url ) );
}
     
if ( azin_opt( 'dis_rss_feeds' ) ) {
    add_action('do_feed', 'azin_disable_feed', 1);
    add_action('do_feed_rdf', 'azin_disable_feed', 1);
    add_action('do_feed_rss', 'azin_disable_feed', 1);
    add_action('do_feed_rss2', 'azin_disable_feed', 1);
    add_action('do_feed_atom', 'azin_disable_feed', 1);
    add_action('do_feed_rss2_comments', 'azin_disable_feed', 1);
    add_action('do_feed_atom_comments', 'azin_disable_feed', 1);
    remove_action( 'wp_head', 'feed_links_extra', 3 );
    remove_action( 'wp_head', 'feed_links', 2 );
}

//Function to set custom 404 page
if( ! function_exists( 'azin_custom_404_page' ) ) {
	function azin_custom_404_page( $template ) {
		global $wp_query;
        
		$custom_404 = azin_opt( 'custom_404_page' );
		if ( $custom_404 == 'default' || empty( $custom_404 )  ) return $template;

		$wp_query->query( 'page_id=' . $custom_404 );
		$wp_query->the_post();
		$template = get_page_template();
		rewind_posts();

		return $template;
	}
    add_filter( '404_template', 'azin_custom_404_page', 999 );
}

//Allowed mime types and file extensions 
add_filter( 'upload_mimes', 'azin_add_fonts_to_allowed_mimes' );
function azin_add_fonts_to_allowed_mimes( $mimes ) {
    $mimes['woff']  = 'application/x-font-woff';
    $mimes['woff2'] = 'application/x-font-woff2';
    $mimes['ttf']   = 'application/x-font-ttf';
    $mimes['svg']   = 'image/svg+xml';
    $mimes['eot']   = 'application/vnd.ms-fontobject';
    $mimes['otf']   = 'font/otf';

    return $mimes;
}

//Correct the mome types and extension for the font types.
add_filter( 'wp_check_filetype_and_ext', 'azin_update_mime_types', 10, 3 );
function azin_update_mime_types( $defaults, $file, $filename ) {
    if ( 'ttf' === pathinfo( $filename, PATHINFO_EXTENSION ) ) {
        $defaults['type'] = 'application/x-font-ttf';
        $defaults['ext']  = 'ttf';
    }

    if ( 'otf' === pathinfo( $filename, PATHINFO_EXTENSION ) ) {
        $defaults['type'] = 'application/x-font-otf';
        $defaults['ext']  = 'otf';
    }

    return $defaults;
}

//Disable the gutenberg block editor
if ( azin_opt( 'dis_widget_editor' ) ) {
    // Disables the block editor from managing widgets in the Gutenberg plugin.
    add_filter( 'gutenberg_use_widgets_block_editor', '__return_false' );
    // Disables the block editor from managing widgets.
    add_filter( 'use_widgets_block_editor', '__return_false' );
}

//azin_add_site_favicon_admin
add_action('login_head', 'azin_add_site_favicon_admin');
add_action('admin_head', 'azin_add_site_favicon_admin');
function azin_add_site_favicon_admin() {
	echo '<link rel="shortcut icon" href="'. azin_to_https( azin_opt( 'site_favicon', 'url' ) ) .'" type="image/x-icon" />';
}

add_filter( 'comment_form_defaults', 'azin_set_comment_form_defaults', 10, 3 );
function azin_set_comment_form_defaults( $defaults ) {
    //Here you are able to change the $defaults[]
    //For example: 
    $defaults['title_reply_before'] = '';
     
    return $defaults;
}

add_action( 'admin_enqueue_scripts', 'azin_remove_googleapis', 999 );
function azin_remove_googleapis() {
    wp_deregister_style( 'elementor-admin-top-bar-fonts' );
    wp_dequeue_style( 'elementor-admin-top-bar-fonts' );
}

function azin_page_loading() {
    if ( ! azin_opt( 'show_page_loading' ) )
        return;
    
    if ( azin_opt( 'show_custom_loading' ) && ! empty ( azin_opt( 'custom_loading_image', 'url' ) ) ) {
        echo '<div class="se-pre-con"></div>';
    } elseif ( ! empty ( azin_opt( 'load_img' ) ) ) {
        echo '<div class="se-pre-con"></div>';
    } else {
        return;
    }
}

//azin_modify_nav_menu_item_title
add_filter( "nav_menu_item_title", "azin_modify_nav_menu_item_title", 10, 4 );
function azin_modify_nav_menu_item_title( $title, $menu_item, $args, $depth ) { 

    $item_icon = "";
    if ( ! empty($menu_item->icon_image) ) {
        $item_icon = '<img src="'.$menu_item->icon_image.'" width="22" height="22" alt="'.$title.'" class="cu-menu-icon">';
    } elseif ( ! empty( $menu_item->icon ) && $menu_item->icon != 'none' ) {
        $item_icon = '<i class="fal '.$menu_item->icon.'"></i>';
    }

    $item_dlabel = "";
    if ( ! empty( $menu_item->dlabel ) ) {
        $item_dlabel = '<span class="dmenu_label">'.$menu_item->dlabel.'</span>';
    }

    return $item_icon . $title . $item_dlabel; 
}

//azin Login redirect to user specific URL.
if ( azin_opt( 'azin_login_redirect' ) ) {
    add_filter( 'login_redirect', 'azin_wp_login_redirect', 10, 3 );
}
function azin_wp_login_redirect ( $redirect_to, $request, $user ) {
    $redirect_to = azin_opt ( 'azin_login_redirect_url' );

    if ( empty( $redirect_to ) ) {
        $redirect_to = azin_myaccount_link();
    }

    return $redirect_to;
}

//azin WC Login redirect to user specific URL.
if ( azin_opt( 'azin_login_redirect' ) ) {
    add_filter( 'woocommerce_login_redirect', 'azin_wc_login_redirect', 99, 2 );
}
function azin_wc_login_redirect( $url, $user ) {
    $redirect_to = azin_opt ( 'azin_login_redirect_url' );

    if ( empty( $redirect_to ) ) {
        $redirect_to = azin_myaccount_link();
    }

    return $redirect_to;
}

//azin Logout redirect to user specific URL.
if ( azin_opt( 'azin_logout_redirect' ) ) {
    add_action( 'wp_logout', 'azin_wp_logout_redirect' );
}
function azin_wp_logout_redirect() {
    $azin_logout_redirect = azin_opt ( 'azin_logout_redirect_url' );

    if ( empty( $azin_logout_redirect ) ) {
        $azin_logout_redirect = azin_myaccount_link();
    }

    wp_redirect( $azin_logout_redirect );
    exit();
}

//Get logo Link
function azin_logo_link() {

    $logo_link = '';

    if( ! azin_opt( 'change_logo_link' ) ) {
        $logo_link = esc_url( home_url() );
    } else {
        $logo_link = esc_url( azin_opt( 'logo_link' ) );
    }

    return $logo_link;
}

//azin_locked_content
function azin_locked_content() {
    if ( function_exists('digits_version') && azin_opt( 'digits_mode' ) ) {
        $digits_mode = ( azin_opt( 'digits_page' ) ? 'digitsbtn digitlink' : 'digitsbtn digitpopup' );
        $login_msg = '<span class="'. $digits_mode .'">'.__( 'You must be logged in to view content.', 'azin-file').'</span>';
    } elseif( azin_opt( 'merge_user_btn' ) ) {
        $login_link = ( azin_opt( 'ch_login_link' ) ? 'href="'. azin_opt( 'login_link' ) .'"' : 'href="'. esc_url( azin_myaccount_link() ) .'"' );
        $login_msg = '<a title="'. __( 'Login Or Register', 'azin-file') .'" class="locked-content-link" '. $login_link .'>';
        $login_msg .= '<span>'.__( 'You must be logged in to view content.', 'azin-file').'</span>';
        $login_msg .= '</a>';
    } else {
        $login_link = ( azin_opt( 'ch_login_link' ) ? 'href="'. azin_opt( 'login_link' ) .'"' : 'href="javascript:void(0)" onclick="openLogin()"' );
        $login_msg = '<a title="'. __( 'Login Or Register', 'azin-file') .'" class="locked-content-link" '. $login_link .'>';
        $login_msg .= '<span>'.__( 'You must be logged in to view content.', 'azin-file').'</span>';
        $login_msg .= '</a>';
    } ?>
    <div class="azin-locked-content">
        <i class="fal fa-user-lock azin-locked-content-icon" aria-hidden="true"></i>
        <div class="azin-locked-content-text">
            <?php echo $login_msg; ?>
        </div>
    </div>
<?php
}

//azin archive description
function azin_archive_description() {
    if ( is_search() ) { 
        return;
    }

    global $wp_query;

    if ( azin_opt( 'show_first_text_cat' ) && $wp_query->get( 'paged' ) > 1 )
        return;
    
    if ( class_exists('WooCommerce') && is_shop() ) {
        $shop_page = get_post( wc_get_page_id( 'shop' ) );
        $allowed_html = wp_kses_allowed_html( 'post' );
        // This is needed for the search product block to work.
        $allowed_html = array_merge(
            $allowed_html,
            array(
                'form'   => array(
                    'action'         => true,
                    'accept'         => true,
                    'accept-charset' => true,
                    'enctype'        => true,
                    'method'         => true,
                    'name'           => true,
                    'target'         => true,
                ),

                'input'  => array(
                    'type'        => true,
                    'id'          => true,
                    'class'       => true,
                    'placeholder' => true,
                    'name'        => true,
                    'value'       => true,
                ),

                'button' => array(
                    'type'  => true,
                    'class' => true,
                    'label' => true,
                ),

                'svg'    => array(
                    'hidden'    => true,
                    'role'      => true,
                    'focusable' => true,
                    'xmlns'     => true,
                    'width'     => true,
                    'height'    => true,
                    'viewbox'   => true,
                ),
                'path'   => array(
                    'd' => true,
                ),
            )
        );
        if ( ! empty ( $shop_page->post_content ) ) {
            $archive_desc = wc_format_content( wp_kses( $shop_page->post_content, $allowed_html ) );
        }
    } elseif ( ! is_author() && ! empty( get_the_archive_description() ) ) {
        $archive_desc = get_the_archive_description();
    }
    ?>
    <?php if ( ! empty ( $archive_desc ) ) { ?>
    <div class="col-12 azin-cat-top-desc shadow-box-white">
        <?php if ( azin_opt( 'show_archive_desc_title' ) ) { ?>
            <div class="main-title">
                <?php 
                    echo ! azin_opt( 'bread_style_two' ) ? '<h1>' : '<strong>';
                    single_cat_title();
                    echo ! azin_opt( 'bread_style_two' ) ? '</h1>' : '</strong>';
                ?>
            </div>
        <?php } ?>
        <div class="main-page<?php if ( azin_opt( 'show_archive_desc_summ' ) ) { echo ' main-page-summ'; } ?>">
        <?php the_archive_description(); ?>
        <?php if ( azin_opt( 'show_archive_desc_summ' ) ) { ?>
            <p class="read-more">
                <span class="sbutton">
                    <?php echo azin_opt( 'text_read_more' ); ?>
                </span>
            </p>
        <?php } ?>
        </div>
    </div>
<?php
    }
}

//Output content and do shortcodes
function azin_output_content( $content ) {
	global $wp_embed;
    
	$content = $wp_embed->autoembed( $content );
	$content = $wp_embed->run_shortcode( $content );
	$content = wpautop( $content );
	$content = do_shortcode( $content );

	return $content;
}

//Convert number 2 word
function az_dig2word( $num ) {

    switch ( $num ) {
        case 1:
            $word = 'one';
            break;
        case 2:
            $word = 'two';
            break;
        case 3:
            $word = 'three';
            break;
        case 4:
            $word = 'four';
            break;
        case 5:
            $word = 'five';
            break;
        case 6:
            $word = 'six';
            break;
        case 7:
            $word = 'seven';
            break;
        case 8:
            $word = 'eight';
            break;
        case 9:
            $word = 'nine';
            break;
    }

    return $word;
}

//azin_rewrite_rules
add_action( 'created_term', 'azin_rewrite_rules', 10, 3 );
add_action( 'edit_term', 'azin_rewrite_rules', 10, 3 );
if ( ! function_exists ( 'azin_rewrite_rules' ) ) {
    function azin_rewrite_rules() {
        flush_rewrite_rules();
    }
}

//Check current page is download taxonomy
function is_download_taxonomy() {
    return is_tax( get_object_taxonomies( 'download' ) );
}

//azin_check_maintenance
function azin_check_maintenance() {
    
    if ( ! azin_opt( 'maintenance' ) )
        return;
    
    if ( current_user_can( 'administrator' ) || ( azin_opt( 'maintenance_editor' ) && current_user_can( 'edit_posts' ) ) )
        return;
    
    get_template_part('under-page');

    die();
}

//Azin remove dashes
function azin_remove_dash($input) {
    $output = preg_replace("/[^A-Za-z0-9]/", "", $input);
    return $output;
}

//Azin register link
function azin_register_link() {
    if ( azin_opt( 'ch_register_link' ) )
        return azin_opt( 'register_link' );

    if ( az_woo() ) {
        $register_link = get_myaccount_link(); 
    } else {
        $register_link = esc_url( home_url() ).'/register"';
    }
          
    return $register_link;
}

//Count number of sellers
function azin_count_sellers() {  

    $count = 0;

    if ( class_exists( 'WeDevs_Dokan' ) ) {

        $dokan_sellers = dokan_get_seller_count();
        $count = $dokan_sellers[ 'active' ];

    } elseif ( class_exists( 'EDD_Front_End_Submissions' ) ) {

        $vendors = new FES_DB_Vendors();

        $count = $vendors->count( array( 'status' => 'approved' ) );
        
    }

    return $count;
}

//Check Product Price Is Free
function azin_is_free( $id ) {
    return az_woo() ? azin_woo_free( $id ) : edd_is_free_download( $id );
}