<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

//Check Meintenance Mode
azin_check_maintenance();
?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-VN5PCQ058H"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-VN5PCQ058H');
</script>
	
    <meta http-equiv="Content-Type" content="text/html; charset=<?php bloginfo( 'charset' ); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <?php if( ! azin_opt( 'dis_mobile_color' ) ) { ?>
        <meta name="theme-color" content="<?php echo ( azin_opt( 'ch_mobile_color' ) ? azin_opt( 'mobile_bar_color' ) : azin_opt( 'msg_bgcolor' ) ); ?>" />
    <?php } ?>
    <meta name="fontiran.com:license" content="B3L8B">
    <link rel="shortcut icon" href="<?php echo azin_to_https( azin_opt( 'site_favicon', 'url' ) ); ?>" type="image/x-icon" />
    <?php
      if ( is_singular() ) {
          wp_enqueue_script( 'comment-reply' );
      }
      ?>
    <link rel="alternate" type="appliction/rss+xml" href="<?php bloginfo( 'rss2_url' ); ?>" title="<?php printf(__( 'Latest Articles %s', 'azin-file' ), esc_html( get_bloginfo( 'name' ), 1) ); ?>" />
    <link rel="alternate" type="appliction/rss+xml" href="<?php bloginfo( 'comments_rss2_url' ); ?>" title="<?php printf(__( 'Last comments %s', 'azin-file' ), esc_html( get_bloginfo( 'name' ), 1) ); ?>" />
    <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
    <?php wp_head(); ?>
	
	
</head>

<body id="top" <?php body_class(); ?><?php if ( azin_opt( 'site_schema' ) ) {?> itemscope itemtype="https://schema.org/WebPage"<?php } ?>>

    <?php 
        if ( function_exists( 'wp_body_open' ) ) {
            wp_body_open();
        } else {
            do_action( 'wp_body_open' );
        }
    ?>

    <?php
    // Elementor header location
    //Support Elementor Header & Footer Builder
    if ( function_exists( 'get_hfe_header_id' ) && get_hfe_header_id() != false ) {
        hfe_render_header();
    } elseif ( ! function_exists( 'elementor_theme_do_location' ) || ! elementor_theme_do_location( 'header' ) ) {
        get_template_part( 'template-parts/header' );
    }