<?php defined('ABSPATH') || exit ("no access");  ?>
<div id="main-guard-inner">
    <div class="license-input">
        <h1> <?php printf(esc_html__( '%s Activation', 'guard-gn-acc9f31c9a0ce63faa56ff47f6724bf' ), esc_html__($this->e4201f393b62a24e1d5b, 'guard-gn-acc9f31c9a0ce63faa56ff47f6724bf')); ?></h1>
        <?php if ($this->b8e37059f65469d15ecf4643a): ?>
            <h3><?php esc_html_e( 'Your activation key:', 'guard-gn-acc9f31c9a0ce63faa56ff47f6724bf') ?></h3>
            <code id="code-style"><?php echo $this->afb18e916e34c22f8b49ad514be7614f() ?></code>
            <div class="text-left">
                    <span id="recheck-license" onclick="recheck_licence(this)"><?php esc_html_e( 'Recheck license', 'guard-gn-acc9f31c9a0ce63faa56ff47f6724bf') ?></span>
                    <span id="remove-license" onclick="remove_licence(this)"><?php esc_html_e( 'Remove / Change key', 'guard-gn-acc9f31c9a0ce63faa56ff47f6724bf') ?></span>
            </div>
            <div id="license-message" style="display: flex; <?php echo ($this->a1054ce2760de6cbe01a6af9d592cdf===true)? 'background:red;':''?>">
                <div class="result" style=""><?php echo $this->afa53894777f758ec7412daccd9cf6a('last_message'); ?></div>
            </div>
            <!-- /#license-message -->
        <?php else: ?>
            <h3><?php esc_html_e( 'Enter your activation key:', 'guard-gn-acc9f31c9a0ce63faa56ff47f6724bf') ?></h3>
            <input id="license-input" type="text" value="">
            <div class="text-left">
                    <span id="install-license" onclick="install_licence(this)"><?php esc_html_e( 'Activate',
                            'guard-gn-acc9f31c9a0ce63faa56ff47f6724bf') ?></span>
            </div>
            <div id="license-message">
            </div>
        <?php endif; ?>

        <!-- /#license-message -->
        <?php
        $crons=get_option('cron');
        $last_cron_run=false;
        foreach ($crons as $time => $cron){
            if (!is_array($cron)){
                continue;
            }
            if (isset($cron['zhaket_guard_daily_validator'])) {
                $last_cron_run = $time;
            }
        }
        if (empty($last_cron_run)){
            ?>
            <div id="license-message" style="display: flex; background:red;">
                <div class="result" ><?php esc_html_e( 'No cron jobs found. Your license can not be activated.', 'guard-gn-acc9f31c9a0ce63faa56ff47f6724bf'); ?></div>
            </div>
            <?php
        }elseif($last_cron_run < time()-90000 || $last_cron_run > time()+90000){
            ?>
            <div id="license-message" style="display: flex; background:red;">
                <div class="result" ><?php printf(__( 'Number of failed Activation checks is reached (%s). your plugin or theme will be disabled soon. Please check cron job settings on your WordPress or host. <a href="%s">cron manual</a>', 'guard-gn-acc9f31c9a0ce63faa56ff47f6724bf' ),human_time_diff( $last_cron_run),'https://codekraken.ir/cron-manual'); ?></div>
            </div>
            <?php
        }
        ?>
        <div id="license-help">
            <strong><?php esc_html_e( 'Manual:', 'guard-gn-acc9f31c9a0ce63faa56ff47f6724bf') ?></strong>
            <ul>
                <?php if ($this->b8e37059f65469d15ecf4643a): ?>
                    <li>
                        <?php esc_html_e( 'Your key is used on this website, and it is not possible to use on another website.',
                            'guard-gn-acc9f31c9a0ce63faa56ff47f6724bf') ?>
                    </li>
                    <li>
                        <?php esc_html_e( 'If you want to transfer a license to another domain, click on the "Remove / Change key", after that login to your account of zhaket.com and go to the download section and click on change domain button. Enter your new domain name and use the license key on your desired domain.',
                            'guard-gn-acc9f31c9a0ce63faa56ff47f6724bf') ?>
                    </li>
                <?php else: ?>
                    <li>
                        <?php esc_html_e( 'To use the product, you should enter the license key, to find your license key, login to your account of zhaket.com and go to downloads section, after than select product and copy your license key or click on create license button and copy your license key.',
                            'guard-gn-acc9f31c9a0ce63faa56ff47f6724bf') ?>
                    </li>
                    <li>
                        <?php esc_html_e( 'Each license can be activated only for one website', 'guard-gn-acc9f31c9a0ce63faa56ff47f6724bf') ?>
                    </li>
                    <li>
                        <?php esc_html_e( 'If your license is activated on another domain, first click on the "Remove / Change key" on the old website, then login to your account of zhaket.com and go to the download section and click on the change domain button, enter your website domain name and use the license key to activate.',
                            'guard-gn-acc9f31c9a0ce63faa56ff47f6724bf') ?>
                    </li>
                <?php endif; ?>
            </ul>
            <?php
            if ( defined( 'DISABLE_WP_CRON' ) && DISABLE_WP_CRON ) {
                echo '<hr>';
                echo sprintf( esc_html__( 'The %s constant is set to true. WP-Cron spawning is disabled.', 'guard-gn-acc9f31c9a0ce63faa56ff47f6724bf' ), 'DISABLE_WP_CRON' );
            }
            if ( defined( 'ALTERNATE_WP_CRON' ) && ALTERNATE_WP_CRON ) {
                echo '<hr>';
                echo sprintf( esc_html__( 'The %s constant is set to true.', 'guard-gn-acc9f31c9a0ce63faa56ff47f6724bf' ), 'ALTERNATE_WP_CRON'
                );
            }

            ?>
            <hr>
            <span style="display: block;direction: ltr;text-align:left;font-size: 10px">version:1.1.0</span>
        </div>


    </div>
    <!-- /.license-input -->
    <div class="background-status">
        <?php if ($this->b8e37059f65469d15ecf4643a): ?>
            <img src="<?php echo $this->da780dee0bbe00abe96eaf936a4ca ?>assets/unlocked.png" alt="">
        <?php else: ?>
            <img src="<?php echo $this->da780dee0bbe00abe96eaf936a4ca ?>assets/locked.png" alt="">
        <?php endif; ?>
    </div>
    <!-- /.background-status -->
</div>
<!-- /#main-guard-inner -->