<?php
/**
 * ReduxFramework Sample Config File
 * For full documentation, please visit: http://docs.reduxframework.com/
*/
load_theme_textdomain( 'azin-file', get_template_directory() . '/languages' );
if ( ! class_exists( 'Redux' ) ) {
    return;
}

if ( ! class_exists( 'ReduxFramework_extension_vendor_support' ) ) {
    if ( file_exists( dirname( __FILE__ ) . '/sample/vendor_support/extension_vendor_support.php' ) ) {
        require dirname( __FILE__ ) . '/sample/vendor_support/extension_vendor_support.php';
        new ReduxFramework_extension_vendor_support();
    }
}

//FontAwesome Icons
require_once( dirname( __FILE__ ) . '/sample/fa.php' );
require_once( dirname( __FILE__ ) . '/sample/fab.php' );
require_once( dirname( __FILE__ ) . '/sample/iricons.php' );

$alliconArray = array_merge( $iconArray, $biconArray, $iriconArray );
// This is your option name where all the Redux data is stored.
$opt_name = "az_data";

//Redux's constants
define ( 'RE_URI', get_template_directory_uri() . '/includes/ReduxCore/' );
define ( 'RE_DIR', get_template_directory() . '/includes/ReduxCore/' );

// Background Patterns Reader
$sample_patterns_path = RE_DIR . 'assets/img/patterns/';
$sample_patterns_url  = RE_URI . 'assets/img/patterns/';
$sample_patterns      = array();
    
if ( is_dir( $sample_patterns_path ) ) {

    if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
        $sample_patterns = array();

        while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

            if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                $name              = explode( '.', $sample_patterns_file );
                $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                $sample_patterns[] = array(
                    'alt' => $name,
                    'img' => $sample_patterns_url . $sample_patterns_file
                );
            }
        }
    }
}

//Footer Background Patterns Reader
$footer_patterns_path = RE_DIR . 'assets/img/fbg/';
$footer_patterns_url  = RE_URI . 'assets/img/fbg/';
$footer_patterns      = array();
    
if ( is_dir( $footer_patterns_path ) ) {

    if ( $footer_patterns_dir = opendir( $footer_patterns_path ) ) {
        $footer_patterns = array();

        while ( ( $footer_patterns_file = readdir( $footer_patterns_dir ) ) !== false ) {

            if ( stristr( $footer_patterns_file, '.png' ) !== false || stristr( $footer_patterns_file, '.jpg' ) !== false ) {
                $name              = explode( '.', $footer_patterns_file );
                $name              = str_replace( '.' . end( $name ), '', $footer_patterns_file );
                $footer_patterns[] = array(
                    'alt' => $name,
                    'img' => $footer_patterns_url . $footer_patterns_file
                );
            }
        }
    }
}

/**
 * ---> SET ARGUMENTS
 * All the possible arguments for Redux.
 * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
 * */

$theme = wp_get_theme(); // For use with some settings. Not necessary.

$args = array(
    // TYPICAL -> Change these values as you need/desire
    'opt_name'             => $opt_name,
    // This is where your data is stored in the database and also becomes your global variable name.
    'display_name'         => $theme->get( 'Name' ),
    // Name that appears at the top of your panel
    'display_version'      => $theme->get( 'Version' ),
    // Version that appears at the top of your panel
    'menu_type'            => 'submenu',
    //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu'       => true,
    // Show the sections below the admin menu item or not
    'menu_title'           => __( 'Theme settings', 'azin-file' ),
    'page_title'           => __( 'Theme settings', 'azin-file' ),
    // You will need to generate a Google API key to use this feature.
    // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
    'google_api_key'       => '',
    // Set it you want google fonts to update weekly. A google_api_key value is required.
    'google_update_weekly' => false,
    // Must be defined to add google fonts to the typography module
    'async_typography'     => false,
    // Use a asynchronous font on the front end or font string
    //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
    'admin_bar'            => true,
    // Show the panel pages on the admin bar
    'admin_bar_icon'       => 'dashicons-admin-generic',
    // Choose an icon for the admin bar menu
    'admin_bar_priority'   => 50,
    // Choose an priority for the admin bar menu
    'global_variable'      => '',
    // Set a different name for your global variable other than the opt_name
    'dev_mode'             => false,
    // Show the time the page took to load, etc
    'update_notice'        => true,
    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer'           => true,
    // Enable basic customizer support
    //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
    //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

    // OPTIONAL -> Give you extra features
    'page_priority'        => null,
    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent'          => 'themes.php',
    // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
    'page_permissions'     => 'manage_options',
    // Permissions needed to access the options panel.
    'menu_icon'            => '',
    // Specify a custom URL to an icon
    'last_tab'             => '',
    // Force your panel to always open to a specific tab (by id)
    'page_icon'            => 'icon-themes',
    // Icon displayed in the admin panel next to your menu_title
    'page_slug'            => '',
    // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
    'save_defaults'        => true,
    // On load save the defaults to DB before user clicks save or not
    'default_show'         => false,
    // If true, shows the default value next to each field that is not the default value.
    'default_mark'         => '',
    // What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export'   => true,
    // Shows the Import/Export panel when not used as a field.

    // CAREFUL -> These options are for advanced use only
    'transient_time'       => 60 * MINUTE_IN_SECONDS,
    'output'               => true,
    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag'           => true,
    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
    // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

    // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
    'database'             => '',
    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'use_cdn'              => false,
    'forced_dev_mode_off' => true,
    'show_options_object' => false,
    // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

    // HINTS
    'hints'                => array(
        'icon'          => 'fa fa-question-sign',
        'icon_position' => 'right',
        'icon_color'    => 'lightgray',
        'icon_size'     => 'normal',
        'tip_style'     => array(
            'color'   => 'red',
            'shadow'  => true,
            'rounded' => false,
            'style'   => '',
        ),
        'tip_position'  => array(
            'my' => 'top left',
            'at' => 'bottom right',
        ),
        'tip_effect'    => array(
            'show' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'mouseover',
            ),
            'hide' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'click mouseleave',
            ),
        ),
    ),
    // Set the theme of the option panel.  Use 'wp' to use a more modern style, default is classic.
    'admin_theme'               => 'wp',

    // Enable or disable flyout menus when hovering over a menu with submenus.
    'flyout_submenus'           => true,

    // Mode to display fonts (auto|block|swap|fallback|optional)
    // See: https://developer.mozilla.org/en-US/docs/Web/CSS/@font-face/font-display.
    'font_display'              => 'swap',
    // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'database'                  => '',
    'network_admin'             => true,
    'search'                    => true,
    'disable_google_fonts_link' => true,
);

// Panel Intro text -> before the form
if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
    if ( ! empty( $args['global_variable'] ) ) {
        $v = $args['global_variable'];
    } else {
        $v = str_replace( '-', '_', $args['opt_name'] );
    }
    $args['intro_text'] = '';
} else {
    $args['intro_text'] = '';
}

// Add content after the form.
$args['footer_text'] = '';

Redux::setArgs( $opt_name, $args );

/*
* ---> END ARGUMENTS
*/

/*
* ---> START HELP TABS
*/

$tabs = array(
    array(
        'id'      => 'redux-help-tab-1',
        'title'   => __( 'AzinFile Theme guide', 'azin-file' ),
        'content' => __( '<p> Please read the guide provided with the theme carefully before using the theme file features.<br /> The Azinfile theme is sold only through the zhaket site and the versions published by other sites are not available at all. They are not legal and their sale is forbidden. <br /> If you have any questions, problems, criticisms or suggestions, please contact my telegram at 09127729027 (Hosseinkhani).</p>', 'azin-file' )
    ),
);
Redux::set_help_tab( $opt_name, $tabs );

/*
* <--- END HELP TABS
*/

$product_taxonomy = ( class_exists( 'WooCommerce' ) ? 'product_cat' : 'download_category' );

/*
*
* ---> START SECTIONS
*
*/

//Home settings
require_once AZ_DIR . '/includes/admin-panel/home-settings.php';

//General settings
require_once AZ_DIR . '/includes/admin-panel/general-settings.php';

//Products and Posts settings
require_once AZ_DIR . '/includes/admin-panel/products-posts.php';

//EDD settings
require_once AZ_DIR . '/includes/admin-panel/edd-settings.php';

//Woocommerce Settings
require_once AZ_DIR . '/includes/admin-panel/woocommerce-settings.php';

//Course settings
require_once AZ_DIR . '/includes/admin-panel/course-settings.php';

//Dokan Settings
require_once AZ_DIR . '/includes/admin-panel/dokan-settings.php';

//User panel settings
require_once AZ_DIR . '/includes/admin-panel/user-panel-settings.php';

//Popup settings
require_once AZ_DIR . '/includes/admin-panel/popup-settings.php';

//Social Media
require_once AZ_DIR . '/includes/admin-panel/social-media.php';

//Custom Codes
require_once AZ_DIR . '/includes/admin-panel/custom-codes.php';

//Azinfile guide
require_once AZ_DIR . '/includes/admin-panel/azinfile-guide.php';


/*
* <--- END SECTIONS
*/

// If Redux is running as a plugin, this will remove the demo notice and links
add_action( 'redux/loaded', 'azin_remove_demo' );
if ( ! function_exists( 'azin_remove_demo' ) ) {
    function azin_remove_demo() {
        // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
        if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
            remove_filter( 'plugin_row_meta', array(
                ReduxFrameworkPlugin::instance(),
                'plugin_metalinks'
            ), null, 2 );

            // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
            remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
        }
    }
}

function azin_removeDemoModeLink() { // Be sure to rename this function to something more unique
    if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
        remove_filter( 'plugin_row_meta', array( ReduxFrameworkPlugin::get_instance(), 'plugin_metalinks' ), null, 2 );
    }
    if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
        remove_action( 'admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ) );    
    }
}
add_action( 'init', 'azin_removeDemoModeLink' );