<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Demo Website: https://azinfile.i-design.ir/
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

//Start Course settings SECTION
Redux::setSection( $opt_name, array(
    'title'      => __( 'Course settings', 'azin-file' ),
    'id'         => 'course_settings',
    'desc'       => __( 'In this section, you can activate the ability to sell the training course, by activating this mode, a box will be added to the product editing page, which will optimize the product page elements for the course sale by activating the training course mode.', 'azin-file' ),
    'icon'       => 'fa fa-graduation-cap',
    'fields'     => array(
        array(
            'id'       => 'course_sales_activation',
            'type'     => 'switch',
            'title'    => __( 'Course sales activation', 'azin-file' ),
            'subtitle' => __( 'By activating this option, course sales options will be added to the site and product editing page.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_course_lessons',
            'type'     => 'switch',
            'title'    => __( 'Show course lessons', 'azin-file' ),
            'subtitle' => __( 'Display course lessons on the course page in a separate tab.', 'azin-file' ),
            'default'  => true,
            'required' => array( 'course_sales_activation', '=', true ),
        ),
        array(
            'id'       => 'course_lessons_title',
            'type'     => 'text',
            'title'    => __( 'Tab title', 'azin-file' ),
            'default'  => __( 'Course lessons', 'azin-file' ),
            'required' => array( 'show_course_lessons', '=', true ),
        ),
        array(
            'id'      =>'course_lessons_content',
            'type'    => 'textarea',
            'title'   => __( 'Tab content', 'azin-file' ),
            'default' => __( 'To access the course files, you must purchase the course.', 'azin-file' ),
            'allowed_html' => array(
                    'a'     => array(
                    'href'  => array(),
                    'title'    => array()
                ),
                'br'     => array(),
                'em'     => array(),
                'strong' => array()
            ),
            'required' => array( 'show_course_lessons', '=', true ),
        ),
        array(
            'id'       => 'course_lessons_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Tab icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-books',
            'options'  => $alliconArray,
            'required' => array( 'show_course_lessons', '=', true ),
        ),
        array(
            'id'       => 'course_user_panel',
            'type'     => 'switch',
            'title'    => __( 'Separation of downloading courses from other products in the user panel', 'azin-file' ),
            'subtitle' => __( 'By activating this option, a section will be displayed as training courses in the user panel, and the courses purchased by the user will be downloadable in this section.', 'azin-file' ),
            'default'  => false,
            'required' => array( 'course_sales_activation', '=', true ),
        ),
        array(
            'id'       => 'remove_downloads',
            'type'     => 'switch',
            'title'    => __( 'Remove downloads option', 'azin-file' ),
            'subtitle' => __( 'Remove downloads option from menu and user panel. If you only sell training courses, you can enable this option.', 'azin-file' ),
            'default'  => false,
            'required' => array( 'course_user_panel', '=', true ),
        ),
        array(
            'id'       => 'course_side',
            'type'     => 'switch',
            'title'    => __( 'Separate Courses sidebar', 'azin-file' ),
            'subtitle' => __( 'Enabling this option will enable a separate sidebar for the Course product page.', 'azin-file' ),
            'default'  => false,
            'required' => array( 'course_sales_activation', '=', true ),
        ),
    ),
) );