<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Demo Website: https://azinfile.i-design.ir/
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

//Start General settings SECTION
Redux::setSection( $opt_name, array(
    'title'            => __( 'General settings', 'azin-file' ),
    'id'               => 'general_setting',
    'customizer_width' => '500px',
    'icon'             => 'fa fa-cogs',
) );

//Maintenance Mode
Redux::setSection( $opt_name, array(
    'title'      => __( 'Maintenance Mode', 'azin-file' ),
    'icon'       => 'fa fa-tools',
    'id'         => 'maintenance_mode',
    'desc'       => __( 'In the maintenance mode, the site will be out of reach of users and only the administrator can view it.', 'azin-file' ),
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'maintenance',
            'type'     => 'switch',
            'title'    => __( 'Enable Maintenance Mode', 'azin-file' ),
            'subtitle' => __( 'In this case, the site will be out of users access.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'maintenance_editor',
            'type'     => 'switch',
            'title'    => __( 'Display site for author users', 'azin-file' ),
            'subtitle' => __( 'Display site for users who have the ability to edit and publish content.', 'azin-file' ),
            'default'  => false,
            'required' => array( 'maintenance', '=', true ),
        ),
        array(
            'id'       => 'maintenance_social',
            'type'     => 'switch',
            'title'    => __( 'Display the link of social networks', 'azin-file' ),
            'subtitle' => __( 'Display the link of social networks in maintenance mode', 'azin-file' ),
            'default'  => false,
            'required' => array( 'maintenance', '=', true ),
        ),
        array(
            'id'       => 'show_counter',
            'type'     => 'switch',
            'title'    => __( 'Enable date countdown', 'azin-file' ),
            'default'  => false,
            'required' => array( 'maintenance', '=', true ),
        ),
        array(
            'id'          => 'date_counter',
            'type'        => 'date',
            'title'       => __( 'Completion date', 'azin-file' ),
            'subtitle'    => __( 'Completion date of the countdown', 'azin-file' ),
            'placeholder' => __( 'Click to enter a date', 'azin-file' ),
            'required'    => array( 'show_counter', '=', true ),
        ),
        array(
            'id'       => 'maintenance_title',
            'type'     => 'text',
            'title'    => __( 'Title', 'azin-file' ),
            'subtitle' => __( 'Title of maintenance mode page', 'azin-file' ),
            'default'  => __( 'Maintenance Mode', 'azin-file' ),
            'required' => array( 'maintenance', '=', true ),
        ),
        array(
            'id'      => 'maintenance_msg',
            'type'    => 'editor',
            'title'   => __( 'Message', 'azin-file' ),
            'desc'    => __( 'You can also use the shortcode', 'azin-file' ),
            'default' => __( 'Updating, please be patient.', 'azin-file' ),
            'args'    => array(
                'wpautop'       => false,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'maintenance', '=', true ),
        ),

        array(
            'id' => 'maintenance-style-section-start',
            'type' => 'section',
            'title'    => __( 'Maintenance mode style settings', 'azin-file' ),
            'indent' => true,
            'required' => array( 'maintenance', '=', true ),
        ),
        array(
            'id'       => 'maintenance_text_color',
            'type'     => 'color',
            'title'    => __( 'Maintenance mode text color', 'azin-file' ),
            'default'  => '#212529',
            'validate' => 'color',
            'transparent' => false,
            'required' => array( 
                array( 'maintenance', '=', true ), 
            )
        ),
        array(
            'id'       => 'maintenance_bg',
            'type'     => 'image_select',
            'output'    => array('.maintenance-mode' ),
            'tiles'    => true,
            'title'    => __( 'Maintenance mode background', 'azin-file' ),
            'subtitle' => __("Select an image as the background of the maintenance mode.", 'azin-file' ),
            'options'  => $footer_patterns,
            'required' => array( 
                array( 'maintenance', '=', true ), 
                array( 'mbg_switch', '!=', true ) 
            )
        ),
        array(
            'id'       => 'mbg_switch',
            'type'     => 'switch',
            'title'    => __( 'Custom Maintenance mode Background', 'azin-file' ),
            'subtitle' => __( 'Choose a background color or upload a custom photo to the Maintenance mode', 'azin-file' ),
            'default'  => false,
            'required' => array( 'maintenance', '=', true ),
        ),
        array(         
            'id'       => 'maintenance_custom_bg',
            'output'    => array('.maintenance-mode' ),
            'type'     => 'background',
            'title'    => __( 'Maintenance mode background', 'azin-file' ),
            'default'  => array(
                'background-color' => '#F4F5F9',
            ),
            'required' => array( 'mbg_switch', '=', true ),
            'required' => array( 
                array( 'maintenance', '=', true ),
                array( 'mbg_switch', '=', true ) 
            )
        ),
        array(
            'id' => 'maintenance-style-section-end',
            'type' => 'section',
            'indent' => false,
        ),

    ),
) );

//Header Settings
Redux::setSection( $opt_name, array(
    'title'      => __( 'Header Settings', 'azin-file' ),
    'icon'       => 'fa fa-browser',
    'id'         => 'header-setting',
    'subsection' => true,
    'desc'       => __( 'Site header personalization', 'azin-file' ),
    'fields'     => array(
        array(
            'id'       => 'social_pos',
            'type'     => 'image_select',
            'title'    => __( 'Position of social networks', 'azin-file' ),
            'subtitle' => __( 'Specify the location of the social media logo and contact information.', 'azin-file' ),
            'options'  => array(
                '2' => array(
                    'alt' => __( 'Right side', 'azin-file' ),
                    'img' => RE_URI . 'assets/img/rso.png'
                ),
                '1' => array(
                    'alt' => __( 'Left side', 'azin-file' ),
                    'img' => RE_URI . 'assets/img/lso.png'
                ),
            ),
            'default'  => '1'
        ),
        array(
            'id'       => 'logo_pos',
            'type'     => 'image_select',
            'title'    => __( 'Logo position', 'azin-file' ),
            'subtitle' => __( 'Specify the location of the site logo.', 'azin-file' ),
            'options'  => array(
                '2' => array(
                    'alt' => __( 'Right side', 'azin-file' ),
                    'img' => RE_URI . 'assets/img/rlogo.png'
                ),
                '1' => array(
                    'alt' => __( 'Left side', 'azin-file' ),
                    'img' => RE_URI . 'assets/img/llogo.png'
                ),
            ),
            'default'  => '1'
        ),
        array(
            'id'       => 'mobile_logo_pos',
            'type'     => 'image_select',
            'title'    =>  __( 'Mobile logo position', 'azin-file' ),
            'subtitle' => __( 'Locate the site logo in mobile.', 'azin-file' ),
            'options'  => array(
                '1' => array(
                    'alt' => __( 'Right side', 'azin-file' ),
                    'img' => RE_URI . 'assets/img/rlogo.png'
                ),
                '2' => array(
                    'alt' => __( 'Left side', 'azin-file' ),
                    'img' => RE_URI . 'assets/img/llogo.png'
                ),
            ),
            'default'  => '2'
        ),
        array(
            'id'       => 'add_home_heading',
            'type'     => 'switch',
            'title'    => __( 'Add an H1 tag to the logo', 'azin-file' ),
            'subtitle' => __( 'Add an H1 tag to the logo on the home page', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'hide_top_bar',
            'type'     => 'switch',
            'title'    => __( 'Hide Site Top Bar (Contact, Menu and Social)', 'azin-file' ),
            'subtitle' => __( 'By Activating this option site top bar not displayed.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'hide_header_social',
            'type'     => 'switch',
            'title'    => __( 'Hiding social networks header', 'azin-file' ),
            'default'  => false,
            'required' => array( 'hide_top_bar', '!=', true ),
        ),
        array(
            'id'       => 'show_mobile_head_contact',
            'type'     => 'switch',
            'title'    => __( 'Display contact information in mobile header', 'azin-file' ),
            'default'  => false,
            'required' => array( 'hide_top_bar', '!=', true ),
        ),
        array(
            'id'       => 'show_mobile_head_social',
            'type'     => 'switch',
            'title'    => __( 'Display social networks in mobile header', 'azin-file' ),
            'default'  => false,
            'required' => array( 'hide_top_bar', '!=', true ),
        ),

        array(
            'id'       => 'show_like_btn_head',
            'type'     => 'switch',
            'title'    => __( 'Show wishlist button in header', 'azin-file' ),
            'default'  => false,
        ),

        array(
            'id'       => 'show_loading_bar',
            'type'     => 'switch',
            'title'    => __( 'Loading bar', 'azin-file' ),
            'subtitle' => __( 'Show loading bar at the top of the site', 'azin-file' ),
            'default'  => true,
        ),

        array(
            'id'     => 'bread-section-start',
            'type'   => 'section',
            'title'    => __( 'Breadcrumbs settings (Path guide)', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_bread',
            'type'     => 'switch',
            'title'    => __( 'Breadcrumbs section', 'azin-file' ),
            'subtitle' => __( 'Show breadcrumbs section', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'bread_crumbs_sync',
            'type'     => 'switch',
            'title'    => __( 'Compatibility with RankMath and Yoast SEO plugins', 'azin-file' ),
            'subtitle' => __( 'By activating this option, if RankMath and Yoast SEO plugins are active, the breadcrumbs section of these plugins will be displayed', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_bread', '=', true ),
        ),
        array(
            'id'       => 'bread_style_two',
            'type'     => 'switch',
            'title'    => __( 'Activation of the second style of the bread crumbs area', 'azin-file' ),
            'subtitle' => __( 'By activating this option, the path guide and page title will be displayed at the top of the content and below the menu.', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_bread', '=', true ),
        ),
        array(
            'id'       => 'bread_count_prod',
            'type'     => 'switch',
            'title'    => __( 'Display number of products', 'azin-file' ),
            'subtitle' => __( 'Display number of products in categories and tags', 'azin-file' ),
            'default'  => false,
            'required' => array( 'bread_style_two', '=', true ),
        ),
        array(
            'id'       => 'bread_bg',
            'output'    => array( '.bread-crumbs' ),
            'type'     => 'background',
            'title'    => __( 'Breadcrumbs background', 'azin-file' ),
            'default'  => array(
                'background-color' => '#00BCD4',
            ),
            'required' => array( 'bread_style_two', '=', true ),
            'required' => array( 
                array( 'bread_style_two', '=', true ),
                array( 'bread_gradient', '!=', true )
            )
        ),
        array(
            'id'       => 'bread_gradient',
            'type'     => 'switch',
            'title'    => __( 'Use gradients', 'azin-file' ),
            'subtitle' => __( 'Use gradients instead of background color and image', 'azin-file' ),
            'default'  => false,
            'required' => array( 'bread_style_two', '=', true ),
        ),
        array(
            'id'       => 'bread_gradient_color',
            'type'     => 'color_gradient',
            'title'    => __( 'Gradient color', 'azin-file' ),
            'validate' => 'color',
            'transparent' => false,
            'default'  => array(
                'from' => '#0083B0',
                'to'   => '#00B4DB',
            ),
            'required' => array( 'bread_gradient', '=', true ),
        ),
        array(
            'id'       => 'bread_text_color',
            'output'    => array( '.bread-crumbs' ),
            'type'     => 'color',
            'title'    => __( 'Coloring the text of the breadcrumbs', 'azin-file' ),
            'default'  => '#ffffff',
            'validate' => 'color',
            'transparent' => false,
            'required' => array( 'bread_style_two', '=', true ),
        ),
        array(
            'id'       => 'bread_link_color',
            'type'     => 'color',
            'title'    => __( 'Coloring the links of the breadcrumbs', 'azin-file' ),
            'default'  => '#E0E0E0',
            'validate' => 'color',
            'transparent' => false,
            'required' => array( 'bread_style_two', '=', true ),
        ),
        array(
            'id'     => 'bread-section-end',
            'type'   => 'section',
            'indent' => false,
        ),

        array(
            'id'     => 'section-search-start',
            'type'   => 'section',
            'title'    => __( 'Search settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'ajax_search',
            'type'     => 'switch',
            'title'    => __( 'Ajax Live Search', 'azin-file' ),
            'subtitle' => __( 'By activating this feature, search results will be displayed by entering the keyword', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'search_type',
            'type'     => 'switch',
            'title'    => __( 'Search type', 'azin-file' ),
            'subtitle' => __( 'Search results in files or posts (searches only on files if disabled)', 'azin-file' ),
            'default'  => true,
            'required' => array( 'search_cat', '!=', true ),
        ),
        array(
            'id'       => 'replace_product_post',
            'type'     => 'switch',
            'title'    => __( 'Replace products and posts in the search box', 'azin-file' ),
            'default'  => false,
            'required' => array( 'search_type', '=', true ),
        ),
        array(
            'id'       => 'search_cat',
            'type'     => 'switch',
            'title'    => __( 'Show Search Category', 'azin-file' ),
            'subtitle' => __( 'Show category box in search section, by activating this option, the search will be done only on products', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'search_cat_sort',
            'type'     => 'switch',
            'title'    => __( 'Sort categories alphabetically', 'azin-file' ),
            'default'  => false,
            'required' => array( 'search_cat', '=', true )
        ),
        array(
            'id'       => 'search_cat_hierarchical',
            'type'     => 'switch',
            'title'    => __( 'Display hierarchy', 'azin-file' ),
            'default'  => true,
            'required' => array( 'search_cat', '=', true )
        ),
        array(
            'id'       => 'search_cat_parent',
            'type'     => 'switch',
            'title'    => __( 'Parent categories only', 'azin-file' ),
            'subtitle' => __( 'By activating this option, only the first level categories are displayed', 'azin-file' ),
            'default'  => false,
            'required' => array( 'search_cat', '=', true )
        ),
        array(
            'id'    => 'search_cat_cats',
            'type'     => 'select',
            'multi'    => true,
            'title'    => __( 'Hide categories', 'azin-file' ), 
            'subtitle' => __( 'Selected categories are not displayed in the search box', 'azin-file' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => $product_taxonomy,
                'hide_empty' => false,
            ),
            'required' => array( 'search_cat', '=', true )
        ),
        array(
            'id'       => 'hide_search_home',
            'type'     => 'switch',
            'title'    => __( 'Hide the search box on the home screen', 'azin-file' ),
            'subtitle' => __( 'Suitable for the case that you have used the elementor search box on the main page.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'replace_search_shortcode',
            'type'     => 'switch',
            'title'    => __( 'Insert shortcode instead of search form', 'azin-file' ),
            'subtitle' => __( 'The content of this shortcode will be displayed instead of the search box', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'search_shortcode',
            'type'     => 'text',
            'title'    => __( 'Search shortcode', 'azin-file' ),
            'subtitle'  => __( 'With this feature, you can use the shortcode of other search plugins', 'azin-file' ),
            'required' => array( 'replace_search_shortcode', '=', true ),
        ),
        array(
            'id'     => 'section-search-end',
            'type'   => 'section',
            'indent' => false,
        ),

        array(
            'id'     => 'section-menu-start',
            'type'   => 'section',
            'title'    => __( 'Menu settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'fixed_head_top',
            'type'     => 'switch',
            'title'    => __( 'Fixed menu', 'azin-file' ), 
            'subtitle' => __( 'Display the header menu fixed when navigating the site', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'mega_column',
            'type'     => 'select',
            'title'    => __( 'Number of megamenu columns', 'azin-file' ),
            'options'  => array(
                'three' => __( 'Three columns', 'azin-file' ),
                'four' =>  __( 'Four columns', 'azin-file' ),
                'five' =>  __( 'Five columns', 'azin-file' ),
                'six' =>  __( 'Six columns', 'azin-file' ),
                'seven' =>  __( 'Seven columns', 'azin-file' ),
                'eight' =>  __( 'Eight columns', 'azin-file' ),
            ),
            'default'  => 'four',
        ),
        array(
            'id'       => 'mega_style',
            'type'     => 'select',
            'title'    => __( 'Megamenu style', 'azin-file' ),
            'options'  => array(
                'first' => __( 'First style', 'azin-file' ),
                'second' =>  __( 'Second style', 'azin-file' ),
            ),
            'default'  => 'first',
        ),
        array(
            'id'       => 'focus_nav',
            'type'     => 'switch',
            'title'    => __( 'Page darkening', 'azin-file' ),
            'subtitle' => __( 'Darken the page by hovering over the menu', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'show_mobile_logo',
            'type'     => 'switch',
            'title'    => __( 'Display the site logo in the mobile menu', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'fixed_head_logo',
            'type'     => 'switch',
            'title'    => __( 'Display the logo in the sticky menu', 'azin-file' ),
            'subtitle' => __( 'Display the logo in the computer sticky menu', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'change_fixed_logo',
            'type'     => 'switch',
            'title'    => __( 'Replace the sticky menu logo', 'azin-file' ),
            'default'  => false,
            'required' => array( 'fixed_head_logo', '=', true ),
        ),
        array(
            'id'       => 'sticky_logo',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Sticky logo', 'azin-file' ),
            'compiler' => 'true',
            'subtitle' => __( 'Appropriate size: 107(w) in 37(h)', 'azin-file' ),
            'required' => array( 'change_fixed_logo', '=', true ),
        ),
        array(
            'id'       => 'remove_parent_link',
            'type'     => 'switch',
            'title'    => __( 'Remove the parent menus link', 'azin-file' ),
            'subtitle' => __( 'Remove the parent menus link in the mobile menu', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'replace_mobile_menu',
            'type'     => 'switch',
            'title'    => __( 'Replace mobile menu with custom menu', 'azin-file' ),
            'subtitle' => __( 'Enabling this option will add a separate place for the mobile side menu to the menu management page.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'menu_label_text_color',
            'type'     => 'color',
            'title'    => __( 'Menu label text color', 'azin-file' ),
            'subtitle' => __( 'The text color of the labels added from the menu management page', 'azin-file' ),
            'default'  => '#ffffff',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'menu_label_bg_color',
            'type'     => 'color',
            'title'    => __( 'Menu label background color', 'azin-file' ),
            'subtitle' => __( 'The background color of the labels added from the menu management page', 'azin-file' ),
            'default'  => '#EF5350',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'     => 'section-menu-end',
            'type'   => 'section',
            'indent' => false,
        ),

        array(
            'id'     => 'section-user-btn-start',
            'type'   => 'section',
            'title'    => __( 'User Button Settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_user_btn',
            'type'     => 'switch',
            'title'    => __( 'User buttons', 'azin-file' ),
            'subtitle' => __( 'Display user buttons (login, membership and user menu) in the header section', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'merge_user_btn',
            'type'     => 'switch',
            'title'    => __( 'Integration of user buttons ( in WooCommerce mode)', 'azin-file' ),
            'subtitle' => __( 'In this case, the login and registration buttons become one button.', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_user_btn', '=', true ),
        ),
        array(
            'id'       => 'show_mo_btn',
            'type'     => 'switch',
            'title'    => __( 'Display user buttons in mobile mode', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_user_btn', '=', true ),
        ),
        array(
            'id'       => 'show_login_notices',
            'type'     => 'switch',
            'title'    => __( 'Show login panel tips', 'azin-file' ),
            'subtitle' => __( 'With this feature, you can display a text in the ajax login panel of the template', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'      => 'login_notices_text',
            'type'    => 'editor',
            'title'   => __( 'Login tips', 'azin-file' ),
            'desc'    => __( 'You can also use the shortcode', 'azin-file' ),
            'default' => __( 'Text', 'azin-file' ),
            'args'    => array(
                'wpautop'       => false,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'show_login_notices', '=', true ),
        ),
        array(
            'id'       => 'azin_login_redirect',
            'type'     => 'switch',
            'title'    => __( 'Redirection after login', 'azin-file' ),
            'subtitle' => __( 'Redirect to your desired address after login', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_user_btn', '=', true ),
        ),
        array(
            'id'       => 'azin_login_redirect_url',
            'type'     => 'text',
            'title'    => __( 'Redirect address after login', 'azin-file' ),
            'required' => array( 'azin_login_redirect', '=', true ),
        ),
        array(
            'id'       => 'azin_logout_redirect',
            'type'     => 'switch',
            'title'    => __( 'Redirection after logout', 'azin-file' ),
            'subtitle' => __( 'Redirect to your desired address after logout', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_user_btn', '=', true ),
        ),
        array(
            'id'       => 'azin_logout_redirect_url',
            'type'     => 'text',
            'title'    => __( 'Redirect address after logout', 'azin-file' ),
            'required' => array( 'azin_logout_redirect', '=', true ),
        ),
        array(
            'id'       => 'digits_mode',
            'type'     => 'switch',
            'title'    => __( 'Compatibility with Digits plugin', 'azin-file' ),
            'subtitle' => __( 'If you have a Digit plugin installed, the login and registration buttons will be connected to this plugin', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_user_btn', '=', true ),
        ),
        array(
            'id'       => 'digits_page',
            'type'     => 'switch',
            'title'    => __( 'Link to Digits page instead of pop-up mode', 'azin-file' ),
            'default'  => false,
            'required' => array( 'digits_mode', '=', true ),
        ),
        array(
            'id'       => 'recapcha_login',
            'type'     => 'switch',
            'title'    => __( 'Google Captcha in the login section', 'azin-file' ),
            'subtitle' => __( 'Activate Google Captcha in login form', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_user_btn', '=', true ),
        ),
        array(
            'id'       => 'site_key',
            'type'     => 'text',
            'title'    => __( 'Site key', 'azin-file' ),
            'description' => __( 'Get it from the link: <a href="https://www.google.com/recaptcha/" target="_blank"> Google</a>', 'azin-file' ),
            'required' => array( 'recapcha_login', '=', true ),
        ),
        array(
            'id'       => 'site_secret',
            'type'     => 'text',
            'title'    => __( 'Security key', 'azin-file' ),
            'description' => __( 'Get it from the link: <a href="https://www.google.com/recaptcha/" target="_blank"> Google</a>', 'azin-file' ),
            'required' => array( 'recapcha_login', '=', true ),
        ),
        array(
            'id'       => 'ch_login_link',
            'type'     => 'switch',
            'title'    => __( 'Change link to the login page', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_user_btn', '=', true ),
        ),
        array(
            'id'       => 'login_link',
            'type'     => 'text',
            'title'    => __( 'Link to the login page', 'azin-file' ),
            'Subtitle' => __( 'Full page link', 'azin-file' ),
            'description' => __( 'Example: http://example.com/login', 'azin-file' ),
            'default'  => '#',
            'required' => array( 'ch_login_link', '=', true ),
        ),
        array(
            'id'       => 'ch_register_link',
            'type'     => 'switch',
            'title'    => __( 'Change link to the register page', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_user_btn', '=', true ),
        ),
        array(
            'id'       => 'register_link',
            'type'     => 'text',
            'title'    => __( 'Link to the register page', 'azin-file' ),
            'subtitle' => __( 'Full page link', 'azin-file' ),
            'description' => __( 'Example: http://example.com/register', 'azin-file' ),
            'default'  => '#',
            'required' => array( 'ch_register_link', '=', true ),
        ),
        array(
            'id'       => 'login_image',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Replace login page image', 'azin-file' ),
            'compiler' => 'true',
            'desc'     => __( 'Upload an image to replace the image on the login page', 'azin-file' ),
            'subtitle' => __( 'Suitable size: 402 pixels (width) and 331 pixels (height)', 'azin-file' ),
            'default'  => array( 'url' => get_template_directory_uri()."/images/login.svg" ),
        ),
        array(
            'id'       => 'register_image',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Replace the registration page image', 'azin-file' ),
            'compiler' => 'true',
            'desc'     => __( 'Upload an image to replace the image on the registration page', 'azin-file' ),
            'subtitle' => __( 'Suitable size: 402 pixels (width) and 331 pixels (height)', 'azin-file' ),
            'default'  => array( 'url' => get_template_directory_uri()."/images/register.svg" ),
        ),
        array(
            'id'       => 'replace_user_menu',
            'type'     => 'switch',
            'title'    => __( 'Replace the user menu with a custom menu', 'azin-file' ),
            'subtitle' => __( 'Added a place in WordPress menus to replace the user menu (this menu options are displayed instead of the user menu)', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_user_btn', '=', true ),
        ),
        array(
            'id'       => 'replace_userbtns_shortcode',
            'type'     => 'switch',
            'title'    => __( 'Insert shortcode instead of user buttons', 'azin-file' ),
            'subtitle' => __( 'The content of this shortcode will be displayed instead of the user buttons', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'userbtns_shortcode',
            'type'     => 'text',
            'title'    => __( 'User buttons shortcode', 'azin-file' ),
            'subtitle'  => __( 'With this feature, you can use the shortcode of other user panel plugins', 'azin-file' ),
            'required' => array( 'replace_userbtns_shortcode', '=', true ),
        ),
        array(
            'id'     => 'section-user-btn-end',
            'type'   => 'section',
            'indent' => false,
        ),

        array(
            'id'     => 'section-blog-btn-start',
            'type'   => 'section',
            'title'    => __( 'Blog button settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'blog_menu',
            'type'     => 'switch',
            'title'    => __( 'Blog button', 'azin-file' ),
            'subtitle' => __( 'Display the blog button in the top menu of the site', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'blog_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Button icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-file-alt',
            'options'  => $alliconArray,
            'required' => array( 'blog_menu', '=', true ),
        ),
        array(
            'id'       => 'blog_color',
            'type'     => 'select',
            'title'    => __( 'Color', 'azin-file' ),
            'options'  => array(
                'btn-info'  =>  __( 'Blue', 'azin-file' ),
                'btn-warning' =>  __( 'Yellow', 'azin-file' ),
                'btn-success'  =>  __( 'Green', 'azin-file' ),
                'btn-danger'  =>  __( 'Red', 'azin-file' )
            ),
            'default'  => 'btn-success',
            'required' => array( 'blog_menu', '=', true ),
        ),
        array(
            'id'       => 'blog_text',
            'type'     => 'text',
            'title'    => __( 'Button text', 'azin-file' ),
            'default'  => __( 'Blog', 'azin-file' ),
            'required' => array( 'blog_menu', '=', true ),
        ),
        array(
            'id'       => 'blog_link',
            'type'     => 'text',
            'title'    => __( 'Button link', 'azin-file' ),
            'default'  => '#',
            'required' => array( 'blog_menu', '=', true ),
        ),
        array(
            'id'     => 'section-blog-btn-end',
            'type'   => 'section',
            'indent' => false,
        ),

        array(
            'id'     => 'section-msg-start',
            'type'   => 'section',
            'title'    => __( 'Message section settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_msg',
            'type'     => 'switch',
            'title'    => __( 'Show message', 'azin-file' ),
            'subtitle' => __( 'Show message section', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'   => 'site_msg',
            'type' => 'textarea',
            'title'    => __( 'Text message', 'azin-file' ),
            'default' => __( 'Welcome to our website', 'azin-file' ),
            'allowed_html' => array(
                'a' => array(
                    'href' => array(),
                    'title'    => array()
                ),
                'br' => array(),
                'em' => array(),
                'strong' => array()
            ),
            'required' => array( 'show_msg', '=', true ),
        ),
        array(
            'id'       => 'msg_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-bell',
            'options'  => $alliconArray,
            'required' => array( 'show_msg', '=', true ),
        ),
        array(
            'id'       => 'msg_btn',
            'type'     => 'switch',
            'title'    => __( 'Show button', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_msg', '=', true ),
        ),
        array(
            'id'       => 'msg_btn_color',
            'type'     => 'select',
            'title'    => __( 'Button color', 'azin-file' ),
            'options'  => array(
                'btn-info'  =>  __( 'Blue', 'azin-file' ),
                'btn-warning' =>  __( 'Yellow', 'azin-file' ),
                'btn-success'  =>  __( 'Green', 'azin-file' ),
                'btn-danger'  =>  __( 'Red', 'azin-file' )
            ),
            'default'  => 'btn-success',
            'required' => array( 'msg_btn', '=', true ),
        ),
        array(
            'id'       => 'msg_btn_text',
            'type'     => 'text',
            'title'    => __( 'Button text', 'azin-file' ),
            'default'  => __( 'View and buy', 'azin-file' ),
            'required' => array( 'msg_btn', '=', true ),
        ),
        array(
            'id'       => 'msg_btn_link',
            'type'     => 'text',
            'title'    => __( 'Button link', 'azin-file' ),
            'default'  => '#',
            'required' => array( 'msg_btn', '=', true ),
        ),
        array(
            'id'       => 'user_close',
            'type'     => 'switch',
            'title'    => __( 'Ability to be closed by the user', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_msg', '=', true ),
        ),
        array(
            'id'       => 'msg_reshown',
            'type'     => 'text',
            'validate' => 'numeric',
            'title'    => __( 'Show again after a few days', 'azin-file' ),
            'subtitle' => __( 'After this time, message section will be displayed again, enter 0 to not display.', 'azin-file' ),
            'default'  => 0,
            'required' => array( 'user_close', '=', true ),
        ),
        array(
        'id'       => 'msg_bgcolor',
        'type'     => 'color',
        'title'    => __( 'Background color', 'azin-file' ),
        'default'  => '#455A64',
        'validate' => 'color',
        'transparent' => false,
        'required' => array( 'show_msg', '=', true ),
        ),
        array(
        'id'       => 'msg_fcolor',
        'type'     => 'color',
        'title'    => __( 'Text message color', 'azin-file' ),
        'default'  => '#ffffff',
        'validate' => 'color',
        'transparent' => false,
        'required' => array( 'show_msg', '=', true ),
        ),
        array(
            'id'     => 'section-msg-end',
            'type'   => 'section',
            'indent' => false,
        ),

        array(
            'id'     => 'section-contact-start',
            'type'   => 'section',
            'title'    => __( 'Contact information settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_contact',
            'type'     => 'switch',
            'title'    => __( 'Contact information', 'azin-file' ),
            'subtitle' => __( 'Show contact information', 'azin-file' ),
            'default'  => true,
            'required' => array( 'header_nav', '!=', true ),
        ),
        array(
            'id'       => 'site_tel_link',
            'type'     => 'switch',
            'title'    => __( 'Linking phone', 'azin-file' ),
            'default'  => false,
            'required' => array( 'header_nav', '!=', true ),
        ),
        array(
            'id'       => 'site_email_link',
            'type'     => 'switch',
            'title'    => __( 'Linking email', 'azin-file' ),
            'default'  => false,
            'required' => array( 'header_nav', '!=', true ),
        ),
        array(
            'id'       => 'site_tel',
            'type'     => 'text',
            'title'    => __( 'Phone', 'azin-file' ),
            'default'  => '09111111111',
            'required' => array( 'show_contact', '=', true ),
        ),
        array(
            'id'       => 'site_email',
            'type'     => 'text',
            'title'    => __( 'Email', 'azin-file' ),
            'default'  => 'test@test.com',
            'required' => array( 'show_contact', '=', true ),
        ),
        array(
            'id'       => 'header_nav',
            'type'     => 'switch',
            'title'    => __( 'Show header menu', 'azin-file' ),
            'subtitle' => __( 'Show menu instead of contact info at the top of the site', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'     => 'section-contact-end',
            'type'   => 'section',
            'indent' => false,
        ),
    )
) );

//Footer Settings
Redux::setSection( $opt_name, array(
    'title'      => __( 'Footer Settings', 'azin-file' ),
    'icon'       => 'fa fa-columns',
    'id'         => 'footer-setting',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'footer_widgets',
            'type'     => 'image_select',
            'title'    => __( 'Number of footer widgets', 'azin-file' ),
            'options'  => array(
                '3' => array(
                    'alt' => __( 'Three columns', 'azin-file' ),
                    'img' => RE_URI . 'assets/img/3col.png'
                ),
                '4' => array(
                    'alt' => __( 'Four columns', 'azin-file' ),
                    'img' => RE_URI . 'assets/img/4col.png'
                ),
            ),
            'default'  => '3'
        ),

        //Section info bar start
        array(
            'id'     => 'section-info-bar-start',
            'type'   => 'section',
            'title'    => __( 'Info bar settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'info_bar',
            'type'     => 'switch',
            'title'    => __( 'Site info bar', 'azin-file' ),
            'subtitle' => __( 'Display the information section in the footer section to display the number of users, purchases and ...', 'azin-file' ),
            'default'  => false,
        ),

        //info_bar_prods
        array(
            'id'       => 'info_bar_prods',
            'type'     => 'switch',
            'title'    => __( 'Display the number of products', 'azin-file' ),
            'default'  => true,
            'required' => array( 'info_bar', '=', true ),
        ),
        array(
            'id'       => 'edit_bar_prods',
            'type'     => 'switch',
            'title'    => __( 'Edit products count', 'azin-file' ),
            'default'  => false,
            'required' => array( 'info_bar_prods', '=', true ),
        ),
        array(
            'id'       => 'bar_prods_title',
            'type'     => 'text',
            'title'    => __( 'Products count title', 'azin-file' ),
            'default'  => __( 'Products', 'azin-file' ),
            'required' => array( 'edit_bar_prods', '=', true ),
        ),
        array(
            'id'       => 'bar_prods_value',
            'type'     => 'text',
            'title'    => __( 'Products count value', 'azin-file' ),
            'default'  => '+1',
            'required' => array( 'edit_bar_prods', '=', true ),
        ),
        array(
            'id'       => 'bar_prods_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Products count icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-shopping-bag',
            'options'  => $alliconArray,
            'required' => array( 'edit_bar_prods', '=', true ),
        ),
        //info_bar_prods

        //info_bar_sales
        array(
            'id'       => 'info_bar_sales',
            'type'     => 'switch',
            'title'    => __( 'Display the number of purchases', 'azin-file' ),
            'default'  => true,
            'required' => array( 'info_bar', '=', true ),
        ),
        array(
            'id'       => 'edit_bar_sales',
            'type'     => 'switch',
            'title'    => __( 'Edit sales count', 'azin-file' ),
            'default'  => false,
            'required' => array( 'info_bar_sales', '=', true ),
        ),
        array(
            'id'       => 'bar_sales_title',
            'type'     => 'text',
            'title'    => __( 'Sales count title', 'azin-file' ),
            'default'  => __( 'Order completed', 'azin-file' ),
            'required' => array( 'edit_bar_sales', '=', true ),
        ),
        array(
            'id'       => 'bar_sales_value',
            'type'     => 'text',
            'title'    => __( 'Sales count value', 'azin-file' ),
            'default'  => '+1',
            'required' => array( 'edit_bar_sales', '=', true ),
        ),
        array(
            'id'       => 'bar_sales_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Sales count icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-box-check',
            'options'  => $alliconArray,
            'required' => array( 'edit_bar_sales', '=', true ),
        ),
        //info_bar_sales

        //info_bar_purchased_products
        array(
            'id'       => 'info_bar_purchased_products',
            'type'     => 'switch',
            'title'    => __( 'Display the number of purchased products', 'azin-file' ),
            'default'  => false,
            'required' => array( 'info_bar', '=', true ),
        ),
        array(
            'id'       => 'edit_bar_purchased_products',
            'type'     => 'switch',
            'title'    => __( 'Edit purchased products count', 'azin-file' ),
            'default'  => false,
            'required' => array( 'info_bar_purchased_products', '=', true ),
        ),
        array(
            'id'       => 'bar_purchased_products_title',
            'type'     => 'text',
            'title'    => __( 'Purchased products count title', 'azin-file' ),
            'default'  => __( 'Purchased products', 'azin-file' ),
            'required' => array( 'edit_bar_purchased_products', '=', true ),
        ),
        array(
            'id'       => 'bar_purchased_products_value',
            'type'     => 'text',
            'title'    => __( 'Purchased products count value', 'azin-file' ),
            'default'  => '+1',
            'required' => array( 'edit_bar_purchased_products', '=', true ),
        ),
        array(
            'id'       => 'bar_purchased_products_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Purchased products count icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-bags-shopping',
            'options'  => $alliconArray,
            'required' => array( 'edit_bar_purchased_products', '=', true ),
        ),
        //info_bar_purchased_products

        //info_bar_users
        array(
            'id'       => 'info_bar_users',
            'type'     => 'switch',
            'title'    => __( 'Display the number of users', 'azin-file' ),
            'default'  => true,
            'required' => array( 'info_bar', '=', true ),
        ),
        array(
            'id'       => 'edit_bar_users',
            'type'     => 'switch',
            'title'    => __( 'Edit users count', 'azin-file' ),
            'default'  => false,
            'required' => array( 'info_bar_users', '=', true ),
        ),
        array(
            'id'       => 'bar_users_title',
            'type'     => 'text',
            'title'    => __( 'Users count title', 'azin-file' ),
            'default'  => __( 'Members', 'azin-file' ),
            'required' => array( 'edit_bar_users', '=', true ),
        ),
        array(
            'id'       => 'bar_users_value',
            'type'     => 'text',
            'title'    => __( 'Users count value', 'azin-file' ),
            'default'  => '+1',
            'required' => array( 'edit_bar_users', '=', true ),
        ),
        array(
            'id'       => 'bar_users_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Users count icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-users',
            'options'  => $alliconArray,
            'required' => array( 'edit_bar_users', '=', true ),
        ),
        //info_bar_users

        //info_bar_posts
        array(
            'id'       => 'info_bar_posts',
            'type'     => 'switch',
            'title'    => __( 'Display the number of posts', 'azin-file' ),
            'default'  => true,
            'required' => array( 'info_bar', '=', true ),
        ),
        array(
            'id'       => 'edit_bar_posts',
            'type'     => 'switch',
            'title'    => __( 'Edit posts count', 'azin-file' ),
            'default'  => false,
            'required' => array( 'info_bar_posts', '=', true ),
        ),
        array(
            'id'       => 'bar_posts_title',
            'type'     => 'text',
            'title'    => __( 'Posts count title', 'azin-file' ),
            'default'  => __( 'Blog content', 'azin-file' ),
            'required' => array( 'edit_bar_posts', '=', true ),
        ),
        array(
            'id'       => 'bar_posts_value',
            'type'     => 'text',
            'title'    => __( 'Posts count value', 'azin-file' ),
            'default'  => '+1',
            'required' => array( 'edit_bar_posts', '=', true ),
        ),
        array(
            'id'       => 'bar_posts_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Posts count icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-file-alt',
            'options'  => $alliconArray,
            'required' => array( 'edit_bar_posts', '=', true ),
        ),
        //info_bar_posts

        array(
            'id'     => 'section-info-bar-end',
            'type'   => 'section',
            'indent' => false,
        ),
        
        //Section shopping cart button start
        array(
            'id'     => 'section-cart-btn-start',
            'type'   => 'section',
            'title'    => __( 'Shopping Cart Button Settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_cart_btn',
            'type'     => 'switch',
            'title'    => __( 'Shopping Cart Button', 'azin-file' ),
            'subtitle' => __( 'Show shopping cart button', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'link_cart_page',
            'type'     => 'switch',
            'title'    => __( 'Direct link of the button to the shopping cart page', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_cart_btn', '=', true )
        ),
        array(
            'id'       => 'show_cart_number',
            'type'     => 'switch',
            'title'    => __( 'Display the number of products in the cart', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_cart_btn', '=', true )
        ),
        array(
            'id'       => 'show_cart_btn_head',
            'type'     => 'switch',
            'title'    => __( 'Show shopping cart button in header', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_cart_btn', '=', true )
        ),
        array(
            'id'       => 'ajax_add_open_cart',
            'type'     => 'switch',
            'title'    => __( 'Open the shopping cart from the side', 'azin-file' ),
            'subtitle' => __( 'Opening the shopping cart from the side after the product is added to the shopping cart', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_cart_btn', '=', true )
        ),
        array(
            'id'       => 'cart_btn_bottom',
            'type'     => 'text',
            'title'    => __( 'Distance from the bottom', 'azin-file' ),
            'default'  => '40',
            'required' => array(
                array( 'show_cart_btn', '=', true ), 
                array( 'show_cart_btn_head', '!=', true ) 
            )
        ),
        array(
            'id'       => 'cart_btn_left',
            'type'     => 'text',
            'title'    => __( 'Distance from the left', 'azin-file' ),
            'default'  => '20',
            'required' => array(
                array( 'show_cart_btn', '=', true ), 
                array( 'show_cart_btn_head', '!=', true ) 
            )
        ),
        array(
            'id'       => 'cart_btn_color',
            'type'     => 'color',
            'title'    => __( 'Shopping cart button color', 'azin-file' ),
            'default'  => '#2B58B3',
            'validate' => 'color',
            'transparent' => false,
            'required' => array(
                array( 'show_cart_btn', '=', true ), 
                array( 'show_cart_btn_head', '!=', true ) 
            )
        ),
        array(
            'id'       => 'cart_btn_hcolor',
            'type'     => 'color',
            'title'    => __( 'Shopping cart button hover color', 'azin-file' ),
            'default'  => '#21448a',
            'validate' => 'color',
            'transparent' => false,
            'required' => array(
                array( 'show_cart_btn', '=', true ), 
                array( 'show_cart_btn_head', '!=', true ) 
            )
        ),
        array(
            'id'     => 'section-cart-btn-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //Section back to up button start
        array(
            'id'     => 'section-return-top-start',
            'type'   => 'section',
            'title'    => __( 'Back up button settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_return_top',
            'type'     => 'switch',
            'title'    => __( 'Back up button', 'azin-file' ),
            'subtitle' => __( 'Show back button', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'return_top_bottom',
            'type'     => 'text',
            'title'    => __( 'Distance from the bottom', 'azin-file' ),
            'default'  => '40',
            'required' => array( 'show_return_top', '=', true ),
        ),
        array(
            'id'       => 'return_top_right',
            'type'     => 'text',
            'title'    => __( 'Distance from the right', 'azin-file' ),
            'default'  => '20',
            'required' => array( 'show_return_top', '=', true ),
        ),
        array(
            'id'     => 'section-return-top-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //Section address start
        array(
            'id'     => 'section-addr-start',
            'type'   => 'section',
            'title'    => __( 'Address section settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_addr',
            'type'     => 'switch',
            'title'    => __( 'Address section', 'azin-file' ),
            'subtitle' => __( 'Display the address section in the footer of the site', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_faddr',
            'type'     => 'switch',
            'title'    => __( 'Show address', 'azin-file' ),
            'subtitle' => __( 'Display the address in the footer of the site', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_addr', '=', true ),
        ),
        array(
            'id'       => 'addr_text',
            'type'     => 'text',
            'title'    => __( 'Address text', 'azin-file' ),
            'default'  => __( 'No. 7, Central Building, Central Street, Tehran City, Tehran Province', 'azin-file' ),
            'required' => array( 'show_faddr', '=', true ),
        ),
        array(
            'id'       => 'show_ftel',
            'type'     => 'switch',
            'title'    => __( 'Show phone number', 'azin-file' ),
            'subtitle' => __( 'Show phone in footer', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_addr', '=', true ),
        ),
        array(
            'id'       => 'site_ftel_link',
            'type'     => 'switch',
            'title'    => __( 'Linking phone', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_ftel', '=', true ),
        ),
        array(
            'id'       => 'show_fmail',
            'type'     => 'switch',
            'title'    => __( 'Show email', 'azin-file' ),
            'subtitle' => __( 'Show email in footer', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_addr', '=', true ),
        ),
        array(
            'id'       => 'site_fmail_link',
            'type'     => 'switch',
            'title'    => __( 'Linking email', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_fmail', '=', true ),
        ),
        array(
            'id'       => 'show_apps',
            'type'     => 'switch',
            'title'    => __( 'Application buttons', 'azin-file' ),
            'subtitle' => __( 'Display app buttons in the footer of the site', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_addr', '=', true ),
        ),
        array(
            'id'       => 'and_link',
            'type'     => 'text',
            'title'    => __( 'Android link', 'azin-file' ),
            'default'  => '#',
            'required' => array( 'show_apps', '=', true ),
        ),
        array(
            'id'       => 'ios_link',
            'type'     => 'text',
            'title'    => __( 'IOS link', 'azin-file' ),
            'default'  => '#',
            'required' => array( 'show_apps', '=', true ),
        ),
        array(
            'id'     => 'section-addr-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //Section application download bar start
        array(
            'id'     => 'section-alert-app-start',
            'type'   => 'section',
            'title'    => __( 'Application download bar settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_alert_app',
            'type'     => 'switch',
            'title'    => __( 'Application download bar', 'azin-file' ),
            'subtitle' => __( 'Display app download bar on mobile', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'alert_app_title',
            'type'     => 'text',
            'title'    => __( 'Title of the application download bar', 'azin-file' ),
            'default'  => __( 'Optimal display in mobile app!', 'azin-file' ),
            'required' => array( 'show_alert_app', '=', true ),
        ),
        array(
            'id'     => 'section-addr-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //Section copyright start
        array(
            'id'     => 'section-copy-start',
            'type'   => 'section',
            'title'    => __( 'Copyright section settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'   => 'footer_text',
            'type' => 'textarea',
            'title'    => __( 'Copyright text', 'azin-file' ),
            'subtitle' => __( 'Change the text in the footer of the site.', 'azin-file' ),
            'default' => __( 'All rights reserved for our site.', 'azin-file' ),
            'allowed_html' => array(
                'a' => array(
                    'href' => array(),
                    'title'    => array()
                ),
                'br' => array(),
                'em' => array(),
                'strong' => array()
            ),
        ),
        array(
            'id'     => 'section-copy-end',
            'type'   => 'section',
            'indent' => false,
        ),

        array(
            'id'     => 'section-footer-social-start',
            'type'   => 'section',
            'title'    => __( 'Footer social networks settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'hide_footer_social',
            'type'     => 'switch',
            'title'    => __( 'Hide footer social networks', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'footer_social_bw',
            'type'     => 'switch',
            'title'    => __( 'Black & white style', 'azin-file' ),
            'default'  => true,
            'required' => array( 'hide_footer_social', '!=', true ),
        ),
        array(
            'id'       => 'footer_social_circle',
            'type'     => 'switch',
            'title'    => __( 'Circle style', 'azin-file' ),
            'default'  => true,
            'required' => array( 'hide_footer_social', '!=', true ),
        ),
        array(
            'id'       => 'footer_nav',
            'type'     => 'switch',
            'title'    => __( 'Show footer menu', 'azin-file' ),
            'subtitle' => __( 'Show menu instead of social networking section at the bottom of the site', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'     => 'section-copy-end',
            'type'   => 'section',
            'indent' => false,
        ),
    )
) );

//Other settings
Redux::setSection( $opt_name, array(
    'title'      => __( 'Other settings', 'azin-file' ),
    'icon'       => 'fa fa-cog',
    'id'         => 'side-setting',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'     => 'section-side-bar-start',
            'type'   => 'section',
            'title'    => __( 'Sidebar settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'side_type',
            'type'     => 'image_select',
            'title'    => __( 'Sidebar location', 'azin-file' ),
            'subtitle' => __( 'Specify the location of the sidebar.', 'azin-file' ),
            'desc'     => '',
            'options'  => array(
                '1' => array(
                    'alt' => __( 'Left side', 'azin-file' ),
                    'img' => RE_URI . 'assets/img/2cl.png'
                ),
                '2' => array(
                    'alt' => __( 'Right side', 'azin-file' ),
                    'img' => RE_URI . 'assets/img/2cr.png'
                )
            ),
            'default'  => '1'
        ),
        array(
            'id'       => 'show_side_mobile',
            'type'     => 'switch',
            'title'    => __( 'Display sidebar', 'azin-file' ),
            'subtitle' => __( 'Specify that the sidebar be displayed in tablet and mobile mode', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'sticky_side',
            'type'     => 'switch',
            'title'    => __( 'Sticky sidebar', 'azin-file' ),
            'subtitle' => __( 'In this case, the widgets and the content section remain fixed when scrolling the page so as not to create empty space.', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'     => 'section-side-bar-end',
            'type'   => 'section',
            'indent' => false,
        ),

        array(
            'id'     => 'section-admin-bar-start',
            'type'   => 'section',
            'title'    => __( 'Admin bar settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_abar',
            'type'     => 'switch',
            'title'    => __( 'Do not display the admin bar', 'azin-file' ),
            'subtitle' => __( 'Do not display the admin bar when viewing the site', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'show_abar_admin',
            'type'     => 'switch',
            'title'    => __( 'Show for admin only', 'azin-file' ),
            'subtitle' => __( 'Show admin bar only for admin', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_abar', '=', true ),
        ),
        array(
            'id'       => 'show_abar_editor',
            'type'     => 'switch',
            'title'    => __( 'Display for author users', 'azin-file' ),
            'subtitle' => __( 'Display for users who have the ability to edit and publish content.', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_abar', '=', true ),
        ),
        array(
            'id'     => 'section-admin-bar-end',
            'type'   => 'section',
            'indent' => false,
        ),

        array(
            'id'     => 'section-loading-start',
            'type'   => 'section',
            'title'    => __( 'Preloader Settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_page_loading',
            'type'     => 'switch',
            'title'    => __( 'Show preloader', 'azin-file' ),
            'subtitle' => __( 'Show preloader when loading pages', 'azin-file' ),
            'default'  => true,
        ),
        array( 
            'id'       => 'load_img',
            'type'     => 'select_image',
            'title'    => __( 'Preloader image', 'azin-file' ),
            'subtitle' => __( 'Select preloader image', 'azin-file' ),
            'options'  => Array(
                Array (
                        'alt'  => __( 'Image 1', 'azin-file' ),
                        'img'  => RE_URI .'assets/img/loading/loader0.gif',
                ),
                Array (
                        'alt'  => __( 'Image 2', 'azin-file' ),
                        'img'  => RE_URI .'assets/img/loading/loader1.gif',
                ),
                Array (
                        'alt'  => __( 'Image 3', 'azin-file' ),
                        'img'  => RE_URI .'assets/img/loading/loader2.gif',
                ),
                Array (
                        'alt'  => __( 'Image 4', 'azin-file' ),
                        'img'  => RE_URI .'assets/img/loading/loader3.gif',
                ),
                Array (
                        'alt'  => __( 'Image 5', 'azin-file' ),
                        'img'  => RE_URI .'assets/img/loading/loader4.gif',
                ),
                Array (
                        'alt'  => __( 'Image 6', 'azin-file' ),
                        'img'  => RE_URI .'assets/img/loading/loader5.gif',
                ),
                Array (
                        'alt'  => __( 'Image 7', 'azin-file' ),
                        'img'  => RE_URI .'assets/img/loading/loader6.gif',
                ),
                Array (
                        'alt'  => __( 'Image 8', 'azin-file' ),
                        'img'  => RE_URI .'assets/img/loading/loader7.gif',
                ),
                Array (
                        'alt'  => __( 'Image 9', 'azin-file' ),
                        'img'  => RE_URI .'assets/img/loading/loader8.gif',
                ),
                Array (
                        'alt'  => __( 'Image 10', 'azin-file' ),
                        'img'  => RE_URI .'assets/img/loading/loader9.gif',
                ),
                Array (
                        'alt'  => __( 'Image 11', 'azin-file' ),
                        'img'  => RE_URI .'assets/img/loading/loader10.gif',
                )
            ),
            'required' => array( 'show_page_loading', '=', true ),
            'default'  => RE_URI .'assets/img/loading/loader0.gif'
        ),
        array(
            'id'     => 'section-loading-end',
            'type'   => 'section',
            'indent' => false,
        ),

        array(
            'id' => '404-page-section-start',
            'type' => 'section',
            'title'    => __( '404 page settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'custom_404_page',
            'type'     => 'select',
            'ajax'     => true,
            'multi'    => false,
            'data'      => 'pages',
            'title'    => __( 'Custom 404 page', 'azin-file' ),
            'subtitle' => __( 'Select a page that will be shown as your default 404 error page.', 'azin-file' ),
        ),
        array(
            'id' => '404-page-section-end',
            'type' => 'section',
            'indent' => false,
        ),

        array(
            'id'       => 'tag_number',
            'type'     => 'text',
            'title'    => __( 'Number of widget tags', 'azin-file' ),
            'subtitle' => __( 'The number of tags displayed in the tag tag widget.', 'azin-file' ),
            'default'  => 32,
        ),
        array(
            'id'       => 'dis_rss_feeds',
            'type'     => 'switch',
            'title'    => __( 'Disable RSS feeds' , 'azin-file' ),
            'subtitle' => __( 'Disable WordPress RSS feeds' , 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'open_cat_widget',
            'type'     => 'switch',
            'title'    => __( 'Open category widget', 'azin-file' ),
            'subtitle' => __( 'Display subcategories of category widgets by default', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'remove_menu_icon',
            'type'     => 'switch',
            'title'    => __( 'Remove menus icon', 'azin-file' ),
            'subtitle' => __( 'By activating this option, the possibility of inserting icons for menus will be removed. In sites that have many menus, activating this item will make the menu management page faster.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'dis_widget_editor',
            'type'     => 'switch',
            'title'    => __( 'Classic widgets' , 'azin-file' ),
            'subtitle' => __( 'Enables the previous "classic" widgets settings screens in Appearance - Widgets and the Customizer. Disables the block editor from managing widgets.' , 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'hide_side_panel_icon',
            'type'     => 'switch',
            'title'    => __( 'Hide side panel icons', 'azin-file' ),
            'subtitle' => __( 'Panels of the user menu, mobile menu, search and login', 'azin-file' ),
            'default'  => false,
        ),
    )
) );

//Mobile Navigation Bar
Redux::setSection( $opt_name, array(
    'title'      => __( 'Mobile Navigation Bar', 'azin-file' ),
    'icon'       => 'fa fa-mobile-android',
    'id'         => 'mobile-nav-setting',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'show_mobile_bar',
            'type'     => 'switch',
            'title'    => __( 'Show mobile navigation bar' , 'azin-file' ),
            'subtitle' => __( 'Show the bottom bar displayed at the bottom of the site in mobile mode' , 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'mobile_bar_title',
            'type'     => 'switch',
            'title' => __( 'Hide mobile navigation bar titles' , 'azin-file' ),
            'subtitle' => __( 'Hide the mobile navigation bar icon title' , 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_mobile_bar', '=', true ),
        ),
        array(
            'id'       => 'mobile_bar_btns',
            'type'     => 'select',
            'multi'    => true,
            'sortable' => true,
            'title'    => __( 'Mobile navigation bar buttons', 'azin-file' ), 
            'subtitle' => __( 'In this section, you can select up to 5 buttons to display in the mobile navigation bar. No more than 5 items will be displayed in the output.', 'azin-file' ),
            'desc'     => __( 'No more than 5 items will be displayed in the output.', 'azin-file' ),
            'options'  => array(
                'back-top'         => __( 'Back top', 'azin-file' ),
                'wishlist'         => __( 'Wishlist', 'azin-file' ),
                'home-btn'         => __( 'Home', 'azin-file' ),
                //'compare-btn'    => __( 'Compare', 'azin-file' ),
                'cart-btn'         => __( 'Shopping cart', 'azin-file' ),
                'my-account'       => __( 'My Account', 'azin-file' ),
                'menu'             => __( 'Menu', 'azin-file' ),
                //'dark-mode'      => __( 'Dark mode', 'azin-file' ),
                'custom-btn-one'   => __( 'Custom button one', 'azin-file' ),
                'custom-btn-two'   => __( 'Custom button two', 'azin-file' ),
                'custom-btn-three' => __( 'Custom button three', 'azin-file' ),
            ),
            'required' => array( 'show_mobile_bar', '=', true ),
            'default'  => array( 'back-top', 'wishlist', 'home-btn', 'cart-btn' )
        ),

        //mobile-nav-btn-one-section-start
        array(
            'id' => 'mobile-nav-btn-one-section-start',
            'type' => 'section',
            'title' => __( 'Settings of the first custom mobile navigation bar button', 'azin-file' ),
            'indent' => true,
            'required' => array( 'show_mobile_bar', '=', true ),
        ),
        array(
            'id'       => 'mobile_nav_btn_one',
            'type'     => 'switch',
            'title' => __( 'Enable Button' , 'azin-file' ),
            'subtitle' => __( 'Enable first custom mobile navigation bar button' , 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'mobile_nav_btn_one_title',
            'type'     => 'text',
            'title'    => __( 'Button title', 'azin-file' ),
            'default'  => __( 'Button one', 'azin-file' ),
            'required' => array( 'mobile_nav_btn_one', '=', true ),
        ),
        array(
            'id'       => 'mobile_nav_btn_one_link',
            'type'     => 'text',
            'title' => __( 'Button link', 'azin-file' ),
            'default'  => '#',
            'required' => array( 'mobile_nav_btn_one', '=', true ),
        ),
        array(
            'id'       => 'mobile_nav_btn_one_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fa' ),
            'title'    => __( 'Button icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-instagram',
            'options'  => $alliconArray,
            'required' => array( 'mobile_nav_btn_one', '=', true ),
        ),
        array(
            'id' => 'mobile-nav-btn-one-section-end',
            'type' => 'section',
            'indent' => false,
        ),

        //mobile-nav-btn-two-section-start
        array(
            'id' => 'mobile-nav-btn-two-section-start',
            'type' => 'section',
            'title' => __( 'Settings of the second custom mobile navigation bar button', 'azin-file' ),
            'indent' => true,
            'required' => array( 'show_mobile_bar', '=', true ),
        ),
        array(
            'id'       => 'mobile_nav_btn_two',
            'type'     => 'switch',
            'title' => __( 'Enable Button' , 'azin-file' ),
            'subtitle' => __( 'Enable second custom mobile navigation bar button' , 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'mobile_nav_btn_two_title',
            'type'     => 'text',
            'title'    => __( 'Button title', 'azin-file' ),
            'default'  => __( 'Button two', 'azin-file' ),
            'required' => array( 'mobile_nav_btn_two', '=', true ),
        ),
        array(
            'id'       => 'mobile_nav_btn_two_link',
            'type'     => 'text',
            'title' => __( 'Button link', 'azin-file' ),
            'default'  => '#',
            'required' => array( 'mobile_nav_btn_two', '=', true ),
        ),
        array(
            'id'       => 'mobile_nav_btn_two_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fa' ),
            'title'    => __( 'Button icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-telegram',
            'options'  => $alliconArray,
            'required' => array( 'mobile_nav_btn_two', '=', true ),
        ),
        array(
            'id' => 'mobile-nav-btn-two-section-end',
            'type' => 'section',
            'indent' => false,
        ),

        //mobile-nav-btn-three-section-start
        array(
            'id' => 'mobile-nav-btn-three-section-start',
            'type' => 'section',
            'title' => __( 'Settings of the third custom mobile navigation bar button', 'azin-file' ),
            'indent' => true,
            'required' => array( 'show_mobile_bar', '=', true ),
        ),
        array(
            'id'       => 'mobile_nav_btn_three',
            'type'     => 'switch',
            'title' => __( 'Enable Button' , 'azin-file' ),
            'subtitle' => __( 'Enable third custom mobile navigation bar button' , 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'mobile_nav_btn_three_title',
            'type'     => 'text',
            'title'    => __( 'Button title', 'azin-file' ),
            'default'  => __( 'Button three', 'azin-file' ),
            'required' => array( 'mobile_nav_btn_three', '=', true ),
        ),
        array(
            'id'       => 'mobile_nav_btn_three_link',
            'type'     => 'text',
            'title' => __( 'Button link', 'azin-file' ),
            'default'  => '#',
            'required' => array( 'mobile_nav_btn_three', '=', true ),
        ),
        array(
            'id'       => 'mobile_nav_btn_three_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fa' ),
            'title'    => __( 'Button icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-whatsapp',
            'options'  => $alliconArray,
            'required' => array( 'mobile_nav_btn_three', '=', true ),
        ),
        array(
            'id' => 'mobile-nav-btn-three-section-end',
            'type' => 'section',
            'indent' => false,
        ),

        //back-top-section-start
        array(
            'id' => 'back-top-section-start',
            'type' => 'section',
            'title' => __( 'Mobile Back to top Button settings', 'azin-file' ),
            'indent' => true,
            'required' => array( 'show_mobile_bar', '=', true ),
        ),
        array(
            'id'       => 'ch_back_top_btn',
            'type'     => 'switch',
            'title' => __( 'Change Back to top Button' , 'azin-file' ),
            'subtitle' => __( 'Change Back to top Button displayed at the bottom of the site in mobile mode' , 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'back_top_btn_title',
            'type'     => 'text',
            'title' => __( 'Button title', 'azin-file' ),
            'default'  => __( 'Return', 'azin-file' ),
            'required' => array( 'ch_back_top_btn', '=', true ),
        ),
        array(
            'id'       => 'back_top_btn_link',
            'type'     => 'text',
            'title' => __( 'Button link', 'azin-file' ),
            'default'  => '#',
            'required' => array( 'ch_back_top_btn', '=', true ),
        ),
        array(
            'id'       => 'back_top_btn_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fa' ),
            'title'    => __( 'Button icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-chevron-up',
            'options'  => $alliconArray,
            'required' => array( 'ch_back_top_btn', '=', true ),
        ),
        array(
            'id' => 'back-top-section-end',
            'type' => 'section',
            'indent' => false,
        ),
        
        //whish-section-start
        array(
            'id' => 'whish-section-start',
            'type' => 'section',
            'title' => __( 'Wishlist Button settings', 'azin-file' ),
            'indent' => true,
            'required' => array( 'show_mobile_bar', '=', true ),
        ),
        array(
            'id'       => 'ch_whish_btn',
            'type'     => 'switch',
            'title' => __( 'Change Wishlist Button' , 'azin-file' ),
            'subtitle' => __( 'Change Wishlist Button displayed at the bottom of the site in mobile mode' , 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'whish_btn_title',
            'type'     => 'text',
            'title' => __( 'Button title', 'azin-file' ),
            'default'  => __( 'Wishlist', 'azin-file' ),
            'required' => array( 'ch_whish_btn', '=', true ),
        ),
        array(
            'id'       => 'whish_btn_link',
            'type'     => 'text',
            'title' => __( 'Button link', 'azin-file' ),
            'default'  => '#',
            'required' => array( 'ch_whish_btn', '=', true ),
        ),
        array(
            'id'       => 'whish_btn_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fa' ),
            'title'    => __( 'Button icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-heart',
            'options'  => $alliconArray,
            'required' => array( 'ch_whish_btn', '=', true ),
        ),
        array(
            'id' => 'whish-section-end',
            'type' => 'section',
            'indent' => false,
        ),
        
    )
) );

//Change phrases
Redux::setSection( $opt_name, array(
    'title'      => __( 'Change phrases', 'azin-file' ),
    'icon'       => 'fa fa-text-width',
    'id'         => 'ch-texts',
    'desc'       => __( 'You can use this section to change the expressions in the theme to the desired expression.', 'azin-file' ),
    'subsection' => true,
    'fields'     => array(
        array(
            'id' => 'section-header',
            'type' => 'section',
            'title'    => __( 'Header section phrases', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'text_shop',
            'type'     => 'text',
            'title'    => __( 'Shopping', 'azin-file' ),
            'default'  => __( 'Shopping', 'azin-file' ),
        ),
        array(
            'id'       => 'text_blog',
            'type'     => 'text',
            'title'    => __( 'Blog', 'azin-file' ),
            'default'  => __( 'Blog', 'azin-file' ),
        ),
        array(
            'id'       => 'text_search',
            'type'     => 'text',
            'title'    => __( 'Search ...', 'azin-file' ),
            'default'  => __( 'Search ...', 'azin-file' ),
        ),
        array(
            'id'       => 'text_date',
            'type'     => 'text',
            'title'    => __( 'Today:', 'azin-file' ),
            'default'  => __( 'Today:', 'azin-file' ),
        ),
        array(
            'id'       => 'text_login',
            'type'     => 'text',
            'title'    => __( 'Login', 'azin-file' ),
            'default'  => __( 'Login', 'azin-file' ),
        ),
        array(
            'id'       => 'text_register',
            'type'     => 'text',
            'title'    => __( 'Register', 'azin-file' ),
            'default'  => __( 'Register', 'azin-file' ),
        ),
        array(
            'id'       => 'text_reg_hint',
            'type'     => 'text',
            'title'    => __( 'Register to use all the features of the site', 'azin-file' ),
            'default'  => __( 'Register to use all the features of the site', 'azin-file' ),
        ),
        array(
            'id'     => 'section-head-end',
            'type'   => 'section',
            'indent' => false,
        ),
        array(
            'id' => 'section-single',
            'type' => 'section',
            'title'    => __( 'Product page and post phrases', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'text_share',
            'type'     => 'text',
            'title'    => __( 'Share', 'azin-file' ),
            'default'  => __( 'Share', 'azin-file' ),
        ),
        array(
            'id'       => 'text_special',
            'type'     => 'text',
            'title'    => __( 'Special', 'azin-file' ),
            'default'  => __( 'Special', 'azin-file' ),
        ),
        array(
            'id'       => 'text_price',
            'type'     => 'text',
            'title'    => __( 'Price', 'azin-file' ),
            'default'  => __( 'Price', 'azin-file' ),
        ),
        array(
            'id'       => 'text_add_shop',
            'type'     => 'text',
            'title'    => __( 'Add to cart', 'azin-file' ),
            'default'  => __( 'Add to cart', 'azin-file' ),
        ),
        array(
            'id'       => 'text_buy_course',
            'type'     => 'text',
            'title'    => __( 'Buy this course', 'azin-file' ),
            'default'  => __( 'Buy this course', 'azin-file' ),
        ),
        array(
            'id'       => 'text_coming',
            'type'     => 'text',
            'title'    => __( 'Coming soon...', 'azin-file' ),
            'default'  => __( 'Coming soon...', 'azin-file' ),
        ),
        array(
            'id'       => 'text_not_stock',
            'type'     => 'text',
            'title'    => __( 'Out of stock', 'azin-file' ),
            'default'  => __( 'Out of stock', 'azin-file' ),
        ),
        array(
            'id'       => 'text_free_logged',
            'type'     => 'text',
            'title'    => __( 'Download this file is only active for site members', 'azin-file' ),
            'default'  => __( 'Download this file is only active for site members', 'azin-file' ),
        ),
        array(
            'id'       => 'text_buy_this',
            'type'     => 'text',
            'title'    => __( 'Buy this product', 'azin-file' ),
            'default'  => __( 'Buy this product', 'azin-file' ),
        ),
        array(
            'id'       => 'text_down_this',
            'type'     => 'text',
            'title'    => __( 'Free download', 'azin-file' ),
            'default'  => __( 'Free download', 'azin-file' ),
        ),
        array(
            'id'       => 'text_read_more',
            'type'     => 'text',
            'title'    => __( 'Read more', 'azin-file' ),
            'default'  => __( 'Read more', 'azin-file' ),
        ),
        array(
            'id'       => 'text_tags',
            'type'     => 'text',
            'title'    => __( 'Tags', 'azin-file' ),
            'default'  => __( 'Tags', 'azin-file' ),
        ),
        array(
            'id'     => 'section-single-end',
            'type'   => 'section',
            'indent' => false,
        ),
        array(
            'id' => 'section-dlbox',
            'type' => 'section',
            'title'    => __( 'Download Box Phrases', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'text_dl',
            'type'     => 'text',
            'title'    => __( 'Download', 'azin-file' ),
            'default'  => __( 'Download', 'azin-file' ),
        ),
        array(
            'id'       => 'text_size',
            'type'     => 'text',
            'title'    => __( 'File size', 'azin-file' ),
            'default'  => __( 'File size', 'azin-file' ),
        ),
        array(
            'id'       => 'text_pass',
            'type'     => 'text',
            'title'    => __( 'Password', 'azin-file' ),
            'default'  => __( 'Password', 'azin-file' ),
        ),
        array(
            'id'       => 'text_hdl',
            'type'     => 'text',
            'title'    => __( 'Download guide', 'azin-file' ),
            'default'  => __( 'Download guide', 'azin-file' ),
        ),
        array(
            'id'     => 'section-dlbox-end',
            'type'   => 'section',
            'indent' => false,
        ),
        array(
            'id' => 'section-general',
            'type' => 'section',
            'title'    => __( 'General phrases', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'text_more',
            'type'     => 'text',
            'title'    => __( 'View All', 'azin-file' ),
            'default'  => __( 'View All', 'azin-file' ),
        ),
        array(
            'id'       => 'text_more_text',
            'type'     => 'text',
            'title'    => __( 'Read more', 'azin-file' ),
            'default'  => __( 'Read more', 'azin-file' ),
        ),
        array(
            'id'       => 'text_home',
            'type'     => 'text',
            'title'    => __( 'Home', 'azin-file' ),
            'default'  => __( 'Home', 'azin-file' ),
        ),
        array(
            'id'       => 'text_not_found',
            'type'     => 'text',
            'title'    => __( 'Item not found', 'azin-file' ),
            'default'  => __( 'Item not found', 'azin-file' ),
        ),
        array(
            'id'       => 'text_admin',
            'type'     => 'text',
            'title'    => __( 'Admin', 'azin-file' ),
            'default'  => __( 'Admin', 'azin-file' ),
        ),
        array(
            'id'       => 'text_seller',
            'type'     => 'text',
            'title'    => __( 'Seller', 'azin-file' ),
            'default'  => __( 'Seller', 'azin-file' ),
        ),
        array(
            'id'       => 'text_customer',
            'type'     => 'text',
            'title'    => __( 'Buyer', 'azin-file' ),
            'default'  => __( 'Buyer', 'azin-file' ),
        ),
        array(
            'id'       => 'text_free',
            'type'     => 'text',
            'title'    => __( 'Free', 'azin-file' ),
            'default'  => __( 'Free', 'azin-file' ),
        ),
        array(
            'id'       => 'text_coming_soon',
            'type'     => 'text',
            'title'    => __( 'Coming soon', 'azin-file' ),
            'default'  => __( 'Coming soon', 'azin-file' ),
        ),
        array(
            'id'       => 'text_buy',
            'type'     => 'text',
            'title'    => __( 'Buy', 'azin-file' ),
            'default'  => __( 'Buy', 'azin-file' ),
        ),
        array(
            'id'     => 'section-general-end',
            'type'   => 'section',
            'indent' => false,
        ), 
    )
) );