<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Demo Website: https://azinfile.i-design.ir/
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

//Start Home settings SECTION
Redux::setSection( $opt_name, array(
    'title'            => __( 'Home settings', 'azin-file' ),
    'id'               => 'menu_home',
    'desc'             => __( 'Site front page settings', 'azin-file' ),
    'customizer_width' => '400px',
    'icon'             => 'fa fa-home'
) );

//Site logo
Redux::setSection( $opt_name, array(
    'title'            => __( 'Site logo', 'azin-file' ),
    'icon'             => 'fa fa-yin-yang',
    'id'               => 'sitelogo',
    'subsection'       => true,
    'customizer_width' => '450px',
    'desc'             => __( 'Settings related to the site logo', 'azin-file' ),
    'fields'           => array(
        array(
            'id'       => 'site_logo',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Your logo', 'azin-file' ),
            'compiler' => 'true',
            'desc'     => __( 'Upload your site logo from this section.', 'azin-file' ),
            'subtitle' => __( 'Suitable size: 140 pixels (width) and 60 pixels (height)', 'azin-file' ),
            'default'  => array( 'url' => get_template_directory_uri()."/images/logo.png" ),
        ),
        array(
            'id'       => 'site_logo_retina',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Retina logo', 'azin-file' ),
            'compiler' => 'true',
            'desc'     => __( 'Upload the site logo twice the size of the logo', 'azin-file' ),
            'subtitle' => __( 'Suitable size: 280 pixels (width) and 120 pixels (height)', 'azin-file' ),
            'default'  => array( 'url' => get_template_directory_uri()."/images/logo2x.png" ),
        ),
        array(
            'id'       => 'site_favicon',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Favicon', 'azin-file' ),
            'compiler' => 'true',
            'mode'     => false, 
            'desc'     => __( 'Upload your site icon. This icon is displayed next to your address in some browsers.', 'azin-file' ),
            'default'  => array( 'url' => get_template_directory_uri()."/images/favicon.png" ),
        ),
        array(
            'id'       => 'login_logo_switch',
            'type'     => 'switch',
            'title'    => __( 'Change the WordPress login page logo', 'azin-file' ),
            'subtitle' => __( 'Enabling this option will change the WordPress logo on the login page of the logo you selected in the Retina logo section.', 'azin-file' ),
            'default'  => false
        ),
        array(
            'id'       => 'change_logo_link',
            'type'     => 'switch',
            'title'    => __( 'Change logo link', 'azin-file' ),
            'subtitle' => __( 'With this option, you can change the default link of the logo that is connected to the main page of your site', 'azin-file' ),
            'default'  => false
        ),
        array(
            'id'       => 'logo_link',
            'type'     => 'text',
            'title'    => __( 'Logo link', 'azin-file' ),
            'default'  => '#',
            'required' => array( 'change_logo_link', '=', true ),
        ),
    )
) );

//Font settings
Redux::setSection( $opt_name, array(
    'title'            => __( 'Font settings', 'azin-file' ),
    'icon'             => 'fa fa-font',
    'id'               => 'theme-font',
    'subsection'       => true,
    'customizer_width' => '500px',
    'desc'             => __( 'Template font settings', 'azin-file' ),
    'fields'           => array(

        array(
            'id' => 'content_font_size',
            'type' => 'slider',
            'title'    => __( 'Content font size (products, posts and pages)', 'azin-file' ),
            'default' => 15,
            'min' => 12,
            'step' => 1,
            'max' => 30,
            'display_value' => 'label'
        ),

        array(
            'id'       => 'theme_font',
            'type'     => 'select',
            'title'    => __( 'Template font', 'azin-file' ),
            'subtitle' => __( 'Select the template font', 'azin-file' ),
            'options'  => array(
                'sans'     =>  __( 'Iran Sans', 'azin-file' ),
                'yekan'    =>  __( 'Iran Yekan', 'azin-file' ),
                'sans-fa'  =>  __( 'Iran Sans (farsi digits)', 'azin-file' ),
                'yekan-fa' =>  __( 'Iran Yekan (farsi digits)', 'azin-file' ),
            ),
            'default'  => 'sans',
        ),

        array(
            'id'       => 'change_dashboard_font',
            'type'     => 'switch',
            'title'    => __( 'Changing the dashboard font', 'azin-file' ),
            'default'  => true
        ),

        array(
            'id'       => 'custom_font',
            'type'     => 'switch',
            'title'    => __( 'Use custom fonts', 'azin-file' ),
            'subtitle' => __( 'With this option you can use your own custom fonts.', 'azin-file' ),
            'default'  => false
        ),

        //Custom Font Normal
        array(
            'id' => 'normal-font-section-start',
            'type' => 'section',
            'title'    => __( 'Normal weight upload', 'azin-file' ),
            'indent' => true,
            'required' => array( 'custom_font', '=', true ),
        ),
        array(
            'id'       => 'theme_font_woff2',
            'type'     => 'media', 
            'title'    => __( 'WOFF2 font', 'azin-file' ),
            'url'      => true,
            'readonly' => false,
            'library_filter' => array('woff2' ),
            'mode' => false,
            'preview'  => false,
            'default'  => '',
            'required' => array( 'custom_font', '=', true ),
        ),
        array(
            'id'       => 'theme_font_woff',
            'type'     => 'media', 
            'title'    => __( 'WOFF font', 'azin-file' ),
            'url'      => true,
            'readonly' => false,
            'library_filter' => array('woff' ),
            'mode' => false,
            'preview'  => false,
            'default'  => '',
            'required' => array( 'custom_font', '=', true ),
        ),
        array(
            'id'       => 'theme_font_ttf',
            'type'     => 'media', 
            'title'    => __( 'TTF font', 'azin-file' ),
            'url'      => true,
            'readonly' => false,
            'library_filter' => array('ttf' ),
            'mode' => false,
            'preview'  => false,
            'default'  => '',
            'required' => array( 'custom_font', '=', true ),
        ),
        array(
            'id'       => 'theme_font_eot',
            'type'     => 'media', 
            'title'    => __( 'EOT font', 'azin-file' ),
            'url'      => true,
            'readonly' => false,
            'library_filter' => array('eot' ),
            'mode' => false,
            'preview'  => false,
            'default'  => '',
            'required' => array( 'custom_font', '=', true ),
        ),
        array(
            'id'       => 'theme_font_svg',
            'type'     => 'media', 
            'title'    => __( 'SVG font', 'azin-file' ),
            'url'      => true,
            'readonly' => false,
            'library_filter' => array('svg' ),
            'mode' => false,
            'preview'  => false,
            'default'  => '',
            'required' => array( 'custom_font', '=', true ),
        ),
        array(
            'id'     => 'normal-font-section-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //Custom Font Bold
        array(
            'id' => 'bold-font-section-start',
            'type' => 'section',
            'title'    => __( 'Bold weight upload', 'azin-file' ),
            'indent' => true,
            'required' => array( 'custom_font', '=', true ),
        ),
        array(
            'id'       => 'custom_bold_font',
            'type'     => 'switch',
            'title'    => __( 'Bold weight upload', 'azin-file' ),
            'subtitle' => __( 'By activating this option, you can upload the bold font weight.', 'azin-file' ),
            'default'  => false
        ),
        array(
            'id'       => 'theme_font_bold_woff2',
            'type'     => 'media',
            'title'    => __( 'WOFF2 font', 'azin-file' ),
            'url'      => true,
            'readonly' => false,
            'library_filter' => array('woff2' ),
            'mode' => false,
            'preview'  => false,
            'default'  => '',
            'required' => array( 'custom_bold_font', '=', true ),
        ),
        array(
            'id'       => 'theme_font_bold_woff',
            'type'     => 'media', 
            'title'    => __( 'WOFF font', 'azin-file' ),
            'url'      => true,
            'readonly' => false,
            'library_filter' => array('woff' ),
            'mode' => false,
            'preview'  => false,
            'default'  => '',
            'required' => array( 'custom_bold_font', '=', true ),
        ),
        array(
            'id'       => 'theme_font_bold_ttf',
            'type'     => 'media', 
            'title'    => __( 'TTF font', 'azin-file' ),
            'url'      => true,
            'readonly' => false,
            'library_filter' => array('ttf' ),
            'mode' => false,
            'preview'  => false,
            'default'  => '',
            'required' => array( 'custom_bold_font', '=', true ),
        ),
        array(
            'id'       => 'theme_font_bold_eot',
            'type'     => 'media', 
            'title'    => __( 'EOT font', 'azin-file' ),
            'url'      => true,
            'readonly' => false,
            'library_filter' => array('eot' ),
            'mode' => false,
            'preview'  => false,
            'default'  => '',
            'required' => array( 'custom_bold_font', '=', true ),
        ),
        array(
            'id'       => 'theme_font_bold_svg',
            'type'     => 'media', 
            'title'    => __( 'SVG font', 'azin-file' ),
            'url'      => true,
            'readonly' => false,
            'library_filter' => array('svg' ),
            'mode' => false,
            'preview'  => false,
            'default'  => '',
            'required' => array( 'custom_bold_font', '=', true ),
        ),
        array(
            'id'     => 'bold-font-section-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //Custom Font Farsi Digits
        array(
            'id' => 'farsi-digits-section-start',
            'type' => 'section',
            'title'    => __( 'Farsi Digits Version upload', 'azin-file' ),
            'indent' => true,
            'required' => array( 'custom_font', '=', true ),
        ),
        array(
            'id'       => 'custom_farsi_font',
            'type'     => 'switch',
            'title'    => __( 'Farsi Digits Version upload', 'azin-file' ),
            'subtitle' => __( 'By activating this option, you can upload the farsi digits version, this version is used in some parts of the template to display Persian numbers.', 'azin-file' ),
            'default'  => false
        ),
        array(
            'id'       => 'theme_font_farsi_woff2',
            'type'     => 'media',
            'title'    => __( 'WOFF2 font', 'azin-file' ),
            'url'      => true,
            'readonly' => false,
            'library_filter' => array('woff2' ),
            'mode' => false,
            'preview'  => false,
            'default'  => '',
            'required' => array( 'custom_farsi_font', '=', true ),
        ),
        array(
            'id'       => 'theme_font_farsi_woff',
            'type'     => 'media', 
            'title'    => __( 'WOFF font', 'azin-file' ),
            'url'      => true,
            'readonly' => false,
            'library_filter' => array('woff' ),
            'mode' => false,
            'preview'  => false,
            'default'  => '',
            'required' => array( 'custom_farsi_font', '=', true ),
        ),
        array(
            'id'       => 'theme_font_farsi_ttf',
            'type'     => 'media', 
            'title'    => __( 'TTF font', 'azin-file' ),
            'url'      => true,
            'readonly' => false,
            'library_filter' => array('ttf' ),
            'mode' => false,
            'preview'  => false,
            'default'  => '',
            'required' => array( 'custom_farsi_font', '=', true ),
        ),
        array(
            'id'       => 'theme_font_farsi_eot',
            'type'     => 'media', 
            'title'    => __( 'EOT font', 'azin-file' ),
            'url'      => true,
            'readonly' => false,
            'library_filter' => array('eot' ),
            'mode' => false,
            'preview'  => false,
            'default'  => '',
            'required' => array( 'custom_farsi_font', '=', true ),
        ),
        array(
            'id'       => 'theme_font_farsi_svg',
            'type'     => 'media', 
            'title'    => __( 'SVG font', 'azin-file' ),
            'url'      => true,
            'readonly' => false,
            'library_filter' => array('svg' ),
            'mode' => false,
            'preview'  => false,
            'default'  => '',
            'required' => array( 'custom_farsi_font', '=', true ),
        ),
        array(
            'id'     => 'farsi-digits-section-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //Font size settings for heading tags
        array(
            'id'       => 'heading-tags-section-start',
            'type'     => 'section',
            'title'    => __( 'Font size settings for heading tags', 'azin-file' ),
            'subtitle' => __( 'In the content of products, pages and posts (in pixel)', 'azin-file' ),
            'indent'   => true,
        ),
        array(
            'id'            => 'h1_font_size',
            'type'          => 'slider',
            'title'         => __( 'H1 Tag font size', 'azin-file' ),
            'default'       => 28,
            'min'           => 12,
            'step'          => 1,
            'max'           => 50,
            'display_value' => 'label'
        ),
        array(
            'id'            => 'h2_font_size',
            'type'          => 'slider',
            'title'         => __( 'H2 Tag font size', 'azin-file' ),
            'default'       => 21,
            'min'           => 12,
            'step'          => 1,
            'max'           => 50,
            'display_value' => 'label'
        ),
        array(
            'id'            => 'h3_font_size',
            'type'          => 'slider',
            'title'         => __( 'H3 Tag font size', 'azin-file' ),
            'default'       => 17,
            'min'           => 12,
            'step'          => 1,
            'max'           => 50,
            'display_value' => 'label'
        ),
        array(
            'id'            => 'h4_font_size',
            'type'          => 'slider',
            'title'         => __( 'H4 Tag font size', 'azin-file' ),
            'default'       => 16,
            'min'           => 12,
            'step'          => 1,
            'max'           => 50,
            'display_value' => 'label'
        ),
        array(
            'id'            => 'h5_font_size',
            'type'          => 'slider',
            'title'         => __( 'H5 Tag font size', 'azin-file' ),
            'default'       => 14,
            'min'           => 12,
            'step'          => 1,
            'max'           => 50,
            'display_value' => 'label'
        ),
        array(
            'id'            => 'h6_font_size',
            'type'          => 'slider',
            'title'         => __( 'H6 Tag font size', 'azin-file' ),
            'default'       => 14,
            'min'           => 12,
            'step'          => 1,
            'max'           => 50,
            'display_value' => 'label'
        ),
        array(
            'id'     => 'heading-tags-section-end',
            'type'   => 'section',
            'indent' => false,
        ),

    )
) );

//Theme style
Redux::setSection( $opt_name, array(
    'title'            => __( 'Theme style', 'azin-file' ),
    'icon'             => 'fa fa-palette',
    'id'               => 'theme-style',
    'subsection'       => true,
    'customizer_width' => '500px',
    'desc'             => __( 'Coloring and personalizing theme style', 'azin-file' ),
    'fields'           => array(
        array(
            'id'       => 'full_width_style',
            'type'     => 'switch',
            'title'    => __( 'Full width mode', 'azin-file' ),
            'subtitle' => __( 'In full width mode, the content of the page is displayed in full width.', 'azin-file' ),
            'default'  => false
        ),

        array(
            'id'       => 'ch_scroll_style',
            'type'     => 'switch',
            'title'    => __( 'Change the scroll bar style', 'azin-file' ),
            'subtitle' => __( 'Changing the style of the scroll bar of the site', 'azin-file' ),
            'default'  => true,
        ),

        array(
            'id'       => 'ch_scroll_bar',
            'type'     => 'switch',
            'title'    => __( 'Change the scrollbar color', 'azin-file' ),
            'subtitle' => __( 'Changing the color of the scroll bar of the site according to the template color', 'azin-file' ),
            'default'  => false,
            'required' => array( 'ch_scroll_style', '=', true ),
        ),

        array(
            'id'       => 'custom_color',
            'type'     => 'color',
            'title'    => __( 'Theme coloring', 'azin-file' ),
            'subtitle' => __( 'Choose the overall color scheme of the theme, this color is displayed as the main theme of the site in most sections such as menus and widgets.', 'azin-file' ),
            'default'  => '#00bcd4',
            'validate' => 'color',
            'transparent' => false,
        ),

        array(
            'id'       => 'dis_mobile_color',
            'type'     => 'switch',
            'title'    => __( 'Disable mobile browser address bar color', 'azin-file' ),
            'default'  => false
        ),
        array(
            'id'       => 'ch_mobile_color',
            'type'     => 'switch',
            'title'    => __( 'Change mobile browser address bar color', 'azin-file' ),
            'subtitle' => __( 'By default the color of this bar is received from the default color of the theme', 'azin-file' ),
            'default'  => false,
            'required' => array( 'dis_mobile_color', '!=', true ),
        ),
        array(
            'id'       => 'mobile_bar_color',
            'type'     => 'color',
            'title'    => __( 'Mobile browser address bar color', 'azin-file' ),
            'default'  => '#17A2B8',
            'validate' => 'color',
            'transparent' => false,
            'required' => array( 'ch_mobile_color', '=', true ),
        ),

        array(
            'id'       => 'sale_count_style',
            'type'     => 'select',
            'title'    => __( 'Discount countdown style', 'azin-file' ),
            'options'  => array(
                'sale-count-black'    =>  __( 'Black', 'azin-file' ),
                'sale-count-white'    =>  __( 'White', 'azin-file' ),
                'sale-count-outline'  =>  __( 'Outline', 'azin-file' ),
            ),
            'default'  => 'sale-count-black',
        ),

        //Site Background Color
        array(
            'id'     => 'bg-section-start',
            'type'   => 'section',
            'title'    => __( 'Site background', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'site_bg',
            'type'     => 'image_select',
            'output'    => array( 'body' ),
            'tiles'    => true,
            'title'    => __( 'Background', 'azin-file' ),
            'subtitle' => __( 'Select an image as the background.', 'azin-file' ),
            'options'  => $sample_patterns,
            'required' => array( 'bg_switch', '!=', true ),
        ),
        array(
            'id'       => 'bg_switch',
            'type'     => 'switch',
            'title'    => __( 'Custom background', 'azin-file' ),
            'subtitle' => __( 'Choose a background color or upload a custom photo', 'azin-file' ),
            'default'  => false
        ),
        array(         
            'id'       => 'site_bg_custom',
            'output'    => array( 'body' ), // An array of CSS selectors
            'type'     => 'background',
            'title'    => __( 'Personalize the background of the site according to your taste.', 'azin-file' ),
            'default'  => array(
                'background-color' => '#F2F6FC',
            ),
            'required' => array( 'bg_switch', '=', true ),
        ),
        array(
            'id'     => 'bg-section-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //Header Style
        array(
            'id' => 'hstyle-section-start',
            'type' => 'section',
            'title'    => __( 'Header coloring', 'azin-file' ),
            'subtitle' => __( 'Personalize the color scheme of different header areas.', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'head_color',
            'type'     => 'color',
            'title'    => __( 'Header background color', 'azin-file' ),
            'default'  => '#ffffff',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'head_text_color',
            'type'     => 'color',
            'title'    => __( 'The color of the header texts', 'azin-file' ),
            'default'  => '#212529',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'head_link_color',
            'type'     => 'color',
            'title'    => __( 'The color of the header links', 'azin-file' ),
            'default'  => '#212529',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'head_lhover_color',
            'type'     => 'color',
            'title'    => __( 'The color of the header links on mouse hover', 'azin-file' ),
            'default'  => '#000000',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'menu_color',
            'type'     => 'color',
            'title'    => __( 'Main menu background color', 'azin-file' ),
            'default'  => '#F4F5F9',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'menu_text_color',
            'type'     => 'color',
            'title'    => __( 'Main menu text colors', 'azin-file' ),
            'default'  => '#4D4D4D',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'     => 'hstyle-section-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //Footer Style
        array(
            'id'     => 'fbg-section-start',
            'type'   => 'section',
            'title'    => __( 'Footer background settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'footer_bg',
            'type'     => 'image_select',
            //'output'    => array( 'footer.sfooter' ), // An array of CSS selectors
            'tiles'    => true,
            'title'    => __( 'Footer background of the site', 'azin-file' ),
            'subtitle' => __( 'Select the image as the footer of the site.', 'azin-file' ),
            'options'  => $footer_patterns,
            //'default'  => 3,
            'required' => array( 'fbg_switch', '!=', true ),
        ),
        array(
            'id'       => 'fbg_switch',
            'type'     => 'switch',
            'title'    => __( 'Custom footer background', 'azin-file' ),
            'subtitle' => __( 'Choose the background color or upload a custom photo for the site footer', 'azin-file' ),
            'default'  => false
        ),
        array(         
            'id'       => 'site_fbg_custom',
            'output'    => array( 'footer.sfooter' ),
            'type'     => 'background',
            'title'    => __( 'Personalize the footer of the site according to your taste.', 'azin-file' ),
            'default'  => array(
                'background-color' => '#2d2d2d',
            ),
            'required' => array( 'fbg_switch', '=', true ),
        ),
        array(
            'id'       => 'footer_text_color',
            'type'     => 'color',
            'title'    => __( 'Footer site text color', 'azin-file' ),
            'default'  => '#ffffff',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'     => 'fbg-section-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //login btn color
        array(
            'id' => 'login-btn-section-start',
            'type' => 'section',
            'title'    => __( 'Login button in header', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'login_btn_color',
            'type'     => 'color',
            'title'    => __( 'Login button color', 'azin-file' ),
            'default'  => '#ffffff',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'login_btn_text_color',
            'type'     => 'color',
            'title'    => __( 'Login button text color', 'azin-file' ),
            'default'  => '#007BFF',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'login_btn_hover_color',
            'type'     => 'color',
            'title'    => __( 'Login button hover and click color', 'azin-file' ),
            'default'  => '#007BFF',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'login_btn_hover_text_color',
            'type'     => 'color',
            'title'    => __( 'Login button hover and click text color', 'azin-file' ),
            'default'  => '#ffffff',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'     => 'login-btn-section-end',
            'type'   => 'section',
            'indent' => false,
       ),

       //register btn color
        array(
            'id' => 'register-btn-section-start',
            'type' => 'section',
            'title'    => __( 'Register button in header', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'register_btn_color',
            'type'     => 'color',
            'title'    => __( 'Register button color', 'azin-file' ),
            'default'  => '#007BFF',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'register_btn_text_color',
            'type'     => 'color',
            'title'    => __( 'Register button text color', 'azin-file' ),
            'default'  => '#ffffff',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'register_btn_hover_color',
            'type'     => 'color',
            'title'    => __( 'Register button hover and click color', 'azin-file' ),
            'default'  => '#0062cc',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'register_btn_hover_text_color',
            'type'     => 'color',
            'title'    => __( 'Register button hover and click text color', 'azin-file' ),
            'default'  => '#ffffff',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'     => 'register-btn-section-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //Add btn section start
        array(
            'id'    => 'add-btn-section-start',
            'type'  => 'section',
            'title'    => __( 'Add to cart button in product page', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'add_btn_color',
            'type'     => 'color',
            'title'    => __( 'Add to cart button color', 'azin-file' ),
            'default'  => '#4caf50',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'add_btn_text_color',
            'type'     => 'color',
            'title'    => __( 'Add to cart button text color', 'azin-file' ),
            'default'  => '#ffffff',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'     => 'add-btn-section-end',
            'type'   => 'section',
            'indent' => false,
       ),
    )
) );

//How to display the home screen
Redux::setSection( $opt_name, array(
    'title'      => __( 'How to display the home screen', 'azin-file' ),
    'icon'       => 'fa fa-th',
    'id'         => 'home_blocks_prod',
    'subsection' => true,
    'desc'       => __( 'Content blocks of the home page ( if the elementor does not manage the main page of the template)', 'azin-file' ),
    'fields'     => array(
        array(
            'id'       => 'main_bcol_count',
            'type'     => 'text',
            'title'    => __( 'Number of products and posts columns in blocks', 'azin-file' ),
            'default'  => 4,
        ),
        array(
            'id'       => 'main_type_post',
            'type'     => 'switch',
            'title'    => __( 'View regular posts', 'azin-file' ),
            'subtitle' => __( 'Display regular posts instead of products on the home screen', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_blocks', '!=', true ),
        ),
        array(
            'id'       => 'show_prod_block',
            'type'     => 'switch',
            'title'    => __( 'New products', 'azin-file' ),
            'subtitle' => __( 'Display new product blocks on the home screen', 'azin-file' ),
            'default'  => false,
            'required' => array( 'main_type_post', '=', true ),
        ),
        array(
            'id'       => 'prod_block_title',
            'type'     => 'text',
            'title'    => __( 'Block title', 'azin-file' ),
            'default'  => __( 'Latest Products', 'azin-file' ),
            'required' => array( 'show_prod_block', '=', true ),
        ),
        array(
            'id'       => 'prod_block_play',
            'type'     => 'switch',
            'title'    => __( 'Automatic movement', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_prod_block', '=', true ),
        ),
        array(
            'id'       => 'prod_block_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-shopping-bag',
            'options'  => $alliconArray,
            'required' => array( 'show_prod_block', '=', true ),
        ),
        array(
            'id'       => 'show_blocks',
            'type'     => 'switch',
            'title'    => __( 'View in blocks', 'azin-file' ),
            'subtitle' => __( 'By default, the latest products are displayed in pagination', 'azin-file' ),
            'default'  => false
        ),
        array(
            'id'       => 'show_recent_prod',
            'type'     => 'switch',
            'title'    => __( 'New products', 'azin-file' ),
            'subtitle' => __( 'Show new product blocks', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_blocks', '=', true ),
        ),
        array(
            'id'       => 'recent_prod_title',
            'type'     => 'text',
            'title'    => __( 'Block title', 'azin-file' ),
            'default'  => __( 'New products', 'azin-file' ),
            'required' => array( 'show_recent_prod', '=', true ),
        ),
        array(
            'id'       => 'recent_prod_play',
            'type'     => 'switch',
            'title'    => __( 'Automatic movement', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_recent_prod', '=', true ),
        ),
        array(
            'id'       => 'recent_prod_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-shopping-bag',
            'options'  => $alliconArray,
            'required' => array( 'show_recent_prod', '=', true ),
        ),
        array(
            'id'       => 'show_block_one',
            'type'     => 'switch',
            'title'    => __( 'Show the first block', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_blocks', '=', true ),
        ),
        array(
            'id'       => 'block_one_title',
            'type'     => 'text',
            'title'    => __( 'Title of the first block', 'azin-file' ),
            'default'  => __( 'First block', 'azin-file' ),
            'required' => array( 'show_block_one', '=', true ),
        ),
        array(
            'id'       => 'block_one_play',
            'type'     => 'switch',
            'title'    => __( 'Automatic movement', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_block_one', '=', true ),
        ),
        array(
            'id'       => 'block_one_cat',
            'type'     => 'select',
            'data'     => 'terms',
            'args' => array( 'taxonomies'=>$product_taxonomy, 'args'=>array() ),
            'multi'    => false,
            'title'    => __( 'First block category', 'azin-file' ),
            'required' => array( 'show_block_one', '=', true ),
       ),
       array(
            'id'       => 'block_one_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'First block icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-bell',
            'options'  => $alliconArray,
            'required' => array( 'show_block_one', '=', true ),
        ),
        array(
            'id'       => 'show_block_two',
            'type'     => 'switch',
            'title'    => __( 'Show the second block', 'azin-file' ),
            'required' => array( 'show_blocks', '=', true ),
            'default'  => false
        ),
        array(
            'id'       => 'block_two_title',
            'type'     => 'text',
            'title'    => __( 'Title of the second block', 'azin-file' ),
            'default'  => __( 'First block', 'azin-file' ),
            'required' => array( 'show_block_two', '=', true ),
        ),
        array(
            'id'       => 'block_two_play',
            'type'     => 'switch',
            'title'    => __( 'Automatic movement', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_block_two', '=', true ),
        ),
        array(
            'id'       => 'block_two_cat',
            'type'     => 'select',
            'data'     => 'terms',
            'args' => array( 'taxonomies'=>$product_taxonomy, 'args'=>array() ),
            'multi'    => false,
            'title'    => __( 'Second block category', 'azin-file' ),
            'required' => array( 'show_block_two', '=', true ),
       ),
       array(
            'id'       => 'block_two_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Second block icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-bell',
            'options'  => $alliconArray,
            'required' => array( 'show_block_two', '=', true ),
        ),
         array(
            'id'       => 'show_block_three',
            'type'     => 'switch',
            'title'    => __( 'Show the third block', 'azin-file' ),
            'required' => array( 'show_blocks', '=', true ),
            'default'  => false
        ),
        array(
            'id'       => 'block_three_title',
            'type'     => 'text',
            'title'    => __( 'Title of the third block', 'azin-file' ),
            'default'  => __( 'Third block', 'azin-file' ),
            'required' => array( 'show_block_three', '=', true ),
        ),
        array(
            'id'       => 'block_three_play',
            'type'     => 'switch',
            'title'    => __( 'Automatic movement', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_block_three', '=', true ),
        ),
        array(
            'id'       => 'block_three_cat',
            'type'     => 'select',
            'data'     => 'terms',
            'args' => array( 'taxonomies'=>$product_taxonomy, 'args'=>array() ),
            'multi'    => false,
            'title'    => __( 'Third block category', 'azin-file' ),
            'required' => array( 'show_block_three', '=', true ),
       ),
       array(
            'id'       => 'block_three_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Third block icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-bell',
            'options'  => $alliconArray,
            'required' => array( 'show_block_three', '=', true ),
        ),
        array(
            'id'       => 'show_block_four',
            'type'     => 'switch',
            'title'    => __( 'Show the fourth block', 'azin-file' ),
            'required' => array( 'show_blocks', '=', true ),
            'default'  => false
        ),
        array(
            'id'       => 'block_four_title',
            'type'     => 'text',
            'title'    => __( 'Title of the fourth block', 'azin-file' ),
            'default'  => __( 'Fourth block', 'azin-file' ),
            'required' => array( 'show_block_four', '=', true ),
        ),
        array(
            'id'       => 'block_four_play',
            'type'     => 'switch',
            'title'    => __( 'Automatic movement', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_block_four', '=', true ),
        ),
        array(
            'id'       => 'block_four_cat',
            'type'     => 'select',
            'data'     => 'terms',
            'args' => array( 'taxonomies'=>$product_taxonomy, 'args'=>array() ),
            'multi'    => false,
            'title'    => __( 'Fourth block category', 'azin-file' ),
            'required' => array( 'show_block_four', '=', true ),
       ),
       array(
            'id'       => 'block_four_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Fourth block icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-bell',
            'options'  => $alliconArray,
            'required' => array( 'show_block_four', '=', true ),
        ),
         array(
            'id'       => 'show_block_five',
            'type'     => 'switch',
            'title'    => __( 'Show the fifth block', 'azin-file' ),
            'required' => array( 'show_blocks', '=', true ),
            'default'  => false
        ),
        array(
            'id'       => 'block_five_title',
            'type'     => 'text',
            'title'    => __( 'Title of the fifth block', 'azin-file' ),
            'default'  => __( 'Fifth block', 'azin-file' ),
            'required' => array( 'show_block_five', '=', true ),
        ),
        array(
            'id'       => 'block_five_play',
            'type'     => 'switch',
            'title'    => __( 'Automatic movement', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_block_five', '=', true ),
        ),
        array(
            'id'       => 'block_five_cat',
            'type'     => 'select',
            'data'     => 'terms',
            'args' => array( 'taxonomies'=>$product_taxonomy, 'args'=>array() ),
            'multi'    => false,
            'title'    => __( 'Fifth block category', 'azin-file' ),
            'required' => array( 'show_block_five', '=', true ),
       ),
       array(
            'id'       => 'block_five_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Fifth block icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-bell',
            'options'  => $alliconArray,
            'required' => array( 'show_block_five', '=', true ),
        ),
       array(
            'id'       => 'show_pblock_one',
            'type'     => 'switch',
            'title'    => __( 'Show the first post block', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_blocks', '=', true ),
        ),
        array(
            'id'       => 'pblock_one_title',
            'type'     => 'text',
            'title'    => __( 'The title of the first post block', 'azin-file' ),
            'default'  => __( 'First post block', 'azin-file' ),
            'required' => array( 'show_pblock_one', '=', true ),
        ),
        array(
            'id'       => 'pblock_one_play',
            'type'     => 'switch',
            'title'    => __( 'Automatic movement', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_pblock_one', '=', true ),
        ),
        array(
            'id'       => 'pblock_one_cat',
            'type'     => 'select',
            'data'     => 'categories',
            'multi'    => false,
            'title'    => __( 'First post block category', 'azin-file' ),
            'required' => array( 'show_pblock_one', '=', true ),
       ),
       array(
            'id'       => 'pblock_one_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'First post block icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-bell',
            'options'  => $alliconArray,
            'required' => array( 'show_pblock_one', '=', true ),
        ),
        array(
            'id'       => 'show_pblock_two',
            'type'     => 'switch',
            'title'    => __( 'Show the Second post block', 'azin-file' ),
            'required' => array( 'show_blocks', '=', true ),
            'default'  => false
        ),
        array(
            'id'       => 'pblock_two_title',
            'type'     => 'text',
            'title'    => __( 'The title of the Second post block', 'azin-file' ),
            'default'  => __( 'Second post block', 'azin-file' ),
            'required' => array( 'show_pblock_two', '=', true ),
        ),
        array(
            'id'       => 'pblock_two_play',
            'type'     => 'switch',
            'title'    => __( 'Automatic movement', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_pblock_two', '=', true ),
        ),
        array(
            'id'       => 'pblock_two_cat',
            'type'     => 'select',
            'data'     => 'categories',
            'multi'    => false,
            'title'    => __( 'Second post block category', 'azin-file' ),
            'required' => array( 'show_pblock_two', '=', true ),
       ),
       array(
            'id'       => 'pblock_two_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Second post block icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-bell',
            'options'  => $alliconArray,
            'required' => array( 'show_pblock_two', '=', true ),
        ),
         array(
            'id'       => 'show_pblock_three',
            'type'     => 'switch',
            'title'    => __( 'Show the Third post block', 'azin-file' ),
            'required' => array( 'show_blocks', '=', true ),
            'default'  => false
        ),
        array(
            'id'       => 'pblock_three_title',
            'type'     => 'text',
            'title'    => __( 'The title of the Third post block', 'azin-file' ),
            'default'  => __( 'Third post block', 'azin-file' ),
            'required' => array( 'show_pblock_three', '=', true ),
        ),
        array(
            'id'       => 'pblock_three_play',
            'type'     => 'switch',
            'title'    => __( 'Automatic movement', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_pblock_three', '=', true ),
        ),
        array(
            'id'       => 'pblock_three_cat',
            'type'     => 'select',
            'data'     => 'categories',
            'multi'    => false,
            'title'    => __( 'Third post block category', 'azin-file' ),
            'required' => array( 'show_pblock_three', '=', true ),
        ),
        array(
            'id'       => 'pblock_three_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Third post block icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-bell',
            'options'  => $alliconArray,
            'required' => array( 'show_pblock_three', '=', true ),
        ),
        array(
            'id'       => 'show_pblock_four',
            'type'     => 'switch',
            'title'    => __( 'Show the Fourth post block', 'azin-file' ),
            'required' => array( 'show_blocks', '=', true ),
            'default'  => false
        ),
        array(
            'id'       => 'pblock_four_title',
            'type'     => 'text',
            'title'    => __( 'The title of the Fourth post block', 'azin-file' ),
            'default'  => __( 'Fourth post block', 'azin-file' ),
            'required' => array( 'show_pblock_four', '=', true ),
        ),
        array(
            'id'       => 'pblock_four_play',
            'type'     => 'switch',
            'title'    => __( 'Automatic movement', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_pblock_four', '=', true ),
        ),
        array(
            'id'       => 'pblock_four_cat',
            'type'     => 'select',
            'data'     => 'categories',
            'multi'    => false,
            'title'    => __( 'Fourth post block category', 'azin-file' ),
            'required' => array( 'show_pblock_four', '=', true ),
       ),
       array(
            'id'       => 'pblock_four_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Fourth post block icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-bell',
            'options'  => $alliconArray,
            'required' => array( 'show_pblock_four', '=', true ),
        ),
         array(
            'id'       => 'show_pblock_five',
            'type'     => 'switch',
            'title'    => __( 'Show the Fifth post block', 'azin-file' ),
            'required' => array( 'show_blocks', '=', true ),
            'default'  => false
        ),
        array(
            'id'       => 'pblock_five_title',
            'type'     => 'text',
            'title'    => __( 'The title of the Fifth post block', 'azin-file' ),
            'default'  => __( 'Fifth post block', 'azin-file' ),
            'required' => array( 'show_pblock_five', '=', true ),
        ),
        array(
            'id'       => 'pblock_five_play',
            'type'     => 'switch',
            'title'    => __( 'Automatic movement', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_pblock_five', '=', true ),
        ),
        array(
            'id'       => 'pblock_five_cat',
            'type'     => 'select',
            'data'     => 'categories',
            'multi'    => false,
            'title'    => __( 'Fifth post block category', 'azin-file' ),
            'required' => array( 'show_pblock_five', '=', true ),
        ),
        array(
            'id'       => 'pblock_five_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Fifth post block icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-bell',
            'options'  => $alliconArray,
            'required' => array( 'show_pblock_five', '=', true ),
        ),
        
    ) 
) );

//Ad settings
Redux::setSection( $opt_name, array(
    'title'      => __( 'Ad settings', 'azin-file' ),
    'icon'       => 'fa fa-bullhorn',
    'id'         => 'home_ads',
    'subsection' => true,
    'desc'       => __( 'Ad management ( if the main page is not managed by the Elementor except for header ads)', 'azin-file' ),
    'fields'     => array(

        //Home Header Banner
        array(
            'id'     => 'head-banner-start',
            'type'   => 'section',
            'title'    => __( 'Ad header settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_head_banner',
            'type'     => 'switch',
            'title'    => __( 'Display header ads', 'azin-file' ),
            'default'  => false
        ),
        array(
            'id'       => 'show_head_down',
            'type'     => 'switch',
            'title'    => __( 'Display header ads in products and posts', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_head_banner', '=', true ),
        ),
        array(
            'id'       => 'show_head_mobile',
            'type'     => 'switch',
            'title'    => __( 'Display header ads on mobile', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_head_banner', '=', true ),
        ),
        array(
            'id'       => 'head_banner_replace',
            'type'     => 'switch',
            'title'    => __( 'Insert code or shortcode instead of image', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_head_banner', '=', true )
        ),
        array(
            'id'       => 'head_banner_code',
            'type'     => 'ace_editor',
            'title'    => __( 'Banner code', 'azin-file' ),
            'mode'     => 'plain_text',
            'theme'    => 'chrome',
            'required' => array(
                array( 'show_head_banner', '=', true ),
                array( 'head_banner_replace', '=', true )
            )
        ),
        array(
            'id'       => 'head_banner',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Header ads', 'azin-file' ),
            'compiler' => 'true',
            'desc'     => __( 'Ad displayed in header', 'azin-file' ),
            'subtitle' => __( 'Suitable size: 1188 pixels (width) and 134 pixels (height)', 'azin-file' ),
            'default'  => array( 'url' => get_template_directory_uri()."/images/hbanner.png" ),
            'required' => array(
                array( 'show_head_banner', '=', true ),
                array( 'head_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'head_banner_link',
            'type'     => 'text',
            'title'    => __( 'Banner link', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_head_banner', '=', true ),
                array( 'head_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'head_banner_title',
            'type'     => 'text',
            'title'    => __( 'Title', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_head_banner', '=', true ),
                array( 'head_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'head_banner_newtab',
            'type'     => 'switch',
            'title'    => __( 'Open the link in a new tab', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_head_banner', '=', true ),
                array( 'head_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'head_banner_nofollow',
            'type'     => 'switch',
            'title'    => __( 'Add nofollow property to link', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_head_banner', '=', true ),
                array( 'head_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'head_banner_hover_effect',
            'type'     => 'select',
            'title'    => __( 'Image hover effect', 'azin-file' ),
            'options'  => array(
                'none'  => __( 'None', 'azin-file' ),
                'azin-brightness'  => __( 'Brightness', 'azin-file' ),
                'azin-zoomin' => __( 'Zoom', 'azin-file' ),
                'azin-rotate' => __( 'Rotate', 'azin-file' ),
                'azin-blur' => __( 'Blur', 'azin-file' ),
                'azin-gray' => __( 'Black & White', 'azin-file' ),
                'azin-opacity' => __( 'Opacity', 'azin-file' ),
                'azin-flash' => __( 'Flashing', 'azin-file' ),
                'azin-shine' => __( 'Shine', 'azin-file' ),
                'azin-circle' => __( 'Circle', 'azin-file' )
            ),
            'default'  => 'azin-brightness',
            'required' => array(
                array( 'show_head_banner', '=', true ),
                array( 'head_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'head_banner_hover_title',
            'type'     => 'switch',
            'title'    => __( 'Display the image title on mouse hover', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_head_banner', '=', true ),
                array( 'head_banner_replace', '!=', true )
            )
        ),
        array(
            'id'     => 'head-banner-section-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //Home Footer Banner
        array(
            'id'     => 'foot-banner-start',
            'type'   => 'section',
            'title'    => __( 'Footer ad settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_foot_banner',
            'type'     => 'switch',
            'title'    => __( 'Show footer ad', 'azin-file' ),
            'default'  => false
        ),
        array(
            'id'       => 'foot_banner_replace',
            'type'     => 'switch',
            'title'    => __( 'Insert code or shortcode instead of image', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_foot_banner', '=', true )
        ),
        array(
            'id'       => 'foot_banner_code',
            'type'     => 'ace_editor',
            'title'    => __( 'Banner code', 'azin-file' ),
            'mode'     => 'plain_text',
            'theme'    => 'chrome',
            'required' => array(
                array( 'show_foot_banner', '=', true ),
                array( 'foot_banner_replace', '=', true )
            )
        ),
        array(
            'id'       => 'foot_banner',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Footer ads', 'azin-file' ),
            'compiler' => 'true',
            'desc'     => __( 'Ad displayed in footer', 'azin-file' ),
            'subtitle' => __( 'Suitable size: 840 pixels (width) and 150 pixels (height)', 'azin-file' ),
            'default'  => array( 'url' => get_template_directory_uri()."/images/fbanner.png" ),
            'required' => array(
                array( 'show_foot_banner', '=', true ),
                array( 'foot_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'foot_banner_link',
            'type'     => 'text',
            'title'    => __( 'Banner link', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_foot_banner', '=', true ),
                array( 'foot_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'foot_banner_title',
            'type'     => 'text',
            'title'    => __( 'Title', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_foot_banner', '=', true ),
                array( 'foot_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'foot_banner_newtab',
            'type'     => 'switch',
            'title'    => __( 'Open the link in a new tab', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_foot_banner', '=', true ),
                array( 'foot_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'foot_banner_nofollow',
            'type'     => 'switch',
            'title'    => __( 'Add nofollow property to link', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_foot_banner', '=', true ),
                array( 'foot_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'foot_banner_hover_effect',
            'type'     => 'select',
            'title'    => __( 'Image hover effect', 'azin-file' ),
            'options'  => array(
                'none'  => __( 'None', 'azin-file' ),
                'azin-brightness'  => __( 'Brightness', 'azin-file' ),
                'azin-zoomin' => __( 'Zoom', 'azin-file' ),
                'azin-rotate' => __( 'Rotate', 'azin-file' ),
                'azin-blur' => __( 'Blur', 'azin-file' ),
                'azin-gray' => __( 'Black & White', 'azin-file' ),
                'azin-opacity' => __( 'Opacity', 'azin-file' ),
                'azin-flash' => __( 'Flashing', 'azin-file' ),
                'azin-shine' => __( 'Shine', 'azin-file' ),
                'azin-circle' => __( 'Circle', 'azin-file' )
            ),
            'default'  => 'azin-brightness',
            'required' => array(
                array( 'show_foot_banner', '=', true ),
                array( 'foot_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'foot_banner_hover_title',
            'type'     => 'switch',
            'title'    => __( 'Display the image title on mouse hover', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_foot_banner', '=', true ),
                array( 'foot_banner_replace', '!=', true )
            )
        ),
        array(
            'id'     => 'foot-banner-section-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //Ads banner #1
        array(
            'id'     => 'ads-banner1-section-start',
            'type'   => 'section',
            'title'    => __( 'Ads settings on top of home products', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_ads_banner1',
            'type'     => 'switch',
            'title'    => __( 'Show top ads on home page products', 'azin-file' ),
            'default'  => false
        ),
        array(
            'id'       => 'show_ads_banner1_down',
            'type'     => 'switch',
            'title'    => __( 'Show on product page', 'azin-file' ),
            'subtitle'     => __( 'Displayed on the product page below the product', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_ads_banner1', '=', true ),
        ),
        array(
            'id'       => 'show_ads_banner1_post',
            'type'     => 'switch',
            'title'    => __( 'Show on post page', 'azin-file' ),
            'subtitle'     => __( 'Displayed on the post page below the post', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_ads_banner1', '=', true ),
        ),
        array(
            'id'       => 'ads_banner1_replace',
            'type'     => 'switch',
            'title'    => __( 'Insert code or shortcode instead of images', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_ads_banner1', '=', true )
        ),
        array(
            'id'       => 'banner1_one_code',
            'type'     => 'ace_editor',
            'title'    => __( 'The first banner code', 'azin-file' ),
            'mode'     => 'plain_text',
            'theme'    => 'chrome',
            'required' => array(
                array( 'show_ads_banner1', '=', true ),
                array( 'ads_banner1_replace', '=', true )
            )
        ),
        array(
            'id'       => 'banner1_two_code',
            'type'     => 'ace_editor',
            'title'    => __( 'The second banner code', 'azin-file' ),
            'mode'     => 'plain_text',
            'theme'    => 'chrome',
            'required' => array(
                array( 'show_ads_banner1', '=', true ),
                array( 'ads_banner1_replace', '=', true )
            )
        ),
        array(
            'id'       => 'banner1_three_code',
            'type'     => 'ace_editor',
            'title'    => __( 'The third banner code', 'azin-file' ),
            'mode'     => 'plain_text',
            'theme'    => 'chrome',
            'required' => array(
                array( 'show_ads_banner1', '=', true ),
                array( 'ads_banner1_replace', '=', true )
            )
        ),
        array(
            'id'       => 'banner1_hover_effect',
            'type'     => 'select',
            'title'    => __( 'Images hover effect', 'azin-file' ),
            'options'  => array(
                'none'  => __( 'None', 'azin-file' ),
                'azin-brightness'  => __( 'Brightness', 'azin-file' ),
                'azin-zoomin' => __( 'Zoom', 'azin-file' ),
                'azin-rotate' => __( 'Rotate', 'azin-file' ),
                'azin-blur' => __( 'Blur', 'azin-file' ),
                'azin-gray' => __( 'Black & White', 'azin-file' ),
                'azin-opacity' => __( 'Opacity', 'azin-file' ),
                'azin-flash' => __( 'Flashing', 'azin-file' ),
                'azin-shine' => __( 'Shine', 'azin-file' ),
                'azin-circle' => __( 'Circle', 'azin-file' )
            ),
            'default'  => 'azin-brightness',
            'required' => array(
                array( 'show_ads_banner1', '=', true ),
                array( 'ads_banner1_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner1_hover_title',
            'type'     => 'switch',
            'title'    => __( 'Display the images title on mouse hover', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_ads_banner1', '=', true ),
                array( 'ads_banner1_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner1_one',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'First ad', 'azin-file' ),
            'compiler' => 'true',
            'desc'     => __( 'The first ad displayed above the products', 'azin-file' ),
            'subtitle' => __( 'Suitable size: 472 pixels (width) and 170 pixels (height)', 'azin-file' ),
            'default'  => array( 'url' => get_template_directory_uri()."/images/ads.png" ),
            'required' => array(
                array( 'show_ads_banner1', '=', true ),
                array( 'ads_banner1_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner1_one_link',
            'type'     => 'text',
            'title'    => __( 'Banner link', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_ads_banner1', '=', true ),
                array( 'ads_banner1_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner1_one_title',
            'type'     => 'text',
            'title'    => __( 'Title', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_ads_banner1', '=', true ),
                array( 'ads_banner1_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner1_one_newtab',
            'type'     => 'switch',
            'title'    => __( 'Open the link in a new tab', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_ads_banner1', '=', true ),
                array( 'ads_banner1_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner1_one_nofollow',
            'type'     => 'switch',
            'title'    => __( 'Add nofollow property to link', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_ads_banner1', '=', true ),
                array( 'ads_banner1_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner1_two',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Second ad', 'azin-file' ),
            'compiler' => 'true',
            'desc'     => __( 'Second ad displayed above the products', 'azin-file' ),
            'subtitle' => __( 'Suitable size: 472 pixels (width) and 170 pixels (height)', 'azin-file' ),
            'default'  => array( 'url' => get_template_directory_uri()."/images/ads.png" ),
            'required' => array(
                array( 'show_ads_banner1', '=', true ),
                array( 'ads_banner1_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner1_two_link',
            'type'     => 'text',
            'title'    => __( 'Banner link', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_ads_banner1', '=', true ),
                array( 'ads_banner1_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner1_two_title',
            'type'     => 'text',
            'title'    => __( 'Title', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_ads_banner1', '=', true ),
                array( 'ads_banner1_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner1_two_newtab',
            'type'     => 'switch',
            'title'    => __( 'Open the link in a new tab', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_ads_banner1', '=', true ),
                array( 'ads_banner1_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner1_two_nofollow',
            'type'     => 'switch',
            'title'    => __( 'Add nofollow property to link', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_ads_banner1', '=', true ),
                array( 'ads_banner1_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner1_three',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Third ad', 'azin-file' ),
            'compiler' => 'true',
            'desc'     => __( 'Third ad displayed above the products', 'azin-file' ),
            'subtitle' => __( 'Suitable size: 472 pixels (width) and 170 pixels (height)', 'azin-file' ),
            'default'  => array( 'url' => get_template_directory_uri()."/images/ads.png" ),
            'required' => array(
                array( 'show_ads_banner1', '=', true ),
                array( 'ads_banner1_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner1_three_link',
            'type'     => 'text',
            'title'    => __( 'Banner link', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_ads_banner1', '=', true ),
                array( 'ads_banner1_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner1_three_title',
            'type'     => 'text',
            'title'    => __( 'Title', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_ads_banner1', '=', true ),
                array( 'ads_banner1_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner1_three_newtab',
            'type'     => 'switch',
            'title'    => __( 'Open the link in a new tab', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_ads_banner1', '=', true ),
                array( 'ads_banner1_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner1_three_nofollow',
            'type'     => 'switch',
            'title'    => __( 'Add nofollow property to link', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_ads_banner1', '=', true ),
                array( 'ads_banner1_replace', '!=', true )
            )
        ),
        array(
            'id'     => 'ads-banner1-section-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //Ads banner #2
        array(
            'id'     => 'ads-banner2-section-start',
            'type'   => 'section',
            'title'    => __( 'Ads settings on below of home products', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_ads_banner2',
            'type'     => 'switch',
            'title'    => __( 'Display ads at the bottom of the home page products', 'azin-file' ),
            'subtitle'     => __( 'Displayed on the home page below the products', 'azin-file' ),
            'default'  => false
        ),
        array(
            'id'       => 'show_ads_banner2_down',
            'type'     => 'switch',
            'title'    => __( 'Show on product page', 'azin-file' ),
            'subtitle'     => __( 'Displayed on the product page below the product', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_ads_banner2', '=', true ),
        ),
        array(
            'id'       => 'show_ads_banner2_post',
            'type'     => 'switch',
            'title'    => __( 'Show on post page', 'azin-file' ),
            'subtitle'     => __( 'Displayed on the post page below the post', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_ads_banner2', '=', true ),
        ),
        array(
            'id'       => 'ads_banner2_replace',
            'type'     => 'switch',
            'title'    => __( 'Insert code or shortcode instead of images', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_ads_banner2', '=', true )
        ),
        array(
            'id'       => 'banner2_one_code',
            'type'     => 'ace_editor',
            'title'    => __( 'The first banner code', 'azin-file' ),
            'mode'     => 'plain_text',
            'theme'    => 'chrome',
            'required' => array(
                array( 'show_ads_banner2', '=', true ),
                array( 'ads_banner2_replace', '=', true )
            )
        ),
        array(
            'id'       => 'banner2_two_code',
            'type'     => 'ace_editor',
            'title'    => __( 'The second banner code', 'azin-file' ),
            'mode'     => 'plain_text',
            'theme'    => 'chrome',
            'required' => array(
                array( 'show_ads_banner2', '=', true ),
                array( 'ads_banner2_replace', '=', true )
            )
        ),
        array(
            'id'       => 'banner2_three_code',
            'type'     => 'ace_editor',
            'title'    => __( 'The third banner code', 'azin-file' ),
            'mode'     => 'plain_text',
            'theme'    => 'chrome',
            'required' => array(
                array( 'show_ads_banner2', '=', true ),
                array( 'ads_banner2_replace', '=', true )
            )
        ),
        array(
            'id'       => 'banner2_hover_effect',
            'type'     => 'select',
            'title'    => __( 'Images hover effect', 'azin-file' ),
            'options'  => array(
                'none'  => __( 'None', 'azin-file' ),
                'azin-brightness'  => __( 'Brightness', 'azin-file' ),
                'azin-zoomin' => __( 'Zoom', 'azin-file' ),
                'azin-rotate' => __( 'Rotate', 'azin-file' ),
                'azin-blur' => __( 'Blur', 'azin-file' ),
                'azin-gray' => __( 'Black & White', 'azin-file' ),
                'azin-opacity' => __( 'Opacity', 'azin-file' ),
                'azin-flash' => __( 'Flashing', 'azin-file' ),
                'azin-shine' => __( 'Shine', 'azin-file' ),
                'azin-circle' => __( 'Circle', 'azin-file' )
            ),
            'default'  => 'azin-brightness',
            'required' => array(
                array( 'show_ads_banner2', '=', true ),
                array( 'ads_banner2_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner2_hover_title',
            'type'     => 'switch',
            'title'    => __( 'Display the images title on mouse hover', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_ads_banner2', '=', true ),
                array( 'ads_banner2_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner2_one',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'The first ad', 'azin-file' ),
            'compiler' => 'true',
            'desc'     => __( 'The first ad displayed below the products', 'azin-file' ),
            'subtitle' => __( 'Suitable size: 472 pixels (width) and 170 pixels (height)', 'azin-file' ),
            'default'  => array( 'url' => get_template_directory_uri()."/images/ads.png" ),
            'required' => array(
                array( 'show_ads_banner2', '=', true ),
                array( 'ads_banner2_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner2_one_link',
            'type'     => 'text',
            'title'    => __( 'Banner link', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_ads_banner2', '=', true ),
                array( 'ads_banner2_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner2_one_title',
            'type'     => 'text',
            'title'    => __( 'Title', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_ads_banner2', '=', true ),
                array( 'ads_banner2_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner2_one_newtab',
            'type'     => 'switch',
            'title'    => __( 'Open the link in a new tab', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_ads_banner2', '=', true ),
                array( 'ads_banner2_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner2_one_nofollow',
            'type'     => 'switch',
            'title'    => __( 'Add nofollow property to link', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_ads_banner2', '=', true ),
                array( 'ads_banner2_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner2_two',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'The second ad', 'azin-file' ),
            'compiler' => 'true',
            'desc'     => __( 'The second ad displayed below the products', 'azin-file' ),
            'subtitle' => __( 'Suitable size: 472 pixels (width) and 170 pixels (height)', 'azin-file' ),
            'default'  => array( 'url' => get_template_directory_uri()."/images/ads.png" ),
            'required' => array(
                array( 'show_ads_banner2', '=', true ),
                array( 'ads_banner2_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner2_two_link',
            'type'     => 'text',
            'title'    => __( 'Banner link', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_ads_banner2', '=', true ),
                array( 'ads_banner2_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner2_two_title',
            'type'     => 'text',
            'title'    => __( 'Title', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_ads_banner2', '=', true ),
                array( 'ads_banner2_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner2_two_newtab',
            'type'     => 'switch',
            'title'    => __( 'Open the link in a new tab', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_ads_banner2', '=', true ),
                array( 'ads_banner2_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner2_two_nofollow',
            'type'     => 'switch',
            'title'    => __( 'Add nofollow property to link', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_ads_banner2', '=', true ),
                array( 'ads_banner2_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner2_three',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Third ad', 'azin-file' ),
            'compiler' => 'true',
            'desc'     => __( 'The third ad displayed below the products', 'azin-file' ),
            'subtitle' => __( 'Suitable size: 472 pixels (width) and 170 pixels (height)', 'azin-file' ),
            'default'  => array( 'url' => get_template_directory_uri()."/images/ads.png" ),
            'required' => array(
                array( 'show_ads_banner2', '=', true ),
                array( 'ads_banner2_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner2_three_link',
            'type'     => 'text',
            'title'    => __( 'Banner link', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_ads_banner2', '=', true ),
                array( 'ads_banner2_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner2_three_title',
            'type'     => 'text',
            'title'    => __( 'Title', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_ads_banner2', '=', true ),
                array( 'ads_banner2_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner2_three_newtab',
            'type'     => 'switch',
            'title'    => __( 'Open the link in a new tab', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_ads_banner2', '=', true ),
                array( 'ads_banner2_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'banner2_three_nofollow',
            'type'     => 'switch',
            'title'    => __( 'Add nofollow property to link', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_ads_banner2', '=', true ),
                array( 'ads_banner2_replace', '!=', true )
            )
        ),
        array(
            'id'     => 'ads-banner2-section-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //Download Page Header Banner
        array(
            'id'     => 'down-head-banner-section-start',
            'type'   => 'section',
            'title'    => __( 'Product top ad settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_down_head_banner',
            'type'     => 'switch',
            'title'    => __( 'Show top product ad', 'azin-file' ),
            'default'  => false
        ),
        array(
            'id'       => 'down_head_banner_replace',
            'type'     => 'switch',
            'title'    => __( 'Insert code or shortcode instead of image', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_down_head_banner', '=', true )
        ),
        array(
            'id'       => 'down_head_banner_code',
            'type'     => 'ace_editor',
            'title'    => __( 'Banner code', 'azin-file' ),
            'mode'     => 'plain_text',
            'theme'    => 'chrome',
            'required' => array(
                array( 'show_down_head_banner', '=', true ),
                array( 'down_head_banner_replace', '=', true )
            )
        ),
        array(
            'id'       => 'down_head_banner',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Product top ad', 'azin-file' ),
            'compiler' => 'true',
            'desc'     => __( 'The ad displayed at the top of the product box on the product page', 'azin-file' ),
            'subtitle' => __( 'Suitable size: 840 pixels (width) and 150 pixels (height)', 'azin-file' ),
            'default'  => array( 'url' => get_template_directory_uri()."/images/fbanner.png" ),
            'required' => array(
                array( 'show_down_head_banner', '=', true ),
                array( 'down_head_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'down_head_banner_link',
            'type'     => 'text',
            'title'    => __( 'Banner link', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_down_head_banner', '=', true ),
                array( 'down_head_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'down_head_banner_title',
            'type'     => 'text',
            'title'    => __( 'Title', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_down_head_banner', '=', true ),
                array( 'down_head_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'down_head_banner_newtab',
            'type'     => 'switch',
            'title'    => __( 'Open the link in a new tab', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_down_head_banner', '=', true ),
                array( 'down_head_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'down_head_banner_nofollow',
            'type'     => 'switch',
            'title'    => __( 'Add nofollow property to link', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_down_head_banner', '=', true ),
                array( 'down_head_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'down_head_banner_hover_effect',
            'type'     => 'select',
            'title'    => __( 'Image hover effect', 'azin-file' ),
            'options'  => array(
                'none'  => __( 'None', 'azin-file' ),
                'azin-brightness'  => __( 'Brightness', 'azin-file' ),
                'azin-zoomin' => __( 'Zoom', 'azin-file' ),
                'azin-rotate' => __( 'Rotate', 'azin-file' ),
                'azin-blur' => __( 'Blur', 'azin-file' ),
                'azin-gray' => __( 'Black & White', 'azin-file' ),
                'azin-opacity' => __( 'Opacity', 'azin-file' ),
                'azin-flash' => __( 'Flashing', 'azin-file' ),
                'azin-shine' => __( 'Shine', 'azin-file' ),
                'azin-circle' => __( 'Circle', 'azin-file' )
            ),
            'default'  => 'azin-brightness',
            'required' => array(
                array( 'show_down_head_banner', '=', true ),
                array( 'down_head_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'down_head_banner_hover_title',
            'type'     => 'switch',
            'title'    => __( 'Display the image title on mouse hover', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_down_head_banner', '=', true ),
                array( 'down_head_banner_replace', '!=', true )
            )
        ),
        array(
            'id'     => 'down-head-banner-section-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //Download Page Footer Banner
        array(
            'id'     => 'down-foot-banner-start',
            'type'   => 'section',
            'title'    => __( 'Product ad bottom settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_down_foot_banner',
            'type'     => 'switch',
            'title'    => __( 'Show ad below product', 'azin-file' ),
            'default'  => false
        ),
        array(
            'id'       => 'down_foot_banner_replace',
            'type'     => 'switch',
            'title'    => __( 'Insert code or shortcode instead of image', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_down_foot_banner', '=', true )
        ),
        array(
            'id'       => 'down_foot_banner_code',
            'type'     => 'ace_editor',
            'title'    => __( 'Banner code', 'azin-file' ),
            'mode'     => 'plain_text',
            'theme'    => 'chrome',
            'required' => array(
                array( 'show_down_foot_banner', '=', true ),
                array( 'down_foot_banner_replace', '=', true )
            )
        ),
        array(
            'id'       => 'down_foot_banner',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Advertise the bottom of the product', 'azin-file' ),
            'compiler' => 'true',
            'desc'     => __( 'The ad displayed below the product box on the product page', 'azin-file' ),
            'subtitle' => __( 'Suitable size: 840 pixels (width) and 150 pixels (height)', 'azin-file' ),
            'default'  => array( 'url' => get_template_directory_uri()."/images/fbanner.png" ),
            'required' => array(
                array( 'show_down_foot_banner', '=', true ),
                array( 'down_foot_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'down_foot_banner_link',
            'type'     => 'text',
            'title'    => __( 'Banner link', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_down_foot_banner', '=', true ),
                array( 'down_foot_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'down_foot_banner_title',
            'type'     => 'text',
            'title'    => __( 'Title', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_down_foot_banner', '=', true ),
                array( 'down_foot_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'down_foot_banner_newtab',
            'type'     => 'switch',
            'title'    => __( 'Open the link in a new tab', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_down_foot_banner', '=', true ),
                array( 'down_foot_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'down_foot_banner_nofollow',
            'type'     => 'switch',
            'title'    => __( 'Add nofollow property to link', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_down_foot_banner', '=', true ),
                array( 'down_foot_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'down_foot_banner_hover_effect',
            'type'     => 'select',
            'title'    => __( 'Image hover effect', 'azin-file' ),
            'options'  => array(
                'none'  => __( 'None', 'azin-file' ),
                'azin-brightness'  => __( 'Brightness', 'azin-file' ),
                'azin-zoomin' => __( 'Zoom', 'azin-file' ),
                'azin-rotate' => __( 'Rotate', 'azin-file' ),
                'azin-blur' => __( 'Blur', 'azin-file' ),
                'azin-gray' => __( 'Black & White', 'azin-file' ),
                'azin-opacity' => __( 'Opacity', 'azin-file' ),
                'azin-flash' => __( 'Flashing', 'azin-file' ),
                'azin-shine' => __( 'Shine', 'azin-file' ),
                'azin-circle' => __( 'Circle', 'azin-file' )
            ),
            'default'  => 'azin-brightness',
            'required' => array(
                array( 'show_down_foot_banner', '=', true ),
                array( 'down_foot_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'down_foot_banner_hover_title',
            'type'     => 'switch',
            'title'    => __( 'Display the image title on mouse hover', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_down_foot_banner', '=', true ),
                array( 'down_foot_banner_replace', '!=', true )
            )
        ),
        array(
            'id'     => 'down-foot-banner-section-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //Post Page Header Banner
        array(
            'id'     => 'post-head-banner-start',
            'type'   => 'section',
            'title'    => __( 'Ads at the top of the post', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_post_head_banner',
            'type'     => 'switch',
            'title'    => __( 'Show ad at the top of the post', 'azin-file' ),
            'default'  => false
        ),
        array(
            'id'       => 'post_head_banner_replace',
            'type'     => 'switch',
            'title'    => __( 'Insert code or shortcode instead of image', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_post_head_banner', '=', true )
        ),
        array(
            'id'       => 'post_head_banner_code',
            'type'     => 'ace_editor',
            'title'    => __( 'Banner code', 'azin-file' ),
            'mode'     => 'plain_text',
            'theme'    => 'chrome',
            'required' => array(
                array( 'show_post_head_banner', '=', true ),
                array( 'post_head_banner_replace', '=', true )
            )
        ),
        array(
            'id'       => 'post_head_banner',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Ads above the post', 'azin-file' ),
            'compiler' => 'true',
            'desc'     => __( 'The ad displayed at the top of the post box on the post page', 'azin-file' ),
            'subtitle' => __( 'Suitable size: 840 pixels (width) and 150 pixels (height)', 'azin-file' ),
            'default'  => array( 'url' => get_template_directory_uri()."/images/fbanner.png" ),
            'required' => array(
                array( 'show_post_head_banner', '=', true ),
                array( 'post_head_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'post_head_banner_link',
            'type'     => 'text',
            'title'    => __( 'Banner link', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_post_head_banner', '=', true ),
                array( 'post_head_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'post_head_banner_title',
            'type'     => 'text',
            'title'    => __( 'Title', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_post_head_banner', '=', true ),
                array( 'post_head_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'post_head_banner_newtab',
            'type'     => 'switch',
            'title'    => __( 'Open the link in a new tab', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_post_head_banner', '=', true ),
                array( 'post_head_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'post_head_banner_nofollow',
            'type'     => 'switch',
            'title'    => __( 'Add nofollow property to link', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_post_head_banner', '=', true ),
                array( 'post_head_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'post_head_banner_hover_effect',
            'type'     => 'select',
            'title'    => __( 'Image hover effect', 'azin-file' ),
            'options'  => array(
                'none'  => __( 'None', 'azin-file' ),
                'azin-brightness'  => __( 'Brightness', 'azin-file' ),
                'azin-zoomin' => __( 'Zoom', 'azin-file' ),
                'azin-rotate' => __( 'Rotate', 'azin-file' ),
                'azin-blur' => __( 'Blur', 'azin-file' ),
                'azin-gray' => __( 'Black & White', 'azin-file' ),
                'azin-opacity' => __( 'Opacity', 'azin-file' ),
                'azin-flash' => __( 'Flashing', 'azin-file' ),
                'azin-shine' => __( 'Shine', 'azin-file' ),
                'azin-circle' => __( 'Circle', 'azin-file' )
            ),
            'default'  => 'azin-brightness',
            'required' => array(
                array( 'show_post_head_banner', '=', true ),
                array( 'post_head_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'post_head_banner_hover_title',
            'type'     => 'switch',
            'title'    => __( 'Display the image title on mouse hover', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_post_head_banner', '=', true ),
                array( 'post_head_banner_replace', '!=', true )
            )
        ),
        array(
            'id'     => 'post-head-banner-section-end',
            'type'   => 'section',
            'indent' => false,
       ),

        //Post Page Footer Banner
        array(
            'id'     => 'post-foot-banner-section-start',
            'type'   => 'section',
            'title'    => __( 'Ads settings at the bottom of the posts', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_post_foot_banner',
            'type'     => 'switch',
            'title'    => __( 'Show ad below post', 'azin-file' ),
            'default'  => false
        ),
        array(
            'id'       => 'post_foot_banner_replace',
            'type'     => 'switch',
            'title'    => __( 'Insert code or shortcode instead of image', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_post_foot_banner', '=', true )
        ),
        array(
            'id'       => 'post_foot_banner_code',
            'type'     => 'ace_editor',
            'title'    => __( 'Banner code', 'azin-file' ),
            'mode'     => 'plain_text',
            'theme'    => 'chrome',
            'required' => array(
                array( 'show_post_foot_banner', '=', true ),
                array( 'post_foot_banner_replace', '=', true )
            )
        ),
        array(
            'id'       => 'post_foot_banner',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Ad at the bottom of the posts', 'azin-file' ),
            'compiler' => 'true',
            'desc'     => __( 'The ad displayed below the posts box on the post page', 'azin-file' ),
            'subtitle' => __( 'Suitable size: 840 pixels (width) and 150 pixels (height)', 'azin-file' ),
            'default'  => array( 'url' => get_template_directory_uri()."/images/fbanner.png" ),
            'required' => array(
                array( 'show_post_foot_banner', '=', true ),
                array( 'post_foot_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'post_foot_banner_link',
            'type'     => 'text',
            'title'    => __( 'Banner link', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_post_foot_banner', '=', true ),
                array( 'post_foot_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'post_foot_banner_title',
            'type'     => 'text',
            'title'    => __( 'Title', 'azin-file' ),
            'default'  => '#',
            'required' => array(
                array( 'show_post_foot_banner', '=', true ),
                array( 'post_foot_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'post_foot_banner_newtab',
            'type'     => 'switch',
            'title'    => __( 'Open the link in a new tab', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_post_foot_banner', '=', true ),
                array( 'post_foot_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'post_foot_banner_nofollow',
            'type'     => 'switch',
            'title'    => __( 'Add nofollow property to link', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_post_foot_banner', '=', true ),
                array( 'post_foot_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'post_foot_banner_hover_effect',
            'type'     => 'select',
            'title'    => __( 'Image hover effect', 'azin-file' ),
            'options'  => array(
                'none'  => __( 'None', 'azin-file' ),
                'azin-brightness'  => __( 'Brightness', 'azin-file' ),
                'azin-zoomin' => __( 'Zoom', 'azin-file' ),
                'azin-rotate' => __( 'Rotate', 'azin-file' ),
                'azin-blur' => __( 'Blur', 'azin-file' ),
                'azin-gray' => __( 'Black & White', 'azin-file' ),
                'azin-opacity' => __( 'Opacity', 'azin-file' ),
                'azin-flash' => __( 'Flashing', 'azin-file' ),
                'azin-shine' => __( 'Shine', 'azin-file' ),
                'azin-circle' => __( 'Circle', 'azin-file' )
            ),
            'default'  => 'azin-brightness',
            'required' => array(
                array( 'show_post_foot_banner', '=', true ),
                array( 'post_foot_banner_replace', '!=', true )
            )
        ),
        array(
            'id'       => 'post_foot_banner_hover_title',
            'type'     => 'switch',
            'title'    => __( 'Display the image title on mouse hover', 'azin-file' ),
            'default'  => false,
            'required' => array(
                array( 'show_post_foot_banner', '=', true ),
                array( 'post_foot_banner_replace', '!=', true )
            )
        ),
        array(
            'id'     => 'post-foot-banner-section-end',
            'type'   => 'section',
            'indent' => false,
        ),
    ) 
) );

//Block settings
Redux::setSection( $opt_name, array(
    'title'      => __( 'Block settings', 'azin-file' ),
    'icon'       => 'fa fa-th-large',
    'id'         => 'home_blocks',
    'subsection' => true,
    'desc'       => __( 'Home page blocks ( if the Elementor does not manage the main page of the template, except for the text page of the main page)', 'azin-file' ),
    'fields'     => array(
        array(
            'id'       => 'show_special',
            'type'     => 'switch',
            'title'    => __( 'Amazing offer box', 'azin-file' ),
            'subtitle' => __( 'Display discounted products as a slider on the home screen', 'azin-file' ),
            'default'  => false
        ),
        array(
            'id'       => 'show_most_viewed',
            'type'     => 'switch',
            'title'    => __( 'Popular products', 'azin-file' ),
            'subtitle' => __( 'Show popular products on the home page', 'azin-file' ),
            'default'  => false
        ),
        array(
            'id'       => 'most_saled',
            'type'     => 'switch',
            'title'    => __( 'Show best selling products', 'azin-file' ),
            'subtitle' => __( 'By activating this option, the best-selling products will be displayed instead of the most visited products', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_most_viewed', '=', true ),
        ),
        array(
            'id'       => 'most_viewed_title',
            'type'     => 'text',
            'title'    => __( 'Block title', 'azin-file' ),
            'default'  => __( 'Popular products', 'azin-file' ),
            'required' => array( 'show_most_viewed', '=', true ),
        ),
        array(
            'id'       => 'most_viewed_play',
            'type'     => 'switch',
            'title'    => __( 'Automatic movement', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_most_viewed', '=', true ),
        ),
        array(
            'id'       => 'most_viewed_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-shopping-bag',
            'options'  => $alliconArray,
            'required' => array( 'show_most_viewed', '=', true ),
        ),
        array(
            'id'       => 'show_main_blog',
            'type'     => 'switch',
            'title'    => __( 'View blog content blocks', 'azin-file' ),
            'subtitle' => __( 'Display a block to display the latest blog content on the home page', 'azin-file' ),
            'default'  => true
        ),
        array(
            'id'       => 'main_blog_title',
            'type'     => 'text',
            'title'    => __( 'Block title', 'azin-file' ),
            'default'  => __( 'Free content', 'azin-file' ),
            'required' => array( 'show_main_blog', '=', true ),
        ),
        array(
            'id'       => 'main_blog_play',
            'type'     => 'switch',
            'title'    => __( 'Automatic movement', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_main_blog', '=', true ),
        ),
        array(
            'id'       => 'main_blog_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-file-alt',
            'options'  => $alliconArray,
            'required' => array( 'show_main_blog', '=', true ),
        ),
        array(
            'id'       => 'main_blog_count',
            'type'     => 'text',
            'title'    => __( 'Number of contents to display', 'azin-file' ),
            'default'  => 8,
            'required' => array( 'show_main_blog', '=', true ),
        ),
        array(
            'id'       => 'main_blog_cat',
            'type'     => 'select',
            'data'     => 'categories',
            'multi'    => true,
            'title'    => __( 'Category', 'azin-file' ),
            'subtitle' => __( 'Display specific category (s) content', 'azin-file' ),
            'desc'     => __( 'Leave blank to show all.', 'azin-file' ),
            'required' => array( 'show_main_blog', '=', true ),
        ),
        array(
            'id'       => 'show_mbtn',
            'type'     => 'switch',
            'title'    => __( 'Show view all buttons', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_main_blog', '=', true )
        ),
        array(
            'id'       => 'show_main_page',
            'type'     => 'switch',
            'title'    => __( 'Display the home text block', 'azin-file' ),
            'subtitle' => __( 'Display a block to display text on the home screen', 'azin-file' ),
            'default'  => true
        ),
        array(
            'id'       => 'show_main_page_summ',
            'type'     => 'switch',
            'title'    => __( 'Display the text of the home screen in summary form', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_main_page', '=', true ),
        ),
        array(
            'id'       => 'main_title',
            'type'     => 'text',
            'title'    => __( 'Block title', 'azin-file' ),
            'default'  => __( 'Home text', 'azin-file' ),
            'required' => array( 'show_main_page', '=', true ),
        ),
        array(
            'id'      => 'main_text',
            'type'    => 'editor',
            'title'   => __( 'Block text', 'azin-file' ),
            'desc'    => __( 'You can also use the shortcode', 'azin-file' ),
            'default' => __( '<p> This text can be changed through the template settings section. You can display text on the site home page. <br />
            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Printers and texts, but also newspapers and magazines in columns and rows as needed and for the current state of technology required and a variety of applications with the aim of improving practical tools. Sixty-three percent of books in the past, present and future require a lot of knowledge from the community and professionals to create more knowledge with software for computer designers, especially creative designers and leading culture in the Persian language. In this case, it can be hoped that all the difficulties in presenting solutions and difficult typing conditions will end and the required time, including typing the main achievements and answering the continuous questions of the existing world of design, will be basically used. </p>', 'azin-file' ),
            'args'    => array(
                'wpautop'       => false,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'show_main_page', '=', true ),            
        ),
    ) 
) );

//Slider
Redux::setSection( $opt_name, array(
    'title'            => __( 'Slider', 'azin-file' ),
    'icon'             => 'fa fa-presentation',
    'desc'             => __( 'Slider settings ( if the Elementor does not manage the main page of the template)', 'azin-file' ),
    'id'               => 'home_slider',
    'subsection'       => true,
    'customizer_width' => '700px',
    'fields'           => array(
        array(
            'id'       => 'show_slider',
            'type'     => 'switch',
            'title'    => __( 'Show slider on home screen', 'azin-file' ),
            'default'  => false
        ),
        array(
            'id'       => 'show_slider_mobile',
            'type'     => 'switch',
            'title'    => __( 'Display slider in mobile mode', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_slider', '=', true ),
        ),
        array(
            'id'          => 'main_slider',
            'type'        => 'slides',
            'title'       => __( 'Slider settings', 'azin-file' ),
            'subtitle'    => __( 'Enter the images related to the slider from this section.', 'azin-file' ),
            'desc'        => '',
            'placeholder' => array(
                'title'       => __( 'Title', 'azin-file' ),
                'description' => __( 'Description', 'azin-file' ),
                'url'         => __( 'Link', 'azin-file' ),
            ),
            'required' => array( 'show_slider', '=', true ),
        ),
    )
) );

//Service box
Redux::setSection( $opt_name, array(
    'title'            => __( 'Service box', 'azin-file' ),
    'icon'             => 'fa fa-certificate',
    'desc'             => __( 'Service box settings ( if the Elementor home page is not managed by the mentor)', 'azin-file' ),
    'id'               => 'home_services',
    'subsection'       => true,
    'customizer_width' => '700px',
    'fields'           => array(
        array(
            'id'       => 'show_services',
            'type'     => 'switch',
            'title'    => __( 'Display the service box on the home page and the product page', 'azin-file' ),
            'default'  => true
        ),
        array(
            'id'       => 'show_services_main',
            'type'     => 'switch',
            'title'    => __( 'Display the service box on the home screen', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_services', '=', true ),
        ),
        array(
            'id'       => 'show_services_prod',
            'type'     => 'switch',
            'title'    => __( 'Display the service box on the product page', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_services', '=', true ),
        ),
        array(
            'id'       => 'show_services_mobile',
            'type'     => 'switch',
            'title'    => __( 'Display box in mobile mode', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_services', '=', true ),
        ),
        array(
            'id'       => 'services_icon_top',
            'type'     => 'switch',
            'title'    => __( 'Show icon at the top', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_services', '=', true ),
        ),
        array(
            'id'       => 'ser_one_title',
            'type'     => 'text',
            'title'    => __( 'Title of the first box', 'azin-file' ),
            'default'  => __( 'Secure payment', 'azin-file' ),
            'required' => array( 'show_services', '=', true ),
        ),
        array(
            'id'       => 'ser_one_des',
            'type'     => 'text',
            'title'    => __( 'Description of the first box', 'azin-file' ),
            'default'  => __( 'By credit cards', 'azin-file' ),
            'required' => array( 'show_services', '=', true ),
        ),
        array(
            'id'       => 'ser_one_link',
            'type'     => 'text',
            'title'    => __( 'First link box', 'azin-file' ),
            'default'  => '',
            'required' => array( 'show_services', '=', true ),
        ),
        array(
            'id'       => 'ser_one_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-credit-card',
            'options'  => $alliconArray,
            'required' => array( 'show_services', '=', true ),
        ),
        array(
            'id'       => 'ser_two_title',
            'type'     => 'text',
            'title'    => __( 'Second box title', 'azin-file' ),
            'default'  => __( 'Refund', 'azin-file' ),
            'required' => array( 'show_services', '=', true ),
        ),
        array(
            'id'       => 'ser_two_des',
            'type'     => 'text',
            'title'    => __( 'Description of the second box', 'azin-file' ),
            'default'  => __( 'Up to 7 days', 'azin-file' ),
            'required' => array( 'show_services', '=', true ),
        ),
        array(
            'id'       => 'ser_two_link',
            'type'     => 'text',
            'title'    => __( 'Second link box', 'azin-file' ),
            'default'  => '',
            'required' => array( 'show_services', '=', true ),
        ),
        array(
            'id'       => 'ser_two_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-calendar-check',
            'options'  => $alliconArray,
            'required' => array( 'show_services', '=', true ),
        ),
        array(
            'id'       => 'ser_three_title',
            'type'     => 'text',
            'title'    => __( 'Title of the third box', 'azin-file' ),
            'default'  => __( 'Quality guarantee', 'azin-file' ),
            'required' => array( 'show_services', '=', true ),
        ),
        array(
            'id'       => 'ser_three_des',
            'type'     => 'text',
            'title'    => __( 'Description of the third box', 'azin-file' ),
            'default'  => __( 'And lowest price', 'azin-file' ),
            'required' => array( 'show_services', '=', true ),
        ),
        array(
            'id'       => 'ser_three_link',
            'type'     => 'text',
            'title'    => __( 'Third box link', 'azin-file' ),
            'default'  => '',
            'required' => array( 'show_services', '=', true ),
        ),
        array(
            'id'       => 'ser_three_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-certificate',
            'options'  => $alliconArray,
            'required' => array( 'show_services', '=', true ),
        ),
        array(
            'id'       => 'ser_four_title',
            'type'     => 'text',
            'title'    => __( 'Title of the fourth box', 'azin-file' ),
            'default'  => __( 'Support', 'azin-file' ),
            'required' => array( 'show_services', '=', true ),
        ),
        array(
            'id'       => 'ser_four_des',
            'type'     => 'text',
            'title'    => __( 'Description of the fourth box', 'azin-file' ),
            'default'  => __( '24 hours, 7 days a week', 'azin-file' ),
            'required' => array( 'show_services', '=', true ),
        ),
        array(
            'id'       => 'ser_four_link',
            'type'     => 'text',
            'title'    => __( 'Fourth link box', 'azin-file' ),
            'default'  => '',
            'required' => array( 'show_services', '=', true ),
        ),
        array(
            'id'       => 'ser_four_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-question-circle',
            'options'  => $alliconArray,
            'required' => array( 'show_services', '=', true ),
        ),
    )
) );