<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Demo Website: https://azinfile.i-design.ir/
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

//Start Popup settings SECTION
Redux::setSection( $opt_name, array(
    'title'      => __( 'Popup settings', 'azin-file' ),
    'id'         => 'popup_setting',
    'icon'       => 'fa fa-window',
    'fields'     => array(
        array(
            'id'       => 'enable_site_popup',
            'type'     => 'switch',
            'title'    => __( 'Enable popup window', 'azin-file' ),
            'subtitle'  => __( 'By activating this option, you can display a pop-up window after loading the site.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'site_popup_home',
            'type'     => 'switch',
            'title'    => __( 'Pop-up display only on home page', 'azin-file' ),
            'default'  => false,
            'required' => array( 'enable_site_popup', '=', true ),
        ),
        array(
            'id'       => 'site_popup_close_any',
            'type'     => 'switch',
            'title'    => __( 'Close the popup by clicking anywhere on the page', 'azin-file' ),
            'default'  => false,
            'required' => array( 'enable_site_popup', '=', true ),
        ),
        array(
            'id'       => 'site_popup_one_time',
            'type'     => 'switch',
            'title'    => __( 'Do not re-display the pop-up', 'azin-file' ),
            'subtitle'  => __( 'Not displaying pop-ups on subsequent user visits after closing the window', 'azin-file' ),
            'default'  => true,
            'required' => array( 'enable_site_popup', '=', true ),
        ),
        array(
            'id'       => 'site_popup_reshown',
            'type'     => 'text',
            'validate' => 'numeric',
            'title'    => __( 'Show again after a few days', 'azin-file' ),
            'subtitle' => __( 'After this time, the pop-up will be displayed again, enter 0 to not display.', 'azin-file' ),
            'default'  => 0,
            'required' => array( 'site_popup_one_time', '=', true ),
        ),
        array(
            'id'       => 'site_popup_size',
            'type'     => 'select',
            'title'    => __( 'Pop-up size', 'azin-file' ),
            'options'  => array(
                'modal-sm' => __( 'Small', 'azin-file' ),
                'modal-md' =>  __( 'Default', 'azin-file' ),
                'modal-lg' =>  __( 'Larg', 'azin-file' ),
            ),
            'default'  => 'modal-lg',
            'required' => array( 'enable_site_popup', '=', true ),
        ),
        array(
            'id'       => 'site_popup_title',
            'type'     => 'text',
            'title'    => __( 'Popup title', 'azin-file' ),
            'default'  => __( 'Title', 'azin-file' ),                
            'required' => array( 'enable_site_popup', '=', true ),
        ),

        array(
            'id' => 'site-popup-content-section-start',
            'type' => 'section',
            'title'    => __( 'Popup content settings', 'azin-file' ),
            'indent' => true,
            'required' => array( 'enable_site_popup', '=', true ),
        ),
        array(
            'id'      => 'site_popup_content_text',
            'type'    => 'editor',
            'title'   => __( 'Popup content text', 'azin-file' ),
            'desc'    => __( 'You can also use the shortcode', 'azin-file' ),
            'default' => __( '<p> This text can be changed through the template settings section.<br />
            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Printers and texts, but also newspapers and magazines in columns and rows as needed and for the current state of technology required and a variety of applications with the aim of improving practical tools. Sixty-three percent of books in the past, present and future require a lot of knowledge from the community and professionals to create more knowledge with software for computer designers, especially creative designers and leading culture in the Persian language. In this case, it can be hoped that all the difficulties in presenting solutions and difficult typing conditions will end and the required time, including typing the main achievements and answering the continuous questions of the existing world of design, will be basically used.</p>', 'azin-file' ),
            'args'    => array(
                'wpautop'       => false,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
        ),
        array(
            'id' => 'site-popup-content-section-end',
            'type' => 'section',
            'indent' => false ,
        ),

        array(
            'id' => 'site-popup-image-section-start',
            'type' => 'section',
            'title'    => __( 'Popup image settings', 'azin-file' ),
            'indent' => true,
            'required' => array( 'enable_site_popup', '=', true ),
        ),
        array(
            'id'       => 'show_site_popup_image',
            'type'     => 'switch',
            'title'    => __( 'Show popup image' , 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'site_popup_image',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Popup image', 'azin-file' ),
            'compiler' => 'true',
            'desc'     => __( 'Upload your popup image from this section.', 'azin-file' ),
            'required' => array( 'show_site_popup_image', '=', true ),
        ),
        array(
            'id'       => 'site_popup_image_link',
            'type'     => 'text',
            'title'    => __( 'Image link' , 'azin-file' ),
            'required' => array( 'show_site_popup_image', '=', true ),
        ),
        array(
            'id'       => 'open_site_popup_image_link_new_tab',
            'type'     => 'switch',
            'title'    => __( 'Open the link in a new tab' , 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_site_popup_image', '=', true ),
        ),
        array(
            'id'       => 'site_popup_image_pos',
            'type'     => 'image_select',
            'title'    => __( 'Popup image position', 'azin-file' ),
            'options'  => array(
                'top' => array(
                    'alt' => __( 'Top', 'azin-file' ),
                    'img' => RE_URI . 'assets/img/t-image.png'
                ),
                'right' => array(
                    'alt' => __( 'Right', 'azin-file' ),
                    'img' => RE_URI . 'assets/img/r-image.png'
                ),
                'left' => array(
                    'alt' => __( 'Left', 'azin-file' ),
                    'img' => RE_URI . 'assets/img/l-image.png'
                ),
                'full-image' => array(
                    'alt' => __( 'Image only', 'azin-file' ),
                    'img' => RE_URI . 'assets/img/f-image.png'
                ),
            ),
            'default'  => 'top',
            'required' => array( 'show_site_popup_image', '=', true ),
        ),

        array(
            'id' => 'site-popup-button-section-start',
            'type' => 'section',
            'title'    => __( 'Popup button settings', 'azin-file' ),
            'indent' => true,
            'required' => array( 'enable_site_popup', '=', true ),
        ),
        array(
            'id'       => 'show_site_popup_button',
            'type'     => 'switch',
            'title'    => __( 'Show popup button' , 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'site_popup_button_title',
            'type'     => 'text',
            'title'    => __( 'Button title' , 'azin-file' ),
            'default'  => __( 'Title' , 'azin-file' ),
            'required' => array( 'show_site_popup_button', '=', true ),
        ),
        array(
            'id'       => 'site_popup_button_link',
            'type'     => 'text',
            'title'    => __( 'Button link' , 'azin-file' ),
            'default'  => '#',
            'required' => array( 'show_site_popup_button', '=', true ),
        ),
        array(
            'id'       => 'open_site_popup_link_new_tab',
            'type'     => 'switch',
            'title'    => __( 'Open the link in a new tab' , 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_site_popup_button', '=', true ),
        ),
        array(
            'id'       => 'site_popup_button_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-shopping-cart',
            'options'  => $alliconArray,
            'required' => array( 'show_site_popup_button', '=', true ),
        ),
        array(
            'id'       => 'site_popup_button_color',
            'type'     => 'select',
            'title'    => __( 'Color', 'azin-file' ),
            'options'  => array(
                'btn-info'  =>  __( 'Blue', 'azin-file' ),
                'btn-warning' =>  __( 'Yellow', 'azin-file' ),
                'btn-success'  =>  __( 'Green', 'azin-file' ),
                'btn-danger'  =>  __( 'Red', 'azin-file' )
            ),
            'default'  => 'btn-success',
            'required' => array( 'show_site_popup_button', '=', true ),
        ),        
        array(
            'id' => 'site-popup-button-section-end',
            'type' => 'section',
            'indent' => false ,
        ),

    ),
) );