<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Demo Website: https://azinfile.i-design.ir/
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

//Start Products and Posts SECTION
Redux::setSection( $opt_name, array(
    'title'      => __( 'Products and Posts', 'azin-file' ),
    'id'         => 'menu_product',
    'desc'       => __( 'Set items related to the products and Posts page.', 'azin-file' ),
    'icon'       => 'fa fa-bags-shopping',
    'fields'     => array(
        array(
            'id'       => 'product_style_two',
            'type'     => 'switch',
            'title'    => __( 'Second style of the product page', 'azin-file' ),
            'subtitle' => __( 'By activating this mode, the product preview area ( image, slider, etc.) will be displayed in full, and the product specifications and purchase button will be transferred to the widgets area.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'remove_product_sidebar',
            'type'     => 'switch',
            'title'    => __( 'Remove product page sidebar', 'azin-file' ),
            'default'  => false,
            'required' => array( 'product_style_two', '!=', true ),
        ),
        array(
            'id'       => 'remove_product_archive_sidebar',
            'type'     => 'switch',
            'title'    => __( 'Remove product archive sidebar', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'remove_post_sidebar',
            'type'     => 'switch',
            'title'    => __( 'Remove post page sidebar', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'remove_post_archive_sidebar',
            'type'     => 'switch',
            'title'    => __( 'Remove post archive sidebar', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'block_style_two',
            'type'     => 'switch',
            'title'    => __( 'The second style of blocks', 'azin-file' ),
            'subtitle' => __( 'By activating this mode, white background of product and post blocks removed.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'product_col',
            'type'     => 'select',
            'title'    => __( 'Number of products columns', 'azin-file' ),
            'subtitle' => __( 'Number of products columns in archive pages', 'azin-file' ),
            'options'  => array(
                2 =>  2,
                3 =>  3,
                4 =>  4,
            ),
            'default'  => 3,
        ),
        array(
            'id'       => 'post_col',
            'type'     => 'select',
            'title'    => __( 'Number of posts columns', 'azin-file' ),
            'subtitle' => __( 'Number of posts columns in archive pages', 'azin-file' ),
            'options'  => array(
                2 =>  2,
                3 =>  3,
                4 =>  4,
            ),
            'default'  => 3,
        ),
        array(
            'id'       => 'mobile_col',
            'type'     => 'select',
            'title'    => __( 'Number of columns in mobile mode', 'azin-file' ),
            'subtitle' => __( 'Number of posts and product columns in mobile mode', 'azin-file' ),
            'options'  => array(
                1 =>  1,
                2 =>  2,
            ),
            'default'  => 2,
        ),
        array(
            'id'       => 'site_schema',
            'type'     => 'switch',
            'title'    => __( 'Schema codes', 'azin-file' ),
            'subtitle' => __( 'Add Schema codes to product and post sections', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_product_link_target',
            'type'     => 'switch',
            'title'    => __( 'Opening the link of products and post in a new window (tab)', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_prod_dis',
            'type'     => 'switch',
            'title'    => __( 'Display the discount percentage on the product page', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'show_archive_dis',
            'type'     => 'switch',
            'title'    => __( 'Display the discount percentage on the archive pages', 'azin-file' ),
            'subtitle' => __( 'In products that are both discounted and special, only the discount percentage will be displayed.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_post_update',
            'type'     => 'switch',
            'title'    => __( 'Show the date the post was updated', 'azin-file' ),
            'subtitle' => __( 'Display the update date of the post instead of the release date', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'slide_img',
            'type'     => 'switch',
            'title'    => __( 'View LightBox images', 'azin-file' ),
            'subtitle' => __( 'View images linked to the image in a larger size by clicking', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'show_vcover_thumb',
            'type'     => 'switch',
            'title'    => __( 'Display image of posts and products as a cover video', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'product_like_btn',
            'type'     => 'switch',
            'title'    => __( 'Add to Wishlist Button', 'azin-file' ),
            'subtitle' => __( 'In EDD mode, EDD Whislist plugin is needed and in WooCommerce mode, YITH WooCommerce Whishlist plugin is needed.', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'social_share',
            'type'     => 'switch',
            'title'    => __( 'Sharing', 'azin-file' ),
            'subtitle' => __( 'Ability to share posts on social networks', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'show_next_prev_post',
            'type'     => 'switch',
            'title'    => __( 'Display link to previous and next post on post page', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'star_rating',
            'type'     => 'switch',
            'title'    => __( 'Star Rating', 'azin-file' ),
            'subtitle' => __( 'Activate star rating', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'text_summ',
            'type'     => 'switch',
            'title'    => __( 'Display summary text', 'azin-file' ),
            'subtitle' => __( 'By selecting this option, the text of the description will be displayed briefly in mobile mode', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'show_post_tags',
            'type'     => 'switch',
            'title'    => __( 'Product tags and posts', 'azin-file' ),
            'subtitle' => __( 'Show product and post tags', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'show_scomm',
            'type'     => 'switch',
            'title'    => __( 'Show commentator role', 'azin-file' ),
            'subtitle' => __( 'Display the phrase seller and buyer next to the name of the commenter', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'link_coming',
            'type'     => 'switch',
            'title'    => __( 'Link phrase coming soon', 'azin-file' ),
            'subtitle' => __( 'Link phrase coming soon instead of price on mode products coming soon.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'link_coming_addr',
            'type'     => 'text',
            'title'    => __( 'Coming soon link', 'azin-file' ),
            'default'  => '#',
            'required' => array( 'link_coming', '=', true ),
        ),

        array(
            'id'     => 'section-buy-fixed-start',
            'type'   => 'section',
            'title'    => __( 'Sticky purchase button settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_buy_fixed',
            'type'     => 'switch',
            'title'    => __( 'Sticky purchase button', 'azin-file' ),
            'subtitle' => __( 'Display the purchase button fixed on the product page', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'show_buy_fixed_mobile',
            'type'     => 'switch',
            'title'    => __( 'Display the sticky buy button in mobile mode', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_buy_fixed', '=', true ),
        ),
        array(
            'id'       => 'show_buy_fixed_title',
            'type'     => 'switch',
            'title'    => __( 'Display product title in mobile mode', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_buy_fixed_mobile', '=', true ),
        ),
        array(
            'id'       => 'show_buy_fixed_price',
            'type'     => 'switch',
            'title'    => __( 'Display product price in mobile mode', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_buy_fixed_mobile', '=', true ),
        ),
        array(
            'id'     => 'section-buy-fixed-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //Archive Descriptions Settings
        array(
            'id'     => 'section-archive-desc-start',
            'type'   => 'section',
            'title'    => __( 'Archive descriptions settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_archive_desc',
            'type'     => 'switch',
            'title'    => __( 'Show archive descriptions', 'azin-file' ),
            'subtitle' => __( 'Show archive description at the bottom of the page (if you complete this section of the category edit)', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'show_archive_desc_title',
            'type'     => 'switch',
            'title'    => __( 'Show archive descriptions title', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_archive_desc', '=', true ),
        ),
        array(
            'id'       => 'show_archive_desc_top',
            'type'     => 'switch',
            'title'    => __( 'Display archive descriptions on top of products', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_archive_desc', '=', true ),
        ),
        array(
            'id'       => 'show_post_archive_desc_top',
            'type'     => 'switch',
            'title'    => __( 'Display archive descriptions on top of posts', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_archive_desc', '=', true ),
        ),
        array(
            'id'       => 'show_archive_desc_summ',
            'type'     => 'switch',
            'title'    => __( 'Display archive descriptions in summary form', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_archive_desc', '=', true ),
        ),
        array(
            'id'       => 'show_first_text_cat',
            'type'     => 'switch',
            'title'    => __( 'Show category description only on the first page', 'azin-file' ),
            'subtitle' => __( 'In case the ajax loading of products is disabled', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'     => 'section-archive-desc-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //Archive Description Settings

        //Ajax loading settings of products and posts on archive pages
        array(
            'id'     => 'section-ajax-prod-start',
            'type'   => 'section',
            'title'    => __( 'Ajax loading settings of products and posts on archive pages', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'ajax_prod',
            'type'     => 'switch',
            'title'    => __( 'Ajax products and posts Loading', 'azin-file' ),
            'subtitle' => __( 'Loading products and posts ajax and remove pagination', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'ajax_prod_auto',
            'type'     => 'switch',
            'title'    => __( 'Automatic loading of more products and posts', 'azin-file' ),
            'subtitle' => __( 'Automatic loading of more products and posts when reaching the end of page', 'azin-file' ),
            'default'  => false,
            'required' => array( 'ajax_prod', '=', true ),
        ),
        array(
            'id'       => 'ajax_prod_history',
            'type'     => 'switch',
            'title'    => __( 'Show page number', 'azin-file' ),
            'subtitle' => __( 'Display page number in Ajax loading mode', 'azin-file' ),
            'default'  => false,
            'required' => array( 'ajax_prod', '=', true ),
        ),
        array(
            'id'     => 'section-ajax-prod-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //Message settings to previous product buyers
        array(
            'id'     => 'section-bought-alert-start',
            'type'   => 'section',
            'title'    => __( 'Message settings to previous product buyers', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_bought_alert',
            'type'     => 'switch',
            'title'    => __( 'Show messages to previous buyers of the product', 'azin-file' ),
            'subtitle' => __( 'By activating this option, a message to previous buyers of the product will be displayed on the product page.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'   => 'bought_alert_text',
            'type' => 'textarea',
            'rows' => 2,
            'title'    => __( 'Text message', 'azin-file' ),
            'default' => __( 'You have already purchased this product.', 'azin-file' ),
            'allowed_html' => array(
                'a' => array(
                    'href' => array(),
                    'title'    => array()
                ),
                'br' => array(),
                'em' => array(),
                'strong' => array()
            ),
            'required' => array( 'show_bought_alert', '=', true ),
        ),
        array(
            'id'       => 'change_bought_text_course',
            'type'     => 'switch',
            'title'    => __( 'Change text for courses', 'azin-file' ),
            'subtitle' => __( 'If you are selling training course products, you can change the text of this type of products from this section.', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_bought_alert', '=', true ),
        ),
        array(
            'id'   => 'bought_alert_text_course',
            'type' => 'textarea',
            'rows' => 2,
            'title'    => __( 'Course message text', 'azin-file' ),
            'default' => __( 'You have already purchased this course.', 'azin-file' ),
            'allowed_html' => array(
                'a' => array(
                    'href' => array(),
                    'title'    => array()
                ),
                'br' => array(),
                'em' => array(),
                'strong' => array()
            ),
            'required' => array( 'change_bought_text_course', '=', true ),
        ),
        array(
            'id'       => 'bought_alert_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-info-circle',
            'options'  => $alliconArray,
            'required' => array( 'show_bought_alert', '=', true ),
        ),
        array(
            'id'       => 'bought_alert_color',
            'type'     => 'select',
            'title'    => __( 'Message color', 'azin-file' ),
            'options'  => array(
                'alert-primary'   =>  __( 'Blue', 'azin-file' ),
                'alert-info'      =>  __( 'Light Blue', 'azin-file' ),
                'alert-warning'   =>  __( 'Yellow', 'azin-file' ),
                'alert-success'   =>  __( 'Green', 'azin-file' ),
                'alert-light'     =>  __( 'White', 'azin-file' ),
                'alert-secondary' =>  __( 'Grey', 'azin-file' ),
                'alert-danger'    =>  __( 'Red', 'azin-file' ),
                'alert-dark'      =>  __( 'Dark Grey', 'azin-file' ),
            ),
            'default'  => 'alert-warning',
            'required' => array( 'show_bought_alert', '=', true ),
        ),
        array(
            'id'     => 'section-bought-alert-end',
            'type'   => 'section',
            'indent' => false,
        ),

        // Purchased download links tab
        array(
            'id'     => 'section-purchased-download-links-start',
            'type'   => 'section',
            'title'    => __( 'Product download settings on the product page', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_purchased_tab',
            'type'     => 'switch',
            'title'    => __( 'Display the product download link on the product page', 'azin-file' ),
            'subtitle' => __( 'By activating this option, the download link of the product files will be displayed in a separate tab to the product buyers.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'purchased_tab_title',
            'type'     => 'text',
            'title'    => __( 'Tab title', 'azin-file' ),
            'default'  => __( 'Product download', 'azin-file' ),
            'required' => array( 'show_purchased_tab', '=', true ),
        ),
        array(
            'id'      =>'purchased_tab_content',
            'type'    => 'textarea',
            'title'   => __( 'Tab content', 'azin-file' ),
            'default' => __( 'You have already purchased this product and you can download the product files from this section.', 'azin-file' ),
            'allowed_html' => array(
                    'a'     => array(
                    'href'  => array(),
                    'title'    => array()
                ),
                'br'     => array(),
                'em'     => array(),
                'strong' => array()
            ),
            'required' => array( 'show_purchased_tab', '=', true ),
        ),
        array(
            'id'       => 'change_purchased_text_course',
            'type'     => 'switch',
            'title'    => __( 'Change text for courses', 'azin-file' ),
            'subtitle' => __( 'If you are selling training course products, you can change the text of this type of products from this section.', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_purchased_tab', '=', true ),
        ),
        array(
            'id'       => 'purchased_course_tab_title',
            'type'     => 'text',
            'title'    => __( 'Course tab title', 'azin-file' ),
            'default'  => __( 'Download course', 'azin-file' ),
            'required' => array( 'change_purchased_text_course', '=', true ),
        ),
        array(
            'id'      => 'purchased_course_tab_content',
            'type'    => 'textarea',
            'title'   => __( 'Course tab content', 'azin-file' ),
            'default' => __( 'You have already purchased this course and you can download the course files from this section.', 'azin-file' ),
            'allowed_html' => array(
                    'a'     => array(
                    'href'  => array(),
                    'title'    => array()
                ),
                'br'     => array(),
                'em'     => array(),
                'strong' => array()
            ),
            'required' => array( 'change_purchased_text_course', '=', true ),
        ),
        array(
            'id'       => 'purchased_tab_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Tab icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-download',
            'options'  => $alliconArray,
            'required' => array( 'show_purchased_tab', '=', true ),
        ),
        array(
            'id'     => 'section-purchased-download-links-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //Section help buy start
        array(
            'id'     => 'section-help-buy-start',
            'type'   => 'section',
            'title'    => __( 'Product purchase guide settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_msg_help',
            'type'     => 'switch',
            'title'    => __( 'Product purchase guide', 'azin-file' ),
            'subtitle' => __( 'Display a block to display the text of the shopping guide', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'msg_help_free_not',
            'type'     => 'switch',
            'title'    => __( 'No display in free products', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_msg_help', '=', true ),
        ),
        array(
            'id'       => 'msg_help_color',
            'type'     => 'select',
            'title'    => __( 'Message color', 'azin-file' ),
            'options'  => array(
                'alert-primary'   =>  __( 'Blue', 'azin-file' ),
                'alert-info'      =>  __( 'Light Blue', 'azin-file' ),
                'alert-warning'   =>  __( 'Yellow', 'azin-file' ),
                'alert-success'   =>  __( 'Green', 'azin-file' ),
                'alert-light'     =>  __( 'White', 'azin-file' ),
                'alert-secondary' =>  __( 'Grey', 'azin-file' ),
                'alert-danger'    =>  __( 'Red', 'azin-file' ),
                'alert-dark'      =>  __( 'Dark Grey', 'azin-file' ),
            ),
            'default'  => 'alert-info',
            'required' => array( 'show_msg_help', '=', true ),
        ),
        array(
            'id'       => 'msg_title',
            'type'     => 'text',
            'title'    => __( 'Help Title', 'azin-file' ),
            'default'  => __( 'Shopping Guide:', 'azin-file' ),   
            'required' => array( 'show_msg_help', '=', true ),
        ),
        array(
            'id'      => 'msg_help',
            'type'    => 'editor',
            'title'   => __( 'Help text', 'azin-file' ),
            'desc'    => __( 'You can also use the shortcode', 'azin-file' ),
            'default' => __( '<ul>
            <li> The file download link will be displayed immediately after payment. </li>
            <li> The download link will also be sent to your email, so enter your email carefully. </li>
            <li> An email may have been sent to your Spam or Bulk email folder. </li>
            <li> Contact us if you could not download the file for any reason. </li>
            </ul>', 'azin-file' ),
            'args'    => array(
                'wpautop'       => false,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'show_msg_help', '=', true ),
        ),
        array(
            'id'     => 'section-help-buy-end',
            'type'   => 'section',
            'indent' => false,
        ),
    ),
) );

//Thumbnail settings
Redux::setSection( $opt_name, array(
    'title'      => __( 'Thumbnail', 'azin-file' ),
    'icon'       => 'fa fa-image',
    'id'         => 'thubm-settings',
    'desc'       => __( 'Thumbnail Settings', 'azin-file' ),
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'show_video_thumb',
            'type'     => 'switch',
            'title'    => __( 'Display preview video or music instead of product thumbnail image', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_video_thumb_block',
            'type'     => 'switch',
            'title'    => __( 'Display preview video or music instead of product thumbnail image in product blocks', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_video_thumb', '=', true ),
        ),
        array(
            'id'       => 'show_aparat_thumb',
            'type'     => 'switch',
            'title'    => __( 'Show aparat videos instead of thumbnail image', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_video_thumb', '=', true ),
        ),
        array(
            'id'       => 'show_audio_thumb',
            'type'     => 'switch',
            'title'    => __( 'Show Preview music instead of thumbnail image', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_video_thumb', '=', true ),
        ),
        array(
            'id'       => 'show_post_thumb',
            'type'     => 'switch',
            'title'    => __( 'Display the thumbnail of the post at the top of the post content', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_post_thumb_video',
            'type'     => 'switch',
            'title'    => __( 'Replace the thumbnail image with a video', 'azin-file' ),
            'subtitle' => __( 'With this feature, you can display a video instead of a thumbnail at the top of the post content', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'square_widget',
            'type'     => 'switch',
            'title'    => __( 'Square style instead of circle', 'azin-file' ),
            'subtitle' => __( 'By activating this option, the thumbnails of the widgets will be displayed in a square mode.', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'firt_img_gallery',
            'type'     => 'switch',
            'title'    => __( 'Display the thumbnail image in the product image gallery', 'azin-file' ),
            'subtitle' => __( 'By activating this option, the product thumbnail image will be displayed in the product image gallery.', 'azin-file' ),
            'default'  => false,
        ),

        // Thumbnail size settings
        array(
            'id'     => 'section-thumbnail-size-settings-start',
            'type'   => 'section',
            'title'    => __( 'Thumbnail size settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'square_thumb',
            'type'     => 'switch',
            'title'    => __( 'Square thumbnail image', 'azin-file' ),
            'description' => __( 'By changing this option once, all thumbnails should be reproduced by the regenerate thumbnails plugin.', 'azin-file' ),
            'subtitle' => __( 'By activating this option, the thumbnails of the products will change to square.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'custom_thumb',
            'type'     => 'switch',
            'title'    => __( 'Custom thumbnail image', 'azin-file' ),
            'description' => __( 'By changing this option once, all thumbnails should be reproduced by the regenerate thumbnails plugin.', 'azin-file' ),
            'subtitle' => __( 'By activating this option, you can define the size of thumbnails of products and posts according to your taste.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'custom_thumb_width',
            'type'     => 'text',
            'title'    => __( 'Thumbnail width', 'azin-file' ),
            'default'  => '472',
            'required' => array( 'custom_thumb', '=', true ),
        ),
        array(
            'id'       => 'custom_thumb_height',
            'type'     => 'text',
            'title'    => __( 'Thumbnail height', 'azin-file' ),
            'default'  => '267',
            'required' => array( 'custom_thumb', '=', true ),
        ),

        //Product page custom thumbnail
        array(
            'id'       => 'product_custom_thumb',
            'type'     => 'switch',
            'title'    => __( 'Separate the thumbnail image size of product page', 'azin-file' ),
            'description' => __( 'By changing this option once, all thumbnails should be reproduced by the regenerate thumbnails plugin.', 'azin-file' ),
            'subtitle' => __( 'By activating this option, you can separate the thumbnail size of the product page from other sizes.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'product_custom_thumb_width',
            'type'     => 'text',
            'title'    => __( 'Product page thumbnail width', 'azin-file' ),
            'default'  => '472',
            'required' => array( 'product_custom_thumb', '=', true ),
        ),
        array(
            'id'       => 'product_custom_thumb_height',
            'type'     => 'text',
            'title'    => __( 'Product page thumbnail height', 'azin-file' ),
            'default'  => '267',
            'required' => array( 'product_custom_thumb', '=', true ),
        ),
        
        //Post custom thumbnail
        array(
            'id'       => 'post_custom_thumb',
            'type'     => 'switch',
            'title'    => __( 'Separate the thumbnail image size of posts from products', 'azin-file' ),
            'description' => __( 'By changing this option once, all thumbnails should be reproduced by the regenerate thumbnails plugin.', 'azin-file' ),
            'subtitle' => __( 'By activating this option, you can separate the thumbnail size of the posts from the products.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'post_custom_thumb_width',
            'type'     => 'text',
            'title'    => __( 'Post width thumbnail', 'azin-file' ),
            'default'  => '472',
            'required' => array( 'post_custom_thumb', '=', true ),
        ),
        array(
            'id'       => 'post_custom_thumb_height',
            'type'     => 'text',
            'title'    => __( 'Post thumbnail height', 'azin-file' ),
            'default'  => '267',
            'required' => array( 'post_custom_thumb', '=', true ),
        ),
        array(
            'id'     => 'section-thumbnail-size-settings-end',
            'type'   => 'section',
            'indent' => false,
        ),
    )
) );

//Price settings
Redux::setSection( $opt_name, array(
    'title'      => __( 'Price settings', 'azin-file' ),
    'icon'       => 'fa fa-dollar-sign',
    'id'         => 'price-settings',
    'desc'       => __( 'Price Settings', 'azin-file' ),
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'toman_currency',
            'type'     => 'switch',
            'title'    => __( 'Toman Price', 'azin-file' ),
            'subtitle' => __( 'Show product prices in Tomans ( in EDD mode)', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'currency_sep',
            'type'     => 'switch',
            'title'    => __( 'Separator of numbers', 'azin-file' ),
            'subtitle' => __( 'Separator of numbers in the form of three digits, three digits ( in EDD mode)', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'free_price',
            'type'     => 'switch',
            'title'    => __( 'Free price', 'azin-file' ),
            'subtitle' => __( 'Show free phrase instead of zero in free products', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'free_price_remove_buy',
            'type'     => 'switch',
            'title'    => __( 'Remove the buy button on free products', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'free_logged',
            'type'     => 'switch',
            'title'    => __( 'Download for members', 'azin-file' ),
            'subtitle' => __( 'Download free priced files for members only', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'free_logged_link',
            'type'     => 'text',
            'title'    => __( 'Text link', 'azin-file' ),
            'subtitle'  => __( 'Link the displayed text to a specific address? Leave blank if there is no link', 'azin-file' ), 
            'default'  => '',
            'required' => array( 'free_logged', '=', true ),
        ),
    )
) );

//Related Products Settings
Redux::setSection( $opt_name, array(
    'title'      => __( 'Related products', 'azin-file' ),
    'icon'       => 'fa fa-shopping-bag',
    'id'         => 'related-product-settings',
    'desc'       => __( 'Related products settings', 'azin-file' ),
    'subsection' => true,
    'fields'     => array(
        //section-related-prod-start
        array(
            'id'     => 'section-related-prod-start',
            'type'   => 'section',
            'title'    => __( 'Related product settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_related_p',
            'type'     => 'switch',
            'title'    => __( 'Related products', 'azin-file' ),
            'subtitle' => __( 'Show related products section on product page', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'show_related_top',
            'type'     => 'switch',
            'title'    => __( 'Show related products above the product description', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'related_p_title',
            'type'     => 'text',
            'title'    => __( 'Block title', 'azin-file' ),
            'default'  => __( 'Related products', 'azin-file' ),   
            'required' => array( 'show_related_p', '=', true ),
        ),
        array(
            'id'       => 'related_p_count',
            'type'     => 'text',
            'title'    => __( 'Number of products', 'azin-file' ),
            'default'  => 8,   
            'required' => array( 'show_related_p', '=', true ),
        ),
        array(
            'id'       => 'related_pcol_count',
            'type'     => 'text',
            'title'    => __( 'Number of product columns', 'azin-file' ),
            'default'  => 4,   
            'required' => array( 'show_related_p', '=', true ),
        ),
        array(
            'id'       => 'related_p_by',
            'type'     => 'select',
            'title'    => __( 'Show Related products by', 'azin-file' ),
            'options'  => array(
                'download_tag'  =>  __( 'Product tags', 'azin-file' ),
                'download_category' =>  __( 'Product category', 'azin-file' )
            ),
            'default'  => 'download_tag',
            'required' => array( 'show_related_p', '=', true ),
        ),
        array(
            'id'     => 'section-related-prod-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //section-related-prod-end

        //up-sells-section-start
        array(
            'id' => 'up-sells-section-start',
            'type' => 'section',
            'title'    => __( 'Up-selling products settings (In WooCommerce mode)', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_up_sells',
            'type'     => 'switch',
            'title'    => __( 'Show up-selling products', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'show_up_sells_top',
            'type'     => 'switch',
            'title'    => __( 'Show up-selling products above the product description', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'up_sells_title',
            'type'     => 'text',
            'title'    => __( 'Block title', 'azin-file' ),
            'default'  => __( 'You may also like', 'azin-file' ),                
            'required' => array( 'show_up_sells', '=', true ),
        ),
        array(
            'id'       => 'up-sells-section-end',
            'type'     => 'section',
            'indent'   => false,
        ),
        //up-sells-section-end

        //section-related-product-posts-start
        array(
            'id'     => 'section-related-product-posts-start',
            'type'   => 'section',
            'title'    => __( 'Product related posts settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_related_product_posts',
            'type'     => 'switch',
            'title'    => __( 'Show related posts in product page', 'azin-file' ),
            'subtitle' => __( 'By activating this option, posts related to the product will be displayed on the product page. These posts are selected by the same tag as the product.', 'azin-file' ),   
            'default'  => false,
        ),
        array(
            'id'       => 'related_product_posts_title',
            'type'     => 'text',
            'title'    => __( 'Block title', 'azin-file' ),
            'default'  => __( 'Related posts', 'azin-file' ),   
            'required' => array( 'show_related_product_posts', '=', true ),
        ),
        array(
            'id'       => 'related_product_posts_count',
            'type'     => 'text',
            'title'    => __( 'Number of posts', 'azin-file' ),
            'default'  => 8,   
            'required' => array( 'show_related_product_posts', '=', true ),
        ),
        array(
            'id'       => 'related_product_posts_col_count',
            'type'     => 'text',
            'title'    => __( 'Number of posts columns', 'azin-file' ),
            'default'  => 4,   
            'required' => array( 'show_related_product_posts', '=', true ),
        ),
        array(
            'id'       => 'related_product_posts_by',
            'type'     => 'select',
            'title'    => __( 'Show Related posts by', 'azin-file' ),
            'options'  => array(
                'tag'     =>  __( 'Tags', 'azin-file' ),
                'manual'  =>  __( 'Manual selection', 'azin-file' )
            ),
            'default'  => 'tag',
            'required' => array( 'show_related_product_posts', '=', true ),
        ),
        array(
            'id'     => 'section-related-product-posts-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //section-related-product-posts-end
    )
) );

//Related Posts Settings
Redux::setSection( $opt_name, array(
    'title'      => __( 'Related posts', 'azin-file' ),
    'icon'       => 'fa fa-file',
    'id'         => 'related-posts-settings',
    'desc'       => __( 'Related posts settings', 'azin-file' ),
    'subsection' => true,
    'fields'     => array(

        //section-related-post-start
        array(
            'id'     => 'section-related-post-start',
            'type'   => 'section',
            'title'    => __( 'Related posts settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_related_s',
            'type'     => 'switch',
            'title'    => __( 'Related posts', 'azin-file' ),
            'subtitle' => __( 'Show related posts section on the posts page', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'related_s_title',
            'type'     => 'text',
            'title'    => __( 'Block title', 'azin-file' ),
            'default'  => __( 'Related posts', 'azin-file' ),   
            'required' => array( 'show_related_s', '=', true ),
        ),
        array(
            'id'       => 'related_s_count',
            'type'     => 'text',
            'title'    => __( 'Number of posts', 'azin-file' ),
            'default'  => 8,   
            'required' => array( 'show_related_s', '=', true ),
        ),
        array(
            'id'       => 'related_scol_count',
            'type'     => 'text',
            'title'    => __( 'Number of post columns', 'azin-file' ),
            'default'  => 4,   
            'required' => array( 'show_related_s', '=', true ),
        ),
        array(
            'id'       => 'related_s_by',
            'type'     => 'select',
            'title'    => __( 'Show related posts by', 'azin-file' ),
            'options'  => array(
                'post_tag'  =>  __( 'Post tag', 'azin-file' ),
                'category' =>  __( 'Post category', 'azin-file' )
            ),
            'default'  => 'post_tag',
            'required' => array( 'show_related_s', '=', true ),
        ),
        array(
            'id'     => 'section-related-post-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //section-related-post-end

        //section-related-post-products-start
        array(
            'id'     => 'section-related-post-products-start',
            'type'   => 'section',
            'title'    => __( 'Post related products settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_related_post_products',
            'type'     => 'switch',
            'title'    => __( 'Show related products in post page', 'azin-file' ),
            'subtitle' => __( 'By activating this option, Products related to the post will be displayed on the post page. These products are selected by the same tag as the post.', 'azin-file' ),   
            'default'  => false,
        ),
        array(
            'id'       => 'related_post_products_title',
            'type'     => 'text',
            'title'    => __( 'Block title', 'azin-file' ),
            'default'  => __( 'Related products', 'azin-file' ),
            'required' => array( 'show_related_post_products', '=', true ),
        ),
        array(
            'id'       => 'related_post_products_count',
            'type'     => 'text',
            'title'    => __( 'Number of products', 'azin-file' ),
            'default'  => 8,
            'required' => array( 'show_related_post_products', '=', true ),
        ),
        array(
            'id'       => 'related_post_products_col_count',
            'type'     => 'text',
            'title'    => __( 'Number of product columns', 'azin-file' ),
            'default'  => 4,
            'required' => array( 'show_related_post_products', '=', true ),
        ),
        array(
            'id'       => 'related_post_products_by',
            'type'     => 'select',
            'title'    => __( 'Show Related products by', 'azin-file' ),
            'options'  => array(
                'tag'     =>  __( 'Tags', 'azin-file' ),
                'manual'  =>  __( 'Manual selection', 'azin-file' )
            ),
            'default'  => 'tag',
            'required' => array( 'show_related_post_products', '=', true ),
        ),
        array(
            'id'     => 'section-related-post-products-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //section-related-post-products-end
    )
) );

//Post Settings
Redux::setSection( $opt_name, array(
    'title'      => __( 'Post settings', 'azin-file' ),
    'icon'       => 'fa fa-file-alt',
    'id'         => 'posts-settings',
    'desc'       => __( 'Manage post settings', 'azin-file' ),
    'subsection' => true,
    'fields'     => array(
        array(
                'id'       => 'show_post_author',
                'type'     => 'switch',
                'title'    => __( 'Show author name', 'azin-file' ),
                'default'  => true,
        ),
        array(
                'id'       => 'show_post_date',
                'type'     => 'switch',
                'title'    => __( 'Display release date', 'azin-file' ),
                'default'  => true,
        ),
        array(
                'id'       => 'show_post_cat',
                'type'     => 'switch',
                'title'    => __( 'Show categories', 'azin-file' ),
                'default'  => true,
        ),
        array(
                'id'       => 'show_post_view',
                'type'     => 'switch',
                'title'    => __( 'Show traffic', 'azin-file' ),
                'default'  => true,
        ),

        //Section post settings on the main page and archive pages
        array(
            'id'     => 'section-post-settings-main-page-archive-start',
            'type'   => 'section',
            'title'    => __( 'Post settings on the main page and archive pages', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_post_cat_archive',
            'type'     => 'switch',
            'title'    => __( 'Show post category on the thumbnail image', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'post_cat_style',
            'type'     => 'select',
            'title'    => __( 'Post category style', 'azin-file' ),
            'options'  => array(
                'first' => __( 'First style', 'azin-file' ),
                'second' =>  __( 'Second style', 'azin-file' ),
            ),
            'default'  => 'first',
            'required' => array( 'show_post_cat_archive', '=', true ),
        ),
        array(
            'id'       => 'show_post_pub',
            'type'     => 'switch',
            'title'    => __( 'Show post publish date on the thumbnail image', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'post_pub_style',
            'type'     => 'select',
            'title'    => __( 'Post publish date style', 'azin-file' ),
            'options'  => array(
                'first' => __( 'First style', 'azin-file' ),
                'second' =>  __( 'Second style', 'azin-file' ),
            ),
            'default'  => 'first',
            'required' => array( 'show_post_pub', '=', true ),
        ),
        array(
            'id'       => 'show_post_author_archive',
            'type'     => 'switch',
            'title'    => __( 'Show the name of the author', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'link_post_author',
            'type'     => 'switch',
            'title'    => __( 'Link author name to author page', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_post_author', '=', true ),
        ),
        array(
            'id'       => 'show_excerpt',
            'type'     => 'switch',
            'title'    => __( 'View post summary', 'azin-file' ),
            'subtitle' => __( 'Display post summaries below post titles on the home page and archive pages', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'     => 'section-post-settings-main-page-archive-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //Section author box start
        array(
            'id'     => 'section-post-author-box-start',
            'type'   => 'section',
            'title'    => __( 'Author information block settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_author_box',
            'type'     => 'switch',
            'title'    => __( 'Show post author information block', 'azin-file' ),
            'subtitle' => __( 'Display a block for author information on the post page', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_author_box_avatar',
            'type'     => 'switch',
            'title'    => __( 'Show author avatar', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_author_box', '=', true ),
        ),
        array(
            'id'       => 'show_author_box_name',
            'type'     => 'switch',
            'title'    => __( 'Show author name', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_author_box', '=', true ),
        ),
        array(
            'id'       => 'show_author_box_bio',
            'type'     => 'switch',
            'title'    => __( 'Show the biography of the author', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_author_box', '=', true ),
        ),
        array(
            'id'       => 'show_author_box_products',
            'type'     => 'switch',
            'title'    => __( 'Show number of products', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_author_box', '=', true ),
        ),
        array(
            'id'       => 'show_author_box_courses',
            'type'     => 'switch',
            'title'    => __( 'Show number of courses', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_author_box', '=', true ),
        ),
        array(
            'id'       => 'show_author_box_posts',
            'type'     => 'switch',
            'title'    => __( 'Show number of posts', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_author_box', '=', true ),
        ),
        array(
            'id'       => 'show_author_box_regdate',
            'type'     => 'switch',
            'title'    => __( 'Show registration date', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_author_box', '=', true ),
        ),
        array(
            'id'     => 'section-post-author-box-end',
            'type'   => 'section',
            'indent' => false,
        ),
    )
) );

//Product Types
Redux::setSection( $opt_name, array(
    'title'      => __( 'Product Types', 'azin-file' ),
    'icon'       => 'fa fa-folders',
    'id'         => 'product-types',
    'desc'       => __( 'In this section, you can add up to five new custom product types to the types available on the product edit page (such as video, image, etc.)', 'azin-file' ),
    'subsection' => true,
    'fields'     => array(
        array(
                'id'       => 'product_type1',
                'type'     => 'switch',
                'title'    => __( 'First Product type', 'azin-file' ),
                'default'  => false,
        ),
        array(
            'id'       => 'product_type1_title',
            'type'     => 'text',
            'title'    => __( 'First Product type title', 'azin-file' ),
            'default'  => __( 'First', 'azin-file' ),   
            'required' => array( 'product_type1', '=', true ),
        ),
        array(
            'id'       => 'product_type1_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'First Product type icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-file-alt',
            'options'  => $alliconArray,
            'required' => array( 'product_type1', '=', true ),
        ),
        array(
            'id'       => 'product_type2',
            'type'     => 'switch',
            'title'    => __( 'Second Product type', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'product_type2_title',
            'type'     => 'text',
            'title'    => __( 'Second Product type title', 'azin-file' ),
            'default'  => __( 'Second', 'azin-file' ),   
            'required' => array( 'product_type2', '=', true ),
        ),
        array(
            'id'       => 'product_type2_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Second Product type icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-file-alt',
            'options'  => $alliconArray,
            'required' => array( 'product_type2', '=', true ),
        ),
        array(
                'id'       => 'product_type3',
                'type'     => 'switch',
                'title'    => __( 'Third Product type', 'azin-file' ),
                'default'  => false,
        ),
        array(
            'id'       => 'product_type3_title',
            'type'     => 'text',
            'title'    => __( 'Third Product type title', 'azin-file' ),
            'default'  => __( 'Third', 'azin-file' ),   
            'required' => array( 'product_type3', '=', true ),
        ),
        array(
            'id'       => 'product_type3_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Third Product type icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-file-alt',
            'options'  => $alliconArray,
            'required' => array( 'product_type3', '=', true ),
        ),
        array(
            'id'       => 'product_type4',
            'type'     => 'switch',
            'title'    => __( 'Fourth Product type', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'product_type4_title',
            'type'     => 'text',
            'title'    => __( 'Fourth Product type title', 'azin-file' ),
            'default'  => __( 'Fourth', 'azin-file' ),   
            'required' => array( 'product_type4', '=', true ),
        ),
        array(
            'id'       => 'product_type4_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Fourth Product type icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-file-alt',
            'options'  => $alliconArray,
            'required' => array( 'product_type4', '=', true ),
        ),
        array(
            'id'       => 'product_type5',
            'type'     => 'switch',
            'title'    => __( 'Fifth Product type', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'product_type5_title',
            'type'     => 'text',
            'title'    => __( 'Fifth Product type title', 'azin-file' ),
            'default'  => __( 'Fifth', 'azin-file' ),   
            'required' => array( 'product_type5', '=', true ),
        ),
        array(
            'id'       => 'product_type5_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Fifth Product type icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-file-alt',
            'options'  => $alliconArray,
            'required' => array( 'product_type5', '=', true ),
        ),
    )
) );

//Product badges
Redux::setSection( $opt_name, array(
    'title'      => __( 'Product badges', 'azin-file' ),
    'icon'       => 'fa fa-star',
    'id'         => 'product-badges',
    'desc'       => __( 'In this section, you can add up to six custom product badges to product edit page', 'azin-file' ),
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'product_badges',
            'type'     => 'switch',
            'title'    => __( 'Enable Product badges', 'azin-file' ),
            'subtitle'     => __( 'By activating this feature, you can define badges for products. Also, a box on the product editing page to select product badges and a widget to display badges on the product page will be added to your site.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'product_badges_style',
            'type'     => 'select',
            'title'    => __( 'Product badge style', 'azin-file' ),
            'options'  => array(
                'azin-circle-badge'  =>  __( 'Circle', 'azin-file' ),
                'azin-square-badge'  =>  __( 'Square', 'azin-file' ),
            ),
            'default'  => 'azin-circle-badge',
            'required' => array( 'product_badges', '=', true ),
        ),
        //Product badge 1
        array(
                'id'       => 'product_badge1',
                'type'     => 'switch',
                'title'    => __( 'First Product badge', 'azin-file' ),
                'default'  => false,
        ),
        array(
            'id'       => 'product_badge1_title',
            'type'     => 'text',
            'title'    => __( 'First Product badge title', 'azin-file' ),
            'default'  => __( 'First badge', 'azin-file' ), 
            'required' => array( 'product_badge1', '=', true ),
        ),
        array(
            'id'       => 'product_badge1_bg',
            'type'     => 'color',
            'title'    => __( 'First Product badge background color', 'azin-file' ),
            'default'  => '#81A5F5',
            'validate' => 'color',
            'transparent' => true,
            'required' => array( 'product_badge1', '=', true ),
        ),
        array(
            'id'       => 'product_badge1_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'First Product badge icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-check',
            'options'  => $alliconArray,
            'required' => array( 'product_badge1', '=', true ),
        ),
        array(
            'id'       => 'product_badge1_image',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Or upload icon image', 'azin-file' ),
            'compiler' => 'true',
            'subtitle' => __( 'Suitable size: 60 pixels (width) and 60 pixels (height)', 'azin-file' ),
            'required' => array( 'product_badge1', '=', true ),
        ),
        //Product badge 2
        array(
            'id'       => 'product_badge2',
            'type'     => 'switch',
            'title'    => __( 'Second Product badge', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'product_badge2_title',
            'type'     => 'text',
            'title'    => __( 'Second Product badge title', 'azin-file' ),
            'default'  => __( 'Second badge', 'azin-file' ),   
            'required' => array( 'product_badge2', '=', true ),
        ),
        array(
            'id'       => 'product_badge2_bg',
            'type'     => 'color',
            'title'    => __( 'Second Product badge background color', 'azin-file' ),
            'default'  => '#FEA000',
            'validate' => 'color',
            'transparent' => true,
            'required' => array( 'product_badge2', '=', true ),
        ),
        array(
            'id'       => 'product_badge2_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Second Product badge icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-shield-check',
            'options'  => $alliconArray,
            'required' => array( 'product_badge2', '=', true ),
        ),
        array(
            'id'       => 'product_badge2_image',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Or upload icon image', 'azin-file' ),
            'compiler' => 'true',
            'subtitle' => __( 'Suitable size: 60 pixels (width) and 60 pixels (height)', 'azin-file' ),
            'required' => array( 'product_badge2', '=', true ),
        ),
        //Product badge 3
        array(
                'id'       => 'product_badge3',
                'type'     => 'switch',
                'title'    => __( 'Third Product badge', 'azin-file' ),
                'default'  => false,
        ),
        array(
            'id'       => 'product_badge3_title',
            'type'     => 'text',
            'title'    => __( 'Third Product badge title', 'azin-file' ),
            'default'  => __( 'Third badge', 'azin-file' ),
            'required' => array( 'product_badge3', '=', true ),
        ),
        array(
            'id'       => 'product_badge3_bg',
            'type'     => 'color',
            'title'    => __( 'Third Product badge background color', 'azin-file' ),
            'default'  => '#0FC9E8',
            'validate' => 'color',
            'transparent' => true,
            'required' => array( 'product_badge3', '=', true ),
        ),
        array(
            'id'       => 'product_badge3_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Third Product badge icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-gem',
            'options'  => $alliconArray,
            'required' => array( 'product_badge3', '=', true ),
        ),
        array(
            'id'       => 'product_badge3_image',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Or upload icon image', 'azin-file' ),
            'compiler' => 'true',
            'subtitle' => __( 'Suitable size: 60 pixels (width) and 60 pixels (height)', 'azin-file' ),
            'required' => array( 'product_badge3', '=', true ),
        ),
        //Product badge 4
        array(
            'id'       => 'product_badge4',
            'type'     => 'switch',
            'title'    => __( 'Fourth Product badge', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'product_badge4_title',
            'type'     => 'text',
            'title'    => __( 'Fourth Product badge title', 'azin-file' ),
            'default'  => __( 'Fourth badge', 'azin-file' ),   
            'required' => array( 'product_badge4', '=', true ),
        ),
        array(
            'id'       => 'product_badge4_bg',
            'type'     => 'color',
            'title'    => __( 'Fourth Product badge background color', 'azin-file' ),
            'default'  => '#388E3C',
            'validate' => 'color',
            'transparent' => true,
            'required' => array( 'product_badge4', '=', true ),
        ),
        array(
            'id'       => 'product_badge4_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Fourth Product badge icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-play',
            'options'  => $alliconArray,
            'required' => array( 'product_badge4', '=', true ),
        ),
        array(
            'id'       => 'product_badge4_image',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Or upload icon image', 'azin-file' ),
            'compiler' => 'true',
            'subtitle' => __( 'Suitable size: 60 pixels (width) and 60 pixels (height)', 'azin-file' ),
            'required' => array( 'product_badge4', '=', true ),
        ),
        //Product badge 5
        array(
            'id'       => 'product_badge5',
            'type'     => 'switch',
            'title'    => __( 'Fifth Product badge', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'product_badge5_title',
            'type'     => 'text',
            'title'    => __( 'Fifth Product badge title', 'azin-file' ),
            'default'  => __( 'Fifth badge', 'azin-file' ),   
            'required' => array( 'product_badge5', '=', true ),
        ),
        array(
            'id'       => 'product_badge5_bg',
            'type'     => 'color',
            'title'    => __( 'Fifth Product badge background color', 'azin-file' ),
            'default'  => '#8360A8',
            'validate' => 'color',
            'transparent' => true,
            'required' => array( 'product_badge5', '=', true ),
        ),
        array(
            'id'       => 'product_badge5_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Fifth Product badge icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-music',
            'options'  => $alliconArray,
            'required' => array( 'product_badge5', '=', true ),
        ),
        array(
            'id'       => 'product_badge5_image',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Or upload icon image', 'azin-file' ),
            'compiler' => 'true',
            'subtitle' => __( 'Suitable size: 60 pixels (width) and 60 pixels (height)', 'azin-file' ),
            'required' => array( 'product_badge5', '=', true ),
        ),
        //Product badge 6
        array(
            'id'       => 'product_badge6',
            'type'     => 'switch',
            'title'    => __( 'Sixth Product badge', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'product_badge6_title',
            'type'     => 'text',
            'title'    => __( 'Sixth Product badge title', 'azin-file' ),
            'default'  => __( 'Sixth badge', 'azin-file' ),
            'required' => array( 'product_badge6', '=', true ),
        ),
        array(
            'id'       => 'product_badge6_bg',
            'type'     => 'color',
            'title'    => __( 'Sixth Product badge background color', 'azin-file' ),
            'default'  => '#EA5C5C',
            'validate' => 'color',
            'transparent' => true,
            'required' => array( 'product_badge6', '=', true ),
        ),
        array(
            'id'       => 'product_badge6_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Sixth Product badge icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-code',
            'options'  => $alliconArray,
            'required' => array( 'product_badge6', '=', true ),
        ),
        array(
            'id'       => 'product_badge6_image',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Or upload icon image', 'azin-file' ),
            'compiler' => 'true',
            'subtitle' => __( 'Suitable size: 60 pixels (width) and 60 pixels (height)', 'azin-file' ),
            'required' => array( 'product_badge6', '=', true ),
        ),
    )
) );

//Quick Access Buttons
Redux::setSection( $opt_name, array(
    'title'      => __( 'Quick Access Buttons', 'azin-file' ),
    'icon'       => 'fa fa-hand-point-up',
    'id'         => 'quick-access',
    'desc'       => __( 'In this section, you can manage product quick access buttons.', 'azin-file' ),
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'show_quick_access_btns',
            'type'     => 'switch',
            'title'    => __( 'Show quick access buttons', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_btn_add_cart',
            'type'     => 'switch',
            'title'    => __( 'Show the add to cart or view product button', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_quick_access_btns', '=', true ),
        ),
        array(
            'id'       => 'show_btn_quick_view',
            'type'     => 'switch',
            'title'    => __( 'Show quick view button', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_quick_access_btns', '=', true ),
        ),
        array(
            'id'       => 'quick_view_style_two',
            'type'     => 'switch',
            'title'    => __( 'Activate the second style of quick view', 'azin-file' ),
            'subtitle' => __( 'Suitable for index image with square ratio', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_btn_quick_view', '=', true ),
        ),
        array(
            'id'       => 'show_btn_like_product',
            'type'     => 'switch',
            'title'    => __( 'Show the Add to Wishlist button', 'azin-file' ),
            'subtitle' => __( 'In EDD mode, EDD Whislist plugin is needed and in WooCommerce mode, YITH WooCommerce Whishlist plugin is needed.', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_quick_access_btns', '=', true ),
        ),
    )
) );

//Download Box Settings
Redux::setSection( $opt_name, array(
    'title'      => __( 'Download Box', 'azin-file' ),
    'icon'       => 'fa fa-download',
    'id'         => 'dl-box-settings',
    'desc'       => __( 'Download Box Settings', 'azin-file' ),
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'show_dl_logged',
            'type'     => 'switch',
            'title'    => __( 'Show download box links to logged in users', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'dl_help_title',
            'type'     => 'text',
            'title'    => __( 'Download guide title', 'azin-file' ),
            'default'  => __( 'Download guide', 'azin-file' ),
        ), 
        array(
            'id'      => 'dl_help_text',
            'type'    => 'editor',
            'title'   => __( 'Download guide text', 'azin-file' ),
            'desc'    => __( 'You can also use the shortcode', 'azin-file' ),
            'default' => __( '<ul>
            <li> Use download management software for better downloads. </li>
            <li> If you have a password, enter it directly and refrain from copying. </li>
            <li> Install the latest version of Winrar if you see an error in the zip file. </li>
            </ul>', 'azin-file' ),
            'args'    => array(
                'wpautop'       => false,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
        ),
        array(
            'id'       => 'dl_box_pass',
            'type'     => 'text',
            'title'    => __( 'Default Password', 'azin-file' ),
            'subtitle' => __( 'This item can be set for each post individually on the post page', 'azin-file' ),
            'default'  => 'www.example.com',
        ),
    )
) );

//Product Preview Btn
Redux::setSection( $opt_name, array(
    'title'      => __( 'Product Preview Button', 'azin-file' ),
    'icon'       => 'fa fa-desktop',
    'id'         => 'product-preview-btn',
    'desc'       => __( 'Product preview button settings. You can manage this button for each product separately.', 'azin-file' ),
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'show_pre_prod_btn_under',
            'type'     => 'switch',
            'title'    => __( 'Display the product preview button under the buy button', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'text_pre',
            'type'     => 'text',
            'title'    => __( 'Button title', 'azin-file' ),
            'default'  => __( 'Preview', 'azin-file' ),
        ),
        array(
            'id'       => 'pre_prod_btn_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fa' ),
            'title'    => __( 'Button icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-desktop',
            'options'  => $alliconArray,
        ),
        array(
            'id'       => 'pre_prod_btn_color',
            'type'     => 'select',
            'title'    => __( 'Button color', 'azin-file' ),
            'options'  => array(
                'btn-info'  =>  __( 'Blue', 'azin-file' ),
                'btn-primary'  =>  __( 'Dark Blue', 'azin-file' ),
                'btn-warning' =>  __( 'Yellow', 'azin-file' ),
                'btn-success'  =>  __( 'Green', 'azin-file' ),
                'btn-dark'  =>  __( 'Dark', 'azin-file' ),
                'btn-danger'  =>  __( 'Red', 'azin-file' )
            ),
            'default'  => 'btn-info',
            'required' => array( 'show_pre_prod_btn_under', '=', true ),
        ),
    )
) );

//Product Additional Btn
Redux::setSection( $opt_name, array(
    'title'      => __( 'Product Additional Button', 'azin-file' ),
    'icon'       => 'fa fa-plus-square',
    'id'         => 'product-extra-btn',
    'desc'       => __( 'Activate the Additional button on the product page and below the purchase button. You can manage this button for each product separately.', 'azin-file' ),
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'show_add_prod_btn',
            'type'     => 'switch',
            'title'    => __( 'Display Additional button in product page', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_add_prod_call',
            'type'     => 'switch',
            'title'    => __( 'Display Additional button in non-purchasable products', 'azin-file' ),
            'default'  => true,
            'required' => array( 'show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'add_prod_btn_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Display Additional button in specific categories', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_add_prod_btn', '=', true ),
        ),
        array(
            'id'    => 'add_prod_btn_cats',
            'type'     => 'select',
            'multi'    => true,
            'title'    => __( 'Categories', 'azin-file' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => $product_taxonomy,
                'hide_empty' => false,
            ),
            'required' => array( 'add_prod_btn_in_cats', '=', true )
        ),
        array(
            'id'       => 'add_prod_btn_not_cats',
            'type'     => 'switch',
            'title'    => __( 'Hide Additional button in specific categories', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_add_prod_btn', '=', true ),
        ),
        array(
            'id'    => 'add_prod_btn_ncats',
            'type'     => 'select',
            'multi'    => true,
            'title'    => __( 'Categories', 'azin-file' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => $product_taxonomy,
                'hide_empty' => false,
            ),
            'required' => array( 'add_prod_btn_not_cats', '=', true )
        ),
        array(
            'id'       => 'show_add_prod_single',
            'type'     => 'switch',
            'title'    => __( 'Display only in products whose link and button title are completed on the product edit page', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'add_prod_btn_title',
            'type'     => 'text',
            'title'    => __( 'Additional product button title', 'azin-file' ),
            'default'  => __( 'Title', 'azin-file' ),
            'required' => array( 'show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'add_prod_btn_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fa' ),
            'title'    => __( 'Additional product button icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-bell',
            'options'  => $alliconArray,
            'required' => array( 'show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'add_prod_btn_color',
            'type'     => 'select',
            'title'    => __( 'Button color', 'azin-file' ),
            'options'  => array(
                'btn-info'  =>  __( 'Blue', 'azin-file' ),
                'btn-primary'  =>  __( 'Dark Blue', 'azin-file' ),
                'btn-warning' =>  __( 'Yellow', 'azin-file' ),
                'btn-success'  =>  __( 'Green', 'azin-file' ),
                'btn-dark'  =>  __( 'Dark', 'azin-file' ),
                'btn-danger'  =>  __( 'Red', 'azin-file' )
            ),
            'default'  => 'btn-primary',
            'required' => array( 'show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'add_prod_btn_link',
            'type'     => 'text',
            'title'    => __( 'Additional product button link', 'azin-file' ),
            'default'  => __( '#', 'azin-file' ),
            'required' => array( 'show_add_prod_btn', '=', true ),
        ), 
    )
) );

//Product Fields
Redux::setSection( $opt_name, array(
    'title'      => __( 'Product Fields', 'azin-file' ),
    'icon'       => 'fa fa-tasks-alt',
    'id'         => 'product-fields',
    'desc'       => __( 'Edits product fields as needed.', 'azin-file' ),
    'subsection' => true,
    'fields'     => array(
            array(
                'id'       => 'show_fone',
                'type'     => 'switch',
                'title'    => __( 'Show the first field', 'azin-file' ),
                'default'  => true,
            ),
            array(
                'id'       => 'fone',
                'type'     => 'text',
                'title'    => __( 'First field', 'azin-file' ),
                'default'  => __( 'File Type', 'azin-file' ),   
                'required' => array( 'show_fone', '=', true ),
            ),
            array(
                'id'       => 'fone_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fal' ),
                'title'    => __( 'First field icon', 'azin-file' ),
                'class'    => ' azin-font-icon',
                'default'  => 'fa fa-file-alt',
                'options'  => $alliconArray,
                'required' => array( 'show_fone', '=', true ),
            ),
            array(
                'id'       => 'show_ftwo',
                'type'     => 'switch',
                'title'    => __( 'Show the second field', 'azin-file' ),
                'default'  => true,
            ),
            array(
                'id'       => 'ftwo',
                'type'     => 'text',
                'title'    => __( 'Second field', 'azin-file' ),
                'default'  => __( 'File Size', 'azin-file' ),   
                'required' => array( 'show_ftwo', '=', true ),
            ),
            array(
                'id'       => 'ftwo_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fal' ),
                'title'    => __( 'Second field icon', 'azin-file' ),
                'class'    => ' azin-font-icon',
                'default'  => 'fa fa-save',
                'options'  => $alliconArray,
                'required' => array( 'show_ftwo', '=', true ),
            ),
            array(
                'id'       => 'show_fthree',
                'type'     => 'switch',
                'title'    => __( 'Show the third field', 'azin-file' ),
                'default'  => true,
            ),
            array(
                'id'       => 'edit_fthree',
                'type'     => 'switch',
                'title'    => __( 'Edit the third field', 'azin-file' ),
                'subtitle' => __( 'Display the desired value instead of displaying the vendor of the file', 'azin-file' ),
                'default'  => false,
                'required' => array( 'show_fthree', '=', true ),
            ),
            array(
                'id'       => 'fthree',
                'type'     => 'text',
                'title'    => __( 'Third field', 'azin-file' ),
                'default'  => __( 'Vendor', 'azin-file' ),
                'required' => array( 'edit_fthree', '=', true ),
            ),
            array(
                'id'       => 'fthree_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fal' ),
                'title'    => __( 'Third field icon', 'azin-file' ),
                'class'    => ' azin-font-icon',
                'default'  => 'fa fa-user',
                'options'  => $alliconArray,
                'required' => array( 'edit_fthree', '=', true ),
            ),
            array(
                'id'       => 'show_ffour',
                'type'     => 'switch',
                'title'    => __( 'Show the fourth field', 'azin-file' ),
                'default'  => true,
            ),
            array(
                'id'       => 'edit_ffour',
                'type'     => 'switch',
                'title'    => __( 'Edit the fourth field', 'azin-file' ),
                'subtitle' => __( 'Display the desired value instead of displaying the publication date', 'azin-file' ),
                'default'  => false,
                'required' => array( 'show_ffour', '=', true ),
            ),
            array(
                'id'       => 'ffour',
                'type'     => 'text',
                'title'    => __( 'Fourth field', 'azin-file' ),
                'default'  => __( 'Date of Release', 'azin-file' ),
                'required' => array( 'edit_ffour', '=', true ),
            ),
            array(
                'id'       => 'ffour_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fal' ),
                'title'    => __( 'Fourth field icon', 'azin-file' ),
                'class'    => ' azin-font-icon',
                'default'  => 'fa fa-calendar',
                'options'  => $alliconArray,
                'required' => array( 'edit_ffour', '=', true ),
            ),
            array(
                'id'       => 'show_ffive',
                'type'     => 'switch',
                'title'    => __( 'Show the Fifth field', 'azin-file' ),
                'default'  => true,
            ),
            array(
                'id'       => 'edit_ffive',
                'type'     => 'switch',
                'title'    => __( 'Edit the fifth field', 'azin-file' ),
                'subtitle' => __( 'Display the desired value instead of displaying content categories', 'azin-file' ),
                'default'  => false,
                'required' => array( 'show_ffive', '=', true ),
            ),
            array(
                'id'       => 'ffive',
                'type'     => 'text',
                'title'    => __( 'Fifth field', 'azin-file' ),
                'default'  => __( 'Category', 'azin-file' ),
                'required' => array( 'edit_ffive', '=', true ),
            ),
            array(
                'id'       => 'ffive_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fal' ),
                'title'    => __( 'Fifth field icon', 'azin-file' ),
                'class'    => ' azin-font-icon',
                'default'  => 'fa fa-folder-open',
                'options'  => $alliconArray,
                'required' => array( 'edit_ffive', '=', true ),
            ),
            array(
                'id'       => 'show_fsix',
                'type'     => 'switch',
                'title'    => __( 'Show the sixth field', 'azin-file' ),
                'default'  => true,
            ),
            array(
                'id'       => 'edit_fsix',
                'type'     => 'switch',
                'title'    => __( 'Edit the sixth field', 'azin-file' ),
                'subtitle' => __( 'Display the desired value instead of displaying post views', 'azin-file' ),
                'default'  => false,
                'required' => array( 'show_fsix', '=', true ),
            ),
            
            array(
                'id'       => 'fsix',
                'type'     => 'text',
                'title'    => __( 'Sixth field', 'azin-file' ),
                'default'  => __( 'Number of visits', 'azin-file' ),
                'required' => array( 'edit_fsix', '=', true ),
            ),
            array(
                'id'       => 'fsix_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fal' ),
                'title'    => __( 'Sixth field icon', 'azin-file' ),
                'class'    => ' azin-font-icon',
                'default'  => 'fa fa-eye',
                'options'  => $alliconArray,
                'required' => array( 'edit_fsix', '=', true ),
            ),

        //Display product sales
        array(
                'id'       => 'show_dcount',
                'type'     => 'switch',
                'title'    => __( 'Display product sales', 'azin-file' ),
                'default'  => false,
        ),
        array(
            'id'       => 'edit_dcount',
            'type'     => 'switch',
            'title'    => __( 'Edit the product sales', 'azin-file' ),
            'subtitle' => __( 'Display the desired value instead of displaying product sales', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_dcount', '=', true ),
        ),
        array(
            'id'       => 'dcount_title',
            'type'     => 'text',
            'title'    => __( 'Product sales title', 'azin-file' ),
            'default'  => __( 'Number of sales', 'azin-file' ),
            'required' => array( 'edit_dcount', '=', true ),
        ),
        array(
            'id'       => 'dcount_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Product sales icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-shopping-bag',
            'options'  => $alliconArray,
            'required' => array( 'edit_dcount', '=', true ),
        ),

        //Display product update date
        array(
            'id'       => 'show_modified_date',
            'type'     => 'switch',
            'title'    => __( 'Display product update date', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'edit_modified_date',
            'type'     => 'switch',
            'title'    => __( 'Edit the product update date', 'azin-file' ),
            'subtitle' => __( 'Display the desired value instead of displaying product update date', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_modified_date', '=', true ),
        ),
        array(
            'id'       => 'modified_date_title',
            'type'     => 'text',
            'title'    => __( 'Product update date title', 'azin-file' ),
            'default'  => __( 'Update date', 'azin-file' ),
            'required' => array( 'edit_modified_date', '=', true ),
        ),
        array(
            'id'       => 'modified_date_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Product update date icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-sync',
            'options'  => $alliconArray,
            'required' => array( 'edit_modified_date', '=', true ),
        ),

        //Product SKU (In WooCommerce mode)
        array(
            'id'       => 'show_product_sku',
            'type'     => 'switch',
            'title'    => __( 'Show product SKU (In WooCommerce mode)', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'edit_product_sku',
            'type'     => 'switch',
            'title'    => __( 'Edit the product SKU', 'azin-file' ),
            'subtitle' => __( 'Display the desired value instead of displaying product SKU', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_product_sku', '=', true ),
        ),
        array(
            'id'       => 'product_sku_title',
            'type'     => 'text',
            'title'    => __( 'Product SKU title', 'azin-file' ),
            'default'  => __( 'SKU', 'azin-file' ),
            'required' => array( 'edit_product_sku', '=', true ),
        ),
        array(
            'id'       => 'product_sku_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Product SKU icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-barcode',
            'options'  => $alliconArray,
            'required' => array( 'edit_product_sku', '=', true ),
        ),

        // product-fields-on-downloads-start
        array(
            'id' => 'product-fields-on-downloads-start',
            'type' => 'section',
            'title'    => __( 'Settings of product fields in user panel downloads', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_downloads_fields',
            'type'     => 'switch',
            'title'    => __( 'Displaying product fields in user panel downloads', 'azin-file' ),
            'subtitle' => __( 'By activating this option, you can display up to three product fields on the downloads page of the user panel for each purchased product. (such as update date, SKU, etc.)', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'downloads_fields',
            'type'     => 'select',
            'multi'    => true,
            'sortable' => true,
            'title'    => __( 'Displayable fields', 'azin-file' ),
            'options'  => array(
                'field-one'      => __( 'First field', 'azin-file' ),
                'field-two'      => __( 'Second field', 'azin-file' ),
                'field-three'    => __( 'Third field / Vendor', 'azin-file' ),
                'field-four'     => __( 'Fourth field / Date of Release', 'azin-file' ),
                'field-five'     => __( 'Fifth field / Category', 'azin-file' ),
                'field-six'      => __( 'Sixth field / Visits', 'azin-file' ),
                'field-dcount'   => __( 'Product sales', 'azin-file' ),
                'field-modified' => __( 'Update date', 'azin-file' ),
                'field-sku'      => __( 'Product SKU', 'azin-file' ),
            ),
            'default'  => array( 'field-modified' ),
            'required' => array( 'show_downloads_fields', '=', true )
        ),
        array(
            'id' => 'product-fields-on-downloads-end',
            'type' => 'section',
            'indent' => false,
        ),
    )
) );

//Additional product tab
Redux::setSection( $opt_name, array(
    'title'      => __( 'Additional product tab', 'azin-file' ),
    'id'         => 'additional_product_tab',
    'icon'       => 'fa fa-folder',
    'subsection' => true,
    'fields'     => array(

        //faq-product-tab-start
        array(
            'id'     => 'faq-product-tab-start',
            'type'   => 'section',
            'title'  => __( 'Product FAQ tab settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_faq_product_tab',
            'type'     => 'switch',
            'title'    => __( 'Show tab', 'azin-file' ),
            'subtitle' => __( 'By activating this option, a section for adding product FAQs will be added to the product edit page', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'faq_product_tab_title',
            'type'     => 'text',
            'title'    => __( 'Tab title', 'azin-file' ),
            'default'  => __( 'FAQ', 'azin-file' ),
            'required' => array( 'show_faq_product_tab', '=', true ),
        ),
        array(
            'id'       => 'faq_product_tab_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fa' ),
            'title'    => __( 'Tab icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-question-square',
            'options'  => $alliconArray,
            'required' => array( 'show_faq_product_tab', '=', true ),
        ),
        array(
            'id'     => 'faq-product-tab-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //additional-product-tab-one-start
        array(
            'id' => 'additional-product-tab-one-start',
            'type' => 'section',
            'title'    => __( 'Settings of the first additional tab of products', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_add_prod_tab_one',
            'type'     => 'switch',
            'title'    => __( 'Show tab', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'add_prod_tab_one_title',
            'type'     => 'text',
            'title'    => __( 'Tab title', 'azin-file' ),
            'default'  => __( 'Title', 'azin-file' ),
            'required' => array( 'show_add_prod_tab_one', '=', true ),
        ),
        array(
            'id'       => 'add_prod_tab_one_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fa' ),
            'title'    => __( 'Tab icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-info-circle',
            'options'  => $alliconArray,
            'required' => array( 'show_add_prod_tab_one', '=', true ),
        ),
        array(
            'id'       => 'tab_one_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Show tab in specific categories', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_add_prod_tab_one', '=', true ),
        ),
        array(
            'id'    => 'add_prod_tab_one_cats',
            'type'     => 'select',
            'multi'    => true,
            'title'    => __( 'Categories', 'azin-file' ), 
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => $product_taxonomy,
                'hide_empty' => false,
            ),
            'required' => array( 'tab_one_in_cats', '=', true )
        ),
        array(
            'id'      => 'add_prod_tab_one_content',
            'type'    => 'editor',
            'title'   => __( 'Tab content', 'azin-file' ),
            'desc'    => __( 'You can also use the shortcode', 'azin-file' ),
            'default' => __( 'Text', 'azin-file' ),
            'args'    => array(
                'wpautop'       => false,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'show_add_prod_tab_one', '=', true ),
        ),
        array(
            'id' => 'additional-product-tab-one-end',
            'type' => 'section',
            'indent' => false,
        ),

        //additional-product-tab-two-start
        array(
            'id' => 'additional-product-tab-two-start',
            'type' => 'section',
            'title'    => __( 'Settings of the second additional tab of products', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_add_prod_tab_two',
            'type'     => 'switch',
            'title'    => __( 'Show tab', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'add_prod_tab_two_title',
            'type'     => 'text',
            'title'    => __( 'Tab title', 'azin-file' ),
            'default'  => __( 'Title', 'azin-file' ),
            'required' => array( 'show_add_prod_tab_two', '=', true ),
        ),
        array(
            'id'       => 'add_prod_tab_two_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fa' ),
            'title'    => __( 'Tab icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-certificate',
            'options'  => $alliconArray,
            'required' => array( 'show_add_prod_tab_two', '=', true ),
        ),
        array(
            'id'       => 'tab_two_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Show tab in specific categories', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_add_prod_tab_two', '=', true ),
        ),
        array(
            'id'    => 'add_prod_tab_two_cats',
            'type'     => 'select',
            'multi'    => true,
            'title'    => __( 'Categories', 'azin-file' ), 
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => $product_taxonomy,
                'hide_empty' => false,
            ),
            'required' => array( 'tab_two_in_cats', '=', true )
        ),
        array(
            'id'      => 'add_prod_tab_two_content',
            'type'    => 'editor',
            'title'   => __( 'Tab content', 'azin-file' ),
            'desc'    => __( 'You can also use the shortcode', 'azin-file' ),
            'default' => __( 'Text', 'azin-file' ),
            'args'    => array(
                'wpautop'       => false,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'show_add_prod_tab_two', '=', true ),
        ),
        array(
            'id' => 'additional-product-tab-two-end',
            'type' => 'section',
            'indent' => false,
        ),

        //additional-product-tab-three-start
        array(
            'id' => 'additional-product-tab-three-start',
            'type' => 'section',
            'title'    => __( 'Settings of the third additional tab of products', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_add_prod_tab_three',
            'type'     => 'switch',
            'title'    => __( 'Show tab', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'add_prod_tab_three_title',
            'type'     => 'text',
            'title'    => __( 'Tab title', 'azin-file' ),
            'default'  => __( 'Title', 'azin-file' ),
            'required' => array( 'show_add_prod_tab_three', '=', true ),
        ),
        array(
            'id'       => 'add_prod_tab_three_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fa' ),
            'title'    => __( 'Tab icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-info-circle',
            'options'  => $alliconArray,
            'required' => array( 'show_add_prod_tab_three', '=', true ),
        ),
        array(
            'id'       => 'tab_three_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Show tab in specific categories', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_add_prod_tab_three', '=', true ),
        ),
        array(
            'id'    => 'add_prod_tab_three_cats',
            'type'     => 'select',
            'multi'    => true,
            'title'    => __( 'Categories', 'azin-file' ), 
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => $product_taxonomy,
                'hide_empty' => false,
            ),
            'required' => array( 'tab_three_in_cats', '=', true )
        ),
        array(
            'id'      => 'add_prod_tab_three_content',
            'type'    => 'editor',
            'title'   => __( 'Tab content', 'azin-file' ),
            'desc'    => __( 'You can also use the shortcode', 'azin-file' ),
            'default' => __( 'Text', 'azin-file' ),
            'args'    => array(
                'wpautop'       => false,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'show_add_prod_tab_three', '=', true ),
        ),
        array(
            'id' => 'additional-product-tab-three-end',
            'type' => 'section',
            'indent' => false,
        ),

        //additional-product-tab-four-start
        array(
            'id' => 'additional-product-tab-four-start',
            'type' => 'section',
            'title'    => __( 'Settings of the fourth additional tab of products', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_add_prod_tab_four',
            'type'     => 'switch',
            'title'    => __( 'Show tab', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'add_prod_tab_four_title',
            'type'     => 'text',
            'title'    => __( 'Tab title', 'azin-file' ),
            'default'  => __( 'Title', 'azin-file' ),
            'required' => array( 'show_add_prod_tab_four', '=', true ),
        ),
        array(
            'id'       => 'add_prod_tab_four_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fa' ),
            'title'    => __( 'Tab icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-info-circle',
            'options'  => $alliconArray,
            'required' => array( 'show_add_prod_tab_four', '=', true ),
        ),
        array(
            'id'       => 'tab_four_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Show tab in specific categories', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_add_prod_tab_four', '=', true ),
        ),
        array(
            'id'    => 'add_prod_tab_four_cats',
            'type'     => 'select',
            'multi'    => true,
            'title'    => __( 'Categories', 'azin-file' ), 
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => $product_taxonomy,
                'hide_empty' => false,
            ),
            'required' => array( 'tab_four_in_cats', '=', true )
        ),
        array(
            'id'      => 'add_prod_tab_four_content',
            'type'    => 'editor',
            'title'   => __( 'Tab content', 'azin-file' ),
            'desc'    => __( 'You can also use the shortcode', 'azin-file' ),
            'default' => __( 'Text', 'azin-file' ),
            'args'    => array(
                'wpautop'       => false,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'show_add_prod_tab_four', '=', true ),
        ),
        array(
            'id' => 'additional-product-tab-four-end',
            'type' => 'section',
            'indent' => false,
        ),

        //additional-product-tab-five-start
        array(
            'id' => 'additional-product-tab-five-start',
            'type' => 'section',
            'title'  => __( 'Settings of the fifth additional tab of products', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_add_prod_tab_five',
            'type'     => 'switch',
            'title'    => __( 'Show tab', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'add_prod_tab_five_title',
            'type'     => 'text',
            'title'    => __( 'Tab title', 'azin-file' ),
            'default'  => __( 'Title', 'azin-file' ),
            'required' => array( 'show_add_prod_tab_five', '=', true ),
        ),
        array(
            'id'       => 'add_prod_tab_five_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fa' ),
            'title'    => __( 'Tab icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-info-circle',
            'options'  => $alliconArray,
            'required' => array( 'show_add_prod_tab_five', '=', true ),
        ),
        array(
            'id'       => 'tab_five_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Show tab in specific categories', 'azin-file' ),
            'default'  => false,
            'required' => array( 'show_add_prod_tab_five', '=', true ),
        ),
        array(
            'id'       => 'add_prod_tab_five_cats',
            'type'     => 'select',
            'multi'    => true,
            'title'    => __( 'Categories', 'azin-file' ), 
            'data'     => 'terms',
            'args'     => array(
                'taxonomies' => $product_taxonomy,
                'hide_empty' => false,
            ),
            'required' => array( 'tab_five_in_cats', '=', true )
        ),
        array(
            'id'      => 'add_prod_tab_five_content',
            'type'    => 'editor',
            'title'   => __( 'Tab content', 'azin-file' ),
            'desc'    => __( 'You can also use the shortcode', 'azin-file' ),
            'default' => __( 'Text', 'azin-file' ),
            'args'    => array(
                'wpautop'       => false,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'show_add_prod_tab_five', '=', true ),
        ),
        array(
            'id' => 'additional-product-tab-five-end',
            'type' => 'section',
            'indent' => false,
        ),

        //custom-product-tabs-start
        array(
            'id' => 'custom-product-tabs-start',
            'type' => 'section',
            'title' => __( 'Settings for additional tabs on the product edit page', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'custom_product_tab_one',
            'title'    => __( 'Activation of the first tab', 'azin-file' ),
            'type'     => 'switch',
            'default'  => true,
        ),
        array(
            'id'       => 'custom_product_tab_two',
            'title'    => __( 'Activation of the second tab', 'azin-file' ),
            'type'     => 'switch',
            'default'  => false,
        ),
        array(
            'id'       => 'custom_product_tab_three',
            'title'    => __( 'Activation of the third tab', 'azin-file' ),
            'type'     => 'switch',
            'default'  => false,
        ),
        array(
            'id'     => 'custom-product-tabs-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //custom-product-tabs-end

    ),
) );

//Comments Settings
Redux::setSection( $opt_name, array(
    'title'      => __( 'Comments', 'azin-file' ),
    'icon'       => 'fa fa-comments',
    'id'         => 'comment-settings',
    'desc'       => __( 'Comments Settings', 'azin-file' ),
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'show_comment_form_before',
            'type'     => 'switch',
            'title'    => __( 'Display the comment submission form before the comments', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'comment_remove_url',
            'type'     => 'switch',
            'title'    => __( 'Remove the website field from the comment form', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'comment_remove_cookie',
            'type'     => 'switch',
            'title'    => __( 'Remove the cookie save field from the comment form', 'azin-file' ),
            'default'  => true,
        ),
    )
) );