<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Demo Website: https://azinfile.i-design.ir/
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

//Start User panel settings SECTION
Redux::setSection( $opt_name, array(
    'title'      => __( 'User panel settings', 'azin-file' ),
    'id'         => 'user_panel_setting',
    'icon'       => 'fa fa-user',
    'fields'     => array(
        array(
            'id'       => 'remove_myacc_hooks',
            'type'     => 'switch',
            'title'    => __( 'Remove template hooks from WooCommerce user panel' , 'azin-file' ),
            'subtitle'  => __( 'Enabling this option removes the template code from the WooCommerce user panel. Enabling this option is used to eliminate interference with other user panel plugins.', 'azin-file' ),
            'default'  => false,
        ),

        array(
            'id'       => 'change_user_avatar',
            'type'     => 'switch',
            'title'    => __( 'Ability to change profile picture' , 'azin-file' ),
            'subtitle'  => __( 'Adding the ability to change the profile image (avatar) to the user panel', 'azin-file' ),
            'default'  => true,
        ),

        array(
            'id' => 'dashboard-link-one-section-start',
            'type' => 'section',
            'title'    => __( 'Settings for the first custom dashboard link', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'dashboard_link_one',
            'type'     => 'switch',
            'title'    => __( 'Activate the first link', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'dashboard_link_one_title',
            'type'     => 'text',
            'title'    => __( 'Title', 'azin-file' ),
            'default'  => __( 'First link', 'azin-file' ),                
            'required' => array( 'dashboard_link_one', '=', true ),
        ),
        array(
            'id'       => 'dashboard_link_one_url',
            'type'     => 'text',
            'title'    => __( 'Link', 'azin-file' ),
            'default'  => '#',                
            'required' => array( 'dashboard_link_one', '=', true ),
        ),
        array(
            'id'       => 'dashboard_link_one_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-link',
            'options'  => $iconArray,
            'required' => array( 'dashboard_link_one', '=', true ),
        ),
        array(
            'id' => 'dashboard-link-one-section-end',
            'type' => 'section',
            'indent' => false ,
        ),

        array(
            'id' => 'dashboard-link-two-section-start',
            'type' => 'section',
            'title'    => __( 'Settings for the second custom dashboard link', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'dashboard_link_two',
            'type'     => 'switch',
            'title'    => __( 'Activate the second link', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'dashboard_link_two_title',
            'type'     => 'text',
            'title'    => __( 'Title', 'azin-file' ),
            'default'  => __( 'Second link', 'azin-file' ),                
            'required' => array( 'dashboard_link_two', '=', true ),
        ),
        array(
            'id'       => 'dashboard_link_two_url',
            'type'     => 'text',
            'title'    => __( 'Link', 'azin-file' ),
            'default'  => '#',                
            'required' => array( 'dashboard_link_two', '=', true ),
        ),
        array(
            'id'       => 'dashboard_link_two_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-link',
            'options'  => $iconArray,
            'required' => array( 'dashboard_link_two', '=', true ),
        ),
        array(
            'id' => 'dashboard-link-two-section-end',
            'type' => 'section',
            'indent' => false ,
        ),

        array(
            'id' => 'dashboard-link-three-section-start',
            'type' => 'section',
            'title'    => __( 'Settings for the third custom dashboard link', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'dashboard_link_three',
            'type'     => 'switch',
            'title'    => __( 'Activate the third link', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'dashboard_link_three_title',
            'type'     => 'text',
            'title'    => __( 'Title', 'azin-file' ),
            'default'  => __( 'Third link', 'azin-file' ),                
            'required' => array( 'dashboard_link_three', '=', true ),
        ),
        array(
            'id'       => 'dashboard_link_three_url',
            'type'     => 'text',
            'title'    => __( 'Link', 'azin-file' ),
            'default'  => '#',                
            'required' => array( 'dashboard_link_three', '=', true ),
        ),
        array(
            'id'       => 'dashboard_link_three_icon',
            'type'     => 'select',
            'select2'  => array( 'containerCssClass' => 'fal' ),
            'title'    => __( 'Icon', 'azin-file' ),
            'class'    => ' azin-font-icon',
            'default'  => 'fa fa-link',
            'options'  => $iconArray,
            'required' => array( 'dashboard_link_three', '=', true ),
        ),
        array(
            'id' => 'dashboard-link-three-section-end',
            'type' => 'section',
            'indent' => false ,
        ),

        array(
            'id' => 'dashboard-message-section-start',
            'type' => 'section',
            'title'    => __( 'Settings for dashboard messages', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_dashboard_message',
            'type'     => 'switch',
            'title'    => __( 'Display messages in users panel' , 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'dashboard_message_one',
            'type'     => 'editor',
            'title'    => __( 'The text of the first message', 'azin-file' ),
            'subtitle' => __( 'The text of the first message displayed in the user panel', 'azin-file' ),   
            'desc'     => __( 'You can also use the shortcode. For example: [azin_first_name] = first name, [azin_last _name] = last name, [azin_display_name] = display name', 'azin-file' ),
            'default'  => __( 'From your account dashboard you can view your recent orders, and edit your password and account details.', 'azin-file' ),
            'args'     => array(
                'wpautop'       => false,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'show_dashboard_message', '=', true ),
        ),
        array(
            'id'       => 'dashboard_message_two',
            'type'     => 'editor',
            'title'    => __( 'The text of the second message', 'azin-file' ),
            'subtitle' => __( 'The text of the second message displayed in the user panel', 'azin-file' ),
            'desc'     => __( 'You can also use the shortcode. For example: [azin_first_name] = first name, [azin_last _name] = last name, [azin_display_name] = display name', 'azin-file' ),
            'default'  => '',
            'args'     => array(
                'wpautop'       => false,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'show_dashboard_message', '=', true ),
        ),
        array(
            'id'       => 'dashboard_message_three',
            'type'     => 'editor',
            'title'    => __( 'The text of the third message', 'azin-file' ),
            'subtitle' => __( 'The text of the third message displayed in the user panel', 'azin-file' ),   
            'desc'     => __( 'You can also use the shortcode. For example: [azin_first_name] = first name, [azin_last _name] = last name, [azin_display_name] = display name', 'azin-file' ),
            'default'  => '',
            'args'     => array(
                'wpautop'       => false,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'show_dashboard_message', '=', true ),
        ),
        array(
            'id' => 'dashboard-message-section-end',
            'type' => 'section',
            'indent' => false ,
        ),

        //User panel style section start
        array(
            'id' => 'user-panel-style-section-start',
            'type' => 'section',
            'title'    => __( 'User panel style settings', 'azin-file' ),
            'indent' => true,
        ),
        array(
            'id'       => 'dashboard_bg_color',
            'type'     => 'color',
            'title'    => __( 'Dashboard menu background color', 'azin-file' ),
            'default'  => '#172b4d',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'dashboard_text_color',
            'type'     => 'color',
            'title'    => __( 'Dashboard menu text color', 'azin-file' ),
            'default'  => '#ffffff',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'total_orders_bg_color',
            'type'     => 'color',
            'title'    => __( 'Total Orders background color', 'azin-file' ),
            'default'  => '#2bc999',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'completed_orders_bg_color',
            'type'     => 'color',
            'title'    => __( 'Completed orders background color', 'azin-file' ),
            'default'  => '#fbb41a',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'wallet_inventory_bg_color',
            'type'     => 'color',
            'title'    => __( 'Wallet Inventory background color', 'azin-file' ),
            'default'  => '#34afff',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'registration_date_bg_color',
            'type'     => 'color',
            'title'    => __( 'Registration date background color', 'azin-file' ),
            'default'  => '#ff5e5b',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id'       => 'panel_widgets_text_color',
            'type'     => 'color',
            'title'    => __( 'Text color of panel widgets', 'azin-file' ),
            'default'  => '#ffffff',
            'validate' => 'color',
            'transparent' => false,
        ),
        array(
            'id' => 'user-panel-style-section-end',
            'type' => 'section',
            'indent' => false,
        ),

    ),
) );