<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Demo Website: https://azinfile.i-design.ir/
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

//Start Woocommerce settings SECTION
Redux::setSection( $opt_name, array(
    'title'      => __( 'Woocommerce Settings', 'azin-file' ),
    'id'         => 'menu_woo',
    'desc'       => __( 'If you use the template with the WooCommerce plugin, make the relevant settings from this section.', 'azin-file' ),
    'icon'       => 'fa fa-wordpress-simple',
    'fields'     => array(
        array(
            'id'       => 'woo_mode',
            'type'     => 'switch',
            'title'    => __( 'Woocommerce Mode', 'azin-file' ),
            'subtitle' => __( 'If you are using template with the WooCommerce plugin, enable this option to make different parts of the template compatible with WooCommerce.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'woo_side',
            'type'     => 'switch',
            'title'    => __( 'Separate Woocommerce sidebar', 'azin-file' ),
            'subtitle' => __( 'Enabling this option will enable a separate sidebar for the Woocommerce product page.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_checkout_steps',
            'type'     => 'switch',
            'title'    => __( 'Display payment steps on shopping cart and checkout pages' , 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'grant_download_access',
            'type'     => 'switch',
            'title'    => __( 'Grant download permissions for past WooCommerce orders', 'azin-file' ),
            'subtitle' => __( 'By activating this option, permission to download new files added to the product will be granted to previous orders.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'external_new_tab',
            'type'     => 'switch',
            'title'    => __( 'Opening the external/affiliate product link in a new tab', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'auto_woo_gallery',
            'type'     => 'switch',
            'title'    => __( 'Automatic product gallery display', 'azin-file' ),
            'subtitle' => __( 'By activating this option, you no longer need to select the image collection option in the preview section in WooCommerce products with image gallery.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'replace_woo_attr',
            'type'     => 'switch',
            'title'    => __( 'Replacing WooCommerce product attributes instead of attributes next to the product image', 'azin-file' ),
            'subtitle' => __( 'By activating this option, the attributes of the template product that are displayed in the first style of the product page next to the product image will be replaced with the product attributes of the WooCommerce plugin.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'woo_attr_number',
            'type'     => 'text',
            'title'    => __( 'Number of attributes', 'azin-file' ),
            'subtitle' => __( 'Leave blank to display all attributes', 'azin-file' ),
            'default'  => 8,
            'required' => array( 'replace_woo_attr', '=', true ),
        ),
        array(
            'id'       => 'remove_product_order',
            'type'     => 'switch',
            'title'    => __( 'Remove product sorting', 'azin-file' ),
            'subtitle' => __( 'Remove product sorting from archive pages', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'remove_price_range',
            'type'     => 'switch',
            'title'    => __( 'Remove price range', 'azin-file' ),
            'subtitle' => __( 'Remove price range and display the lowest price in variable products', 'azin-file' ),
            'default'  => true,
        ),
        array(
            'id'       => 'show_max_price',
            'type'     => 'switch',
            'title'    => __( 'Display higher price', 'azin-file' ),
            'subtitle' => __( 'Remove price range and display the higher price', 'azin-file' ),
            'default'  => false,
            'required' => array( 'remove_price_range', '=', true ),
        ),
        array(
            'id'       => 'remove_dub_price_range',
            'type'     => 'switch',
            'title'    => __( 'Remove second price', 'azin-file' ),
            'subtitle' => __( 'Remove second price in variable products (Prices should not be the same)', 'azin-file' ),
            'default'  => false,
            'required' => array( 'remove_price_range', '=', true ),
        ),
        array(
            'id'       => 'product_sold_individually',
            'type'     => 'switch',
            'title'    => __( 'Removing the product quantity', 'azin-file' ),
            'subtitle' => __( 'Removing the product quantity from WooCommerce products', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'stock_order',
            'type'     => 'switch',
            'title'    => __( 'Show out of stock products at the end of the product list', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'ajax_add',
            'type'     => 'switch',
            'title'    => __( 'Ajax add to cart', 'azin-file' ),
            'subtitle' => __( 'Product has been added Ajax to the cart (without loading page again)', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'remove_address',
            'type'     => 'switch',
            'title'    => __( 'Remove address option', 'azin-file' ),
            'subtitle' => __( 'Remove address option from menu and user panel', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'remove_extra_fields',
            'type'     => 'switch',
            'title'    => __( 'Remove extra fields', 'azin-file' ),
            'subtitle' => __( 'Remove extra fields from products that do not have physical shipping', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'remove_dimensions',
            'type'     => 'switch',
            'title'    => __( 'Hides the product’s weight and dimension', 'azin-file' ),
            'subtitle' => __( 'Hides the product’s weight and dimension in the single product page.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'remove_cart_fragments',
            'type'     => 'switch',
            'title'    => __( 'Remove cart fragments script', 'azin-file' ),
            'subtitle' => __( 'Removing this script from the main page will increase the loading speed of your site, but if you use the cache plugin, removing this script will cause the shopping cart content to not be updated automatically when the page is loaded.', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'order_tracking_code',
            'type'     => 'switch',
            'title'    => __( 'Order tracking or license code', 'azin-file' ),
            'subtitle' => __( 'Ability to insert the tracking or license code on the order management page and display it on the user panel', 'azin-file' ),
            'default'  => false,
        ),
        array(
            'id'       => 'order_tracking_code_title',
            'type'     => 'text',
            'title'    => __( 'Tracking code title', 'azin-file' ),
            'default'  => __( 'Tracking code', 'azin-file' ),
            'required' => array( 'order_tracking_code', '=', true ),
        ),
    ),
) );