<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

    add_action( 'init', 'ajax_login_init' );
    
    function ajax_login_init() {
        
        wp_register_script( 'ajax-login-script', get_stylesheet_directory_uri() . '/js/ajax-login-script.js', array( 'jquery' ), '1.0', true );
        wp_enqueue_script( 'ajax-login-script' );
        
        if ( azin_opt( 'recapcha_login' ) ) {
            $recapcha_hl = ( is_rtl() ? 'fa' : 'en' );
            wp_register_script( 'ajax-login-recapcha', 'https://www.google.com/recaptcha/api.js?hl='. $recapcha_hl , array( 'jquery' ), '' , true );
            wp_enqueue_script( 'ajax-login-recapcha' );
        }

        $redirect_to = ( ( ! azin_opt( 'azin_login_redirect' ) || empty ( azin_opt( 'azin_login_redirect_url' ) ) ) ? get_permalink( get_the_ID() ) : azin_opt( 'azin_login_redirect_url' ) );

        wp_localize_script( 'ajax-login-script', 'ajax_login_object', array(
            'ajaxurl' => admin_url( 'admin-ajax.php' ),
            'redirecturl' => $redirect_to,
            'loadingmessage' => __( 'Please wait...', 'azin-file' ),
            'class' => 'alert alert-info'
        ) );

        // Enable the user with no privileges to run ajax_login() in AJAX
        add_action( 'wp_ajax_nopriv_ajaxlogin', 'ajax_login' );
    }

    // Check if users input information is valid
    function ajax_login() {
        
        

        $scookie = ( is_ssl()?true:false);
        
        // First check the nonce, if it fails the function will break
        check_ajax_referer( 'ajax-login-nonce', 'security' );
        
        if ( azin_opt( 'recapcha_login' ) ) {
            
            // your secret key
            $secret = azin_opt( 'site_secret' );

            // empty response
            $response = null;

            // check secret key
            $reCaptcha = new ReCaptcha( $secret);

            //Nonce is checked, get the POST data and sign user on
            if ( $_POST["g-recaptcha-response"] ) {
                $response = $reCaptcha->verifyResponse(
                    $_SERVER["REMOTE_ADDR"],
                    $_POST["g-recaptcha-response"]
                );
            }    
        }
        
    if ( azin_opt( 'recapcha_login' ) ) { 
        
    if ( $response != null && ( $response->success) ) {
    $info = array();
    $info['user_login'] = $_POST['username'];
    $info['user_password'] = $_POST['password'];
    $info['remember'] = true;
    $user_signon = wp_signon( $info, $scookie );
    if ( is_wp_error( $user_signon ) || $response == null || !( $response->success) ) {
        echo json_encode( array( 'loggedin'=>false, 'class' => 'alert alert-danger' , 'message'=>__( 'The login details are incorrect!', 'azin-file' ) ));
    } else {
        echo json_encode( array( 'loggedin'=>true, 'class' => 'alert alert-success' , 'message'=>__( 'Login was successful ...', 'azin-file' ) ));
    }
    }
    else {
         echo json_encode( array( 'loggedin'=>false, 'class' => 'alert alert-danger' , 'message'=>__( 'Enter Captcha Code!', 'azin-file' ) ));
    }
    }
    else{
            
         $info = array();
    $info['user_login'] = $_POST['username'];
    $info['user_password'] = $_POST['password'];
    $info['remember'] = true;
    $user_signon = wp_signon( $info, $scookie );
    if ( is_wp_error( $user_signon ) ) {
        echo json_encode( array( 'loggedin'=>false, 'class' => 'alert alert-danger' , 'message'=>__( 'The login details are incorrect!', 'azin-file' ) ));
    } else {
        echo json_encode( array( 'loggedin'=>true, 'class' => 'alert alert-success' , 'message'=>__( 'Login was successful...', 'azin-file' ) ));
    }
        
    }
    die();
}