<?php

if ( file_exists( dirname( __FILE__ ) . '/widget-icon/fa.php' ) ) {
	require_once dirname( __FILE__ ) . '/widget-icon/fa.php';
}

//Post MetaBox
add_filter( 'rwmb_meta_boxes', 'azin_register_meta_boxes' );
function azin_register_meta_boxes( $meta_boxes) {

    global $font_awesome_icons;

    $foclass  = ( azin_opt( 'show_fone' ) ? 'fshow' : 'fhide' );

    $ftwclass = ( azin_opt( 'show_ftwo' ) ? 'fshow' : 'fhide' );

    $ftclass  = ( azin_opt( 'show_fthree' ) && azin_opt( 'edit_fthree' ) ? 'fshow' : 'fhide' );
    
    $ffclass  = ( azin_opt( 'show_ffour' ) && azin_opt( 'edit_ffour' ) ? 'fshow' : 'fhide' );
    
    $fficlass = ( azin_opt( 'show_ffive' ) && azin_opt( 'edit_ffive' ) ? 'fshow' : 'fhide' );
    
    $fsclass  = ( azin_opt( 'show_fsix' ) && azin_opt( 'edit_fsix' ) ? 'fshow' : 'fhide' );

    $fpsclass = ( azin_opt( 'show_product_sku' ) && azin_opt( 'edit_product_sku' ) ? 'fshow' : 'fhide' );

    $fmdclass = ( azin_opt( 'show_modified_date' ) && azin_opt( 'edit_modified_date' ) ? 'fshow' : 'fhide' );

    $fdcclass = ( azin_opt( 'show_dcount' ) && azin_opt( 'edit_dcount' ) ? 'fshow' : 'fhide' );

    $spclass  = ( azin_opt( 'woo_mode' ) ? 'fhide' : '' );
    
    $dclass   = ( ! azin_opt( 'woo_mode' ) ? 'fhide' : '' );
    
    $prefix = 'file_';
    
    //Course Settings
    if ( azin_opt( 'course_sales_activation' ) ) {
        $meta_boxes[] = array(
            'id'         => $prefix .'course',
            'title'      => __( 'Course settings', 'azin-file' ),
            'post_types' => array( 'product', 'download' ),
            'fields'     => array(
                array(
                    'type' => 'heading',
                    'name' => '',
                    'desc' => __( 'By activating the training course option, the purchase button on the product page will change to participate in the course, and also parts such as the number of sales, the name of the author or seller will also change according to the type of training course.', 'azin-file' ),
                ),
                array(
                    'name'  => __( 'Is this a training course product?', 'azin-file' ),
                    'id'    => $prefix . 'training_course',
                    'type'  => 'checkbox',
                ),
                array(
                    'name'  => __( 'Download the first lesson of the course for free?', 'azin-file' ),
                    'id'    => $prefix . 'first_lesson_free',
                    'type'  => 'checkbox',
                    'desc'  => __( 'The option to display course lessons must be active in the template settings. Be careful that due to the limitation of the file download folder, upload the file of the first chapter through the media section of WordPress or the control panel of the host and insert its link in the address section of the file so that you do not encounter the error of lack of access.', 'azin-file' ),
                ),
                array(
                    'name'  => __( 'Course progress percentage', 'azin-file' ),
                    'id'    => $prefix . 'course_progress',
                    'type'  => 'text',
                    'desc'  => __( 'Enter the progress percentage of the course. To display on the course page, you must use the course progress percentage widget.', 'azin-file' ),
                ),
            )
        );
    }

    //File Details MetaBox
    $meta_boxes[] = array(
        'id'         => 'fdetails',
        'title'      => __( 'Product Specifications', 'azin-file' ),
        'post_types' => array( 'download', 'product' ),
        'context'    => 'normal',
        'priority'   => 'high',
        'fields' => array(
            array(
                'name'  => __( 'Product label', 'azin-file' ),
                'id'    => $prefix . 'plabel',
                'type'  => 'text',
                'desc'  => __( 'This label will be displayed on the product image', 'azin-file' ),
            ),
            array(
                'name'            => __( 'Product label color', 'azin-file' ),
                'id'              => $prefix . 'plabel_color',
                'type'            => 'select',
                'desc'  => __( 'Select the label color', 'azin-file' ),
                'options'      => array(
                    'lred'     => __( 'Red', 'azin-file' ),
                    'lgreen'   => __( 'Green', 'azin-file' ),
                    'lblue'    => __( 'Blue', 'azin-file' ),
                    'lyellow'  => __( 'Yellow', 'azin-file' ),
                    'lorange'  => __( 'Orange', 'azin-file' ),
                    'lpurple'  => __( 'Purple', 'azin-file' ),
                    'lblack'   => __( 'Black', 'azin-file' ),
                ),
                'multiple'        => false,
                'placeholder'     => __( 'Select', 'azin-file' ),
            ),
            array(
                'name'  => __( 'Special product', 'azin-file' ),
                'id'    => $prefix . 'special',
                'type'  => 'checkbox',
            ),
            array(
                'name'  => __( 'Coming soon mode', 'azin-file' ),
                'id'    => $prefix . 'coming',
                'type'  => 'checkbox',
                'desc'  => __( 'Show phrase coming soon instead of buy button', 'azin-file' ),
            ),
            array(
                'name'  => __( 'Special sale', 'azin-file' ),
                'id'    => $prefix . 'spsale',
                'type'  => 'checkbox',
                'desc'  => __( 'Show in the amazing offer block on the home screen (The product must have a discounted price)', 'azin-file' ),
            ),
            array(
                'name'  => __( 'Special pre-sale price (If the currency is Toman, enter Toman)', 'azin-file' ),
                'id'    => $prefix . 'saleprice',
                'type'  => 'text',
                'desc'  => __( 'This price is displayed in dashed form before the product price', 'azin-file' ),
                'class' => $spclass,
            ),
            array(
                'name'  => azin_opt( 'fone' ),
                'id'    => $prefix . 'fone',
                'type'  => 'text',
                'class' => $foclass,
            ),
            array(
                'name'  => azin_opt( 'ftwo' ),
                'id'    => $prefix . 'ftwo',
                'type'  => 'text',
                'class' => $ftwclass,
            ),
            array(
                'name'  => azin_opt( 'fthree' ),
                'id'    => $prefix . 'fthree',
                'type'  => 'text',
                'class' => $ftclass,
            ),
            array(
                'name'  => azin_opt( 'ffour' ),
                'id'    => $prefix . 'ffour',
                'type'  => 'text',
                'class' => $ffclass,
            ),
            array(
                'name'  => azin_opt( 'ffive' ),
                'id'    => $prefix . 'ffive',
                'type'  => 'text',
                'class' => $fficlass,
            ),
            array(
                'name'  => azin_opt( 'fsix' ),
                'id'    => $prefix . 'fsix',
                'type'  => 'text',
                'class' => $fsclass,
            ),
            array(
                'name'  => azin_opt( 'dcount_title' ),
                'id'    => $prefix . 'dcount',
                'type'  => 'text',
                'class' => $fdcclass,
            ),
            array(
                'name'  => azin_opt( 'modified_date_title' ),
                'id'    => $prefix . 'modified_date',
                'type'  => 'text',
                'class' => $fmdclass,
            ),
            array(
                'name'  => azin_opt( 'product_sku_title' ),
                'id'    => $prefix . 'product_sku',
                'type'  => 'text',
                'class' => $fpsclass,
            ),
            array(
                'name'    => __( 'Product type', 'azin-file' ),
                'id'      => $prefix . 'p_type',
                'type'    => 'radio',
                'inline'  => true,
                'options' => azin_product_types(),
            ),
            array(
                'type' => 'heading',
                'name' => '',
                'desc' => __( 'In the following section, you can put a file or link as a product preview.', 'azin-file' ),
            ),
            array(
                'name'  => __( 'Preview file or link', 'azin-file' ),
                'id'    => $prefix . 'pre',
                'type'  => 'file_input',
                'class' => 'file_pre',
            ),
        )
    );

    //Preview Files
    $meta_boxes[] = array(
        'id'         => $prefix .'preview',
        'post_types' => array( 'download', 'product' ),
        'title'  => __( 'Upload product preview files', 'azin-file' ),
        'fields' => array(
            array(
                'type' => 'heading',
                'name' => '',
                'desc' => __( 'Select the type of product preview, note that each product can only have one type of preview, a set of images, video or song, if not selected only the product index image is displayed.', 'azin-file' ) .
                '<br><span class="'.$dclass.'">' . __( 'In WooCommerce mode, upload a collection of images from the product gallery section.', 'azin-file' ) . '</span>',
            ),
            array(
                    'name'  => __( 'Preview type', 'azin-file' ),
                    'id'    => $prefix . 'pre_type',
                    'type'  => 'radio',
                    'inline' => true,
                    'options' => array(
                        'pre_slides' => __( 'Collection of images', 'azin-file' ),
                        'pre_video' => __( 'Video', 'azin-file' ),
                        'pre_music' => __( 'Sound', 'azin-file' ),
                        'pre_aparat' => __( 'Aparat', 'azin-file' ),
                    ),
            ),
            array(
                'id'               => $prefix . 'images',
                'name'             => __( 'Upload images', 'azin-file' ),
                'type'             => 'image_advanced',
                'force_delete'     => false,
                'class' => 'az_image_file_input ' . $spclass,
            ),
            array(
                'name'             => __( 'Upload video', 'azin-file' ),
                'id'               => $prefix . 'video',
                'type'             => 'file_input',
                'force_delete'     => false,
                'class' => 'az_video_file_input',
            ),
            array(
                'name'             => __( 'Upload sound', 'azin-file' ),
                'id'               => $prefix . 'audio',
                'type'             => 'file_input',
                'force_delete'     => false,
                'class' => 'az_music_file_input',
            ),
            array(
                        'name'  => __( 'Aparat', 'azin-file' ),
                        'id'    => $prefix . 'aparat',
                        'type'  => 'text',
                        'desc'  => __( 'Just enter the video ID, for example: Uxmit', 'azin-file' ),
                        'class' => 'az_aparat_text_input',
            ),
        ),
    );

    //Product Badges MetaBox
    if ( azin_opt( 'product_badges' ) && ! empty ( azin_product_badges() ) ) {
        $meta_boxes[] = array(
            'id'         => 'pbadges',
            'title'      => __( 'Product Badges', 'azin-file' ),
            'post_types' => array( 'download', 'product' ),
            'context'    => 'normal',
            'priority'   => 'high',
            'fields' => array(
                array(
                    'type' => 'heading',
                    'name' => '',
                    'desc' => __( 'In this section, you can choose product badges. To manage product badges, go to Appearance menu > Theme settings > Products and posts > Product badges. Also, use the product badges widget (AzinFile) to display badges on the product page.', 'azin-file' ),
                ),
                array(
                    'name'    => __( 'Product badges', 'azin-file' ),
                    'id'      => $prefix . 'product_badges',
                    'type'    => 'checkbox_list',
                    'inline'  => true,
                    'options' => azin_product_badges(),
                ),
            )
        );
    }
    
    //Page Settings
    $meta_boxes[] = array(
        'id'         => $prefix .'psettings',
        'title'      => __( 'Page settings', 'azin-file' ),
        'post_types' => array( 'page' ),
        'fields'     => array(
            array(
                'name'  => __( 'Sidebar settings', 'azin-file' ),
                'id'    => $prefix . 'wside',
                'type'  => 'radio',
                'inline' => true,
                'options' => array(
                    'dside' => __( 'default settings', 'azin-file' ),
                    'noside' => __( 'No sidebar', 'azin-file' ),
                    'rside' => __( 'Right sidebar', 'azin-file' ),
                    'lside' => __( 'Left sidebar', 'azin-file' ),
                ),
            ),
            array(
                'name'  => __( 'Do not show breadcrumbs (The path of the page)', 'azin-file' ),
                'id'    => $prefix . 'bread',
                'type'  => 'checkbox',
            ),
            array(
                'name'  => __( 'Lock content', 'azin-file' ),
                'desc' => __( 'Display page content to logged in users', 'azin-file' ),
                'id'    => $prefix . 'lock_page_content',
                'type'  => 'checkbox',
            ),
            )
    );

    //Post Settings
    $meta_boxes[] = array(
        'id'         => $prefix .'post_settings',
        'title'      => __( 'Post settings', 'azin-file' ),
        'post_types' => array( 'post' ),
        'fields'     => array(
            array(
                'name'  => __( 'Sidebar settings', 'azin-file' ),
                'id'    => $prefix . 'wside',
                'type'  => 'radio',
                'inline' => true,
                'options' => array(
                    'dside' => __( 'default settings', 'azin-file' ),
                    'noside' => __( 'No sidebar', 'azin-file' ),
                    'rside' => __( 'Right sidebar', 'azin-file' ),
                    'lside' => __( 'Left sidebar', 'azin-file' ),
                ),
            ),
            array(
                'name'  => __( 'Reading time', 'azin-file' ),
                'id'    => 'az_reading_time',
                'type'  => 'text',
            ),
            array(
                'name'  => __( 'Do not show breadcrumbs (The path of the post)', 'azin-file' ),
                'id'    => $prefix . 'bread',
                'type'  => 'checkbox',
            ),
            array(
                'name'  => __( 'Lock content', 'azin-file' ),
                'desc' => __( 'Display content to logged in users', 'azin-file' ),
                'id'    => $prefix . 'lock_post_content',
                'type'  => 'checkbox',
            ),
            array(
                'name'  => __( 'Hide related posts', 'azin-file' ),
                'id'    => $prefix . 'hide_related_posts',
                'type'  => 'checkbox',
            ),
            array(
                'name'  => __( 'Hide the author information block', 'azin-file' ),
                'id'    => $prefix . 'hide_author_block',
                'type'  => 'checkbox',
            ),
            )
    );

    if ( azin_opt( 'show_post_thumb_video' ) ) {
        //Post Video thumbnail
        $meta_boxes[] = array(
            'id'         => $prefix .'vthumb',
            'title'      => __( 'Video thumbnail', 'azin-file' ),
            'post_types' => array( 'post' ),
            'fields'     => array(
                    array(
                        'type' => 'heading',
                        'name' => '',
                        'desc' => __( 'With this feature, you can display a video instead of a thumbnail at the top of the post content', 'azin-file' ),
                    ),
                    array(
                        'name'  => __( 'Video thumbnail', 'azin-file' ),
                        'id'    => 'az_video_thumb',
                        'type'             => 'file_input',
                        'force_delete'     => false,
                        'class' => 'az_video_thumb',
                    ),
                    array(
                        'name'  => __( 'Or Aparat', 'azin-file' ),
                        'id'    => 'az_aparat_thumb',
                        'type'  => 'text',
                        'desc'  => __( 'Just enter the video ID, for example: Uxmit', 'azin-file' ),
                    ),
                )
        );
    }

    if ( azin_opt( 'related_post_products_by' ) == 'manual' ) {
        $post_type = az_woo() ? 'product' : 'download';
        $meta_boxes[] = array(
            'id'         => $prefix .'related_products',
            'title'      => __( 'Related products', 'azin-file' ),
            'post_types' => array( 'post' ),
            'fields'     => array(
                array(
                    'name'        => __( 'Related products', 'azin-file' ),
                    'id'          => $prefix . 'related_products_ids',
                    'type'        => 'post',
                    'post_type'   => $post_type,
                    'field_type'  => 'select_advanced',
                    'placeholder'        => __( 'Select products', 'azin-file' ),
                    'ajax'        => true,
                    'multiple'    => true,
                    'query_args'  => array(
                        'post_status'    => 'publish',
                        'posts_per_page' => -1,
                    ),
                ),
            )
        );
    }

    if ( azin_opt( 'related_product_posts_by' ) == 'manual' ) {
        $meta_boxes[] = array(
            'id'         => $prefix .'related_posts',
            'title'      => __( 'Related posts', 'azin-file' ),
            'post_types' => array( 'download', 'product' ),
            'fields'     => array(
                array(
                    'name'        => __( 'Related posts', 'azin-file' ),
                    'id'          => $prefix . 'related_posts_ids',
                    'type'        => 'post',
                    'post_type'   => 'post',
                    'field_type'  => 'select_advanced',
                    'placeholder'        => __( 'Select posts', 'azin-file' ),
                    'ajax'        => true,
                    'multiple'    => true,
                    'query_args'  => array(
                        'post_status'    => 'publish',
                        'posts_per_page' => -1,
                    ),
                ),
            )
        );
    }

    //Download Box
    $meta_boxes[] = array(
        'id'         => $prefix .'links',
        'title'      => __( 'Download box', 'azin-file' ),
        'post_types' => array( 'download', 'post', 'product' ),
        'fields'     => array(
            array(
                'name'  => __( 'Show download box?', 'azin-file' ),
                'id'    => $prefix . 'dbox',
                'type'  => 'checkbox',
            ),
            array(
                'name'  => __( 'File name', 'azin-file' ),
                'id'    => $prefix . 'fname',
                'type'  => 'text',
            ),
            array(
                'name'  => __( 'Size', 'azin-file' ),
                'id'    => $prefix . 'fsize',
                'type'  => 'text',
            ),
            array(
                'name'  => __( 'Password', 'azin-file' ),
                'id'    => $prefix . 'fpass',
                'type'  => 'text',
                'std' => azin_opt( 'dl_box_pass' ),
            ),
            array(
                'type' => 'heading',
                'name' => '',
                'desc' => __( 'Specify the type of download box, in the first case (suitable for multi-part files), if you write only text in each field, it will be displayed as the title of the parts, and if you write a link, the name of the file in the link will be automatically displayed as the text of the download link. It is possible, in the second case (suitable for single files), for each file, enter the file link in the first field, and by adding a new field, enter the file name in the second field.', 'azin-file' ),
            ),
            array(
                'name'  => __( 'Download box type', 'azin-file' ),
                'id'    => $prefix . 'box_type',
                'type'  => 'radio',
                'inline' => true,
                'options' => array(
                    'box_part' => __( 'Suitable for multi-part files', 'azin-file' ),
                    'box_single' => __( 'Suitable for single files', 'azin-file' ),
                ),
            ),
            array(
            'id'   => $prefix .'furl',
            'name' => __( 'Link(s)', 'azin-file' ),
            'type' => 'text',
            'add_button' => __( 'Add', 'azin-file' ),
            'clone' => true,
            'sort_clone' => true
            ),
        )
    );

    //Custom tab MetaBox one
    if ( azin_opt( 'custom_product_tab_one' ) ) {
        $meta_boxes[] = array(
            'id'         => $prefix .'tab_one',
            'post_types' => array( 'download', 'product' ),
            'title'  => __( 'Additional product tab one settings', 'azin-file' ),
            'fields' => array(
               
                array(
                    'name'  => __( 'Tab title', 'azin-file' ),
                    'id'    => $prefix . 'tab_one_title',
                    'type'  => 'text',
                ),

                array(
                    'name'            => __( 'Tab Icon', 'azin-file' ),
                    'id'              => $prefix . 'tab_one_icon',
                    'type'            => 'select_advanced',
                    'options'         => $font_awesome_icons,
                    'placeholder'     => __( 'Select an Icon', 'azin-file' ),
                    'js_options'      => array(
                        'containerCssClass' => 'ficon_select',
                    ),
                ),
                
                array(
                    'name'    => __( 'Tab Content', 'azin-file' ),
                    'id'      => $prefix . 'tab_one_content',
                    'type'    => 'wysiwyg',
                    'raw'     => false,
                    'options' => array(
                        'textarea_rows' => 4,
                        'teeny'         => false,
                    ),
                ),
            ),
        );
    }

    //Custom tab MetaBox two
    if ( azin_opt( 'custom_product_tab_two' ) ) {
        $meta_boxes[] = array(
            'id'         => $prefix .'tab_two',
            'post_types' => array( 'download', 'product' ),
            'title'  => __( 'Additional product tab two settings', 'azin-file' ),
            'fields' => array(
               
                array(
                    'name'  => __( 'Tab title', 'azin-file' ),
                    'id'    => $prefix . 'tab_two_title',
                    'type'  => 'text',
                ),

                array(
                    'name'            => __( 'Tab Icon', 'azin-file' ),
                    'id'              => $prefix . 'tab_two_icon',
                    'type'            => 'select_advanced',
                    'options'         => $font_awesome_icons,
                    'placeholder'     => __( 'Select an Icon', 'azin-file' ),
                    'js_options'      => array(
                        'containerCssClass' => 'ficon_select',
                    ),
                ),
                
                array(
                    'name'    => __( 'Tab Content', 'azin-file' ),
                    'id'      => $prefix . 'tab_two_content',
                    'type'    => 'wysiwyg',
                    'raw'     => false,
                    'options' => array(
                        'textarea_rows' => 4,
                        'teeny'         => false,
                    ),
                ),
            ),
        );
    }

    //Custom tab MetaBox three
    if ( azin_opt( 'custom_product_tab_three' ) ) {
        $meta_boxes[] = array(
            'id'         => $prefix .'tab_three',
            'post_types' => array( 'download', 'product' ),
            'title'  => __( 'Additional product tab three settings', 'azin-file' ),
            'fields' => array(
               
                array(
                    'name'  => __( 'Tab title', 'azin-file' ),
                    'id'    => $prefix . 'tab_three_title',
                    'type'  => 'text',
                ),

                array(
                    'name'            => __( 'Tab Icon', 'azin-file' ),
                    'id'              => $prefix . 'tab_three_icon',
                    'type'            => 'select_advanced',
                    'options'         => $font_awesome_icons,
                    'placeholder'     => __( 'Select an Icon', 'azin-file' ),
                    'js_options'      => array(
                        'containerCssClass' => 'ficon_select',
                    ),
                ),
                
                array(
                    'name'    => __( 'Tab Content', 'azin-file' ),
                    'id'      => $prefix . 'tab_three_content',
                    'type'    => 'wysiwyg',
                    'raw'     => false,
                    'options' => array(
                        'textarea_rows' => 4,
                        'teeny'         => false,
                    ),
                ),
            ),
        );
    }
    
    //FAQ tab
    $meta_boxes[] = array(
        'id'         => $prefix .'faq',
        'title'      => __( 'Product FAQs', 'azin-file' ),
        'post_types' => array( 'download', 'product' ),
        'fields'     => array(
            array(
                'name'  => __( 'Show FAQ tab?', 'azin-file' ),
                'id'    => $prefix . 'show_faq',
                'type'  => 'checkbox',
            ),
            array(
                'type' => 'heading',
                'name' => '',
                'desc' => __( 'In this section, enter frequently asked questions and their answers, respectively, enter the question in the first field and the answer in the second field, and add fields for the rest of the questions and answers in the same way.', 'azin-file' ),
            ),
            array(
            'id'   => $prefix .'faqs',
            'name' => __( 'FAQ(s)', 'azin-file' ),
            'type' => 'textarea',
            'add_button' => __( 'Add', 'azin-file' ),
            'clone' => true,
            'sort_clone' => true
            ),
        )
    );

    //Product purchase guide
    $meta_boxes[] = array(
        'id'         => $prefix .'product_help',
        'post_types' => array( 'download', 'product' ),
        'title'  => __( 'Product purchase guide', 'azin-file' ),
        'fields' => array(
            array(
                'type' => 'heading',
                'name' => '',
                'desc' => __( 'From this section, you can customize the text of the product buying guide displayed on the product page. This text will be displayed in the first style of the product page below the product description and in the second style above the buy button.', 'azin-file' ),
            ),

            array(
                'name'  => __( 'Help Title', 'azin-file' ),
                'id'    => $prefix . 'msg_title',
                'type'  => 'text',
            ),
            
            array(
                'name'    => __( 'Help text', 'azin-file' ),
                'id'      => $prefix . 'msg_help',
                'type'    => 'wysiwyg',
                'raw'     => false,
                'options' => array(
                    'textarea_rows' => 4,
                    'teeny'         => false,
                ),
            ),
        ),
    );

    //Product Additional Button
    $meta_boxes[] = array(
        'id'         => $prefix .'product_add_btn',
        'post_types' => array( 'download', 'product' ),
        'title'  => __( 'Product Additional Button', 'azin-file' ),
        'fields' => array(
            array(
                'type' => 'heading',
                'name' => '',
                'desc' => __( 'From this section, you can customize the text and link of the product additional button displayed on the product page. These settings are adjustable for all products in the theme settings.', 'azin-file' ),
            ),

            array(
                'name'  => __( 'Additional product button title', 'azin-file' ),
                'id'    => $prefix . 'add_btn_title',
                'type'  => 'text',
            ),
            
            array(
                'name'    => __( 'Additional product button link', 'azin-file' ),
                'id'      => $prefix . 'add_btn_link',
                'type'  => 'text',
            ),
        ),
    );

    //Product Top Banner
    $meta_boxes[] = array(
        'id'         => $prefix .'product_top_banner',
        'post_types' => array( 'download', 'product' ),
        'title'  => __( 'Upload product top banner', 'azin-file' ),
        'fields' => array(
            array(
                'type' => 'heading',
                'name' => '',
                'desc' => __( 'This banner is displayed at the top of the product', 'azin-file' ),
            ),            
            array(
                'name'             => __( 'Banner', 'azin-file' ),
                'id'               => $prefix . 'product_top_banner_img',
                'type'             => 'file_input',
                'force_delete'     => false,
                'class'            => 'fshow',
            ),
            array(
                'name'  => __( 'Title', 'azin-file' ),
                'id'    => $prefix . 'product_top_banner_title',
                'type'  => 'text',
            ),
            
            array(
                'name'    => __( 'Link', 'azin-file' ),
                'id'      => $prefix . 'product_top_banner_link',
                'type'  => 'text',
            ),
        ),
    );

    return $meta_boxes;
}

//azin_product_types
function azin_product_types() {
    
    $azin_product_type = array(
        'graduation-cap' => __( 'Education', 'azin-file' ),
        'film' => __( 'Movie', 'azin-file' ),
        'image' => __( 'Image', 'azin-file' ),
        'music' => __( 'Sound', 'azin-file' ),
        'book' => __( 'Book', 'azin-file' ),
        'cube' => __( '3D Model', 'azin-file' ),
        'laptop-code' => __( 'Software', 'azin-file' ),
        'file-alt' => __( 'Others', 'azin-file' ),
    );

    
    for( $i=1; $i<6; $i++) {
        if ( azin_opt( 'product_type'.$i ) ) {
            $icon_type = 'c' . azin_opt( 'product_type'.$i.'_icon' );
            $icon_title = azin_opt( 'product_type'.$i.'_title' );
            $azin_custom_type[ $icon_type ] = $icon_title;
        }
    }

    if ( !empty ( $azin_custom_type ) ) {
        $azin_product_types = array_merge( $azin_product_type, $azin_custom_type ); 
    } else {
        $azin_product_types = $azin_product_type;
    }

    return $azin_product_types;
    
}

//azin_product_badges
function azin_product_badges() {
    
    $azin_product_badge = array();
    
    for( $i=1; $i<7; $i++ ) {
        if ( azin_opt( 'product_badge' . $i ) ) {
            $badge_value = 'product_badge' . $i;
            $badge_title = azin_opt( 'product_badge' . $i . '_title' );
            $azin_custom_badge[ $badge_value ] = $badge_title;
        }
    }

    if ( ! empty ( $azin_custom_badge ) ) {
        $azin_product_badges = array_merge( $azin_product_badge, $azin_custom_badge );
    } else {
        $azin_product_badges = $azin_product_badge;
    }

    return $azin_product_badges;
    
}