<?php

require_once AZ_DIR . '/includes/widgets/az-course-progress.php';

//azin_is_course
function azin_is_course( $id ) {

    if ( ! azin_opt( 'course_sales_activation' ) )
        return false;

    if ( rwmb_meta( 'file_training_course', '', $id ) ) {
        return true;
    } else {
        return false;
    }
    
}

//azin_count_course
function azin_count_course( $author ) {
    $post_type = az_woo() ? 'product' : 'download';
    $query = new WP_Query( array(
        'post_type'   => $post_type,
        'post_status' => 'publish',
        'author'      => $author,
        'meta_key'    => 'file_training_course',
        'meta_value'  => 1
        ) );
    return $query->found_posts;
}

if ( azin_opt( 'course_user_panel') ) {
	//Add rewrite endpoint courses
	add_action( 'init', function() {
		add_rewrite_endpoint( 'courses', EP_ROOT | EP_PAGES );
	});
	add_filter ( 'woocommerce_account_menu_items', 'azin_account_courses_link' );
	//Add courses endpoint content
	add_action('woocommerce_account_courses_endpoint', function() {
		azin_purchased_courses();
	});
	add_filter( 'woocommerce_endpoint_courses_title', 'azin_courses_endpoint_title', 10, 2 );
	add_filter('woocommerce_get_query_vars', 'azin_courses_query_vars', 0);
}


//Add courses link to my-account page
function azin_account_courses_link( $menu_links ){
    $new = array( 'courses' => __( 'Courses', 'azin-file' ) ); 
    $menu_links = array_slice( $menu_links, 0, 2, true ) 
    + $new 
    + array_slice( $menu_links, 1, NULL, true );
    return $menu_links;
}

//azin_courses_endpoint_title
function azin_courses_endpoint_title( $title, $endpoint ) {
    $title = __( 'Courses', 'azin-file' );
    return $title;
}

//azin_courses_query_vars
function azin_courses_query_vars( $endpoints ) {
    $endpoints['courses'] = 'courses';
    return $endpoints;
}

//azin_purchased_courses
function azin_purchased_courses(){
    $downloads = WC()->customer->get_downloadable_products();
 ?>
    <section class="woocommerce-order-downloads">
		<?php if ( isset( $show_title ) ) : ?>
			<h2 class="woocommerce-order-downloads__title"><?php esc_html_e( 'Courses', 'azin-file' ); ?></h2>
		<?php endif; ?>

		<div id="accordion" class="azin-download-accordion">
			<?php $downloadNumber = 1; ?>
			<?php foreach ( $downloads as $download ) :
				$id = $download['product_id'];
				if ( rwmb_meta( 'file_training_course', '', $id ) == 1 ) {
			?>

				<div class="card">

					<div class="card-header" id="heading<?php echo $downloadNumber; ?>">
						<h5 class="mb-0">
							<button class="btn btn-link" data-toggle="collapse" data-target="#collapse<?php echo $downloadNumber; ?>" aria-expanded="true" aria-controls="collapse<?php echo $downloadNumber; ?>">
							<?php
							echo get_the_post_thumbnail( $download['product_id'], 'thumbnail' );

								//if ( $download['product_url'] ) {
									//echo '<a href="' . esc_url( $download['product_url'] ) . '">' . esc_html( $download['product_name'] ) . '</a>';
								//} else {
									echo esc_html( $download['product_name'] );
								//}
							?>
							</button>
						</h5>
					</div>

					<div id="collapse<?php echo $downloadNumber; ?>" class="collapse" aria-labelledby="heading<?php echo $downloadNumber; ?>" data-parent="#accordion">
						<div class="card-body azin-accordion-body">

							<?php 

							if ( azin_opt( 'show_downloads_fields' ) && ! empty ( azin_opt( 'downloads_fields' ) ) ) {
								
								$count = count ( azin_opt( 'downloads_fields' ) );
								$i = 0;
								foreach( azin_opt( 'downloads_fields' ) as $field ) {
									$title = '';
									$icon  = '';
									$value = '';
									if ( $i++ > $count ) break;
									switch ( $field ) {
										case 'field-one':
											$title = azin_opt( 'fone' );
											$icon = ( ! empty ( azin_opt( 'fone_icon' ) ) ? azin_opt( 'fone_icon' ) : 'fa-file-alt' );
											$value = rwmb_meta( 'file_fone', '', $id );
											break;
										case 'field-two':
											$title = azin_opt( 'ftwo' );
											$icon = ( ! empty ( azin_opt( 'ftwo_icon' ) ) ? azin_opt( 'ftwo_icon' ) : 'fa-save' );
											$value = rwmb_meta( 'file_ftwo', '', $id );
											break;
										case 'field-three':
											$title = azin_is_course( $id ) && ! azin_opt( 'edit_fthree' ) ? __( 'Teacher', 'azin-file' ) : azin_opt( 'fthree' );
											$icon = azin_opt( 'fthree_icon' );
											if ( azin_opt( 'edit_fthree' ) ) { 
												$value = rwmb_meta( 'file_fthree', '', $id );
											} else {
												$author_id = get_post_field( 'post_author', $id );
												$value = get_the_author_meta( 'display_name', $author_id );
											}
											break;
										case 'field-four':
											$title = azin_opt( 'ffour' );
											$icon = azin_opt( 'ffour_icon' );
											if ( azin_opt( 'edit_ffour' ) ) {
												$value = rwmb_meta( 'file_ffour', '', $id );
											} else {
												$value = get_the_date( 'j F Y' ); 
											}
											break;
										case 'field-five':
											$title = azin_opt( 'ffive' );
											$icon = ( ! empty ( azin_opt( 'ffive_icon' ) ) ? azin_opt( 'ffive_icon' ) : 'fa-folder-open' );
											if ( azin_opt( 'edit_ffive' ) ) {
												$value = rwmb_meta( 'file_ffive', '', $id );
											} else {
												$sep = ( is_rtl() ? '، ' : ', ' );
												$term_obj_list = get_the_terms( $id, 'product_cat' );
												$value = join( $sep, wp_list_pluck( $term_obj_list, 'name') );
											}
											break;
										case 'field-six':
											$title = azin_opt( 'fsix' );
											$icon = azin_opt( 'fsix_icon' );
											if ( azin_opt( 'edit_fsix' ) ) {
												$value = rwmb_meta( 'file_fsix', '', $id );
											} else {
												$value = getPostViews( $id );
											}
											break;
										case 'field-dcount':
											$title = azin_is_course( $id ) && ! azin_opt( 'edit_dcount' ) ? __( 'Number of students', 'azin-file' ) : azin_opt( 'dcount_title' );
											$icon  = azin_opt( 'dcount_icon' );
											if ( azin_opt( 'edit_dcount' ) ) {
												$value = rwmb_meta( 'file_dcount', '', $id );
											} else {
												$count = get_post_meta( $id, 'total_sales', true );
												$value = $count . __( ' Sales', 'azin-file' );
											}
											break;
										case 'field-modified':
											$title = azin_opt( 'modified_date_title' );
											$icon  = azin_opt( 'modified_date_icon' );
											if ( azin_opt( 'edit_modified_date' ) ) {
												$value = rwmb_meta( 'file_modified_date', '', $id );
											} else {
												$value = get_the_modified_time( 'j F Y', $id );
											}
											break;
										case 'field-sku':
											$title = azin_opt( 'product_sku_title' );
											$icon  = azin_opt( 'product_sku_icon' );
											if ( azin_opt( 'edit_product_sku' ) ) {
												$value = rwmb_meta( 'file_modified_date', '', $id );
											} else {
												$product = wc_get_product( $id );
												$value = $product->get_sku();
											}
											break;
									} 
									
									if ( ! empty ( $title ) && ! empty ( $value ) ) {
									?>
									<div class="col-12 col-md-6 col-xl-4 azin-accordion-extra azin-downloads-field-<?php echo $i ?>">
										<i class="fa <?php echo $icon ?>" aria-hidden="true"></i>
										<?php echo $title . ': ' . $value; ?>
									</div>
								<?php
									}
								}
							}
							?>

							<div class="col-12 col-md-6 col-xl-4 azin-accordion-extra azin-remaining-downloads">
								<i class="fa fa-tasks" aria-hidden="true"></i>
								<?php
									_e( 'Remaining downloads: ', 'azin-file' );
									echo is_numeric( $download['downloads_remaining'] ) ? esc_html( $download['downloads_remaining'] ) : esc_html__( '&infin;', 'azin-file' );
								?>
							</div>

							<div class="col-12 col-md-6 col-xl-4 azin-accordion-extra azin-access-expiration">
								<i class="fa fa-alarm-exclamation" aria-hidden="true"></i>
								<?php
									_e( 'Access Expiration: ', 'azin-file' );
									if ( ! empty( $download['access_expires'] ) ) {
										echo '<time datetime="' . esc_attr( date( 'Y-m-d', strtotime( $download['access_expires'] ) ) ) . '" title="' . esc_attr( strtotime( $download['access_expires'] ) ) . '">' . esc_html( date_i18n( get_option( 'date_format' ), strtotime( $download['access_expires'] ) ) ) . '</time>';
									} else {
										esc_html_e( 'Never', 'azin-file' );
									}
								?>
							</div>

							<?php
							$lists = $download['list'];

							if ( empty( $lists ) ) {
								_e( 'No Download Files', 'azin-file' );
								return;
							}
						
							echo '<ul class="azin-download-list col-12">';
						
							foreach ( $lists as $list ) {
								echo '<li>';
								echo '<a href="' . esc_url( $list['download_url'] ) . '" class="woocommerce-MyAccount-downloads-file">';
								echo esc_html( $list['file_name'] );
								echo '</a></li>';
							}
						
							echo '</ul>';
							//do_action( 'woocommerce_account_downloads_column_download-file', $download );
							?>


						</div>
					</div>

				</div>

				<?php $downloadNumber++;
				} ?>
			<?php endforeach;
			if ( $downloadNumber == 1 ) { ?>
				<div class="woocommerce-Message woocommerce-Message--info woocommerce-info">
					<a class="woocommerce-Button button" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
						<?php _e( 'Browse products', 'azin-file' ); ?>
					</a>
					<?php _e( 'You have not purchased any courses.', 'azin-file' ); ?>
				</div>
			<?php
			}
			?>
		</div>
	</section>
 <?php
}

//Remove downloads item from user panel
if( azin_opt( 'course_user_panel' ) && azin_opt( 'remove_downloads' ) ) {
    add_filter( 'woocommerce_account_menu_items', 'az_remove_my_account_downloads_items' );
}
function az_remove_my_account_downloads_items( $items ) {
    unset( $items['downloads'] );
    return $items;
}

// azin_course_lessons_tab
add_filter( 'woocommerce_product_tabs', 'azin_course_lessons_tab' );
function azin_course_lessons_tab( $tab ) {

    global $product;

    if ( ! azin_opt( 'show_course_lessons' ) || wc_customer_bought_product( '', get_current_user_id(), $product->get_id() ) || ! azin_is_course( $product->get_id() ) )
        return $tab;

    $tab_title = ! empty ( azin_opt( 'course_lessons_title' ) ) ? azin_opt( 'course_lessons_title' ) : __( 'Course lessons', 'azin-file' );

	$tab_icon = azin_opt( 'course_lessons_icon' );

    if( ! empty( $tab_icon ) && $tab_icon != 'none' )
        $tab_title = '<i class="azin-tab-icon fal fa-'. $tab_icon .'"></i> '. $tab_title;
    
    $tab['azin_course_lessons'] = array(
        'title'     => $tab_title,
        'priority'  => 10,
        'callback'  => 'azin_course_lessons_content'
    );

    return $tab;
}

// azin_course_lessons_content
function azin_course_lessons_content() {
    
    global $product;
    $downloads = $product->get_downloads();

    echo '<div class="azin-course-lessons-tab-content">';
        echo do_shortcode( azin_opt( 'course_lessons_content' ) );
    echo '</div>';

    if ( ! empty( $downloads ) ) {
        echo '<ul class="azin-course-lessons col-12">';
		$count = 1;
        foreach ( $downloads as $download ) {
			if ( rwmb_meta( 'file_first_lesson_free', '', $product->get_id() ) && $count == 1 ) {
                echo '<li class="azin-first-lesson-free">';
					echo '<a href="'. esc_html( $download['file'] ) .'" title="'. esc_html( $download['name'] ) .'">';
                    	echo esc_html( $download['name'] ) . '<span class="azin-lesson-notice">' .__( ' (Download for free)', 'azin-file' ).'</span>';
					echo '</a>';
                echo '</li>';
			} else {
				echo '<li>';
					echo esc_html( $download['name'] ) . '<span class="azin-lesson-notice">' .__( ' (You must purchase the course to download)', 'azin-file' ).'</span>';
				echo '</li>';
			}
			$count++;
        }
        echo '</ul>';
    }
}

// azin_course_lessons_content
function azin_edd_course_lessons_content( $product_id ) {
    
	$downloads = get_post_meta( $product_id, 'edd_download_files', true );

    echo '<div class="azin-course-lessons-tab-content">';
        echo do_shortcode( azin_opt( 'course_lessons_content' ) );
    echo '</div>';

    if ( ! empty( $downloads ) ) {
        echo '<ul class="azin-course-lessons col-12">';
		$count = 1;
        foreach ( $downloads as $download ) {
			if ( rwmb_meta( 'file_first_lesson_free', '', $product_id ) && $count == 1 ) {
                echo '<li class="azin-first-lesson-free">';
					echo '<a href="'. esc_html( $download['file'] ) .'" title="'. esc_html( $download['name'] ) .'">';
                    	echo esc_html( $download['name'] ) . '<span class="azin-lesson-notice">' .__( ' (Download for free)', 'azin-file' ).'</span>';
					echo '</a>';
                echo '</li>';
			} else {
				echo '<li>';
					echo esc_html( $download['name'] ) . '<span class="azin-lesson-notice">' .__( ' (You must purchase the course to download)', 'azin-file' ).'</span>';
				echo '</li>';
			}
			$count++;
        }
        echo '</ul>';
    }
}