<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
   exit;

if ( az_woo() ) {
   $post_type    = 'product';
   $cat_taxonomy = 'product_cat';
} else {
   $post_type    = 'download';
   $cat_taxonomy = 'download_category';
}
 
//Recent Products
if ( azin_opt( 'show_recent_prod' ) ) {

   $args = array(
      'posts_per_page' => 8,
      'post_type' => $post_type,
      'post_status' => 'publish',
      'order' => 'DESC'
   );

   if ( az_woo() && 'yes' === get_option( 'woocommerce_hide_out_of_stock_items' ) ) {
      $args['meta_query' ] = array(
         'relation' => 'AND',
         array(
               'key' => '_stock_status',
               'value' => 'instock'
         )
      );
   }

   $block_args = array(
      'block_title'      => azin_opt( 'recent_prod_title' ),
      'block_icon'       => azin_opt( 'recent_prod_icon' ),
      'block_itemscount' => azin_opt( 'main_bcol_count' ),
      'block_itemplay'   => azin_opt( 'recent_prod_play' ) ? true : false,
      'block_query'      => $args,
      'block_post_type'  => $post_type
   );

   azin_carousel_block( $block_args ); 

}
//Recent Products
?>

<?php
//Products Blocks
for ( $block_num = 1; $block_num < 6; $block_num++ ) {

   $block = az_dig2word( $block_num );

   if ( azin_opt( 'show_block_' . $block ) ) {

      $args = array(
         'posts_per_page' => 8,
         'post_type' => $post_type,
         'post_status' => 'publish',
            'tax_query' => array(
               array(
                  'taxonomy' => $cat_taxonomy,
                  'field' => 'term_id',
                  'terms' => azin_opt( 'block_'. $block .'_cat' )
               )
            ),
         'order' => 'DESC'  );

      if ( az_woo() && 'yes' === get_option( 'woocommerce_hide_out_of_stock_items' ) ) {
         $args['meta_query' ] = array(
                     'relation' => 'AND',
                     array(
                           'key' => '_stock_status',
                           'value' => 'instock'
                     )
                  );
      }

      $block_title_link = ! empty( azin_opt( 'block_'. $block .'_cat' ) ) ? get_term_link( (int)azin_opt( 'block_'. $block .'_cat' ), $cat_taxonomy ) : '';
      
      $block_args = array(
         'block_title'      => azin_opt( 'block_'. $block .'_title' ),
         'block_title_link' => $block_title_link,
         'block_icon'       => azin_opt( 'block_'. $block .'_icon' ),
         'block_itemscount' => azin_opt( 'main_bcol_count' ),
         'block_itemplay'   => azin_opt( 'block_'. $block .'_play' ) ? true : false,
         'block_query'      => $args,
         'block_post_type'  => $post_type
      );

      azin_carousel_block( $block_args );
      
   }
}

//Posts Blocks
for ( $block_num = 1; $block_num < 6; $block_num++ ) {

   $block = az_dig2word( $block_num );

   if ( azin_opt( 'show_pblock_' . $block ) ) {

      $args = array(
         'posts_per_page' => 8,
         'post_type'      => 'post',
         'post_status'    => 'publish',
         'category__in'   => azin_opt( 'pblock_'. $block .'_cat' ),
         'order'          => 'DESC'  
      );

      $block_title_link = ! empty( azin_opt( 'pblock_'. $block .'_cat' ) ) ? get_category_link( azin_opt( 'pblock_'. $block .'_cat' ) ) : '';
      
      $block_args = array(
         'block_title'      => azin_opt( 'pblock_'. $block .'_title' ),
         'block_title_link' => $block_title_link,
         'block_icon'       => azin_opt( 'pblock_'. $block .'_icon' ),
         'block_itemscount' => azin_opt( 'main_bcol_count' ),
         'block_itemplay'   => azin_opt( 'pblock_'. $block .'_play' ) ? true : false,
         'block_query'      => $args,
         'block_post_type'  => 'post'
      );

      azin_carousel_block( $block_args );
   }
}
?>