<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

// Breadcrumbs
function breadcrumb() {
    
    // Settings
    $separator          = '<span class="breadcrumbs__separator"> » </span>';
    $breadcrums_id      = 'breadcrumbs';
    $breadcrums_class   = 'breadcrumbs';
    $home_title         = azin_opt( 'text_home' );
      
    // If you have any custom post types with custom taxonomies, put the taxonomy name below (e.g. product_cat)
    if ( az_woo() ) {
        $custom_taxonomy    = 'product_cat';
    } else {
        $custom_taxonomy    = 'download_category';
    }
       
    // Get the query & post information
    global $post, $wp_query;
       
    // Do not display on the homepage
    if ( !is_front_page() ) {
       
        // Build the breadcrums
        echo '<ul id="' . $breadcrums_id . '" class="' . $breadcrums_class . '"  itemscope itemtype="http://schema.org/BreadcrumbList">';
           
        // Home page
        echo '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem" class="item-home"><a itemprop="item" class="bread-link bread-home" href="' . get_home_url() . '" title="' . $home_title . '"><span itemprop="name">' . $home_title . '</span></a><meta itemprop="position" content="1" /></li>';
        echo '<li class="separator separator-home"> ' . $separator . ' </li>';
           
        if ( is_archive() && !is_tax() && !is_category() && !is_tag() ) {
            $prefix = '';
            echo '<li class="item-current item-archive"><span class="bread-current bread-archive">' . post_type_archive_title( $prefix, false) . '</span></li>';
              
        } else if ( is_archive() && is_tax() && !is_category() && !is_tag() ) {
              
            // If post is a custom post type
            $post_type = get_post_type();
              
            // If it is a custom post type display name and link
            if ( $post_type != 'post' ) {
                  
                $post_type_object = get_post_type_object( $post_type);
                $post_type_archive = get_post_type_archive_link( $post_type);

                if ( is_object( $post_type_object ) ) {
                    echo '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem" class="item-cat item-custom-post-type-' . $post_type . '">
                    <a itemprop="item" class="bread-cat bread-custom-post-type-' . $post_type . '" href="' . $post_type_archive . '" title="' . $post_type_object->labels->name . '">
                    <span itemprop="name">' . $post_type_object->labels->name . '</span>
                    </a><meta itemprop="position" content="2" /></li>';
                    echo '<li class="separator"> ' . $separator . ' </li>';
                }
              
            }
              
            $custom_tax_name = get_queried_object()->name;
            echo '<li class="item-current item-archive"><span class="bread-current bread-archive">' . $custom_tax_name . '</span></li>';
              
        } else if ( is_single() ) {
              
            // If post is a custom post type
            $post_type = get_post_type();
              
            // If it is a custom post type display name and link
            if ( $post_type != 'post' ) {
                  
                $post_type_object = get_post_type_object( $post_type);
                $post_type_archive = get_post_type_archive_link( $post_type);
              
                echo '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem" class="item-cat item-custom-post-type-' . $post_type . '"><a itemprop="item" class="bread-cat bread-custom-post-type-' . $post_type . '" href="' . $post_type_archive . '" title="' . $post_type_object->labels->name . '"><span itemprop="name">' . $post_type_object->labels->name . '</span></a><meta itemprop="position" content="2" /></li>';
                echo '<li class="separator"> ' . $separator . ' </li>';
              
            }
              
            // Get post category info
            $category = get_the_category();
             
            if ( ! empty( $category ) ) {
              
                // Get last category post is in
                $catArray = array_values( $category );
                $last_category = end( $catArray );
                  
                // Get parent any categories and create array
                $get_cat_parents = rtrim( get_category_parents( $last_category->term_id, true, ',' ),',' );
                $cat_parents = explode( ',', $get_cat_parents);
                  
                // Loop through parent categories and store in variable $cat_display
                $cat_display = '';
                $position = 2;
                foreach( $cat_parents as $parents) {
                    $parents = str_replace( '<a', '<a itemprop="item"', $parents);
                    $parents = str_replace( '">', '"><span itemprop="name">', $parents);
                    $parents = str_replace( '</a>', '</span></a>', $parents);
                    $cat_display .= '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem" class="item-cat">'.$parents.'<meta itemprop="position" content="'.$position.'"</li>';
                    $cat_display .= '<li class="separator"> ' . $separator . ' </li>';
                    $position ++;
                }
             
            }
              
            // If it's a custom post type within a custom taxonomy
            $taxonomy_exists = taxonomy_exists( $custom_taxonomy );
            if ( empty( $last_category ) && ! empty( $custom_taxonomy ) && $taxonomy_exists ) {
                   
                $taxonomy_terms = ! empty ( get_the_terms( $post->ID, $custom_taxonomy ) ) ? get_the_terms( $post->ID, $custom_taxonomy ) : '';
                
                if ( is_array ( $taxonomy_terms ) && is_object ( $taxonomy_terms[0] ) ) {
                    $cat_id         = ! empty ( $taxonomy_terms[0]->term_id ) ? $taxonomy_terms[0]->term_id : '';
                    $cat_nicename   = ! empty ( $taxonomy_terms[0]->slug ) ? $taxonomy_terms[0]->slug : '';
                    $cat_link       = ! empty ( get_term_link( $taxonomy_terms[0]->term_id, $custom_taxonomy) ) ? get_term_link( $taxonomy_terms[0]->term_id, $custom_taxonomy) : '';
                    $cat_name       = ! empty ( $taxonomy_terms[0]->name ) ? $taxonomy_terms[0]->name : '';
                }
               
            }
              
            // Check if the post is in a category
            if ( ! empty( $last_category) ) {
                echo $cat_display;
                echo '<li class="item-current item-' . $post->ID . '"><span class="bread-current bread-' . $post->ID . '" title="' . get_the_title() . '" itemprop="name">' . get_the_title() . '</span></li>';
                  
            // Else if post is in a custom taxonomy
            } else if ( ! empty( $cat_id) ) {
                  
                echo '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem" class="item-cat item-cat-' . $cat_id . ' item-cat-' . $cat_nicename . '"><a itemprop="item" class="bread-cat bread-cat-' . $cat_id . ' bread-cat-' . $cat_nicename . '" href="' . $cat_link . '" title="' . $cat_name . '"><span itemprop="name">' . $cat_name . '</span></a><meta itemprop="position" content="3" /></li>';
                echo '<li class="separator"> ' . $separator . ' </li>';
                echo '<li class="item-current item-' . $post->ID . '"><span class="bread-current bread-' . $post->ID . '" title="' . get_the_title() . '">' . get_the_title() . '</span></li>';
              
            } else {
                  
                echo '<li class="item-current item-' . $post->ID . '"><span class="bread-current bread-' . $post->ID . '" title="' . get_the_title() . '">' . get_the_title() . '</span></li>';
                  
            }
              
        } else if ( is_category() ) {
               
            // Category page
            echo '<li class="item-current item-cat"><span class="bread-current bread-cat">' . single_cat_title( '', false) . '</span></li>';
               
        } else if ( is_page() ) {
               
            // Standard page
            if ( $post->post_parent ) {
                   
                // If child page, get parents 
                $anc = get_post_ancestors( $post->ID );
                   
                // Get parents in the right order
                $anc = array_reverse( $anc);
                   
                // Parent page loop
                if ( !isset( $parents ) ) $parents = null;
                foreach ( $anc as $ancestor ) {
                    $parents .= '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem" class="item-parent item-parent-' . $ancestor . '"><a itemprop="item" class="bread-parent bread-parent-' . $ancestor . '" href="' . get_permalink( $ancestor) . '" title="' . get_the_title( $ancestor) . '"><span itemprop="name">' . get_the_title( $ancestor) . '</span></a><meta itemprop="position" content="2" /></li>';
                    $parents .= '<li class="separator separator-' . $ancestor . '"> ' . $separator . ' </li>';
                }
                   
                // Display parent pages
                echo $parents;
                   
                // Current page
                echo '<li class="item-current item-' . $post->ID . '"><span title="' . get_the_title() . '">' . get_the_title() . '</span></li>';
                   
            } else {
                   
                // Just display current page if not parents
                echo '<li class="item-current item-' . $post->ID . '"><span class="bread-current bread-' . $post->ID . '">' . get_the_title() . '</span></li>';
                   
            }
               
        } else if ( !is_front_page() && is_home() ) {
            echo '<li class="item-current item-blog"><span class="bread-current bread-blog">'.__( 'Blog', 'azin-file' ).'</span></li>';
        } else if ( is_tag() ) {
               
            // Tag page
               
            // Get tag information
            $term_id        = get_query_var( 'tag_id' );
            $taxonomy       = 'post_tag';
            $args           = 'include=' . $term_id;
            $terms          = get_terms( $taxonomy, $args );
            $get_term_id    = $terms[0]->term_id;
            $get_term_slug  = $terms[0]->slug;
            $get_term_name  = $terms[0]->name;
               
            // Display the tag name
            echo '<li class="item-current item-tag-' . $get_term_id . ' item-tag-' . $get_term_slug . '"><span class="bread-current bread-tag-' . $get_term_id . ' bread-tag-' . $get_term_slug . '">' . $get_term_name . '</span></li>';
           
        } elseif ( is_day() ) {
               
            // Day archive
               
            // Year link
            echo '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem" class="item-year item-year-' . get_the_time( 'Y' ) . '"><a itemprop="item" class="bread-year bread-year-' . get_the_time( 'Y' ) . '" href="' . get_year_link( get_the_time( 'Y' ) ) . '" title="' . get_the_time( 'Y' ) . '"><span itemprop="name">' . __( 'Archives of ', 'azin-file') . get_the_time( 'Y' ) . ' </span></a><meta itemprop="position" content="2" /></li>';
            echo '<li class="separator separator-' . get_the_time( 'Y' ) . '"> ' . $separator . ' </li>';
               
            // Month link
            echo '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem" class="item-month item-month-' . get_the_time( 'm' ) . '"><a itemprop="item" class="bread-month bread-month-' . get_the_time( 'm' ) . '" href="' . get_month_link( get_the_time( 'Y' ), get_the_time( 'm' ) ) . '" title="' . get_the_time( 'M' ) . '"><span itemprop="name">' . __( 'Archives of ', 'azin-file') . get_the_time( 'M' ) . ' </span></a><meta itemprop="position" content="2" /></li>';
            echo '<li class="separator separator-' . get_the_time( 'm' ) . '"> ' . $separator . ' </li>';
               
            // Day display
            echo '<li class="item-current item-' . get_the_time( 'j' ) . '"><span class="bread-current bread-' . get_the_time( 'j' ) . '">' . __( 'Archives of ', 'azin-file') . get_the_time( 'jS' ) . ' ' . get_the_time( 'M' ) . '</span></li>';
               
        } else if ( is_month() ) {
               
            // Month Archive
               
            // Year link
            echo '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem" class="item-year item-year-' . get_the_time( 'Y' ) . '"><a itemprop="item" class="bread-year bread-year-' . get_the_time( 'Y' ) . '" href="' . get_year_link( get_the_time( 'Y' ) ) . '" title="' . get_the_time( 'Y' ) . '"><span itemprop="name">' . __( 'Archives of ', 'azin-file') . get_the_time( 'Y' ) . '</span></a><meta itemprop="position" content="2" /></li>';
            echo '<li class="separator separator-' . get_the_time( 'Y' ) . '"> ' . $separator . ' </li>';
               
            // Month display
            echo '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem" class="item-month item-month-' . get_the_time( 'm' ) . '"><span class="bread-month bread-month-' . get_the_time( 'm' ) . '" title="' . get_the_time( 'M' ) . '">' . __( 'Archives of ', 'azin-file') . get_the_time( 'M' ) . '</span></li>';
               
        } else if ( is_year() ) {
               
            // Display year archive
            echo '<li class="item-current item-current-' . get_the_time( 'Y' ) . '"><span class="bread-current bread-current-' . get_the_time( 'Y' ) . '" title="' . get_the_time( 'Y' ) . '">' . __( 'Archives of ', 'azin-file') . get_the_time( 'Y' ) . '</span></li>';
               
        } else if ( is_author() ) {
               
            // Auhor archive
               
            // Get the author information
            global $author;
            $userdata = get_userdata( $author );
               
            // Display author name
            echo '<li class="item-current item-current-' . $userdata->user_nicename . '"><span class="bread-current bread-current-' . $userdata->user_nicename . '" title="' . $userdata->display_name . '">' . 'Author: ' . $userdata->display_name . '</span></li>';
           
        } else if ( get_query_var( 'paged' ) ) {
               
            // Paginated archives
            echo '<li class="item-current item-current-' . get_query_var( 'paged' ) . '"><span class="bread-current bread-current-' . get_query_var( 'paged' ) . '" title="'. __( 'Page ', 'azin-file') . get_query_var( 'paged' ) . '">'. __( 'Page ', 'azin-file') . get_query_var( 'paged' ) . '</span></li>';
               
        } else if ( is_search() ) {
           
            // Search results page
            echo '<li class="item-current item-current-' . get_search_query() . '"><span class="bread-current bread-current-' . get_search_query() . '" title="' . __( 'Search results for: ', 'azin-file') . get_search_query() . '">' . __( 'Search results for: ', 'azin-file') . get_search_query() . '</span></li>';
           
        } elseif ( is_404() ) {
               
            // 404 page
            echo '<li>' . __( 'Not found', 'azin-file') . '</li>';
        }
       
        echo '</ul>';
           
    }
       
}