<?php

//Products per page of the More Products tab
add_filter( 'dokan_get_more_products_per_page', function($post_per_page) {
    return 4;
} );

//Add Dokan link to my account page
add_filter ( 'woocommerce_account_menu_items', 'dokan_acc_link' );
function dokan_acc_link( $menu_links ) {
    $user = wp_get_current_user();
    if( user_can( $user, 'dokandar' ) ) {
        $new = array( 'dokan-link' => __( 'Vendor Dashboard' , 'azin-file') ); 
    } else {
        $new = array( 'dokan-link-become' => __( 'Become a Vendor' , 'azin-file') ); 
    }
    $menu_links = array_slice( $menu_links, 0, 1, true )
    + $new 
    + array_slice( $menu_links, 1, NULL, true );
    return $menu_links;
}
add_filter( 'woocommerce_get_endpoint_url', 'dokan_hook_endpoint', 5, 4 );
function dokan_hook_endpoint( $url, $endpoint, $value, $permalink ) {
    if( $endpoint === 'dokan-link' ) {
        $seller_dashboard = dokan_get_option( 'dashboard', 'dokan_pages' );
        $url = get_permalink( $seller_dashboard );
    } elseif( $endpoint === 'dokan-link-become' ) {
        $url = esc_url( dokan_get_page_url( 'myaccount', 'woocommerce', 'account-migration' ) );
    }
    return $url;
}

//Add add-product link to my account page
if ( is_user_logged_in() ) {
    $user = wp_get_current_user();

    if ( user_can( $user, 'dokandar' ) ) {
                
        add_filter ( 'woocommerce_account_menu_items', 'add_product_dokan_link' );
        function add_product_dokan_link( $menu_links ) {
            $new = array( 'add-product-dokan' => __( 'Add Product', 'azin-file') ); 
            $menu_links = array_slice( $menu_links, 0, 2, true ) 
            + $new 
            + array_slice( $menu_links, 1, NULL, true );
            return $menu_links;
        }
        
        add_filter( 'woocommerce_get_endpoint_url', 'add_product_dokan_endpoint', 10, 4 );
        function add_product_dokan_endpoint( $url, $endpoint, $value, $permalink ) {
            $seller_dashboard = dokan_get_option( 'dashboard', 'dokan_pages' );

            if ( $seller_dashboard != -1 ) {
                $seller_page = get_permalink( $seller_dashboard );
            }
            if ( $endpoint === 'add-product-dokan' ) {
                $url = esc_url( $seller_page . 'new-product/' );
            }
            return $url;
        }
    }
}

//Remove Dokan FontAwesome Library
add_action( 'wp_enqueue_scripts', 'remove_default_stylesheet' );
function remove_default_stylesheet() {
    wp_dequeue_style( 'dokan-fontawesome' );
    wp_deregister_style( 'dokan-fontawesome' );
}

//Set template of Dokan
add_filter( 'page_template', 'dokan_page_template' );
function dokan_page_template( $page_template ) {
    $post_id = get_the_ID();
    if ( $post_id === (int)dokan_get_option( 'dashboard', 'dokan_pages' ) ) {
        $page_template = get_stylesheet_directory() . '/dashboard.php'; 
    } 
    return $page_template;
}

add_action( 'dokan_dashboard_wrap_start', 'azin_dokan_dashboard_wrap_start', 10);
function azin_dokan_dashboard_wrap_start() {
if ( azin_opt( 'show_bread' ) && azin_opt( 'bread_style_two' ) && ! is_front_page() ) {
    azin_bread_two( get_the_ID() );
}
?>
<div class="container-fluid main-con">
    <main class="container">
        <?php azin_bread(); ?>
            <div class="row main<?php side_type(); ?>" id="main" <?php if ( azin_opt( 'site_schema' ) ) { ?>itemscope itemtype="https://schema.org/Blog" <?php } ?>>
                <section class="single-con">
                    <article>
<?php }

add_action( 'dokan_dashboard_wrap_end', 'azin_dokan_dashboard_wrap_end', 10);
function azin_dokan_dashboard_wrap_end() {
 ?>
                    </article>
                </section>
            </div>
    </main>
</div>
<?php }

function az_get_vendor_rating( $vendor_id) {
    global $wpdb;

    $result = $wpdb->get_row( $wpdb->prepare(
        "SELECT AVG( cm.meta_value) as average, COUNT(wc.comment_ID) as count FROM $wpdb->posts p
        INNER JOIN $wpdb->comments wc ON p.ID = wc.comment_post_ID
        LEFT JOIN $wpdb->commentmeta cm ON cm.comment_id = wc.comment_ID
        WHERE p.post_author = %d AND p.post_type = 'product' AND p.post_status = 'publish'
        AND ( cm.meta_key = 'rating' OR cm.meta_key IS NULL) AND wc.comment_approved = 1
        ORDER BY wc.comment_post_ID", $vendor_id ) );

    $rating_value = apply_filters( 'dokan_seller_rating_value', array(
        'rating' => number_format( $result->average, 2 ),
        'count'  => (int) $result->count
    ), $vendor_id );

    return $rating_value;
}


//Remove shippng tab from WooCommerce single product page
if( azin_opt( 'hide_dokan_shipping' ) ) { 
    add_filter( 'woocommerce_product_tabs', 'azin_remove_shipping_product_tab', 98 );
    function azin_remove_shipping_product_tab( $tabs) {
        unset( $tabs['shipping']);
        return $tabs;
    }
}

//Remove seller product tab from WooCommerce single product page
if( azin_opt( 'hide_dokan_seller_info' ) ) {
    add_filter( 'woocommerce_product_tabs', 'azin_remove_seller_product_tab', 98 );
    function azin_remove_seller_product_tab( $tabs) {
        unset( $tabs['seller']);
        return $tabs;
    }
}

//Remove more seller product tab from WooCommerce single product page
if( azin_opt( 'hide_dokan_more_product' ) ) { 
    add_filter( 'woocommerce_product_tabs', 'azin_remove_more_seller_product_tab', 98 );
    function azin_remove_more_seller_product_tab( $tabs) {
        unset( $tabs['more_seller_product']);
        return $tabs;
    }
}