<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined ( 'ABSPATH' ) ) {
    exit;
}

add_action('wp_head', 'custom_styles', 160);

function custom_styles() {
    
    ?>
    <style>
    :root {
        --azin-custom-color: <?php echo azin_opt( 'custom_color' ) ?>;
        --azin-msg-bgcolor: <?php echo azin_opt( 'msg_bgcolor' ); ?>;
        --azin-msg-fcolor: <?php echo azin_opt( 'msg_fcolor' ); ?>;
        --azin-head-color: <?php echo azin_opt( 'head_color' ) ?>;
        --azin-head-text-color: <?php echo azin_opt( 'head_text_color' ) ?>;
        --azin-head-link-color: <?php echo azin_opt( 'head_link_color' ) ?>;
        --azin-head-lhover-color: <?php echo azin_opt( 'head_lhover_color' ) ?>;
        --azin-menu-text-color: <?php echo azin_opt( 'menu_text_color' ) ?>;
        --azin-menu-color: <?php echo azin_opt( 'menu_color' ) ?>;
        --azin-footer-text-color: <?php echo azin_opt( 'footer_text_color' ) ?>;
        --azin-content-font-size: <?php echo azin_opt( 'content_font_size' ) ?>px;
        --azin-h1-font-size: <?php echo azin_opt( 'h1_font_size' ) ?>px;
        --azin-h2-font-size: <?php echo azin_opt( 'h2_font_size' ) ?>px;
        --azin-h3-font-size: <?php echo azin_opt( 'h3_font_size' ) ?>px;
        --azin-h4-font-size: <?php echo azin_opt( 'h4_font_size' ) ?>px;
        --azin-h5-font-size: <?php echo azin_opt( 'h5_font_size' ) ?>px;
        --azin-h6-font-size: <?php echo azin_opt( 'h6_font_size' ) ?>px;
        --azin-add-btn-color: <?php echo azin_opt( 'add_btn_color' ) ?>;
        --azin-add-btn-text-color: <?php echo azin_opt( 'add_btn_text_color' ) ?>;
        --azin-register-btn-text-color: <?php echo azin_opt( 'register_btn_text_color' ) ?>;
        --azin-register-btn-color: <?php echo azin_opt( 'register_btn_color' ) ?>;
        --azin-register-btn-hover-text-color: <?php echo azin_opt( 'register_btn_hover_text_color' ) ?>;
        --azin-register-btn-hover-color: <?php echo azin_opt( 'register_btn_hover_color' ) ?>;
        --azin-login-btn-text-color: <?php echo azin_opt( 'login_btn_text_color' ) ?>;
        --azin-login-btn-color: <?php echo azin_opt( 'login_btn_color' ) ?>;
        --azin-login-btn-hover-text-color: <?php echo azin_opt( 'login_btn_hover_text_color' ) ?>;
        --azin-login-btn-hover-color: <?php echo azin_opt( 'login_btn_hover_color' ) ?>;
        --azin-dashboard-bg-color: <?php echo azin_opt( 'dashboard_bg_color' ) ?>;
        --azin-dashboard-text-color: <?php echo azin_opt( 'dashboard_text_color' ) ?>;
        --azin-total-orders-bg-color: <?php echo azin_opt( 'total_orders_bg_color' ) ?>;
        --azin-completed-orders-bg-color: <?php echo azin_opt( 'completed_orders_bg_color' ) ?>;
        --azin-wallet-inventory-bg-color: <?php echo azin_opt( 'wallet_inventory_bg_color' ) ?>;
        --azin-registration-date-bg-color: <?php echo azin_opt( 'registration_date_bg_color' ) ?>;
        --azin-panel-widgets-text-color: <?php echo azin_opt( 'panel_widgets_text_color' ) ?>;
        --azin-menu-label-bg-color: <?php echo azin_opt( 'menu_label_bg_color' ) ?>;
        --azin-menu-label-text-color: <?php echo azin_opt( 'menu_label_text_color' ) ?>;
        <?php if ( azin_opt( 'show_page_loading' ) ) {
        if ( ! empty ( azin_opt( 'custom_loading_image', 'url' ) ) || ! empty ( azin_opt( 'load_img' ) ) ) { ?>
        --azin-loading-img: url(<?php echo ( ! azin_opt( 'show_custom_loading' ) ? azin_opt( 'load_img' ) : azin_to_https( azin_opt( 'custom_loading_image', 'url' ) ) ); ?>);
        <?php }
        } ?>
    }

    <?php if ( azin_opt( 'custom_font' ) ) { echo azin_custom_font(); } ?>

    <?php if ( azin_opt( 'ch_scroll_style' ) ) { ?>
        body::-webkit-scrollbar {-webkit-appearance: none;width: 10px}
        body::-webkit-scrollbar-track {background: #fff;border: 1px solid #fff}
        body::-webkit-scrollbar-thumb {background: #c1c1c1;border: 1px solid #c1c1c1;height: 100px;border-radius: 5px}
        body::-webkit-scrollbar-thumb:hover {background: #a8a8a8}
    <?php if ( azin_opt( 'ch_scroll_bar' ) ) { ?>
        body::-webkit-scrollbar-thumb{background:var(--azin-custom-color)}
        body::-webkit-scrollbar-thumb:hover{background:var(--azin-custom-color)}
    <?php } } ?>

    <?php
    if ( ! azin_opt( 'fbg_switch' ) && ! empty ( azin_opt ( 'footer_bg' ) ) && azin_opt( 'footer_bg' ) != '3' ) { ?>
    footer.sfooter{background-image: url(<?php echo azin_to_https( azin_opt( 'footer_bg' ) )?>);}
    <?php } ?>
    
    .searchwp-live-search-no-min-chars:after {content: <?php _e( 'Type ...', 'azin-file' ) ?>}

    <?php if ( azin_opt( 'custom_css' ) != '' ) {
        print_r( azin_opt( 'custom_css' ) ) . "\n";
    }

    ?>
    
    <?php if ( !azin_opt( 'show_loading_bar' )) { ?>
        .pace{display: none}
    <?php } ?>

    <?php if (azin_opt( 'show_return_top' )) { ?>
        #back-top {
            bottom: <?php echo azin_opt( 'return_top_bottom' ); ?>px;
            right: <?php echo azin_opt( 'return_top_right' ); ?>px;
        }
    <?php } ?>

    <?php if (azin_opt( 'show_cart_btn' )) { ?>
        #cart-btn {
            bottom: <?php echo azin_opt( 'cart_btn_bottom' ); ?>px;
            left: <?php echo azin_opt( 'cart_btn_left' ); ?>px;
        }
        #cart-btn .shop-icon{background:<?php echo azin_opt( 'cart_btn_color' ) ?>}
        #cart-btn .shop-icon:hover{background:<?php echo azin_opt( 'cart_btn_hcolor' ) ?>}
    <?php } ?>

    <?php if (function_exists('digits_version')) { ?>
        .dig_ma-box,.dig_ma-box input,.dig_ma-box input::placeholder,.dig_ma-box ::placeholder,.dig_ma-box label,.dig_ma-box button,.dig_ma-box select,.dig_ma-box * {font-family: 'sans', sans-serif !important;}
    <?php } ?>

    <?php if ( azin_opt( 'bread_style_two' ) ) { ?>
        .bread-crumbs .bread-st-two a, .bread-extra .share-btn, .bread-crumbs .azin-like-product-single, .bread-extra .azin-like-product-single .yith-wcwl-add-to-wishlist a {
            color: <?php echo azin_opt( 'bread_link_color' ); ?> !important
        }
    <?php if ( azin_opt( 'bread_gradient' ) ) { ?>
        .bread-crumbs {
            background: <?php echo azin_opt( 'bread_gradient_color', 'from' ); ?>;
            background: -webkit-linear-gradient(to right, <?php echo azin_opt( 'bread_gradient_color', 'from' ); ?>, <?php echo azin_opt( 'bread_gradient_color', 'to' ); ?>);
            background: linear-gradient(to right, <?php echo azin_opt( 'bread_gradient_color', 'from' ); ?>, <?php echo azin_opt( 'bread_gradient_color', 'to' ); ?>);
        }
    <?php } } ?>
    
    .bnr-hover-title {
        background: <?php echo hex2rgba( azin_opt( 'custom_color' ), 0.5 );
        ?>
    }

    
    <?php if ( az_woo() && is_user_logged_in() ) { ?>

        <?php if ( azin_opt( 'dashboard_link_one' ) ) { ?>
        .woocommerce-MyAccount-navigation-link--azin-dashboard-link-one a:before {content: "\<?php echo azfa_search( azin_opt( 'dashboard_link_one_icon' ) ); ?>"}
        <?php } ?>

        <?php if ( azin_opt( 'dashboard_link_two' ) ) { ?>
        .woocommerce-MyAccount-navigation-link--azin-dashboard-link-two a:before {content: "\<?php echo azfa_search( azin_opt( 'dashboard_link_two_icon' ) ); ?>"}
        <?php } ?>

        <?php if ( azin_opt( 'dashboard_link_three' ) ) { ?>
        .woocommerce-MyAccount-navigation-link--azin-dashboard-link-three a:before {content: "\<?php echo azfa_search( azin_opt( 'dashboard_link_three_icon' ) ); ?>"}
        <?php } ?>

        <?php if ( azin_opt( 'show_purchased_tab' ) ) { ?>
        .azin_purchased_tab a:before {content: "\<?php echo azfa_search( azin_opt( 'purchased_tab_icon' ) ); ?>"}
        <?php } ?>

    <?php } elseif ( is_user_logged_in() ) { ?>

        <?php if ( azin_opt( 'dashboard_link_one' ) ) { ?>
        .customer-dashboard-menu-item.dashboard-link-one a:before,.customer-dashboard-menu-tab.dashboard-link-one a:before {content: "\<?php echo azfa_search( azin_opt( 'dashboard_link_one_icon' ) ); ?>"}
        <?php } ?>

        <?php if ( azin_opt( 'dashboard_link_two' ) ) { ?>
            .customer-dashboard-menu-item.dashboard-link-two a:before,.customer-dashboard-menu-tab.dashboard-link-two a:before {content: "\<?php echo azfa_search( azin_opt( 'dashboard_link_two_icon' ) ); ?>"}
        <?php } ?>

        <?php if ( azin_opt( 'dashboard_link_three' ) ) { ?>
            .customer-dashboard-menu-item.dashboard-link-three a:before,.customer-dashboard-menu-tab.dashboard-link-three a:before {content: "\<?php echo azfa_search( azin_opt( 'dashboard_link_three_icon' ) ); ?>"}
        <?php } ?>

    <?php } ?>

    <?php if ( azin_opt( 'product_sold_individually' ) ) { ?>
        .woocommerce-cart .product-quantity {display: none}
    <?php } ?>
        
    </style>
    
    <?php if ( ! empty( azin_opt( 'header_codes' ) ) ) {
        print_r( azin_opt( 'header_codes' ) ) . "\n";
    }
}

function azin_custom_font() {

    //Custom Font Normal
    $azin_font = '@font-face{font-family:sans;font-display: swap;font-fallback:arial, sans-serif,tahoma;font-weight:400;src:';

    if ( ! empty( azin_opt( 'theme_font_woff2', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_woff2', 'url' ) ) .") format('woff2' ),";
    }

    if ( !empty( azin_opt( 'theme_font_woff', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_woff', 'url' ) ) .") format('woff' ),";
    }

    if ( !empty( azin_opt( 'theme_font_ttf', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_ttf', 'url' ) ) .") format('ttf' ),";
    }

    if ( !empty( azin_opt( 'theme_font_eot', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_eot', 'url' ) ) .") format('eot' ),";
    }

    if ( !empty( azin_opt( 'theme_font_svg', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_svg', 'url' ) ) .") format('svg')";
    }
    
    $azin_font .= ';}';

    //Custom Font Bold
    $azin_font .= '@font-face{font-family:sans-m;font-display:swap;font-fallback:arial,sans-serif,tahoma;font-weight:500;src:';

    if ( azin_opt( 'custom_bold_font' ) && !empty( azin_opt( 'theme_font_bold_woff2', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_bold_woff2', 'url' ) ) .") format('woff2' ),";
    } elseif ( !empty( azin_opt( 'theme_font_woff2', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_woff2', 'url' ) ) .") format('woff2' ),";
    }

    if ( azin_opt( 'custom_bold_font' ) && !empty( azin_opt( 'theme_font_bold_woff', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_bold_woff', 'url' ) ) .") format('woff' ),";
    } elseif ( !empty( azin_opt( 'theme_font_woff', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_woff', 'url' ) ) .") format('woff' ),";
    }

    if ( azin_opt( 'custom_bold_font' ) && !empty( azin_opt( 'theme_font_bold_ttf', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_bold_ttf', 'url' ) ) .") format('ttf' ),";
    } elseif ( !empty( azin_opt( 'theme_font_ttf', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_ttf', 'url' ) ) .") format('ttf' ),";
    }

    if ( azin_opt( 'custom_bold_font' ) && !empty( azin_opt( 'theme_font_bold_eot', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_bold_eot', 'url' ) ) .") format('eot' ),";
    } elseif ( !empty( azin_opt( 'theme_font_eot', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_eot', 'url' ) ) .") format('eot' ),";
    }

    if ( azin_opt( 'custom_bold_font' ) && !empty( azin_opt( 'theme_font_bold_svg', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_bold_svg', 'url' ) ) .") format('svg')";
    } elseif ( !empty( azin_opt( 'theme_font_svg', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_svg', 'url' ) ) .") format('svg')";
    }
    
    $azin_font .= ';}';

    //Custom Font Farsi Digits
    $azin_font .= '@font-face{font-family:sans-fd;font-display:swap;font-fallback:arial,sans-serif,tahoma;font-weight:400;src:';

    if ( azin_opt( 'custom_farsi_font' ) && !empty( azin_opt( 'theme_font_farsi_woff2', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_farsi_woff2', 'url' ) ) .") format('woff2' ),";
    } elseif ( !empty( azin_opt( 'theme_font_woff2', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_woff2', 'url' ) ) .") format('woff2' ),";
    }

    if ( azin_opt( 'custom_farsi_font' ) && !empty( azin_opt( 'theme_font_farsi_woff', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_farsi_woff', 'url' ) ) .") format('woff' ),";
    } elseif ( !empty( azin_opt( 'theme_font_woff', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_woff', 'url' ) ) .") format('woff' ),";
    }

    if ( azin_opt( 'custom_farsi_font' ) && !empty( azin_opt( 'theme_font_farsi_ttf', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_farsi_ttf', 'url' ) ) .") format('ttf' ),";
    } elseif ( !empty( azin_opt( 'theme_font_ttf', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_ttf', 'url' ) ) .") format('ttf' ),";
    }
    
    if ( azin_opt( 'custom_farsi_font' ) && !empty( azin_opt( 'theme_font_farsi_eot', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_farsi_eot', 'url' ) ) .") format('eot' ),";
    } elseif ( !empty( azin_opt( 'theme_font_eot', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_eot', 'url' ) ) .") format('eot' ),";
    }

    if ( azin_opt( 'custom_farsi_font' ) && !empty( azin_opt( 'theme_font_farsi_svg', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_farsi_svg', 'url' ) ) .") format('svg')";
    } elseif ( !empty( azin_opt( 'theme_font_svg', 'url' ) ) ) {
        $azin_font .= "url(". azin_to_https( azin_opt( 'theme_font_svg', 'url' ) ) .") format('svg')";
    }
    
    $azin_font .= ';}';

    $azin_font .= 'body,html{font-family:sans,Arial,sans-serif,tahoma;font-size:15px}';

    //Return Custom Font
    return $azin_font;
}