<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

require_once AZ_DIR . '/includes/eudash.php';
require_once AZ_DIR . '/includes/edd/azin-purchased-course.php';

//Change product option's to dropdown

if ( azin_opt( 'change_option_mode' ) ) {
    $type = edd_single_price_option_mode( get_the_ID() ) ? 'checkbox' : 'radio';
    if ( $type == 'radio' ) {
        remove_action( 'edd_purchase_link_top', 'edd_purchase_variable_pricing', 10, 1 );
        add_action( 'edd_purchase_link_top', 'azin_edd_purchase_variable_pricing', 10, 1 );
    }
}

// remove the standard button that shows after the download's content
remove_action( 'edd_after_download_content', 'edd_append_purchase_link' );

function custom_edd_add_custom_field_support( $supports ) {
    $new = array( 'custom-fields' );
    return array_merge( $new, $supports );
}

add_action( 'init', 'my_custom_init' );
function my_custom_init() {
    add_post_type_support( 'download', 'publicize' );
}

//Theme Designed By: Meysam Hosseinkhani   
//Enable comments on downloads
function custom_enable_comments( $supports ) {
return array_merge( $supports, array( 'comments' ) );
}
add_filter( 'edd_download_supports', 'custom_enable_comments' );

//Modify Rss Feed to add download post_type
function myfeed_request( $qv) {
    if ( isset( $qv['feed'] ) ) {
    $qv['post_type'] = array( 'post', 'download' );
}
return $qv;
}
add_filter( 'request', 'myfeed_request' );

//Toman EDD Currency
function edd_rial_currency( $formatted, $currency, $price ) {
    
    if ( !is_admin() ) {
        $price = str_replace(edd_get_option( 'thousands_separator', ',' ), '', $price);
        $price = (int)$price / 10;
        if ( azin_opt( 'currency_sep' ) ) { 
        $price = edd_format_amount( $price);}
        $price = $price;
        
        return $price . __( ' Toman', 'azin-file');
    } else {
        return $price . __( ' Rials', 'azin-file');
    }
}
if ( is_rtl() && azin_opt( 'toman_currency' ) ) {
add_filter( 'edd_rial_currency_filter_after', 'edd_rial_currency', 10, 3 );
add_filter( 'edd_rial_currency_filter_before', 'edd_rial_currency', 10, 3 );
}

//Create edit-profile page
if ( isset( $_GET['activated'] ) && is_admin() ) {
        $new_page_title = __( 'User Profile', 'azin-file');
        $new_page_content = '[edd_profile_editor]';
        $new_page_addr = 'edit-profile';
        $new_page_template = ''; //ex. template-custom.php. Leave blank if you don't want a custom page template.
        //don't change the code bellow, unless you know what you're doing
        $page_check = get_page_by_title( $new_page_title);
        $new_page = array(
                'post_type' => 'page',
                'post_title' => $new_page_title,
                'post_name' => $new_page_addr,
                'post_content' => $new_page_content,
                'post_status' => 'publish',
                'post_author' => 1,
        );
        if ( !isset( $page_check->ID) ) {
                $new_page_id = wp_insert_post( $new_page);
                if ( ! empty( $new_page_template) ) {
                        update_post_meta( $new_page_id, '_wp_page_template', $new_page_template);
                }
        }
}

//Create register page
if ( isset( $_GET['activated'] ) && is_admin() ) {
        $new_page_title = __( 'Register', 'azin-file');
        $new_page_content = '[edd_register]';
        $new_page_addr = 'register';
        $new_page_template = ''; //ex. template-custom.php. Leave blank if you don't want a custom page template.
        //don't change the code bellow, unless you know what you're doing
        $page_check = get_page_by_title( $new_page_title);
        $new_page = array(
                'post_type' => 'page',
                'post_title' => $new_page_title,
                'post_name' => $new_page_addr,
                'post_content' => $new_page_content,
                'post_status' => 'publish',
                'post_author' => 1,
        );
        if ( !isset( $page_check->ID) ) {
                $new_page_id = wp_insert_post( $new_page);
                if ( ! empty( $new_page_template) ) {
                        update_post_meta( $new_page_id, '_wp_page_template', $new_page_template);
                }
        }
}

//Create login page
if ( isset( $_GET['activated'] ) && is_admin() ) {
        $new_page_title = __( 'Login', 'azin-file');
        $new_page_content = '[edd_login]';
        $new_page_addr = 'login';
        $new_page_template = ''; //ex. template-custom.php. Leave blank if you don't want a custom page template.
        //don't change the code bellow, unless you know what you're doing
        $page_check = get_page_by_title( $new_page_title);
        $new_page = array(
                'post_type' => 'page',
                'post_title' => $new_page_title,
                'post_name' => $new_page_addr,
                'post_content' => $new_page_content,
                'post_status' => 'publish',
                'post_author' => 1,
        );
        if ( !isset( $page_check->ID) ) {
                $new_page_id = wp_insert_post( $new_page);
                if ( ! empty( $new_page_template) ) {
                        update_post_meta( $new_page_id, '_wp_page_template', $new_page_template);
                }
        }
}

//EDD Dis_price
function dis_price ( $id) {
    
    if ( edd_get_currency() == 'RIAL' && azin_opt( 'toman_currency' ) ) {
        $r_price = rwmb_meta( 'file_saleprice', '' , $id ) * 10;
    } else {
        $r_price = rwmb_meta( 'file_saleprice', '' , $id );
    }

    if ( edd_has_variable_prices( $id ) ) {
        $default = edd_get_default_variable_price( $id);
        $s_price = edd_get_price_option_amount( $id, $default );
    } else {
        $s_price = str_replace( ',' , '', edd_get_download_price( $id) );
    }
    
    $d_price = $r_price - $s_price;
    $t_price = round(( $d_price/$r_price)*100);
    
    if(is_rtl()) {
        $t_price ='<span>٪'. $t_price . __( ' Discount', 'azin-file').'</span>';
    } else {
        $t_price ='<span>'. $t_price . '%' . __( ' Discount', 'azin-file').'</span>';
    }
 
    return $t_price;
}

//EDD Dis price product
function dis_price_prod ( $id ) {
    
    if ( edd_get_currency() == 'RIAL' && azin_opt( 'toman_currency' ) ) {
        $r_price = rwmb_meta( 'file_saleprice', '' , $id ) * 10;
    } else {
        $r_price = rwmb_meta( 'file_saleprice', '' , $id );
    }
    $s_price = str_replace( ',' , '', edd_get_download_price( $id) );
    $d_price = $r_price - $s_price;
    $t_price = round( ( $d_price / $r_price ) * 100 );
    
    if( is_rtl() ) {
        $t_price = '<span class="prod-dis">٪'. $t_price . __( ' Discount', 'azin-file').'</span>';
    } else {
        $t_price = '<span class="prod-dis">'. $t_price . '%' . __( ' Discount', 'azin-file').'</span>';
    }
 
    return $t_price;
}

//EDD Dis price product
function dis_price_archive ( $id ) {

    if ( ! azin_opt( 'show_archive_dis' ) || rwmb_meta( 'file_saleprice', '' , $id ) == '' )
        return;

    if ( edd_get_currency() == 'RIAL' && azin_opt( 'toman_currency' ) ) {
        $r_price = rwmb_meta( 'file_saleprice', '' , $id ) * 10;
    } else {
        $r_price = rwmb_meta( 'file_saleprice', '' , $id );
    }
    $s_price = str_replace( ',' , '', edd_get_download_price( $id) );
    $d_price = $r_price - $s_price;
    $t_price = round( ( $d_price / $r_price ) * 100 );
    
    if( is_rtl() ) {
        $t_price = '٪'. $t_price;
    } else {
        $t_price = $t_price . '%';
    }
 
    return $t_price;
}

// EDD Allowed Extensions
function az_edd_filetypes( $arr ) {
    
    $arr = array( 'jpg','png','gif','ogg' );
    if ( ! empty( azin_opt( 'edd_ext' ) ) ) {
        foreach( azin_opt( 'edd_ext' ) as $ext) {
            $arr[] = $ext;
        }
    }
    return $arr;
}
add_filter( 'edd_protected_directory_allowed_filetypes', 'az_edd_filetypes', 10, 1 );

//Remove EDD Microdata
remove_action( 'loop_start', 'edd_microdata_wrapper_open' );
remove_filter( 'the_content', 'edd_microdata_description' );
remove_filter( 'the_title', 'edd_microdata_title' );
remove_action( 'edd_purchase_link_top', 'edd_purchase_link_single_pricing_schema' );
remove_action( 'loop_end', 'edd_microdata_wrapper_close' );
add_filter( 'edd_add_schema_microdata', '__return_false' );
add_filter( 'edd_generate_download_structured_data', '__return_false' );

//EDD Prices
function p_price( $p_id ) { 
    
    $price = "";
    if ( ! rwmb_meta( 'file_coming','', $p_id ) ) {
        if ( azin_is_free( $p_id ) && azin_opt( 'free_price' ) ) {
            $price = '<span>'.azin_opt( 'text_free' ).'</span>';
        } elseif ( edd_has_variable_prices( get_the_ID() ) ) {
            $price = edd_price_range( $p_id );
            $price = '<span>'.preg_replace("/<([a-z][a-z0-9]*)[^>]*?(\/?)>/i",'<$1$2>', $price).'</span>';
        } else {
            $price = edd_price( $p_id,false );
            $price = preg_replace("/<([a-z][a-z0-9]*)[^>]*?(\/?)>/i",'<$1$2>', $price);
            $saleprice = rwmb_meta( 'file_saleprice', '' , get_the_ID() );
            if ( !empty( $saleprice ) ) { 
                if ( edd_get_currency() == 'RIAL' && azin_opt( 'toman_currency' ) ) {
                    $saleprice = edd_currency_filter( edd_format_amount( $saleprice * 10 ) );
                } else {
                    $saleprice = edd_currency_filter( edd_format_amount( $saleprice ) );
                }
                $price = '<span><del>'. $saleprice .'</del> ' . $price . '</span>';
            } else {
                $price = '<span>'. $price .'</span>';
            }
        }
    } else {
        $price="<span>" . azin_opt( 'text_coming_soon' ) . "</span>";
    }
    return $price;
}


//Convert variable prices from radio buttons to a dropdown
function azin_edd_purchase_variable_pricing( $download_id ) {
	$variable_pricing = edd_has_variable_prices( $download_id );
	if ( !$variable_pricing) {
        return;
    }
    $prices = apply_filters( 'edd_purchase_variable_prices', edd_get_variable_prices( $download_id ), $download_id );
	$type   = edd_single_price_option_mode( $download_id ) ? 'checkbox' : 'radio';
	do_action( 'edd_before_price_options', $download_id );
	echo '<div class="edd_price_options">';
		if ( $prices ) {
			echo '<select class="form-control v-select" name="edd_options[price_id][]">';
			foreach ( $prices as $key => $price ) {
				printf(
					'<option for="%3$s" name="edd_options[price_id][]" id="%3$s" class="%4$s" value="%5$s" %7$s> %6$s</option>',
					checked( 0, $key, false ),
					$type,
					esc_attr( 'edd_price_option_' . $download_id . '_' . $key ),
					esc_attr( 'edd_price_option_' . $download_id ),
					esc_attr( $key ),
					esc_html( $price['name'] . ' - ' . edd_currency_filter( edd_format_amount( $price[ 'amount' ] ) ) ),
					selected( isset( $_GET['price_option'] ), $key, false )
				);
				do_action( 'edd_after_price_option', $key, $price, $download_id );
			}
			echo '</select>';
		}
		do_action( 'edd_after_price_options_list', $download_id, $prices, $type );
	echo '</div><!--end .edd_price_options-->';
	do_action( 'edd_after_price_options', $download_id );
}

//Customer dashboard menu items
function azin_build_menu() {
    
    $menu = array();
    
    $menu[ 'dashboard' ] = array(
        'task' => 'dashboard',
        'name' => __( 'Dashboard', 'azin-file' ),
        "link" => 'dashboard/',
        "dashboard_link" => false,
    );

    $user_id = get_current_user_id();
    if( class_exists( 'EDD_Front_End_Submissions' ) && !EDD_FES()->vendors->user_is_vendor( $user_id ) ) {
        $menu[ 'fes_become_vendor' ] = array(
            'task'=> 'fes_become_vendor',
            'name' => __( 'Become a Vendor', 'azin-file' ),
            "link" => '',
            "dashboard_link" => false,
        );
    }

    if( class_exists( 'EDD_Front_End_Submissions' ) && EDD_FES()->vendors->user_is_vendor( $user_id ) ) {
        $menu[ 'fes_become_vendor' ] = array(
            'task'=> 'fes_become_vendor',
            'name' => __( 'Vendor Dashboard', 'azin-file' ),
            "link" => 'vendor-dashboard',
            "dashboard_link" => false,
        );
    }

    // Azin dashboard link one
    if ( azin_opt( 'dashboard_link_one' ) ) {
        $menu['azin_dashboard_link_one'] = array(
            "icon" => azin_opt( 'dashboard_link_one_icon' ),
            "task" => 'dashboard-link-one',
            "name" => azin_opt( 'dashboard_link_one_title' ),
            "link" => azin_opt( 'dashboard_link_one_url' ),
            "dashboard_link" => true,
        );
    }

    // Azin dashboard link two
    if ( azin_opt( 'dashboard_link_two' ) ) {
        $menu['azin_dashboard_link_two'] = array(
            "icon" => azin_opt( 'dashboard_link_two_icon' ),
            "task" => 'dashboard-link-two',
            "name" => azin_opt( 'dashboard_link_two_title' ),
            "link" => azin_opt( 'dashboard_link_two_url' ),
            "dashboard_link" => true,
        );
    }

    // Azin dashboard link three
    if ( azin_opt( 'dashboard_link_three' ) ) {
        $menu['azin_dashboard_link_three'] = array(
            "icon" => azin_opt( 'dashboard_link_three_icon' ),
            "task" => 'dashboard-link-three',
            "name" => azin_opt( 'dashboard_link_three_title' ),
            "link" => azin_opt( 'dashboard_link_three_url' ),
            "dashboard_link" => true,
        );
    }

    if ( azin_opt( 'course_user_panel' ) ) {
        $menu[ 'courses' ] = array(
            'task' => 'courses',
            'name' => __( 'Courses', 'azin-file' ),
            "link" => '',
            "dashboard_link" => false,
        );
    }

    if ( azin_opt( 'course_user_panel' ) && ! azin_opt( 'remove_downloads' ) ) {
        $menu[ 'downloads' ] = array(
            'task' => 'download',
            'name' => __( 'Downloads', 'azin-file' ),
            "link" => '',
            "dashboard_link" => false,
        );
    }

    $menu[ 'purchases' ] = array(
        'task' => 'purchases',
        'name' => __( 'Purchase History', 'azin-file' ),
        "link" => '',
        "dashboard_link" => false,
    );
    
    if( class_exists( 'EDD_Points_Renderer' ) ) {
        $menu[ 'points' ] = array(
            "task" => 'points',
            "name" => __( 'Points', 'azin-file' ),
            "link" => '',
            "dashboard_link" => false,
        );
    }

    if( class_exists( 'EDD_Software_Licensing' ) ) {
        $menu[ 'license' ] = array(
            "task" => 'license',
            "name" => __( 'Licenses', 'azin-file' ),
            "link" => '',
            "dashboard_link" => false,
        );
    }
    
    // Support for EDD Wallet
    if( class_exists( 'EDD_Wallet' ) ) {
        $menu[ 'wallet' ] = array(
            'task'=> 'wallet',
            'name' => __( 'Wallet', 'azin-file' ),
            "link" => '',
            "dashboard_link" => false,
        );
    }

    // Support for EDD All Access
    if( class_exists( 'EDD_All_Access' ) ) {
        $menu[ 'edd-all-access' ] = array(
            'task'=> 'subscriptions',
            'name' => __( 'Subscriptions', 'azin-file' ),
            "link" => '',
            "dashboard_link" => false,
        );
    }
    
    if( class_exists( 'EDD_Wish_Lists' ) ) {
        $menu[ 'wishlists' ] = array(
            'task'=> 'wishlist',
            'name' => __( 'Wishlist', 'azin-file' ),
            "link" => azin_edd_whishlist_url(),
            "dashboard_link" => true,
        );
    }
    
    if( class_exists( 'Awesome_Support' ) ) {
        $ticket_submit_id = wpas_get_option( 'ticket_submit' );
        if(is_array($ticket_submit_id)){
            $ticket_submit = $ticket_submit_id[0];
        }
        else {
            $ticket_submit = $ticket_submit_id;
        }
        $tpost = get_post((int)$ticket_submit); 
        $tslug = $tpost->post_name;
        $menu[ 'submit-ticket' ] = array(
            'task'=> 'send-ticket',
            'name' => __( 'Submit ticket', 'azin-file' ),
            "link" => $tslug,
            "dashboard_link" => false,
        );
    }
    
    if( class_exists( 'Awesome_Support' ) ) {
        $lpost = get_post((int)wpas_get_option( 'ticket_list' )); 
        $lslug = $lpost->post_name;
        $menu[ 'tickets' ] = array(
            'task'=> 'tickets',
            'name' => __( 'Tickets', 'azin-file' ),
            "link" => $lslug,
            "dashboard_link" => false,
        );
    }
    
    if( class_exists( 'Affiliate_WP' ) ) {
        $apost = get_post(affwp_get_affiliate_area_page_id()); 
        $aslug = $apost->post_name;
        $menu[ 'affiliate' ] = array(
            'task'=> 'affiliate',
            'name' => __( 'Affiliate', 'azin-file' ),
            "link" => $aslug,
            "dashboard_link" => false,
        );
    }

    $menu[ 'profile' ] = array(
        'task' => 'profile',
        'name' => __( 'Edit profile', 'azin-file' ),
        "link" => '',
        "dashboard_link" => false,
    );

    $menu = apply_filters( "azin-file_menu_links", $menu );
    
    return $menu;

}

//Removes decimal places from all prices 
function azin_edd_remove_decimals( $decimals ) {
	return 0;
}
if ( azin_opt( 'edd_remove_decimals' ) ) {
    add_filter( 'edd_format_amount_decimals', 'azin_edd_remove_decimals' );
}

if ( is_rtl() ) {
    add_filter('gettext','azin_edd_translate_words');
    add_filter('ngettext','azin_edd_translate_words');
}
function azin_edd_translate_words($translated){

	$words=array(
		'Personal info' => 'اطلاعات پرداخت',
		'First name' => 'نام',
        'Last name' => 'نام خانوادگی',
	); 

	$translated = str_ireplace( array_keys($words), $words, $translated );
	
	return $translated;
}

//Ajax add to cart on archives
function azin_archive_add_to_cart( $id ) {

    
    $product_purchasable = false;
    $download = new EDD_Download( $id );
    $variable_pricing = $download->has_variable_prices();

    if ( ! rwmb_meta( 'file_coming', '', $id ) ) {

        if ( function_exists( 'edd_price' ) ) {
            if ( azin_is_free( $id ) || $variable_pricing ) {
                $product_purchasable = false;
            } else {
                $product_purchasable = true;
            }
        }

    } else {
        $product_purchasable = false;
    }
    ?>

    <?php if ( $product_purchasable ) { ?>
        <span class="azin-add-cart-btn<?php echo azin_is_course( $id ) ? ' azin-add-cart-course' : ''; ?> btn btn-light" data-toggle="tooltip" data-placement="top" title="<?php echo azin_is_course( $id) ? azin_opt( 'text_buy_course' ) : azin_opt( 'text_add_shop' ); ?>">
            <?php echo edd_get_purchase_link( $id, 'Add', 'button' ); ?>
        </span>
    <?php } else { ?>
        <span class="azin-add-cart-btn btn btn-light" data-toggle="tooltip" data-placement="top" title="<?php _e( 'View Product', 'azin-file' ); ?>">
            <a href="<?php the_permalink(); ?>" rel="nofollow" <?php azin_link_target() ?>>
                <i class="fal fa-shopping-bag" aria-hidden="true"></i>
            </a>
        </span>
    <?php } ?>
        
    <?php
}

//Easy Digital Downloads Change the button text
add_filter( 'edd_purchase_link_args', 'azin_edd_text_args' );
function azin_edd_text_args( $args ) {
    $args['text']  = azin_is_course( get_the_id() ) ? azin_opt( 'text_buy_course' ) : azin_opt( 'text_add_shop' );
    $args['class'] = 'btn btn-success btn-sm';
return $args;
}

//Set EDD Wishlists Template
if( class_exists( 'EDD_Wish_Lists' ) ) {
    add_filter( 'page_template', 'azin_whishlist_page_template' );
    function azin_whishlist_page_template( $page_template )
    {
        global $post;
        $post_id = $post->ID;

        $whishlist_page_ids = array(
			(int)edd_get_option( 'edd_wl_page' ),
			(int)edd_get_option( 'edd_wl_page_view' ),
			(int)edd_get_option( 'edd_wl_page_edit' ),
			(int)edd_get_option( 'edd_wl_page_create' )
		);

        if ( in_array( $post_id, $whishlist_page_ids) ) {
            $page_template = get_stylesheet_directory() . '/tpls/user-panel.php';
        }

        return $page_template;
    }

    //Get myaccount_page_url
    function azin_edd_whishlist_url() {

        $wishlist_url = '';
        $wishlist = (int)edd_get_option( 'edd_wl_page' );

        if ( $wishlist ) {
            $wishlist_url = get_permalink( $wishlist );
        }

        return $wishlist_url;
    }

    //EDD Wish Lists -  Changing the default messages
    function azin_edd_wl_messages( $messages ) {
        $messages = array(
            'must_login' 				=> sprintf( __( 'Sorry, you must login to create a %s', 'azin-file' ), edd_wl_get_label_singular( true ) ),
            'list_updated'				=> sprintf( __( '%s successfully updated', 'azin-file' ), 	edd_wl_get_label_singular() ),
            'list_created_guest'			=> sprintf( __( '%s successfully created and saved for 30 days. If you wish to keep it longer, please create an account.', 'azin-file' ), edd_wl_get_label_singular() ),
            'list_created'				=> sprintf( __( '%s successfully created', 'azin-file' ), edd_wl_get_label_singular() ),
            'list_deleted'				=> sprintf( __( '%s successfully deleted', 'azin-file' ), 	edd_wl_get_label_singular() ),
            'no_lists' 				=> sprintf( __( 'You currently have no %s', 'azin-file' ), edd_wl_get_label_plural( true ) ),
            'no_downloads' 				=> sprintf( __( 'Nothing here yet, how about adding some %s?', 'azin-file' ), edd_get_label_plural( true ) ),
            'lists_included'			=> __( 'This item has already been added to: ', 'azin-file' ),
            'modal_option_save'			=> __( 'Save', 'azin-file' ),
            'modal_option_close'			=> __( 'Great, I\'m done', 'azin-file' ),
            'modal_option_add_new'			=> __( 'Add to new', 'azin-file' ),
            'modal_option_add_to_existing'	=> __( 'Add to existing', 'azin-file' ),
            'modal_option_title'			=> __( 'Title', 'azin-file' ),
            'list_option_private'			=> __( 'Private - only viewable by you', 'azin-file' ),
            'list_option_public'			=> __( 'Public - viewable by anyone', 'azin-file' ),
            'list_share_success'			=> __( 'Successfully shared.', 'azin-file' ),
            'list_title_required'			=> __( 'You need to enter a title', 'azin-file' ),
            'item_already_purchased'		=> __( 'Already purchased', 'azin-file' ),
        );

        return $messages;
    }
    add_filter( 'edd_wl_messages', 'azin_edd_wl_messages' );

    //Remove EDD Wish Lists Defualt Link
    remove_action( 'edd_purchase_link_top', 'edd_wl_load_wish_list_link' );

    // Load scripts on EDD's custom taxonomy archive pages.
    wp_enqueue_script( 'edd-wl' );
    wp_enqueue_script( 'edd-wl-modal' );
}

//Total Sales of EDD products
function az_edd_get_total_purchased_products() {
    global $wpdb; 
  
    $result = $wpdb->get_row("
        SELECT SUM(pm.meta_value) AS total_sales
        FROM $wpdb->posts AS p
        LEFT JOIN $wpdb->postmeta AS pm ON (p.ID = pm.post_id AND pm.meta_key = '_edd_download_sales') 
        WHERE p.post_type = 'download'
    ");
  
    return $result->total_sales;
}


// azin_purchased_download_links_content
function azin_purchased_download_links_content( $id ) {
    
    $customer = edd_get_customer_by( 'user_id', get_current_user_id() );
    $page     = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;

    if ( ! empty( $customer ) ) {
        $orders = edd_get_orders(
            array(
                'customer_id' => $customer->id,
                //'number'      => 20,
                //'offset'      => 20 * ( intval( $page ) - 1 ),
                'type'        => 'sale',
            )
        );
    } else {
        $orders = array();
    }

    if ( $orders ) {

        echo '<div class="azin-purchased-tab-content">';
            $tab_content = azin_is_course( get_the_ID() ) && azin_opt( 'change_purchased_text_course' ) ? azin_opt( 'purchased_course_tab_content' ) : azin_opt( 'purchased_tab_content' );
            echo do_shortcode( $tab_content );
        echo '</div>';
        
        foreach ( $orders as $order ) {
            foreach ( $order->get_items() as $key => $item ) {
                
                if ( edd_is_bundled_product( $item->product_id ) ) {
					continue;
				}                

                if ( $item->product_id == $id ) {                 

                    $price_id       = $item->price_id;
					// Get price ID of product with variable prices included in Bundle
                    if ( ! empty( $download['in_bundle'] ) && edd_has_variable_prices( $download['id'] ) ) {
                        $price_id = edd_get_bundle_item_price_id( $download['id'] );
                    }


                    $download_files = edd_get_download_files( $item->product_id, $price_id );

					$name           = $item->product_name;

                    if ( $item->is_deliverable() ) {

                        if ( $download_files ) {
                            
                        echo '<ul class="azin-download-list col-12">';

                        foreach ( $download_files as $filekey => $file ) {
                            
                            $download_url = edd_get_download_file_url( $order->payment_key, $order->email, $filekey, $item->product_id, $price_id );

                            echo '<li>';
                                echo '<a class="azin-download-list-file" href="' . esc_url( $download_url ) . '" target="_blank">' . edd_get_file_name( $file ) . '</a>' ;
                            echo '</li>';
                        }

                        echo '</ul>';

                        }
                    }
                }
            }
        }
        
    }
    
}