<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

?>
<?php

if ( is_user_logged_in() ) {
    $user = wp_get_current_user();
    $user_id = get_current_user_id();
}

$user_vendor = false;

if ( function_exists( 'EDD_FES' ) ) {
    if ( EDD_FES()->vendors->user_is_vendor( $user_id ) ) {
        $user_vendor = true;
    }
}

if ( ! $user_vendor ) {  ?>

    <li>
        <a href="<?php echo esc_url( home_url() ); ?>/dashboard/">
            <span class="fal fa-tachometer-alt"></span>
            <?php _e( 'Dashboard', 'azin-file' ); ?>
        </a>
    </li>

    <?php if ( class_exists( 'EDD_Front_End_Submissions' ) ) { ?>
        <li>
            <a href="<?php echo esc_url( home_url() ); ?>/vendor-dashboard" class="fes-bav">
                <span class="fal fa-users"></span>
                <?php _e( 'Become a Vendor', 'azin-file' ) ?>
            </a>
        </li>
    <?php } ?>

    <?php if ( azin_opt( 'dashboard_link_one' ) ) { ?>
    <li>
        <a href="<?php echo azin_opt( 'dashboard_link_one_url' ); ?>">
            <span class="<?php echo azin_opt( 'dashboard_link_one_icon' ); ?>"></span>
            <?php echo azin_opt( 'dashboard_link_one_title' ); ?>
        </a>
    </li>
    <?php } ?>

    <?php if ( azin_opt( 'dashboard_link_two' ) ) { ?>
    <li>
        <a href="<?php echo azin_opt( 'dashboard_link_two_url' ); ?>">
            <span class="<?php echo azin_opt( 'dashboard_link_two_icon' ); ?>"></span>
            <?php echo azin_opt( 'dashboard_link_two_title' ); ?>
        </a>
    </li>
    <?php } ?>

    <?php if ( azin_opt( 'dashboard_link_three' ) ) { ?>
    <li>
        <a href="<?php echo azin_opt( 'dashboard_link_three_url' ); ?>">
            <span class="<?php echo azin_opt( 'dashboard_link_three_icon' ); ?>"></span>
            <?php echo azin_opt( 'dashboard_link_three_title' ); ?>
        </a>
    </li>
    <?php } ?>

    <?php if ( azin_opt( 'course_user_panel' ) ) { ?>
        <li>
            <a href="<?php echo esc_url( home_url() ); ?>/dashboard/?task=courses">
                <span class="fal fa-graduation-cap"></span>
                <?php _e( 'Courses' , 'azin-file'); ?>
            </a>
        </li>
    <?php } ?>

    <?php if ( azin_opt( 'course_user_panel' ) && ! azin_opt( 'remove_downloads' ) ) { ?>
    <li>
        <a href="<?php echo esc_url( home_url() ); ?>/dashboard/?task=download">
            <span class="fal fa-cloud-download"></span>
            <?php _e( 'Downloads' , 'azin-file'); ?>
        </a>
    </li>
    <?php } ?>

    <li>
        <a href="<?php echo esc_url( home_url() ); ?>/dashboard/?task=purchases">
            <span class="fal fa-history"></span>
            <?php _e( 'Purchase History', 'azin-file' ); ?>
        </a>
    </li>

    <?php if ( class_exists( 'EDD_Points_Renderer' ) ) { ?>
    <li>
        <a href="<?php echo esc_url( home_url() ); ?>/dashboard/?task=points">
            <span class="fal fa-gift"></span>
            <?php _e( 'Points', 'azin-file' ); ?>
        </a>
    </li>
    <?php } ?>

    <?php if ( class_exists( 'EDD_Software_Licensing' ) ) { ?>
    <li>
        <a href="<?php echo esc_url( home_url() ); ?>/dashboard/?task=license">
            <span class="fal fa-key"></span>
            <?php _e( 'Licenses', 'azin-file' ); ?>
        </a>
    </li>
    <?php } ?>

    <?php if ( class_exists( 'EDD_Wallet' ) ) { ?>
    <li>
        <a href="<?php echo esc_url( home_url() ); ?>/dashboard/?task=wallet">
            <span class="fal fa-wallet"></span>
            <?php _e( 'Wallet', 'azin-file' ); ?>
        </a>
    </li>
    <?php } ?>

    <?php if ( class_exists( 'EDD_All_Access' ) ) { ?>
    <li>
        <a href="<?php echo esc_url( home_url() ); ?>/dashboard/?task=subscriptions">
            <span class="fal fa-file-invoice-dollar"></span>
            <?php _e( 'Subscriptions', 'azin-file' ); ?>
        </a>
    </li>
    <?php } ?>

    <?php if ( class_exists( 'EDD_Wish_Lists' ) ) { ?>
    <li>
        <a href="<?php echo azin_edd_whishlist_url(); ?>">
            <span class="fal fa-heart"></span>
            <?php _e( 'Wishlist', 'azin-file' ); ?>
        </a>
    </li>
    <?php } ?>

    <?php if ( class_exists( 'Awesome_Support' ) ) { ?>
        <li>
            <a href="<?php echo wpas_get_submission_page_url(); ?>">
                <span class="fal fa-paper-plane"></span>
                <?php _e( 'Submit ticket', 'azin-file' ); ?>
            </a>
        </li>
    <?php } ?>

    <?php if ( class_exists( 'Awesome_Support' ) ) { ?>
    <li>
        <a href="<?php echo wpas_get_tickets_list_page_url(); ?>">
            <span class="fal fa-list"></span>
            <?php _e( 'Tickets', 'azin-file' ); ?>
        </a>
    </li>
    <?php } ?>

    <?php if ( class_exists( 'Affiliate_WP' ) ) { ?>
    <li>
        <a href="<?php echo esc_url( affwp_get_affiliate_area_page_url() ); ?>">
            <span class="fal fa-handshake"></span>
            <?php _e( 'Affiliate' , 'azin-file'); ?>
        </a>
    </li>
    <?php } ?>

    <li>
        <a href="<?php echo esc_url( home_url() ); ?>/dashboard/?task=profile">
            <span class="fal fa-user-edit"></span>
            <?php _e( 'Edit profile', 'azin-file' ); ?>
        </a>
    </li>

    <li>
        <a href="<?php echo wp_logout_url(home_url() ); ?>">
            <span class="fal fa-power-off"></span>
            <?php _e( 'Logout', 'azin-file' ) ?>
        </a>
    </li>
    
<?php } else { ?>

    <li>
        <a href="<?php echo esc_url( home_url() ); ?>/vendor-dashboard/?task=dashboard">
            <span class="fal fa-tachometer-alt"></span>
            <?php _e( 'Dashboard' , 'azin-file'); ?>
        </a>
    </li>

    <li>
        <a href="<?php echo esc_url( home_url() ); ?>/vendor-dashboard/?task=products">
            <span class="fal fa-briefcase"></span>
            <?php _e( 'Products' , 'azin-file'); ?>
        </a>
    </li>

    <?php if ( EDD_FES()->vendors->vendor_can_create_product() ) { ?>
    <li>
        <a href="<?php echo esc_url( home_url() ); ?>/vendor-dashboard/?task=new-product">
            <span class="fal fa-plus-circle"></span>
            <?php _e( 'New Product' , 'azin-file'); ?> 
        </a>
    </li>
    <?php } ?>

    <?php if ( azin_opt( 'dashboard_link_one' ) ) { ?>
    <li>
        <a href="<?php echo azin_opt( 'dashboard_link_one_url' ); ?>">
            <span class="<?php echo azin_opt( 'dashboard_link_one_icon' ); ?>"></span>
            <?php echo azin_opt( 'dashboard_link_one_title' ); ?>
        </a>
    </li>
    <?php } ?>

    <?php if ( azin_opt( 'dashboard_link_two' ) ) { ?>
    <li>
        <a href="<?php echo azin_opt( 'dashboard_link_two_url' ); ?>">
            <span class="<?php echo azin_opt( 'dashboard_link_two_icon' ); ?>"></span>
            <?php echo azin_opt( 'dashboard_link_two_title' ); ?>
        </a>
    </li>
    <?php } ?>

    <?php if ( azin_opt( 'dashboard_link_three' ) ) { ?>
    <li>
        <a href="<?php echo azin_opt( 'dashboard_link_three_url' ); ?>">
            <span class="<?php echo azin_opt( 'dashboard_link_three_icon' ); ?>"></span>
            <?php echo azin_opt( 'dashboard_link_three_title' ); ?>
        </a>
    </li>
    <?php } ?>

    <?php if ( azin_opt( 'course_user_panel' ) ) { ?>
        <li>
            <a href="<?php echo esc_url( home_url() ); ?>/vendor-dashboard/?task=courses">
                <span class="fal fa-graduation-cap"></span>
                <?php _e( 'Courses' , 'azin-file'); ?>
            </a>
        </li>
    <?php } ?>

    <?php if ( azin_opt( 'course_user_panel' ) && ! azin_opt( 'remove_downloads' ) ) { ?>
    <li>
        <a href="<?php echo esc_url( home_url() ); ?>/vendor-dashboard/?task=download">
            <span class="fal fa-cloud-download"></span>
            <?php _e( 'Downloads' , 'azin-file'); ?>
        </a>
    </li>
    <?php } ?>

    <?php if ( EDD_FES()->integrations->is_commissions_active() ) { ?>
    <li>
        <a href="<?php echo esc_url( home_url() ); ?>/vendor-dashboard/?task=earnings">
            <span class="fal fa-dollar-sign"></span>
            <?php _e( 'Income' , 'azin-file'); ?>
        </a>
    </li>
    <?php } ?>

    <?php if ( EDD_FES()->vendors->vendor_can_view_orders() ) { ?>
    <li>
        <a href="<?php echo esc_url( home_url() ); ?>/vendor-dashboard/?task=orders">
            <span class="fal fa-shopping-cart"></span>
            <?php _e( 'Orders' , 'azin-file'); ?>
        </a>
    </li>
    <?php } ?>

    <?php if ( class_exists( 'EDD_Points_Renderer' ) ) { ?>
    <li>
        <a href="<?php echo esc_url( home_url() ); ?>/vendor-dashboard/?task=points">
            <span class="fal fa-gift"></span>
            <?php _e( 'Points' , 'azin-file'); ?>
        </a>
    </li>
    <?php } ?>

    <?php if ( class_exists( 'EDD_Software_Licensing' ) ) { ?>
    <li>
        <a href="<?php echo esc_url( home_url() ); ?>/vendor-dashboard/?task=license">
            <span class="fal fa-key"></span> 
            <?php _e( 'Licenses' , 'azin-file'); ?>
        </a>
    </li>
    <?php } ?>

    <li>
        <a href="<?php echo esc_url( home_url() ); ?>/vendor-dashboard/?task=purchases">
            <span class="fal fa-list-alt"></span>
            <?php _e( 'My purchases' , 'azin-file'); ?>
        </a>
    </li>

    <?php if ( class_exists( 'EDD_Wallet' ) ) { ?>
    <li>
        <a href="<?php echo esc_url( home_url() ); ?>/vendor-dashboard/?task=wallet">
            <span class="fal fa-wallet"></span>
            <?php _e( 'Wallet' , 'azin-file'); ?>
        </a>
    </li>
    <?php } ?>

    <?php if ( class_exists( 'EDD_All_Access' ) ) { ?>
    <li>
        <a href="<?php echo esc_url( home_url() ); ?>/vendor-dashboard/?task=subscriptions">
            <span class="fal fa-file-invoice-dollar"></span>
            <?php _e( 'Subscriptions', 'azin-file' ); ?>
        </a>
    </li>
    <?php } ?>

    <?php if ( class_exists( 'EDD_Wish_Lists' ) ) { ?>
    <li>
        <a href="<?php echo azin_edd_whishlist_url(); ?>">
            <span class="fal fa-heart"></span>
            <?php _e( 'Wishlist', 'azin-file' ); ?>
        </a>
    </li>
    <?php } ?>

    <?php if ( class_exists( 'Awesome_Support' ) ) { ?>
    <li>
        <a href="<?php echo wpas_get_submission_page_url(); ?>">
            <span class="fal fa-paper-plane"></span>
            <?php _e( 'Submit ticket' , 'azin-file'); ?>
        </a>
    </li>
    <?php } ?>

    <?php if ( class_exists( 'Awesome_Support' ) ) { ?>
    <li>
        <a href="<?php echo wpas_get_tickets_list_page_url(); ?>">
            <span class="fal fa-list"></span>
            <?php _e( 'Tickets' , 'azin-file'); ?>
        </a>
    </li>
    <?php } ?>

    <?php if ( class_exists( 'Affiliate_WP' ) ) { ?>
        <li>
            <a href="<?php echo esc_url( affwp_get_affiliate_area_page_url( ) ); ?>">
                <span class="fal fa-handshake"></span>
                <?php _e( 'Affiliate' , 'azin-file'); ?>
            </a>
        </li>
    <?php } ?>

    <li>
        <a href="<?php echo esc_url( home_url() ); ?>/vendor-dashboard/?task=profile">
            <span class="fal fa-pen-square"></span>
            <?php _e( 'Profile' , 'azin-file'); ?>
        </a>
    </li>

    <li>
        <a href="<?php echo esc_url( home_url() ); ?>/vendor-dashboard/?task=logout">
            <span class="fal fa-power-off"></span>
            <?php _e( 'Logout' , 'azin-file'); ?>
        </a>
    </li>

<?php }