<?php
namespace Elementor;

class Ads_Image extends Widget_Base
{
    public function get_name()
    {
        return 'ads-image';
    }
    
    public function get_title()
    {
        return __( 'Advertising banner', 'azin-file' );
    }
    
    public function get_icon()
    {
        return 'fal fa-image';
    }
    
    public function get_categories()
    {
        return [ 'azin-file' ];
    }
    
    protected function register_controls()
    {
        $this->start_controls_section(
            'section_title',
            [
                'label' => __( 'Advertising banner', 'azin-file' ),
            ]
        );
        
        $this->add_control(
            'img_title',
            [
                'label' => __( 'Image Title', 'azin-file' ),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter the title of the image', 'azin-file' ),
                'default' => '#',
            ]
        );
        
        $this->add_control(
            'img_link',
            [
                'label' => __( 'Image Link', 'azin-file' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'azin-file' ),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => false,
                ],
            ]
        );

        $this->add_control(
			'hover_effect',
			[
				'label' => __( 'Image hover effect', 'azin-file' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'azin-brightness',
				'options' => [
					'none'  => __( 'None', 'azin-file' ),
					'azin-brightness'  => __( 'Brightness', 'azin-file' ),
					'azin-zoomin' => __( 'Zoom', 'azin-file' ),
					'azin-rotate' => __( 'Rotate', 'azin-file' ),
					'azin-blur' => __( 'Blur', 'azin-file' ),
					'azin-gray' => __( 'Black & White', 'azin-file' ),
					'azin-opacity' => __( 'Opacity', 'azin-file' ),
					'azin-flash' => __( 'Flashing', 'azin-file' ),
					'azin-shine' => __( 'Shine', 'azin-file' ),
					'azin-circle' => __( 'Circle', 'azin-file' )
				],
			]
		);

		$this->add_control(
			'hover_title',
			[
				'label' => __( 'Display the image title on mouse hover', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
        
        $this->add_control(
            'image',
            [
                'label' => __( 'Select the image', 'azin-file' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();    
        $image_attributes = wp_get_attachment_image_src( $settings['image']['id'], 'full' );
        $target = $settings['img_link']['is_external'] ? ' target="_blank"' : '';
		$nofollow = $settings['img_link']['nofollow'] ? ' rel="nofollow"' : '';
		
        $args = array(
            'img_src' => $settings['image']['url'],
            'img_link_url' => $settings['img_link']['url'],
            'img_title' => $settings['img_title'],
            'link_target' => $target,
            'link_rel' => $nofollow,
            'hover_effect' => $settings['hover_effect'],
            'hover_title' => $settings['hover_title'],
            'image_width' => $image_attributes[1],
            'image_height' => $image_attributes[2],
            'not_on_mobile' => false,
            'custom_class' => ''
        );

        azin_bnr_image( $args );
	}
}