<?php
namespace Elementor;

class Azin_Site_Info extends Widget_Base {
	
	public function get_name() {
		return 'azin-site-info';
	}
	
	public function get_title() {
		return __( 'Site information icon (Azinfile)', 'azin-file' );
	}
	
	public function get_icon() {
		return 'fal fa-info-circle';
	}
	
	public function get_categories() {
		return [ 'azin-file' ];
	}
	
	protected function register_controls() {

		require get_template_directory() . '/includes/el-widgets/fa.php';

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Site information icon (Azinfile)', 'azin-file' ),
			]
		);
		
		$this->add_control(
			'info_title',
			[
				'label' => __( 'Title', 'azin-file' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter icon title', 'azin-file' ),
                'default' => __( 'Title', 'azin-file' ),
			]
        );

		$this->add_control(
			'info_icon',
			[
				'label' => __( 'Icon', 'azin-file' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
			]
		);

		$this->add_control(
			'inherit_color',
			[
				'label'        => __( 'Inherit the color from the template color', 'azin-file' ),
				'type' 		   => Controls_Manager::SWITCHER,
				'label_on'	   => __( 'On', 'azin-file' ),
				'label_off'	   => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'	   => 'yes',
			]
		);

		$this->add_control(
			'color',
			[
				'label'   => __( 'Color', 'azin-file' ),
				'type'    => Controls_Manager::COLOR,
				'default' => '#000000',
				'selectors' => [
					'{{WRAPPER}} .azin-info-icon i' => 'color: {{VALUE}}',
				],
				'condition' => [
					'inherit_color' => '',
				],
			]
		);

		$this->add_control(
			'info_image',
			[
				'label' => __( 'Or custom icon (Suitable size: 64px by 64px)', 'azin-file' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'info_data_source',
			[
				'label'   => __( 'Data source', 'azin-file' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'none' 			 => __( 'None', 'azin-file' ),
					'products-count' => __( 'Products', 'azin-file' ),
					'users-count'    => __( 'Members', 'azin-file' ),
					'sellers-count'  => __( 'Sellers', 'azin-file' ),
					'sales-count'    => __( 'Order completed', 'azin-file' ),
					'posts-count'    => __( 'Blog content', 'azin-file' ),
					'custom-data'    => __( 'Custom data', 'azin-file' ),
				],
			]
		);

		$this->add_control(
			'custom_data_value',
			[
				'label'		  => __( 'Custom data value', 'azin-file' ),
				'label_block' => true,
				'type' 		  => Controls_Manager::TEXT,
				'description' => __( 'You can also use the shortcode', 'azin-file' ),
                'placeholder' => __( 'Enter custom data value', 'azin-file' ),
                'default'	  => __( 'Value', 'azin-file' ),
				'condition'   => [
					'info_data_source' => 'custom-data',
				],
			]
        );

		$this->add_control(
			'display_border',
			[
				'label'        => __( 'Display border', 'azin-file' ),
				'type' 		   => Controls_Manager::SWITCHER,
				'label_on'	   => __( 'On', 'azin-file' ),
				'label_off'	   => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'	   => 'yes',
			]
		);
        
		$this->end_controls_section();
	}
	
	protected function render() {

		//Init
        $settings 		  = $this->get_settings_for_display();
        $info_title 	  = $settings['info_title'];
        $info_icon 		  = $settings['info_icon'];
        $info_image 	  = $settings['info_image']['url'];
		$info_data_source = $settings['info_data_source'];
		$inherit_color    = $settings['inherit_color'] === 'yes' ? ' azin-inherit-color' : '';
		$display_border   = $settings['display_border'] != 'yes' ? ' azin-noborder' : '';

		switch ( $info_data_source ) {

			case 'products-count':
				$count 	    = az_woo() ? wp_count_posts( 'product' ) : wp_count_posts( 'download' );
				$info_value = $count->publish . '+';
				break;

			case 'users-count':
				$count		= count_users();
				$info_value = $count['total_users'] . '+';
				break;

			case 'sellers-count':
				$info_value	= azin_count_sellers() . '+';
				break;

			case 'sales-count':
				$sales_count = az_woo() ? az_woo_get_total_sales() : edd_get_total_sales();
				$info_value  = $sales_count . '+';
				break;

			case 'posts-count':
				$count = wp_count_posts( 'post' );
				$info_value = $count->publish . '+';
				break;

			case 'custom-data':
				$info_value = do_shortcode( $settings['custom_data_value'] );
				break;

			default:
				$info_value = '';
		}

		?>

		<div class="el-azin-info-icon azin-info-icon<?php echo $inherit_color ?>">
			<?php if( ! empty( $info_image ) ) { ?>
				<img src="<?php echo $info_image; ?>" width="64" height="64" alt="<?php echo $info_title; ?>" class="info-custum-icon<?php echo $display_border; ?>">
			<?php } else { ?>
				<i class="fal fa-<?php echo $info_icon . $display_border; ?>" aria-hidden="true"></i>
			<?php } ?>
			<span class="count-num"><?php echo $info_value; ?></span>
			<span class="count-text"><?php echo $info_title; ?></span>
		</div>

        <?php
	}
}