<?php
namespace Elementor;

class Azin_Text_Ticker extends Widget_Base {
	
	public function get_name() {
		return 'azin-text-ticker';
	}
	
	public function get_title() {
		return __( 'Text Ticker (Azinfile)', 'azin-file' );
	}
	
	public function get_icon() {
		return 'fal fa-text-height';
	}
	
	public function get_categories() {
		return [ 'azin-file' ];
	}

	public function get_script_depends() {
		return [ 'azin-easy-ticker' ];
	}
	
	protected function register_controls() {

		require get_template_directory() . '/includes/el-widgets/fa.php';

		$post_cat = array();
		$categories = get_terms( array(
			'taxonomy'   => 'category',
			'hide_empty' => false,
		) );
		if ( ! empty( $categories ) && ! is_wp_error( $categories ) ){
			foreach ( $categories as $category ) {
				$post_cat[ $category->term_id ] = $category->name;
			}
		}

		$post_taga = array();
		$tags = get_terms( "post_tag" );
		if ( ! empty( $tags ) && ! is_wp_error( $tags ) ){
			foreach ( $tags as $tag ) {
				$post_taga[ $tag->term_id ] = $tag->name;
			}
		}

		//Start Title Section
		$this->start_controls_section(
			'title_section',
			[
				'label' => __( 'Title settings', 'azin-file' ),
			]
		);

		$this->add_control(
			'show_title',
			[
				'label'        => __( 'Show title', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'tickers_title',
			[
				'label'       => __( 'Title', 'azin-file' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'default'      => __( 'title', 'azin-file' ),
				'condition' => [
					'show_title' => 'yes'
				],
			]
		);

		$this->add_control(
			'tickers_icon',
			[
				'label' => __( 'Title icon', 'azin-file' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
			]
		);

		$this->end_controls_section();
		//End Title Section

		//Start Tickers Section
		$this->start_controls_section(
			'tickers_section',
			[
				'label' => __( 'Tickers settings', 'azin-file' ),
			]
		);

		$this->add_control(
			'titles_source',
			[
				'label' => __( 'Source of titles', 'azin-file' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'manual',
				'options' => [
					'manual'   => __( 'Manual', 'azin-file' ),
					'posts'    => __( 'Posts', 'azin-file' )
				],
			]
		);

		$this->add_control(
			'titles_rows',
			[
				'label' => __( 'Number of rows', 'azin-file' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 200,
				'step' => 1,
				'default' => 1,
			]
		);

		//Posts Ticker
		$this->add_control(
			'post_sort',
			[
				'label'    => __( 'Posts sorting', 'azin-file' ),
				'type'     => Controls_Manager::SELECT,
				'default'  => 'latest',
				'options'  => [
					'latest'         => __( 'Latest posts', 'azin-file' ),
					'latest-updated' => __( 'Latest updated posts', 'azin-file' ),
					'random'         => __( 'Random posts', 'azin-file' ),
					'viewed'         => __( 'Most viewed posts', 'azin-file' ),
				],
				'condition' => [
					'titles_source' => 'posts',
				]
			]
		);

		$this->add_control(
			'post_filter',
			[
				'label' => __( 'Post filtering', 'azin-file' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'category',
				'options' => [
					'category'  => __( 'Post category', 'azin-file' ),
					'tag' => __( 'Post tag', 'azin-file' ),
					'post-ids' => __( 'Post ID', 'azin-file' ),
				],
				'condition' => [
					'titles_source' => 'posts',
				]
			]
		);

		$this->add_control(
			'post_cat',
			[
				'label' => __( 'Posts category', 'azin-file' ),
				'description' => __( 'Empty categories (no post) are not displayed', 'azin-file' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => $post_cat,
				'condition' => [
					'post_filter' => 'category',
					'titles_source' => 'posts',
				],
			]
		);

		$this->add_control(
			'post_tag',
			[
				'label' => __( 'Post tag', 'azin-file' ),
				'description' => __( 'Empty tags (no post) are not displayed', 'azin-file' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => $post_taga,
				'condition' => [
					'post_filter' => 'tag',
					'titles_source' => 'posts',
				],
			]
		);

		$this->add_control(
			'post_ids',
			[
				'label' => __( 'Post ID', 'azin-file' ),
				'description' => __( 'If you have defined the post filter on the post ID, enter the desired ID(s) in this box (separate the IDs with a "," sign, for example 145,12,6)', 'azin-file' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Post(s) ID', 'azin-file' ),
				'condition' => [
					'post_filter' => 'post-ids',
					'titles_source' => 'posts',
				],
			]
		);

		$this->add_control(
			'ptotalcount',
			[
				'label'     => __( 'Posts total count', 'azin-file' ),
				'type'      => Controls_Manager::NUMBER,
				'min'       => 1,
				'max'       => 200,
				'step'      => 1,
				'default'   => 8,
				'condition' => [
					'titles_source' => 'posts',
				],
			]
		);

		$this->add_control(
			'publication_date',
			[
				'label'        => __( 'Display the publication date', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'no',
				'condition' => [
					'titles_source' => 'posts',
				],
			]
		);

		//Manual Tickers
		$ticker = new Repeater();

		$ticker->add_control(
			'ticker_title',
			[
				'label'       => __( 'Ticker title', 'azin-file' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$ticker->add_control(
			'ticker_link',
			[
				'label' => __( 'Ticker link', 'azin-file' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'azin-file' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => false,
					'nofollow' => false,
				],
			]
        );

		$ticker->add_control(
			'ticker_date',
			[
				'label' => __( 'Scheduling the ticker show', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$ticker->add_control(
			'ticker_date_start',
			[
				'label' => __( 'Start time', 'azin-file' ),
				'type' => Controls_Manager::DATE_TIME,
				'picker_options' => [
					'enableTime' => false,
				],
				'condition' => [
					'ticker_date' => 'yes',
				],
			]
		);

		$ticker->add_control(
			'ticker_date_end',
			[
				'label' => __( 'End time', 'azin-file' ),
				'type' => Controls_Manager::DATE_TIME,
				'picker_options' => [
					'enableTime' => false,
				],
				'condition' => [
					'ticker_date' => 'yes',
				],
			]
		);
		//Manual Tickers

		$this->add_control(
			'tickers',
			[
				'label'   => __( 'Tickers', 'azin-file' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $ticker->get_controls(),
				'default' => [
					[
						'ticker_title' => __( 'Ticker title', 'azin-file' ),
						'ticker_link' => __( 'https://your-link.com', 'azin-file' ),
					],
				],
				'title_field' => '{{{ ticker_title }}}',
				'condition' => [
					'titles_source' => 'manual',
				]
			]
		);

		$this->end_controls_section();
		//End Tickers Section



		//Start Style Section
		$this->start_controls_section(
			'style_section',
			[
				'label' => __( 'Style settings', 'azin-file' ),
			]
		);

		$this->add_control(
			'white_box',
			[
				'label' => __( 'White box style', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->end_controls_section();



		//Start Animation Section
		$this->start_controls_section(
			'animation_section',
			[
				'label' => __( 'Animation settings', 'azin-file' ),
			]
		);

		$this->add_control(
			'direction',
			[
				'label' => __( 'Direction of movement', 'azin-file' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'up',
				'options' => [
					'up'   => __( 'Up', 'azin-file' ),
					'down' => __( 'Down', 'azin-file' )
				],
			]
		);

		$this->add_control(
			'animation_speed',
			[
				'label' => __( 'Animation speed', 'azin-file' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'medium',
				'options' => [
					'slow'   => __( 'Slow', 'azin-file' ),
					'medium' => __( 'Medium', 'azin-file' ),
					'fast'   => __( 'Fast', 'azin-file' )
				],
			]
		);

		$this->add_control(
			'animation_interval',
			[
				'label' => __( 'Interval', 'azin-file' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 50000,
				'step' => 1000,
				'default' => 5000,
			]
		);

		$this->add_control(
			'pause_over',
			[
				'label' => __( 'Pause ticker on mouse over', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
        
		$this->end_controls_section();
		//End Animation Section
	}
	
	protected function render() {

		$settings         = $this->get_settings_for_display();

		$block_classes   = array();
		$block_classes[] = 'azin-ticker-wrapper';
		$block_classes[] = ( 'yes' === $settings['white_box'] ? 'shadow-box white-box' : '' );
		

		$ticker_options   = array();
		$ticker_options[] = 'data-direction="'. $settings['direction'] .'"';
		$ticker_options[] = 'data-speed="'. $settings['animation_speed'] .'"';
		$ticker_options[] = 'data-interval="'. $settings['animation_interval'] .'"';
		$ticker_options[] = 'data-rows="'. $settings['titles_rows'] .'"';
		$ticker_options[] = $settings['pause_over'] === 'yes' ? 'data-pause-over="true"' : 'data-pause-over="false"';

		if ( $settings['titles_source'] === 'manual' && ! empty ( $settings['tickers'] ) ) {

			$tickers = array();

			foreach ( $settings['tickers'] as $ticker ) {

				if( $ticker['ticker_date'] === 'yes' ) {

					$timezone = get_option('timezone_string');
					date_default_timezone_set( $timezone );

					$currentDate = date( 'Y-m-d' );
					$currentDate = date( 'Y-m-d', strtotime( $currentDate ) );

					$dateBegin = date( 'Y-m-d', strtotime( $ticker['ticker_date_start'] ) );
					$dateEnd   = date( 'Y-m-d', strtotime( $ticker['ticker_date_end'] ) );
						
					if ( ( $currentDate >= $dateBegin ) && ( $currentDate <= $dateEnd ) ){
						$tickers[] = $ticker;
					}

				} else {
					$tickers[] = $ticker;
				}

			}
		} elseif ( $settings['titles_source'] === 'posts' ) {

			$post_sort   = $settings['post_sort'];
			$post_filter = $settings['post_filter'];
			$post_cat    = $settings['post_cat'];
			$post_tag    = $settings['post_tag'];

			switch ( $post_sort ) {
				case 'latest':
					$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
					break;
				case 'latest-updated':
					$args = array(
						'posts_per_page'      => $settings['ptotalcount'],
						'post_type'           => 'post',
						'post_status'         => 'publish',
						'orderby'             => 'modified',
						'ignore_sticky_posts' => '1',
						'order'               => 'DESC'  );
					break;
				case 'viewed':
					$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'meta_key' => azin_opt( 'views_meta_key' ),
						'orderby' => 'meta_value_num',
						'order' => 'DESC'  );
					break;
				case 'random':
					$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'orderby'        => 'rand'  );
					break;
				default:
				$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
				}
				if ( $post_filter ) {
					if ( $post_filter == 'category' && ! empty( $post_cat ) ) {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'category',
							'field' => 'term_id',
							'terms' => $post_cat
							)
						);
					} elseif ( $post_filter == 'tag' && ! empty( $post_tag ) ) {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'post_tag',
							'field' => 'term_id',
							'terms' => $post_tag
							)
						);
					}
				}

				$args[] = array(
					//'fields'                    => 'ids',
					'no_found_rows'             => true,
					'update_post_term_cache'    => false
				);

				if ( $settings['post_filter'] == 'post-ids' && ! empty( $settings['post_ids'] ) ){
					$args['post__in'] = explode( ',', $settings['post_ids'] );
				}
			
			$postsquery = new \WP_Query( $args );
		}
		?>
		<div class="<?php echo implode( ' ', $block_classes ); ?>">
			<?php if ( $settings['show_title'] === 'yes' ) { ?>
			<div class="azin-ticker-title">
				<?php if ( ! empty( $settings['tickers_icon'] ) ) { ?>
					<i class="fal fa-<?php echo $settings['tickers_icon']; ?> azin-ticker-icon"></i>
				<?php } ?>
				<?php echo $settings['tickers_title']; ?>
			</div>
			<?php } ?>
			<div class="azin-text-ticker" <?php echo implode( ' ', $ticker_options ); ?>>
				<ul>
		<?php
		if ( $settings['titles_source'] === 'manual' && ! empty( $tickers ) ) {
			foreach ( $tickers as $ticker ) {
			?>
				<li class="azin-ticker-item">
					<?php if( ! empty( $ticker['ticker_link']['url'] ) ) {
						$target   = ! empty ( $item['ticker_link']['is_external'] ) ? ' target="_blank"' : '';
						$nofollow = ! empty ( $item['ticker_link']['nofollow'] ) ? ' rel="nofollow"' : '';
						?>
						<a href="<?php echo $ticker['ticker_link']['url']; ?>" title="<?php echo $ticker['ticker_title']; ?>"<?php echo $target . $nofollow; ?>>
					<?php }

					echo $ticker['ticker_title'];

					if( ! empty( $ticker['ticker_link']['url'] ) ) { ?>
					</a>
					<?php } ?>						
				</li>
			<?php }
		} elseif ( $settings['titles_source'] === 'posts' && $postsquery->have_posts() ) {
			while ( $postsquery->have_posts() ) : $postsquery->the_post();
			?>
				<li class="azin-ticker-item">
					<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" target="<?php echo azin_link_target(); ?>">
						<?php the_title(); ?>
					</a>	
					<?php if ( $settings['publication_date'] === 'yes' ) {
						echo '<span class="azin-ticker-date">('. get_jdate_publish_time_two( 'j F Y' ) .')</span>'; 
					} ?>
				</li>
			<?php endwhile;
		}
		?>
				</ul>
			</div>
		</div>
		<?php
		wp_reset_postdata();
	}
}