<?php
namespace Elementor;

class Azin_Category_Grid extends Widget_Base {
	
	public function get_name() {
		return 'azin-category-grid';
	}
	
	public function get_title() {
		return __( 'Category Grid (Azinfile)', 'azin-file' );
	}
	
	public function get_icon() {
		return 'fal fa-th';
	}
	
	public function get_categories() {
		return [ 'azin-file' ];
	}
	
	protected function register_controls() {

	require get_template_directory() . '/includes/el-widgets/fa.php';
	
		$prod_cats = array();

		$taxonomy = az_woo() ? 'product_cat' : 'download_category';
		$args = array (
			'taxonomy'    => $taxonomy,
            'hide_empty'  => false
		);

		$prod_cats = get_terms( $args );
		
		$product_cat = array();
		if ( ! empty( $prod_cats ) && ! is_wp_error( $prod_cats ) ) {
			foreach ( $prod_cats as $prod_cat ) {
				$product_cat[ $prod_cat->term_id ] = $prod_cat->name;
			}
		}

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Category Grid (Azinfile)', 'azin-file' ),
			]
		);

		$this->add_control(
			'title',
			[
				'label' => __( 'Title', 'azin-file' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your title', 'azin-file' ),
                'default' => __( 'Categories', 'azin-file' ),
			]
		);

		$this->add_control(
			'icon',
			[
				'label' => __( 'Icon', 'azin-file' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'sitemap '
			]
		);

		$this->add_control(
			'custom_icon',
			[
				'label' => __( 'Or custom icon (Suitable size: 32px by 32px)', 'azin-file' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'product_cat',
			[
				'label' => __( 'Categories', 'azin-file' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => $product_cat,
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'   => __( 'Order by', 'azin-file' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					''           => '',
					'id'         => __( 'ID', 'azin-file' ),
					'date'       => __( 'Date', 'azin-file' ),
					'title'      => __( 'Title', 'azin-file' ),
					'menu_order' => __( 'Menu order', 'azin-file' ),
					'modified'   => __( 'Last modified date', 'azin-file' ),
				),
			]
		);

		$this->add_control(
			'order',
			[
				'label'   => __( 'Sort order', 'azin-file' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					''     => __( 'Inherit', 'azin-file' ),
					'DESC' => __( 'Descending', 'azin-file' ),
					'ASC'  => __( 'Ascending', 'azin-file' ),
				),
			]
		);

		$this->add_control(
			'hide_empty',
			[
				'label' => __( 'Hide empty categories', 'azin-file' ),
				'description' => __( 'Empty categories (no product) are not displayed', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'middle_title',
			[
				'label' 	   => __( 'Show title in the middle', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'	   => 'yes',
			]
		);

		/*$this->add_control(
			'title_tag',
			[
				'label'   => __( 'Block title tag', 'azin-file' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h2',
				'options' => [
					'div' => __( 'div', 'azin-file' ),
					'h1'  => __( 'h1', 'azin-file' ),
					'h2'  => __( 'h2', 'azin-file' ),
					'h3'  => __( 'h3', 'azin-file' ),
					'h4'  => __( 'h4', 'azin-file' ),
				],
			]
		);*/

		$this->add_control(
			'image_size',
			[
				'label'   => __( 'Image size', 'azin-file' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'thumbnail',
				'options' => array(
					'thumbnail'             => __( '150*150', 'azin-file' ),
					'woocommerce_thumbnail' => __( '300*300', 'azin-file' ),
					'woocommerce_single'    => __( '600*600', 'azin-file' ),
					'full'                  => __( 'Full size', 'azin-file' ),
				),
			]
		);

		$this->add_responsive_control(
			'image_width',
			[
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'label' => esc_html__( 'Image width', 'azin-file' ),
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 50,
					'unit' => '%',
				],
				'tablet_default' => [
					'size' => 80,
					'unit' => '%',
				],
				'mobile_default' => [
					'size' => 100,
					'unit' => '%',
				],
				'selectors' => [
					'{{WRAPPER}} .azin-term-cat img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'white_box',
			[
				'label' => __( 'White box style', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'bw_style',
			[
				'label' => __( 'Black & white style', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'bg_hover_style',
			[
				'label'   => __( 'Background style on mouseover', 'azin-file' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'bg-hover-none'   => __( 'None', 'azin-file' ),
					'bg-hover-style1' => __( 'First style', 'azin-file' ),
					'bg-hover-style2' => __( 'Second style', 'azin-file' ),
					//'bg-hover-style3' => __( 'Third style', 'azin-file' ),
				),
				'default' => 'bg-hover-none',
			]
		);

		$this->add_control(
			'show_title',
			[
				'label' => __( 'Show category title', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'show_product_count',
			[
				'label' => __( 'Show products count', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'white_border',
			[
				'label' => __( 'White border activation', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'cat_total_count',
			[
				'label' => __( 'Categories total count', 'azin-file' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
			]
		);

		$this->add_control(
			'columns_count',
			[
				'label' => __( 'Columns count', 'azin-file' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 2,
				'max' => 8,
				'step' => 1,
				'default' => 6,
			]
		);
        
		$this->end_controls_section();
	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();

		$product_cat     = $settings['product_cat'];
		$cat_total_count = $settings['cat_total_count'];
		$image_size      = $settings['image_size'];
		$taxonomy        = az_woo() ? 'product_cat' : 'download_category';

		$args = array (
			'taxonomy'    => $taxonomy,
			'order'       => $settings['order'],
			'hide_empty'  => 'yes' === $settings['hide_empty'],
			'include' 	  => $product_cat,
			'number'	  => $cat_total_count
		);

		if ( $settings['orderby'] ) {
			$args['orderby'] = $settings['orderby'];
		}
		
		$terms = get_terms( $args );
		?>
		
		<?php
		if ( ! empty( $terms ) ) {

			$block_classes  = 'azin-cats-grid ';
			$block_classes .= $settings['bg_hover_style'];
			$block_classes .= 'yes' === $settings['white_box'] ? ' white-box' : '';
			$block_classes .= 'yes' === $settings['bw_style'] ? ' bw-style' : '';
			$block_classes .= 'yes' === $settings['middle_title'] ? ' azin-middle-title' : ' azin-right-title';
		?>
			<div class="<?php echo $block_classes ?>">

				<?php if ( ! empty( $settings['title'] ) ) { ?>
				<div class="col-12 az-product-heading">
					<h2>
						<?php if( ! empty( $settings['custom_icon']['url'] ) ) { ?>
							<img src="<?php echo $settings['custom_icon']['url'] ?>" width="32" height="32" alt="<?php echo $settings['title'] ?>" class="cust-icon">
						<?php } elseif ( ! empty( $settings['icon'] ) ) { ?>
							<i class="fal fa-<?php echo $settings['icon'] ?>" aria-hidden="true"></i>
						<?php } ?>

						<?php echo $settings['title']; ?>
					</h2>
				</div>
				<?php } ?>

				<div class="row">

					<?php foreach ( $terms as $term ) {
						$term_link       = get_term_link( $term, $taxonomy );
						$term_image_name = az_woo() ? 'thumbnail_id' : 'download_term_image';
						$thumbnail_id    = get_term_meta ( $term->term_id, $term_image_name, true );
						if ( ! empty( $thumbnail_id ) ) {
							$cat_attr = wp_get_attachment_image_src( $thumbnail_id, $image_size );
							if ( isset ( $cat_attr[0] ) ) {
								$cat_logo = $cat_attr[0];
							}
						} else {
							$cat_logo = '';
						}

						$item_cols = 'azin-term-cat-con';
						
						switch ( $settings['columns_count'] ) {
							case 2:
								$item_cols .= ' col-6';
								break;
							case 3:
								$item_cols .= ' col-md-4 col-6';
								break;
							case 4:
								$item_cols .= ' col-md-3 col-6';
								break;
							case 5:
								$item_cols .= ' col-p-5 col-md-3 col-6';
								break;
							case 6:
								$item_cols .= ' col-md-2 col-6';
								break;
							case 7:
								$item_cols .= ' col-p-7 col-md-2 col-6';
								break;
							case 8:
								$item_cols .= ' col-p-8 col-md-2 col-6';
								break;
							default:
								$item_cols .= ' col-md-2 col-6';
						}

						$item_classes = 'azin-term-cat';
						$item_classes .= 'yes' === $settings['white_border'] ? ' shadow-box-white' : '';
					?>

					<div class="<?php echo $item_cols; ?>">
					
						<div class="<?php echo $item_classes; ?>">

							<a href="<?php echo $term_link; ?>" title="<?php echo $term->name; ?>" class="azin-term-link">
								<?php if ( ! empty ( $cat_logo ) ) { ?>
									<img src="<?php echo $cat_logo; ?>" alt="<?php echo $term->name; ?>" width="<?php echo $cat_attr[1]; ?>" height="<?php echo $cat_attr[2]; ?>">
								<?php } else { ?>
									<img src="<?php echo esc_url( get_template_directory_uri() ) . '/images/mthumb.png'; ?>" alt="<?php echo $term->name; ?>" width="150" height="150">
								<?php } ?>

							<?php 
							if ( 'yes' === $settings['show_title'] ) { ?>
								<span class="azin-term-name">
								<?php echo $term->name; ?>
								</span>
							<?php } ?>
							</a>

							<?php 
							if ( 'yes' === $settings['show_product_count'] ) { ?>
								<span class="azin-term-count">
								<?php
								$count = '';
								$term_count = sprintf( _n( '%s product', '%s products', $count, 'azin-file' ), $term->count );
								echo $term_count; ?>
								</span>
							<?php } ?>

						</div>
						
					</div>

					<?php } ?>
				</div>
			</div>
        <?php
		}
	}
}