<?php
namespace Elementor;

class Azin_Edd_Products extends Widget_Base {

	public function get_name() {
		return 'azin-edd-products';
	}
	
	public function get_title() {
		return __( 'EDD Product', 'azin-file' );
	}
	
	public function get_icon() {
		return 'fal fa-shopping-cart';
	}
	
	public function get_categories() {
		return [ 'azin-file' ];
	}
	
	protected function register_controls() {

		require get_template_directory() . '/includes/el-widgets/fa.php';

		$prod_cat = array();

		$categories = get_terms( array(
			'taxonomy'   => 'download_category',
			'hide_empty' => false,
		) );

		if ( ! empty( $categories ) && !is_wp_error( $categories ) ) {
			foreach ( $categories as $category ) {
				$prod_cat[ $category->term_id ] = $category->name;
			}
		}

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'EDD Product', 'azin-file' ),
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'azin-file' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter the title', 'azin-file' ),
			]
		);

		$this->add_control(
			'prod_sort',
			[
				'label'   => __( 'Sort products', 'azin-file' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'         => __( 'Latest Products', 'azin-file' ),
					'latest-updated' => __( 'Latest updated products', 'azin-file' ),
					'random'         => __( 'Random products', 'azin-file' ),
					'viewed'         => __( 'Popular products', 'azin-file' ),
					'saled'          => __( 'Best-selling products', 'azin-file' ),
					'discounted'     => __( 'Discounted products', 'azin-file' ),
					'special'        => __( 'Special products', 'azin-file' ),
				],
			]
		);

		$this->add_control(
			'prod_filter',
			[
				'label'   => __( 'Product filtering', 'azin-file' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'category',
				'options' => [
					'category'  => __( 'Products category', 'azin-file' ),
					'tag'       => __( 'Products tag', 'azin-file' ),
				],
			]
		);

		$this->add_control(
			'prod_cat',
			[
				'label'       => __( 'Product categories', 'azin-file' ),
				'type'        => Controls_Manager::SELECT2,
				'multiple'    => true,
				'options'     => $prod_cat,
				'condition' => [
					'prod_filter' => 'category',
				]
			]
		);

		$this->add_control(
			'prod_tag',
			[
				'label'       => __( 'Product tag', 'azin-file' ),
				'description' => __( 'If you have defined the product filter on the tag, enter the desired tags in this box (separate the IDs with a "," sign, for example 145,12,6)', 'azin-file' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Tag(s) ID', 'azin-file' ),
				'condition'   => [
					'prod_filter' => 'tag',
				]
			]
		);

		$this->add_control(
			'prod_cat_exclude',
			[
				'label'       => __( 'Exclude Product categories', 'azin-file' ),
				'description' => __( 'Selected categories will not be displayed', 'azin-file' ),
				'type'        => Controls_Manager::SELECT2,
				'multiple'    => true,
				'options'     => $prod_cat,
			]
		);

		$this->add_control(
			'prod_icon',
			[
				'label'   => __( 'Icon', 'azin-file' ),
				'type'    => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'shopping-cart'
			]
		);

		$this->add_control(
			'custom_icon',
			[
				'label' => __( 'Or custom icon (Suitable size: 32px by 32px)', 'azin-file' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'ptotalcount',
			[
                'label'   => __( 'Number of products', 'azin-file' ),
                'type'    => Controls_Manager::NUMBER,
                'min'     => 1,
                'max'     => 54,
                'step'    => 1,
                'default' => 8,
            ]
		);

        $this->add_control(
            'pcount',
            [
                'label'   => __( 'Number of column products', 'azin-file' ),
                'type'    => Controls_Manager::NUMBER,
                'min'     => 2,
                'max'     => 4,
                'step'    => 1,
                'default' => 4,
            ]
		);

		$this->add_control(
			'hide_no_prod',
			[
				'label'        => __( 'Hide the block if there is no product', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'middle_title',
			[
				'label' 	   => __( 'Show title in the middle', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'	   => 'yes',
			]
		);

		$this->add_control(
			'white_box',
			[
				'label' => __( 'White box style', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'view_all',
			[
				'label'        => __( 'Display view all button (If category or tag selected)', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'view_all_text',
			[
				'label'       => __( 'View all button text', 'azin-file' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Button Text', 'azin-file' ),
				'default'     => __( 'View All Products', 'azin-file' ),
				'condition'   => [
					'view_all' => 'yes',
				]
			]
		);

		$this->add_control(
			'view_all_link',
			[
				'label'         => __( 'View all button custom link', 'azin-file' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => __( 'https://your-link.com', 'azin-file' ),
				'show_external' => true,
				'default'       => [
					'url'         => '',
					'is_external' => true,
					'nofollow'    => false,
				],
				'condition'      => [
					'view_all' => 'yes',
				],
			]
        );

		$this->end_controls_section();
	}
	
	protected function render() {
        
        $settings = $this->get_settings_for_display();
		
		switch ( $settings['pcount'] ) {
			case 2:
				$col = 'col-6';
				break;
			case 3:
				$col = 'col-md-4 col-6';
				break;
			case 4:
				$col = 'col-lg-3 col-md-4 col-6';
				break;
		}

		$prod_sort 		  = $settings['prod_sort'];
		$prod_filter 	  = $settings['prod_filter'];
		$prod_cat 		  = $settings['prod_cat'];
		$prod_cat_exclude = $settings['prod_cat_exclude'];
        $prod_tag 		  = ( ! empty ( $settings['prod_tag'] && $settings['prod_tag'] != ' ' ) ? explode ( ",", $settings['prod_tag'] ) : '' );
		$view_all_link    = '';

			if ( $prod_sort != 'special' ) {
			switch ( $prod_sort) {
				case 'latest':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'download',
					'post_status' => 'publish',
					'order' => 'DESC'  );
					break;
				case 'latest-updated':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'download',
					'post_status' => 'publish',
					'orderby' => 'modified',
					'ignore_sticky_posts' => '1',
					'order' => 'DESC'  );
					break;
				case 'saled':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'download',
					'post_status' => 'publish',
					'meta_key' => '_edd_download_earnings',
                    'orderby' => 'meta_value_num',
                    'order' => 'DESC'  );
					break;
				case 'discounted':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'download',
					'post_status' => 'publish',
					'meta_query' => array(
						array(
							'key' => 'file_saleprice',
							'value'   => array( '' ),
							'compare' => 'NOT IN'
						)
                    ),
                    'order' => 'DESC'  );
					break;
				case 'viewed':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'download',
					'post_status' => 'publish',
					'meta_key' => 'post_views_count',
                    'orderby' => 'meta_value_num',
                    'order' => 'DESC'  );
					break;
				case 'random':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type'      => 'download',
					'post_status'    => 'publish',
					'orderby'        => 'rand'  );
					break;
				default:
				$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type'   => 'download',
					'post_status' => 'publish',
					'order'       => 'DESC'  );
				}
				
				if ( $prod_cat && $prod_filter == 'category' ) {
					$args['tax_query'] = array(
						array(
						'taxonomy' => 'download_category',
						'field'    => 'term_id',
						'terms'    => $prod_cat
						)
					);
					$view_all_link = azin_get_term_links( 'download_category', $prod_cat );
				} elseif ( ! empty ( $prod_tag ) && $prod_filter == 'tag' ) {
					$args['tax_query'] = array(
						array(
						'taxonomy' => 'download_tag',
						'field'    => 'term_id',
						'terms'    => $prod_tag
						)
					);
					$view_all_link = azin_get_term_links( 'download_tag', $prod_tag );
				}
			}
			elseif ( $prod_sort == 'special' ) {
				$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'download',
					'post_status' => 'publish',
					'meta_query' => array(
						array(
							'key' => 'file_special',
							'compare' => '=',
							'value' => 1,
							'type' => 'numeric'
						),
                    ),
					'order' => 'DESC'  );
			}

			if ( ! empty( $prod_cat_exclude ) ) {
				$args['tax_query'] = array(
							'relation' => 'AND',
							array(
								'taxonomy' => 'download_category',
								'field' => 'term_id',
								'terms' => $prod_cat_exclude,
								'operator' => 'NOT IN'
							)
						);
			}

        $products = new \WP_Query( $args);
		
		$block_classes  = 'row';
		$block_classes .= 'yes' === $settings['white_box'] ? ' white-box' : '';
		$block_classes .= 'yes' === $settings['middle_title'] ? ' azin-middle-title' : ' azin-right-title';
		?>
		
		<div class="<?php echo $block_classes ?>">
		
		<?php if ( $products->have_posts() ) : ?>

		<?php if ( ! empty( $settings['title'] ) ) { ?>
		<div class="col-12 az-product-heading">
			<h2>
				<?php if( ! empty( $settings['custom_icon']['url'] ) ) { ?>
					<img src="<?php echo $settings['custom_icon']['url'] ?>" width="32" height="32" alt="<?php echo $settings['title'] ?>" class="cust-icon">
				<?php } elseif ( ! empty( $settings['prod_icon'] ) ) { ?>
					<i class="fal fa-<?php echo $settings['prod_icon'] ?>" aria-hidden="true"></i>
				<?php } ?>

				<?php echo $settings['title']; ?>
			</h2>
		</div>
		<?php } ?>

			<?php while ( $products->have_posts() ) : $products->the_post(); ?>
				<?php azin_product_archive_content( get_the_ID(), $col ); ?>
			<?php endwhile; ?>
			<div class="col-12">
				<?php
				if ( 'yes' === $settings['view_all'] ) {
					if ( ! empty ( $settings['view_all_link']['url'] ) ) {
						$all_link = $settings['view_all_link']['url'];
					} elseif ( ! empty ( $view_all_link ) ) {
						$all_link = $view_all_link;
					} else {
						$all_link = get_home_url(). '/?post_type=download&s=';
					}
				?>
					<a href="<?php echo $all_link; ?>" class="btn azin-btn btn-lg btn-view-all" title="<?php _e( 'View All Products', 'azin-file') ?>">
						<i aria-hidden="true" class="fal fa-<?php echo $settings['prod_icon']; ?>"></i>
							<?php echo $settings['view_all_text']; ?>
						<i class="fal fa-angle-left" aria-hidden="true"></i>
					</a>
				<?php
				}
				?>
			</div>
			<?php else :
				$no_prod_class = ( 'yes' === $settings['hide_no_prod'] ? ' not-azin-hide-section' : '' );
				?>
				<div class="alert alert-warning alert-dismissible anote<?php echo $no_prod_class ?>">
					<strong>
						<span class="fal fa-bell" aria-hidden="true"></span>
						<?php echo azin_opt( 'text_not_found' ); ?>
					</strong>
				</div>
		<?php endif;
		wp_reset_postdata(); ?>
		</div>
        <?php

	}

}