<?php
namespace Elementor;

class Azin_Header_Logo extends Widget_Base {
    
	public function get_name() {
		return 'azin-header-logo';
	}
	
	public function get_title() {
		return __( 'Header logo (Azinfile)', 'azin-file' );
	}
	
	public function get_icon() {
		return 'fal fa-image-polaroid';
	}
	
	public function get_categories() {
		return [ 'azin-file-header' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Header logo (Azinfile)', 'azin-file' ),
			]
		);

		$this->add_control(
			'site_logo',
			[
				'label'        => __( 'Your logo', 'azin-file' ),
				'type'         => Controls_Manager::MEDIA,
				'description'  => __( 'Upload your site logo from this section. Appropriate size: 140 pixel(w) in 60 pixel(h)', 'azin-file' ),
				'default'      => [
					'url' => get_template_directory_uri()."/images/logo.png",
				],
			]
		);

		$this->add_control(
			'site_logo_retina',
			[
				'label'        => __( 'Retina logo', 'azin-file' ),
				'type'         => Controls_Manager::MEDIA,
				'description'  => __( 'Upload a site logo in a two-dimensional size to the current logo. Appropriate size: 280 pixel(w) in 120 pixel(h)', 'azin-file' ),
				'default'      => [
					'url' => get_template_directory_uri()."/images/logo2x.png",
				],
			]
		);

		$this->add_control(
			'add_home_heading',
			[
				'label'        => __( 'Add an H1 tag to the logo', 'azin-file' ),
				'description'  => __( 'Add an H1 tag to the logo on the home page', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'change_logo_link',
			[
				'label'        => __( 'Change logo link', 'azin-file' ),
				'description'  => __( 'With this option, you can change the default link of the logo that is connected to the main page of your site', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'logo_link',
			[
				'label'         => __( 'Logo link', 'azin-file' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => __( 'https://your-link.com', 'azin-file' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
				'condition' => [
                    'change_logo_link' => 'yes',
                ],
			]
        );
        
		$this->end_controls_section();
	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();

		$site_logo          = $settings['site_logo']['url'];
        $site_logo_retina   = $settings['site_logo_retina']['url'];
		$add_home_heading   = $settings['add_home_heading'] === 'yes' ? true : false;

		$image_attributes   = wp_get_attachment_metadata( $settings['site_logo']['id'] );
		$width              = ( isset( $image_attributes['width'] ) ? $image_attributes['width'] : '' );
		$height             = ( isset( $image_attributes['height'] ) ? $image_attributes['height'] : '' );		

		$change_logo_link = $settings['change_logo_link'] === 'yes' ? true : false;
		$logo_link        = ( $change_logo_link ? $settings['logo_link']['url'] : esc_url( home_url() ) );
		$logo_target      = isset ( $settings['logo_link']['is_external'] ) ? ' target="_blank"' : '';
		$logo_nofollow    = isset ( $settings['logo_link']['nofollow'] ) ? ' rel="nofollow"' : 'rel="home"';

		if ( is_front_page() && $add_home_heading ) { echo '<h1>'; } ?>

		<a href="<?php echo $logo_link; ?>" title="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" class="azin-logo-link az-el-site-logo" <?php echo $logo_target . $logo_nofollow; ?>>

		<?php
			$logo_src        = azin_to_https( $site_logo );
			$logo_retina_src = ( ! empty( $site_logo_retina ) ) ? ' srcset="'. azin_to_https( $site_logo_retina ) . ' 2x"' : '';
			$logo_width      = ( ! empty( $width ) ) ? $width : '140';
			$logo_height     = ( ! empty( $height ) ) ? $height : '60';
			$alt             = get_bloginfo('name') . ' | ' . get_bloginfo('description');
			$logo_schema     = azin_opt( 'site_schema' ) ? 'itemprop="logo"' : '';
		?>

			<img <?php echo $logo_schema; ?>
			src="<?php echo $logo_src; ?>"
			<?php echo $logo_retina_src; ?>
			width="<?php echo $logo_width; ?>"
			height="<?php echo $logo_height; ?>"
			alt="<?php echo $alt; ?>"
			title="<?php echo $alt; ?>"
			class="img-logo"/>

			<strong><?php bloginfo('name'); ?> | <?php bloginfo('description'); ?> </strong>
		</a>
			
	<?php if ( is_front_page() && $add_home_heading ) { echo '</h1>'; }
	}
}