<?php
namespace Elementor;

class Azin_Mobile_Menu_Btn extends Widget_Base {
    
	public function get_name() {
		return 'azin-mobile-menu-btn';
	}
	
	public function get_title() {
		return __( 'Mobile menu button (Azinfile)', 'azin-file' );
	}
	
	public function get_icon() {
		return 'fal fa-bars';
	}
	
	public function get_categories() {
		return [ 'azin-file-header' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Mobile menu button (Azinfile)', 'azin-file' ),
			]
		);
		
		$this->add_control(
			'show_hover_title',
			[
				'label' => __( 'Show title when hovering mouse', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
        
		$this->end_controls_section();
	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();

        $show_hover_title = $settings['show_hover_title'] === 'yes' ? true : false;
	?>
		<span class="btn btn-outline-primary logged-btn mm-btn az-el-btn-mobile-menu" onclick="openmNav()"<?php if ( $show_hover_title ) { ?> data-toggle="tooltip" data-placement="top" title="<?php _e( 'Menu', 'azin-file' ); ?>"<?php } ?>>
			<i aria-hidden="true" data-title="<?php _e( 'Menu', 'azin-file' ); ?>" class="fal fa-bars"></i>
		</span>
	<?php
	}
}