<?php
namespace Elementor;

class Azin_Mobile_User_Buttons extends Widget_Base {

    
	public function get_name() {
		return 'azin-mobile-user-buttons';
	}
	
	public function get_title() {
		return __( 'Mobile user buttons (Azinfile)', 'azin-file' );
	}
	
	public function get_icon() {
		return 'fal fa-user';
	}
	
	public function get_categories() {
		return [ 'azin-file-header' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Mobile user buttons (Azinfile)', 'azin-file' ),
			]
		);
		
		$this->add_control(
			'merge_user_btn',
			[
				'label'        => __( 'Merge buttons', 'azin-file' ),
				'description'  => __( 'Integration of login and registration buttons', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);
		
		$this->add_control(
			'digits_mode',
			[
				'label'        => __( 'Compatibility with Digits plugin', 'azin-file' ),
				'description'  => __( 'If you have a Digit plugin installed, the login and registration buttons will be connected to this plugin', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'digits_page',
			[
				'label' => __( 'Link to Digits page instead of pop-up mode', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
                    'digits_mode' => 'yes',
                ],
			]
		);
        
		$this->end_controls_section();
	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();

		$merge_user_btn         = $settings['merge_user_btn'] === 'yes' ? true : false;
		$digits_mode            = $settings['digits_mode'] === 'yes' ? true : false;
		$digits_page            = $settings['digits_page'] === 'yes' ? true : false;
        
		?>
		
		<div class="az-el-mobile-btns mobile-btns">
				
				<?php if( ! is_user_logged_in() ) { ?>
					<?php
					if ( function_exists( 'digits_version' ) && $digits_mode ) {
						$digits_link = ( $digits_page ? 'digitlink' : 'digitpopup' ); ?>
						<span title="<?php _e( 'Login Or Register', 'azin-file' ); ?>" class="btn btn-primary register-btn az-merged-btn digitsbtn  <?php echo $digits_link; ?>">
							<i aria-hidden="true" data-title="<?php _e( 'Login ', 'azin-file' ); ?>" class="fal fa-user"></i>
							<span class="login-separator">/</span>
							<i aria-hidden="true" data-title="<?php _e( 'Register', 'azin-file' ); ?>" class="fal fa-user-plus"></i>
						</span>
					<?php } elseif( az_woo() && $merge_user_btn ) { ?>
						<a title="<?php _e( 'Login Or Register', 'azin-file' ); ?>" class="btn btn-primary register-btn az-merged-btn digitsbtn" <?php if( azin_opt( 'ch_login_link' ) ) { echo 'href="'. azin_opt( 'login_link' ) .'"'; } else {echo 'href="' . esc_url( get_myaccount_link() ) .'"'; } ?>>
							<i aria-hidden="true" data-title="<?php _e( 'Login ', 'azin-file' ); ?>" class="fal fa-user"></i>
							<span class="login-separator">/</span>
							<i aria-hidden="true" data-title="<?php _e( 'Register', 'azin-file' ); ?>" class="fal fa-user-plus"></i>
						</a>
					<?php } else { ?>
					<a title="<?php _e( 'Login', 'azin-file' ); ?>" <?php if( azin_opt( 'ch_login_link' ) ) { echo 'href="'. azin_opt( 'login_link' ) .'"'; } else { echo 'href="#" onclick="openLogin()"';} ?>
						class="btn btn-outline-primary ml-btn logged-btn az-not-merged-btn">
						<i aria-hidden="true" data-title="<?php _e( 'Login ', 'azin-file' ); ?>" class="fal fa-sign-in-alt user-icon"></i>
					</a>
					<a href="<?php echo azin_register_link() ?>" title="<?php _e( 'Register', 'azin-file' ); ?>" class="btn btn-primary register-btn mu-btn az-not-merged-btn">
						<i aria-hidden="true" data-title="<?php _e( 'Regsiter', 'azin-file' ); ?>" class="fal fa-user-plus"></i>
					</a>
				<?php }
				} else { ?>
					<span title="<?php _e( 'User Menu', 'azin-file' ); ?>" class="btn btn-outline-primary logged-btn ml-btn" onclick="openNav()">
						<i aria-hidden="true" data-title="<?php _e( 'User Menu', 'azin-file' ); ?>" class="fal fa-user"></i>
					</span>
				<?php } ?>
		</div>

		<?php
	}
}