<?php
namespace Elementor;

class Azin_Search_Bar extends Widget_Base {

    
	public function get_name() {
		return 'azin-search-bar';
	}
	
	public function get_title() {
		return __( 'Search bar (Azinfile)', 'azin-file' );
	}
	
	public function get_icon() {
		return 'fal fa-search';
	}
	
	public function get_categories() {
		return [ 'azin-file-header' ];
	}
	
	protected function register_controls() {

		$prod_cata  = array();
		$post_type  = az_woo() ? 'product_cat' : 'download_category';
		$categories = get_terms( $post_type );

		if ( ! empty( $categories ) && ! is_wp_error( $categories ) ){
			foreach ( $categories as $category ) {
				$prod_cata[ $category->term_id ] = $category->name;
			}
		}

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Search bar (Azinfile)', 'azin-file' ),
			]
		);
		
		$this->add_control(
			'ajax_search',
			[
				'label'        => __( 'Ajax live search', 'azin-file' ),
				'description'  => __( 'By activating this feature, search results will be displayed by entering the keyword', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'search_type',
			[
				'label'        => __( 'Search type', 'azin-file' ),
				'description'  => __( 'Search results in files or posts (searches only on files if disabled)', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'replace_product_post',
			[
				'label'        => __( 'Replace products and posts', 'azin-file' ),
				'description'  => __( 'Replace products and posts in the search box', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'no',
				'condition' => [
                    'search_type' => 'yes',
                ],
			]
		);

		$this->add_control(
			'search_cat',
			[
				'label' => __( 'Show Search Category', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'search_cat_sort',
			[
				'label' => __( 'Sort categories alphabetically', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
                    'search_cat' => 'yes',
                ],
			]
		);

		$this->add_control(
			'search_cat_hierarchical',
			[
				'label' => __( 'Display hierarchy', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
                    'search_cat' => 'yes',
                ],
			]
		);

		$this->add_control(
			'search_cat_parent',
			[
				'label'       => __( 'Parent categories only', 'azin-file' ),
				'description' => __( 'By activating this option, only the first level categories are displayed', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'no',
				'condition'    => [
                    'search_cat' => 'yes',
                ],
			]
		);

		$this->add_control(
			'search_cat_cats',
			[
				'label'       => __( 'Hide categories', 'azin-file' ),
				'description' => __( 'Selected categories are not displayed in the search box', 'azin-file' ),
				'type'        => Controls_Manager::SELECT2,
				'multiple'    => true,
				'options'     => $prod_cata,
				'condition'   => [
                    'search_cat' => 'yes',
                ],
			]
		);
        
		$this->end_controls_section();
	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();

		$ajax_search              = $settings['ajax_search'] === 'yes' ? true : false;
		$search_type              = $settings['search_type'] === 'yes' ? true : false;
		$replace_product_post     = $settings['replace_product_post'] === 'yes' ? true : false;
		$search_cat               = $settings['search_cat'] === 'yes' ? true : false;
		$search_cat_sort          = $settings['search_cat_sort'] === 'yes' ? true : false;
		$search_cat_hierarchical  = $settings['search_cat_hierarchical'] === 'yes' ? true : false;
		$search_cat_parent        = $settings['search_cat_parent'] === 'yes' ? true : false;
		$search_cat_cats          = $settings['search_cat_cats'] === 'yes' ? true : false;

	?>

		<form class="azin-search-bar az-el-search" role="search" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
		
        <div class="input-group input-group-lg ajax-search-wrapper">

            <?php if ( $search_type && ! $search_cat ) {
                $product_ptype = ( az_woo() ? 'product' : 'download' ); ?>
                <span class="input-group-before s-select">
                    <select aria-label="Post type" name="post_type">
                        
                    <?php if ( $replace_product_post ) { ?>
                        <option value="post">
                            <?php echo azin_opt( 'text_blog' ); ?>
                        </option>

                        <option value="<?php echo $product_ptype; ?>">
                                <?php echo azin_opt( 'text_shop' ); ?>
                        </option>
                    <?php } else { ?>
                        <option value="<?php echo $product_ptype; ?>">
                                <?php echo azin_opt( 'text_shop' ); ?>
                        </option>

                        <option value="post">
                            <?php echo azin_opt( 'text_blog' ); ?>
                        </option>
                    <?php } ?>

                    </select>
                </span>
            <?php } else { ?>
                <?php if ( az_woo() ) { ?>
                    <input type="hidden" value="product" name="post_type">
                <?php } else {  ?>
                    <input type="hidden" value="download" name="post_type">
                <?php } ?>
            <?php } ?>

            <?php 

                if ( $search_cat ) {

                    $product_taxonomy = ( az_woo() ? 'product_cat' : 'download_category' );

                    $args = array (
                        'taxonomy'        => $product_taxonomy,
                        'hide_empty'      => true,
                        'show_count'      => 0,
                        'hierarchical'    => 1,
                        'show_option_all' => __( 'Category', 'azin-file' ),
                        'value_field'     => 'slug',
                        'name'            => 'product_cat',
                        'class'           => 'product_cat',
                        'echo'            => 0
                    );

                    if ( $search_cat_sort ) {
                        $args['orderby'] = 'name';
                        $args['order'] = 'ASC';
                    }

                    if ( $search_cat_parent ) {
                        $args['parent'] = 0;
                    }

                    if ( ! empty ( $search_cat_cats ) ) {
                        $args['exclude'] = $search_cat_cats;
                    }

                    if ( $search_cat_hierarchical ) {
                        $args['hierarchical'] = 1;
                    }

                    $categories = wp_dropdown_categories( $args );

                    if ( ! empty( $categories ) && ! is_wp_error( $categories ) ) {
                        ?>
                        <div class="input-group-before s-select">
                            <?php echo $categories; ?>
                        </div>
                    <?php } 
                }
            ?>

            <input autocomplete="off"<?php if( $ajax_search ) { echo ' data-swplive="true"'; } ?> aria-label="Search" type="text" name="s" class="form-control msh<?php if ( ! azin_opt( 'search_type' ) ) { ?> sntype<?php } ?>" placeholder="<?php echo azin_opt( 'text_search' ); ?>" required>

            <span class="input-group-append">
                <button type="submit" aria-label="Search" id="searchsubmith" class="btn btn-search"><i class="fal fa-search"></i></button>
            </span>
        </div>
    </form>

        <?php
	}
}