<?php
namespace Elementor;

class Azin_Shopping_Cart extends Widget_Base {

    
	public function get_name() {
		return 'azin-shopping-cart';
	}
	
	public function get_title() {
		return __( 'Shopping cart (Azinfile)', 'azin-file' );
	}
	
	public function get_icon() {
		return 'fal fa-shopping-bag';
	}
	
	public function get_categories() {
		return [ 'azin-file-header' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Shopping cart (Azinfile)', 'azin-file' ),
			]
		);
		
		$this->add_control(
			'show_items',
			[
				'label' => __( 'Show number of products', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_hover_title',
			[
				'label' => __( 'Show title when hovering mouse', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

        $this->add_control(
			'direct_cart_link',
			[
				'label' => __( 'Direct link to shopping cart', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
        
		$this->end_controls_section();
	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();

        $direct_cart_link = $settings['direct_cart_link'];
        $show_hover_title = $settings['show_hover_title'] === 'yes' ? true : false;
        $show_items       = $settings['show_items'];

		if ( az_woo() ) {
			$cart_count = is_object( WC()->cart ) ? WC()->cart->get_cart_contents_count() : '0';;
			$cart_url = wc_get_cart_url();
		} else {
			$cart_count = edd_get_cart_quantity();
			$cart_url = edd_get_checkout_uri();
		}
		?>
        <div class="btn-cart az-el-btn-cart">
            <?php if ( $direct_cart_link != 'yes' ) { ?>
				<span class="shop-icon" <?php if ( $show_hover_title ) { ?>data-toggle="tooltip" data-placement="top" title="<?php _e( 'Shopping cart', 'azin-file' ); ?>"<?php } ?> onclick="openCart()">
					<i aria-hidden="true" class="fal fa-shopping-bag"></i>
					<?php if ( $show_items === 'yes' ) { ?>
						<span class="cart-amount edd-cart-quantity">
							<?php echo $cart_count; ?>
						</span>
					<?php } ?>
				</span>
            <?php } else { ?>
                <a class="shop-icon" <?php if ( $show_hover_title ) { ?>data-toggle="tooltip" data-placement="top"<?php } ?> title="<?php _e( 'Shopping cart', 'azin-file' ); ?>" href="<?php echo $cart_url; ?>">
                    <i aria-hidden="true" class="fal fa-shopping-bag"></i>
                    <?php if ( $show_items === 'yes' ) { ?>
                        <span class="cart-amount edd-cart-quantity">
							<?php echo $cart_count; ?>
						</span>
                    <?php } ?>
                </a>
            <?php } ?>
        </div>
        <?php
	}
}