<?php
namespace Elementor;

class Azin_User_Buttons extends Widget_Base {

    
	public function get_name() {
		return 'azin-user-buttons';
	}
	
	public function get_title() {
		return __( 'User Buttons (Azinfile)', 'azin-file' );
	}
	
	public function get_icon() {
		return 'fal fa-user';
	}
	
	public function get_categories() {
		return [ 'azin-file-header' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'User Buttons (Azinfile)', 'azin-file' ),
			]
		);
		
		$this->add_control(
			'merge_user_btn',
			[
				'label'        => __( 'Merge buttons', 'azin-file' ),
				'description'  => __( 'Integration of login and registration buttons', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);
		
		$this->add_control(
			'digits_mode',
			[
				'label'        => __( 'Compatibility with Digits plugin', 'azin-file' ),
				'description'  => __( 'If you have a Digit plugin installed, the login and registration buttons will be connected to this plugin', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'digits_page',
			[
				'label' => __( 'Link to Digits page instead of pop-up mode', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
                    'digits_mode' => 'yes',
                ],
			]
		);
        
		$this->end_controls_section();
	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();

        $merge_user_btn  = $settings['merge_user_btn'] === 'yes' ? true : false;
		$digits_mode     = $settings['digits_mode'] === 'yes' ? true : false;
		$digits_page     = $settings['digits_page'] === 'yes' ? true : false;
		
		if( ! is_user_logged_in() ) { ?>

			<div class="az-el-user-btn">
				<?php
				if ( function_exists( 'digits_version' ) && $digits_mode ) {
                    $digits_link = ( $digits_page ? 'digitlink' : 'digitpopup' ); ?>
                    <span title="<?php _e( 'Login or Register', 'azin-file' ) ?>" class="btn btn-primary register-btn user-btn reg-btn az-merged-btn digitsbtn <?php echo $digits_link; ?>">
                        <i aria-hidden="true" class="fal fa-user"></i>
                        <span class="hidden-sm"><?php _e( 'Login', 'azin-file' ) ?></span>
                        /
                        <i aria-hidden="true" class="fal fa-user-plus"></i>
                        <span class="hidden-sm"><?php _e( 'Register', 'azin-file' ) ?></span>
                    </span>
                <?php } elseif ( az_woo() && $merge_user_btn ) { ?>
                    <a title="<?php _e( 'Login or Register', 'azin-file' ) ?>" class="btn btn-primary register-btn user-btn reg-btn az-merged-btn digitsbtn" <?php if ( azin_opt( 'ch_login_link' ) ) {echo 'href="'.azin_opt( 'login_link' ).'"'; } else {echo 'href="' . get_myaccount_link() .'"';} ?>>
                        <i aria-hidden="true" class="fal fa-user"></i>
                        <span class="hidden-sm"><?php _e( 'Login', 'azin-file' ) ?></span>
                        /
                        <i aria-hidden="true" class="fal fa-user-plus"></i>
                        <span class="hidden-sm"><?php _e( 'Register', 'azin-file' ) ?></span>
                    </a>
                <?php } else { ?>
                <a class="logged-btn user-btn login-btn btn btn-outline-primary az-not-merged-btn" <?php if ( ! azin_opt( 'ch_login_link' ) ) { echo 'href="#" onclick="openLogin()"'; } else { echo 'href="'. azin_opt( 'login_link' ) .'"'; } ?>>
                    <span class="fal fa-user user-icon"></span>
                    <span class="hidden-sm"><?php echo azin_opt( 'text_login' ); ?></span>
                </a>
				
				<a href="<?php echo azin_register_link() ?>" title="<?php echo azin_opt( 'text_reg_hint' ); ?>" class="btn btn-primary register-btn user-btn reg-btn az-not-merged-btn">
                    <span class="fal fa-user-plus reg-icon"></span>
                    <span class="hidden-sm"><?php echo azin_opt( 'text_register' ); ?></span>
                </a>
                <?php } 
				?>
			</div>

		<?php } else {
		$user = wp_get_current_user(); ?>

		<div class="dropdown user-btns az-el-user-drop">
			
			<button class="dropdown-toggle user-btn" type="button" data-toggle="dropdown">
				<?php echo get_avatar( get_current_user_id(), 30, '', $user->display_name); ?>
				<span class="user-name"><?php echo $user->display_name; ?></span>
				<?php if ( class_exists( 'EDD_Wallet' ) ) { 
					echo '<span class="hidden-sm">';
					$wallet = edd_currency_filter(edd_wallet()->wallet->balance( get_current_user_id() ) );
					echo ' | '. $wallet;
					echo '</span>';
				}
				if ( class_exists( 'WooWallet' ) ) {
					echo '<span class="hidden-sm">';
					$wallet = woo_wallet()->wallet->get_wallet_balance( get_current_user_id() );
					echo ' | '. $wallet;
					echo '</span>';
				} ?>
				<span class="fal fa-chevron-down user-chevron-down" aria-hidden="true"></span>
			</button>

			<?php if ( azin_opt( 'replace_user_menu' ) && has_nav_menu('user_menu') ) { ?>
				<?php
					wp_nav_menu( array(
						'menu'              => 'user_menu',
						'theme_location'    => 'user_menu',
						'menu_class'        => 'dropdown-menu user-menu mu-menu',
						'depth'             => 1,
						'container'         => ''
						)
					);
				?>
			<?php } else { ?>
				<ul class="dropdown-menu user-menu mu-menu">
					<?php
					if ( az_woo() ) {
						require AZ_DIR .'/includes/woo/umenu.php';
					} else {
						require AZ_DIR .'/includes/edd/umenu.php';
					} ?>
				</ul>
			<?php } ?>
		</div>
			
		<?php
		} 
	}
}