<?php
namespace Elementor;

class Azin_Wishlist_Btn extends Widget_Base {

    
	public function get_name() {
		return 'azin-wishlist-btn';
	}
	
	public function get_title() {
		return __( 'Wishlist button (Azinfile)', 'azin-file' );
	}
	
	public function get_icon() {
		return 'fal fa-heart';
	}
	
	public function get_categories() {
		return [ 'azin-file-header' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Wishlist button (Azinfile)', 'azin-file' ),
			]
		);
		
		$this->add_control(
			'show_items',
			[
				'label' => __( 'Show number of products (Only in woocommerce mode)', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_hover_title',
			[
				'label' => __( 'Show title when hovering mouse', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        
		$this->end_controls_section();
	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();

        $show_hover_title = $settings['show_hover_title'] === 'yes' ? true : false;
        $show_items       = $settings['show_items'];

		if ( class_exists( 'YITH_WCWL' ) || class_exists( 'EDD_Wish_Lists' ) ) {
			
			if ( class_exists( 'YITH_WCWL' ) ) {
				$wcwl_url = esc_url( YITH_WCWL()->get_wishlist_url() ); ?>
				<div class="btn-wish az-el-btn-wish azin-yith-wcwl-btn">
					<a href="<?php echo $wcwl_url; ?>" aria-label="<?php _e( 'Wishlist', 'azin-file' ); ?>" rel="nofollow" class="wish-icon" <?php if ( $show_hover_title ) { ?>data-toggle="tooltip" data-placement="top" title="<?php _e( 'Wishlist', 'azin-file' ); ?>"<?php } ?>>
						<i aria-hidden="true" class="fal fa-heart"></i>
						<?php if ( $show_items === 'yes' ) { ?>
						<span class="wish-amount"><?php echo do_shortcode( '[yith_wcwl_items_count]' ); ?></span>
						<?php } ?>
					</a>
				</div>
			<?php
			} elseif( class_exists( 'EDD_Wish_Lists' ) ) {
				$wish_url = azin_edd_whishlist_url(); ?>
				<div class="btn-wish az-el-btn-wish">
					<a href="<?php echo $wish_url; ?>" aria-label="<?php _e( 'Wishlist', 'azin-file' ); ?>" rel="nofollow" class="wish-icon" <?php if ( $show_hover_title ) { ?>data-toggle="tooltip" data-placement="top" title="<?php _e( 'Wishlist', 'azin-file' ); ?>"<?php } ?>>
						<i aria-hidden="true" class="fal fa-heart"></i>
					</a>
				</div>
		<?php 
			} 
		}
	}
}