<?php
namespace Elementor;

class Azin_Blog_Posts_Block extends Widget_Base {
	
	public function get_name() {
		return 'azin-blog-posts-block';
	}
	
	public function get_title() {
		return __( 'Blog post block', 'azin-file' );
	}
	
	public function get_icon() {
		return 'fal fa-file-alt';
	}
	
	public function get_categories() {
		return [ 'azin-file' ];
	}
	
	protected function register_controls() {

		require get_template_directory() . '/includes/el-widgets/fa.php';

		$post_cat = array();

		$categories = get_terms( array(
			'taxonomy'   => 'category',
			'hide_empty' => false,
		) );

		if ( ! empty( $categories ) && !is_wp_error( $categories ) ) {
			foreach ( $categories as $category ) {
				$post_cat[ $category->term_id ] = $category->name;
			}
		}

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Blog post block', 'azin-file' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'azin-file' ),
				'label_block' => true,
				'default'     => __( 'Posts', 'azin-file' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter the title', 'azin-file' ),
			]
		);

		$this->add_control(
			'post_sort',
			[
				'label'   => __( 'Sort posts', 'azin-file' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'         => __( 'Recent Posts', 'azin-file' ),
					'latest-updated' => __( 'Latest updated posts', 'azin-file' ),
					'random'         => __( 'Random posts', 'azin-file' ),
					'viewed'         => __( 'Popular posts', 'azin-file' ),
				],
			]
		);

		$this->add_control(
			'post_filter',
			[
				'label'   => __( 'Post filtering', 'azin-file' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'category',
				'options' => [
					'category' => __( 'Post category', 'azin-file' ),
					'tag'      => __( 'Post tag', 'azin-file' ),
				],
			]
		);

		$this->add_control(
			'post_cat',
			[
				'label'   => __( 'Post categories', 'azin-file' ),
				'type'    => Controls_Manager::SELECT2,
				'options' => $post_cat,
			]
		);

		$this->add_control(
			'post_tag',
			[
				'label'       => __( 'Post tags', 'azin-file' ),
				'description' => __( 'If you have defined the post filter on the tag, enter the desired tags in this box (separate the IDs with a "," sign, for example 145,12,6)', 'azin-file' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Tag(s) ID', 'azin-file' ),
				'condition'   => [
					'post_filter' => 'tag',
				]
			]
		);

		$this->add_control(
			'post_icon',
			[
				'label'   => __( 'Icon', 'azin-file' ),
				'type'    => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'file-alt'
			]
		);

		$this->add_control(
			'custom_icon',
			[
				'label' => __( 'Or custom icon (Suitable size: 32px by 32px)', 'azin-file' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'auto_play',
			[
				'label'        => __( 'Automatic movement', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'post_loop',
			[
				'label'        => __( 'Duplicate posts', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'ptotalcount',
			[
				'label'   => __( 'Number of posts', 'azin-file' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 1,
				'max'     => 50,
				'step'    => 1,
				'default' => 8,
			]
		);

		$this->add_control(
			'pcount',
			[
				'label'   => __( 'Number of post columns', 'azin-file' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 3,
				'max'     => 7,
				'step'    => 1,
				'default' => 4,
			]
		);

		$this->add_control(
			'view_all',
			[
				'label'        => __( 'Display view all button (If category selected)', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'view_all_link',
			[
				'label'         => __( 'View all button custom link', 'azin-file' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => __( 'https://your-link.com', 'azin-file' ),
				'show_external' => true,
				'default'       => [
					'url'         => '',
					'is_external' => true,
					'nofollow'    => false,
				],
				'condition'     => [
					'view_all' => 'yes',
				]
			]
        );

		$this->add_control(
			'link_title',
			[
				'label'        => __( 'Linking the title of the block (If category selected)', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'hide_no_post',
			[
				'label'        => __( 'Hide the block if there is no post', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {
		
		$settings      = $this->get_settings_for_display();
		$post_sort     = $settings['post_sort'];
		$post_filter   = $settings['post_filter'];
		$post_cat      = $settings['post_cat']; 
		$post_tag      = ( ! empty ( $settings['post_tag'] && $settings['post_tag'] != ' ' ) ? explode ( ",", $settings['post_tag'] ) : '' );
		$view_all_link = '';

		switch ( $post_sort) {
			case 'latest':
				$args = array(
				'posts_per_page' => $settings['ptotalcount'],
				'post_type' => 'post',
				'post_status' => 'publish',
				'order' => 'DESC'  );
				break;
			case 'latest-updated':
				$args = array(
				'posts_per_page' => $settings['ptotalcount'],
				'post_type' => 'post',
				'post_status' => 'publish',
				'orderby' => 'modified',
				'ignore_sticky_posts' => '1',
				'order' => 'DESC'  );
				break;
			case 'viewed':
				$args = array(
				'posts_per_page' => $settings['ptotalcount'],
				'post_type' => 'post',
				'post_status' => 'publish',
				'meta_key' => 'post_views_count',
				'orderby' => 'meta_value_num',
				'order' => 'DESC'  );
				break;
			case 'random':
				$args = array(
				'posts_per_page' => $settings['ptotalcount'],
				'post_type' => 'post',
				'post_status' => 'publish',
				'orderby'        => 'rand'  );
				break;
			default:
			$args = array(
				'posts_per_page' => $settings['ptotalcount'],
				'post_type' => 'post',
				'post_status' => 'publish',
				'order' => 'DESC'  );
		}

		if ( $post_filter == 'category' && ! empty ( $post_cat ) ) {
			$args['tax_query'] = array(
				array(
				'taxonomy' => 'category',
				'field'    => 'term_id',
				'terms'    => $post_cat
				)
			);
			$view_all_link = azin_get_term_links( 'category', $post_cat );
		} elseif ( $post_filter == 'tag' && ! empty ( $post_tag ) ) {
			$args['tax_query'] = array(
				array(
				'taxonomy' => 'post_tag',
				'field'    => 'term_id',
				'terms'    => $post_tag
				)
			);
			$view_all_link = azin_get_term_links( 'post_tag', $post_tag );
		}

		if ( 'yes' === $settings['view_all'] ) {
			if ( ! empty ( $settings['view_all_link']['url'] ) ) {
				$all_link = $settings['view_all_link']['url'];
			} elseif ( ! empty ( $view_all_link ) ) {
				$all_link = $view_all_link;
			} else {
				$all_link = "";
			}
		}

		$block_args = array(
			'block_title'      => $settings['title'],
			'block_title_link' => 'yes' === $settings['link_title'] && $all_link != '' ? $all_link : '',
			'block_view_all'   => $settings['view_all'] = 'yes' ? true : false,
			'block_view_link'  => $all_link,
			'block_icon'       => 'fal fa-'. $settings['post_icon'],
			'block_icon_img'   => ! empty ( $settings['custom_icon']['url'] ) ? $settings['custom_icon']['url'] : '',
			'block_itemscount' => $settings['pcount'],
			'block_itemplay'   => 'yes' === $settings['auto_play'] ? true : false,
			'block_itemloop'   => 'yes' === $settings['post_loop'] ? true : false,
			'block_query'      => $args,
			'block_hide'	   => 'yes' === $settings['hide_no_post'] ? true : false,
			'block_post_type'  => 'post'
		);

		azin_carousel_block( $block_args );

	}

}