<?php
namespace Elementor;

class Azin_Blog_Posts extends Widget_Base {
	
	public function get_name() {
		return 'azin-blog-posts';
	}
	
	public function get_title() {
		return __( 'Blog posts', 'azin-file' );
	}
	
	public function get_icon() {
		return 'fal fa-file-alt';
	}
	
	public function get_categories() {
		return [ 'azin-file' ];
	}
	
	protected function register_controls() {

		require get_template_directory() . '/includes/el-widgets/fa.php';

		$post_cat = array();

		$categories = get_terms( array(
			'taxonomy'   => 'category',
			'hide_empty' => false,
		) );

		if ( ! empty( $categories ) && !is_wp_error( $categories ) ) {
			foreach ( $categories as $category ) {
				$post_cat[ $category->term_id ] = $category->name;
			}
		}

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Blog posts', 'azin-file' ),
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'azin-file' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter the title', 'azin-file' ),
			]
		);

		$this->add_control(
			'post_sort',
			[
				'label'   => __( 'Sort posts', 'azin-file' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'         => __( 'Recent Posts', 'azin-file' ),
					'latest-updated' => __( 'Latest updated posts', 'azin-file' ),
					'random'         => __( 'Random posts', 'azin-file' ),
					'viewed'         => __( 'Popular posts', 'azin-file' ),
				],
			]
		);

		$this->add_control(
			'post_filter',
			[
				'label'   => __( 'Post filtering', 'azin-file' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'category',
				'options' => [
					'category' => __( 'Post category', 'azin-file' ),
					'tag'      => __( 'Post tag', 'azin-file' ),
				],
			]
		);

		$this->add_control(
			'post_cat',
			[
				'label'       => __( 'Post categories', 'azin-file' ),
				'description' => __( 'Empty categories (no product) are not displayed', 'azin-file' ),
				'type'        => Controls_Manager::SELECT2,
				'multiple'    => true,
				'options'     => $post_cat,
				'condition'   => [
					'post_filter' => 'category',
				]
			]
		);

		$this->add_control(
			'post_tag',
			[
				'label'       => __( 'Post tags', 'azin-file' ),
				'description' => __( 'If you have defined the post filter on the tag, enter the desired tags in this box (separate the IDs with a "," sign, for example 145,12,6)', 'azin-file' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Tag(s) ID', 'azin-file' ),
				'condition'   => [
					'post_filter' => 'tag',
				]
			]
		);

		$this->add_control(
			'post_icon',
			[
				'label'   => __( 'Icon', 'azin-file' ),
				'type'    => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'file-alt'
			]
		);

		$this->add_control(
			'custom_icon',
			[
				'label' => __( 'Or custom icon (Suitable size: 32px by 32px)', 'azin-file' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'ptotalcount',
			[
				'label'   => __( 'Number of posts', 'azin-file' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 1,
				'max'     => 54,
				'step'    => 1,
				'default' => 8,
			]
		);

		$this->add_control(
			'pcount',
			[
				'label'   => __( 'Number of column posts', 'azin-file' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 2,
				'max'     => 4,
				'step'    => 1,
				'default' => 4,
			]
		);

		$this->add_control(
			'hide_no_post',
			[
				'label'        => __( 'Hide the block if there is no post', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'middle_title',
			[
				'label' 	   => __( 'Show title in the middle', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'	   => 'yes',
			]
		);

		$this->add_control(
			'white_box',
			[
				'label' => __( 'White box style', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'view_all',
			[
				'label'        => __( 'Display view all button (If category or tag selected)', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'view_all_text',
			[
				'label'       => __( 'View all button text', 'azin-file' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Button Text', 'azin-file' ),
				'default'     => __( 'View All Posts', 'azin-file' ),
				'condition'   => [
					'view_all' => 'yes',
				]
			]
		);

		$this->add_control(
			'view_all_link',
			[
				'label'         => __( 'View all button custom link', 'azin-file' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => __( 'https://your-link.com', 'azin-file' ),
				'show_external' => true,
				'default'       => [
					'url'         => '',
					'is_external' => true,
					'nofollow'    => false,
				],
				'condition'     => [
					'view_all' => 'yes',
				]
			]
        );

		$this->end_controls_section();
	}
	
	protected function render() {
		
		$settings      = $this->get_settings_for_display();
		$post_sort     = $settings['post_sort'];
		$post_filter   = $settings['post_filter'];
		$post_cat      = $settings['post_cat'];
		$post_tag      = ( ! empty ( $settings['post_tag'] && $settings['post_tag'] != ' ' ) ? explode ( ",", $settings['post_tag'] ) : '' );
		$view_all_link = '';
		
		switch ( $settings['pcount'] ) {
			case 2:
				$col = 'col-6';
				break;
			case 3:
				$col = 'col-md-4 col-6';
				break;
			case 4:
				$col = 'col-lg-3 col-md-4 col-6';
				break;
		}

		switch ( $post_sort) {
			case 'latest':
				$args = array(
				'posts_per_page' => $settings['ptotalcount'],
				'post_type' => 'post',
				'post_status' => 'publish',
				'order' => 'DESC'  );
				break;
			case 'latest-updated':
				$args = array(
				'posts_per_page' => $settings['ptotalcount'],
				'post_type' => 'post',
				'post_status' => 'publish',
				'orderby' => 'modified',
				'ignore_sticky_posts' => '1',
				'order' => 'DESC'  );
				break;
			case 'viewed':
				$args = array(
				'posts_per_page' => $settings['ptotalcount'],
				'post_type' => 'post',
				'post_status' => 'publish',
				'meta_key' => 'post_views_count',
				'orderby' => 'meta_value_num',
				'order' => 'DESC'  );
				break;
			case 'random':
				$args = array(
				'posts_per_page' => $settings['ptotalcount'],
				'post_type' => 'post',
				'post_status' => 'publish',
				'orderby'        => 'rand'  );
				break;
			default:
			$args = array(
				'posts_per_page' => $settings['ptotalcount'],
				'post_type' => 'post',
				'post_status' => 'publish',
				'order' => 'DESC'  );
			}

			if ( $post_filter == 'category' && ! empty ( $post_cat ) ) {
				$args['tax_query'] = array(
					array(
					'taxonomy' => 'category',
					'field'    => 'term_id',
					'terms'    => $post_cat
					)
				);
				$view_all_link = azin_get_term_links( 'category', $post_cat );
			} elseif ( $post_filter == 'tag' && ! empty ( $post_tag ) ) {
				$args['tax_query'] = array(
					array(
					'taxonomy' => 'post_tag',
					'field'    => 'term_id',
					'terms'    => $post_tag
					)
				);
				$view_all_link = azin_get_term_links( 'post_tag', $post_tag );
			}
			
		$postsquery = new \WP_Query( $args );

		$block_classes  = 'row';
		$block_classes .= 'yes' === $settings['white_box'] ? ' white-box' : '';
		$block_classes .= 'yes' === $settings['middle_title'] ? ' azin-middle-title' : ' azin-right-title';

		?>

		<div class="<?php echo $block_classes ?>">

		<?php if ( $postsquery->have_posts() ) : ?>

		<?php if ( ! empty( $settings['title'] ) ) { ?>
		<div class="col-12 az-product-heading">
			<h2>
				<?php if( ! empty( $settings['custom_icon']['url'] ) ) { ?>
					<img src="<?php echo $settings['custom_icon']['url'] ?>" width="32" height="32" alt="<?php echo $settings['title'] ?>" class="cust-icon">
				<?php } elseif ( ! empty( $settings['post_icon'] ) ) { ?>
					<i class="fal fa-<?php echo $settings['post_icon'] ?>" aria-hidden="true"></i>
				<?php } ?>

				<?php echo $settings['title']; ?>
			</h2>
		</div>
		<?php } ?>

			<?php while ( $postsquery->have_posts() ) : $postsquery->the_post();
				azin_post_archive_content( get_the_ID(), $col );
			endwhile; ?>
			
			<div class="col-12">
				<?php
				if ( 'yes' === $settings['view_all'] ) {
					if ( ! empty ( $settings['view_all_link']['url'] ) ) {
						$all_link = $settings['view_all_link']['url'];
					} elseif ( ! empty ( $view_all_link ) ) {
						$all_link = $view_all_link;
					} else {
						$all_link = get_home_url(). '/?post_type=post&s=';
					}
					?>
					<a href="<?php echo $all_link; ?>" class="btn azin-btn btn-lg btn-view-all" title="<?php _e( 'View All Posts', 'azin-file' ); ?>">
						<i aria-hidden="true" class="fal fa-<?php echo $settings['post_icon']; ?>"></i>
							<?php echo $settings['view_all_text']; ?>
						<i class="fal fa-angle-left" aria-hidden="true"></i>
					</a>
				<?php
				}
				?>
			</div>
			<?php else :
				$no_post_class = ( 'yes' === $settings['hide_no_post'] ? ' not-azin-hide-section' : '' );
				?>
				<div class="alert alert-warning alert-dismissible anote<?php echo $no_post_class ?>">
					<strong>
						<span class="fal fa-bell" aria-hidden="true"></span>
						<?php echo azin_opt( 'text_not_found' ); ?>
					</strong>
				</div>
		<?php endif;
		wp_reset_postdata(); ?>
		</div>
        <?php
	}
}