<?php
namespace Elementor;

class Search_Box extends Widget_Base {
	
	public function get_name() {
		return 'search-box';
	}
	
	public function get_title() {
		return __( 'Search Box', 'azin-file' );
	}
	
	public function get_icon() {
		return 'fal fa-search';
	}
	
	public function get_categories() {
		return [ 'azin-file' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Search Box', 'azin-file' ),
			]
		); 

		$this->add_control(
			'ajax_search',
			[
				'label' => __( 'Enable Ajax Search', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'title',
			[
				'label' => __( 'Title', 'azin-file' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'placeholder' => __( 'Enter your title', 'azin-file' ),
			]
		);

		$this->add_control(
			'subtitle',
			[
				'label' => __( 'Subtitle', 'azin-file' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'placeholder' => __( 'Enter your subtitle', 'azin-file' ),
			]
		);
        
		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings_for_display();
		$ajax_search = ( 'yes' === $settings['ajax_search'] ? true : false );
	?>
        <div class="row az-elementor-search-box">
			<div class="col-xl-6 col-lg-8 col-md-8 col-sm-8 col-12">
				<h2 class="az-search-box-title">
					<?php echo $settings['title']; ?>
				</h2>
				<div class="az-search-box-subtitle">
					<?php echo $settings['subtitle']; ?>
				</div>
				<?php azin_search_form( 'col-12', 'searchforme', $ajax_search, 'searchsubmite' ); ?>
			</div>
        </div>
         <?php
	}
}