<?php
namespace Elementor;

class Our_Service_Box extends Widget_Base {
	
	public function get_name() {
		return 'our-service-box';
	}
	
	public function get_title() {
		return __( 'Service Box', 'azin-file' );
	}
	
	public function get_icon() {
		return 'fal fa-th-large';
	}
	
	public function get_categories() {
		return [ 'azin-file' ];
	}
	
	protected function register_controls() {
		require get_template_directory() . '/includes/el-widgets/fa.php';
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Service Box', 'azin-file' ),
			]
		);

		$this->add_control(
			'icon_top',
			[
				'label'        => __( 'Show icon at the top', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'trasparent_bg',
			[
				'label'        => __( 'Transparent background', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);
		
		$this->add_control(
			'title_one',
			[
				'label'       => __( 'Title of the first box', 'azin-file' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter the title of the first box', 'azin-file' ),
                'default'     => __( 'Secure payment', 'azin-file' ),
			]
		);

		$this->add_control(
			'subtitle_one',
			[
				'label'       => __( 'Description of the first box', 'azin-file' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter the description of the first box', 'azin-file' ),
                'default'     => __( 'By credit cards', 'azin-file' ),
			]
		);
		
		$this->add_control(
			'link_one',
			[
				'label'        => __( 'First link box', 'azin-file' ),
				'type'         => Controls_Manager::URL,
				'placeholder'   => __( 'https://your-link.com', 'azin-file' ),
				'show_external' => true,
				'default'       => [
					'url'         => '',
					'is_external' => false,
					'nofollow'    => false,
				],
			]
        );
		
		$this->add_control(
			'icon_one',
			[
				'label' => __( 'Icon', 'azin-file' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'credit-card'
			]
		);

		$this->add_control(
			'custom_icon_one',
			[
				'label' => __( 'Or custom icon (Suitable size: 64px by 64px)', 'azin-file' ),
				'type' => Controls_Manager::MEDIA,
			]
		);
        
        $this->add_control(
			'title_two',
			[
				'label' => __( 'Title of the second box', 'azin-file' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter the title of the second box', 'azin-file' ),
                'default' => __( 'Refund', 'azin-file' ),
			]
		);

		$this->add_control(
			'subtitle_two',
			[
				'label' => __( 'Description of the second box', 'azin-file' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter the description of the second box', 'azin-file' ),
                'default' => __( 'Up to 7 days', 'azin-file' ),
			]
		);
		
		$this->add_control(
			'link_two',
			[
				'label' => __( 'Second link box', 'azin-file' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'azin-file' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => false,
					'nofollow' => false,
				],
			]
        );
		
		$this->add_control(
			'icon_two',
			[
				'label' => __( 'Icon', 'azin-file' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'calendar-check'
			]
		);

		$this->add_control(
			'custom_icon_two',
			[
				'label' => __( 'Or custom icon (Suitable size: 64px by 64px)', 'azin-file' ),
				'type' => Controls_Manager::MEDIA,
			]
		);
        
        $this->add_control(
			'title_three',
			[
				'label' => __( 'Title of the third box', 'azin-file' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter the title of the third box', 'azin-file' ),
                'default' => __( 'Quality guarantee', 'azin-file' ),
			]
		);

		$this->add_control(
			'subtitle_three',
			[
				'label' => __( 'Description of the third box', 'azin-file' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter the description of the third box', 'azin-file' ),
                'default' => __( 'And lowest price', 'azin-file' ),
			]
		);
		
		$this->add_control(
			'link_three',
			[
				'label' => __( 'Third link box', 'azin-file' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'azin-file' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => false,
					'nofollow' => false,
				],
			]
        );
        
		$this->add_control(
			'icon_three',
			[
				'label' => __( 'Icon', 'azin-file' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'certificate'
			]
		);

		$this->add_control(
			'custom_icon_three',
			[
				'label' => __( 'Or custom icon (Suitable size: 64px by 64px)', 'azin-file' ),
				'type' => Controls_Manager::MEDIA,
			]
		);
        
        $this->add_control(
			'title_four',
			[
				'label' => __( 'Title of the fourth box', 'azin-file' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter the title of the fourth box', 'azin-file' ),
                'default' => __( 'Support', 'azin-file' ),
			]
		);

		$this->add_control(
			'subtitle_four',
			[
				'label' => __( 'Description of the fourth box', 'azin-file' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter the description of the fourth box', 'azin-file' ),
                'default' => __( '24 hours, 7 days a week', 'azin-file' ),
			]
		);
		
		$this->add_control(
			'link_four',
			[
				'label' => __( 'Fourth link box', 'azin-file' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'azin-file' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => false,
					'nofollow' => false,
				],
			]
        );
		
		$this->add_control(
			'icon_four',
			[
				'label' => __( 'Icon', 'azin-file' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'question-circle'
			]
		);

		$this->add_control(
			'custom_icon_four',
			[
				'label' => __( 'Or custom icon (Suitable size: 64px by 64px)', 'azin-file' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'title_five',
			[
				'label' => __( 'Title of the fifth box', 'azin-file' ),
				'label_block' => true,
				'description' => __( 'This icon is only displayed in home screen mode without sidebar and desktop mode.', 'azin-file' ),
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter the title of the fifth box', 'azin-file' ),
                'default' => __( 'Easy download', 'azin-file' ),
			]
		);

		$this->add_control(
			'subtitle_five',
			[
				'label' => __( 'Description of the fifth box', 'azin-file' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter the description of the fifth box', 'azin-file' ),
                'default' => __( 'After payment', 'azin-file' ),
			]
		);
		
		$this->add_control(
			'link_five',
			[
				'label' => __( 'Fifth link box', 'azin-file' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'azin-file' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => false,
					'nofollow' => false,
				],
			]
        );
		
		$this->add_control(
			'icon_five',
			[
				'label' => __( 'Icon', 'azin-file' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'download'
			]
		);

		$this->add_control(
			'custom_icon_five',
			[
				'label' => __( 'Or custom icon (Suitable size: 64px by 64px)', 'azin-file' ),
				'type' => Controls_Manager::MEDIA,
			]
		);
        
		$this->end_controls_section();
	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();
		$classes  = 'row ser-row';
		$classes .= $settings['icon_top'] == 'yes' ? ' azin-ser-icon-top' : ' azin-ser-icon-side';
		$classes .= $settings['trasparent_bg'] == 'yes' ? ' azin-ser-trasparent-bg' : ' azin-ser-white-bg';
        
		?>
		<!-- Services -->
			
            <div class="<?php echo $classes; ?>">

				<?php
				for ( $i = 1; $i <= 5; $i++ ) {
					switch ( $i ) {
						case 1:
						  	$number = 'one';
						  	break;
						case 2:
							$number = 'two';
						  	break;
						case 3:
						  	$number = 'three';
						  	break;
						case 4:
							$number = 'four';
							break;
						case 5:
							$number = 'five';
							break;
						default:
							$number = 'one';
					}
				?>

				<?php if ( ! empty( $settings['title_' . $number ] ) ) { ?>
				<div class="col ser-col azin-ser-col-<?php echo $number; ?>">
				<?php
					if ( ! empty( $settings['link_' . $number]['url'] ) ) {
						$target = ! empty ( $settings['link_' . $number ]['is_external'] ) ? ' target="_blank"' : '';
						$nofollow = ! empty ( $settings['link_' . $number ]['nofollow'] ) ? ' rel="nofollow"' : ''; 
					?>
					<a href="<?php echo $settings['link_' . $number]['url']; ?>" title="<?php echo $settings['title_' . $number ]; ?>"<?php echo $target . $nofollow; ?>>
				<?php } ?>
					<div class="ser-con">			
						<div class="col-md-3 col-12 ser-icon s<?php echo $number; ?>">
							<?php if( ! empty( $settings['custom_icon_' . $number ]['url'] ) ) { ?>
								<img src="<?php echo $settings['custom_icon_' . $number ]['url']; ?>" width="64" height="64" alt="<?php echo $settings['title_' . $number ]; ?>" class="ser-cust-icon">
							<?php } else { ?>
								<i class="fal fa-<?php echo $settings['icon_' . $number ]; ?>" aria-hidden="true"></i>
							<?php } ?>
						</div>
						<div class="col-md-9 col-12 ser-det">
							<span class="ser-title"><?php echo $settings['title_' . $number]; ?></span>
							<span class="ser-desc"><?php echo $settings['subtitle_' . $number]; ?></span>
						</div>
					</div>
				<?php if ( ! empty( $settings['link_' . $number]['url'] ) ) { ?>
					</a>
				<?php } ?>
				</div>
				<?php }
				}
				?>

			</div>
        <!-- Services -->
		 <?php
	}
}