<?php
namespace Elementor;

class Slider extends Widget_Base {
	
	public function get_name() {
		return 'slider';
	}
	
	public function get_title() {
		return __( 'Slider', 'azin-file' );
	}
	
	public function get_icon() {
		return 'fal fa-file-image';
	}
	
	public function get_categories() {
		return [ 'azin-file' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Slider', 'azin-file' ),
			]
		);
		
		$slider = new Repeater();

		$slider->add_control(
			'slide_title', [
				'label' 	  => __( 'Slide Title', 'azin-file' ),
				'type'		  => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$slider->add_control(
			'slide_description',
			[
				'label'		  => __( 'Slide description', 'azin-file' ),
				'type'		  => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);


		$slider->add_control(
			'slide_link',
			[
				'label'		    => __( 'Slide Link', 'azin-file' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => __( 'https://your-link.com', 'azin-file' ),
				'show_external' => true,
				'default'       => [
					'url'         => '#',
					'is_external' => true,
					'nofollow'    => false,
				],
			]
        );
        
        $slider->add_control(
			'slide_image',
			[
				'label'   => __( 'Image selection', 'azin-file' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'slides',
			[
				'label'   => __( 'Slides', 'azin-file' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $slider->get_controls(),
				'default' => [
					[
						'slide_title' => __( 'Slide Title', 'azin-file' ),
						'slide_link'  => __( 'https://your-link.com', 'azin-file' ),
					],
				],
				'title_field' => '{{{ slide_title }}}',
			]
		);

		$this->add_control(
			'fade_slide',
			[
				'label'  	   => __( 'Slider fade effect', 'azin-file' ),
				'type' 		   => Controls_Manager::SWITCHER,
				'label_on'	   => __( 'On', 'azin-file' ),
				'label_off'	   => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'	   => 'yes',
			]
		);

		$this->add_control(
			'show_arrows',
			[
				'label'		   => __( 'Show arrows', 'azin-file' ),
				'type'		   => Controls_Manager::SWITCHER,
				'label_on' 	   => __( 'On', 'azin-file' ),
				'label_off'	   => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'	   => 'yes',
			]
		);

		$this->add_control(
			'remove_white_border',
			[
				'label'		   => __( 'Remove the white border', 'azin-file' ),
				'type'		   => Controls_Manager::SWITCHER,
				'label_on' 	   => __( 'On', 'azin-file' ),
				'label_off'	   => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'	   => 'no',
			]
		);

		$this->add_control(
			'auto_play',
			[
				'label'        => __( 'Automatic movement', 'azin-file' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'azin-file' ),
				'label_off'    => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default'	   => 'yes',
			]
		);

		$this->add_control(
			'time',
			[
				'label'   => __( 'Speed of movement', 'azin-file' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 1000,
				'max'     => 20000,
				'step'    => 1000,
				'default' => 8000,
			]
		);
        
		$this->end_controls_section();
	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();
        
		?>
		<!-- start slider -->
		<div class="scon<?php if ( 'yes' === $settings['remove_white_border'] ) { echo ' az-slide-no-border'; } ?>">
			<div class="slide-con">
				<?php if ( $settings['slides'] ) { ?>
				<div class="slider_container"> 
					<div class="slider owl-carousel" <?php if ( 'yes' === $settings['fade_slide'] ) { echo 'data-fade="fadeOut"'; } ?> <?php if ( 'yes' === $settings['show_arrows'] ) { echo 'data-itemnavs="true"'; } else { echo 'data-itemnavs="false"'; } ?> <?php if ( 'yes' === $settings['auto_play'] ) { echo 'data-itemplay="true"'; } else { echo 'data-itemplay="false"'; } ?> data-itemtime="<?php echo $settings['time']; ?>" data-dir="<?php azin_rtl(); ?>">
						<?php 
						foreach (  $settings['slides'] as $item ) {
							$target = $item['slide_link']['is_external'] ? ' target="_blank"' : '';
							$nofollow = $item['slide_link']['nofollow'] ? ' rel="nofollow"' : ''; ?>
								<div class="item">
									<a href="<?php echo $item['slide_link']['url']; ?>" aria-label="<?php echo $item['slide_title']; ?>">
									<?php $image_attributes = wp_get_attachment_image_src( $item['slide_image']['id'], 'full' ); ?>
										<img src="<?php echo $item['slide_image']['url']; ?>" alt="<?php echo $item['slide_title']; ?>" width="<?php echo $image_attributes[1]; ?>" height="<?php echo $image_attributes[2]; ?>">
									</a>
									<?php if ( $item['slide_title'] != '' ) { ?>
										<div class="caption hidden-mobile"><?php echo $item['slide_title']; ?>
											<div class="desc"><?php echo $item['slide_description']; ?></div>
										</div>
									<?php } ?>
								</div>
						<?php } ?>
					</div>
				</div>
				<?php } else { 
						_e( 'Please first add a slide.', 'azin-file' );
					 } ?>
			</div>
		</div>
		<!-- end slider -->
        <?php
	}
}