<?php
namespace Elementor;

class Text_Box extends Widget_Base {
	
	public function get_name() {
		return 'text-box';
	}
	
	public function get_title() {
		return __( 'TextBox', 'azin-file' );
	}
	
	public function get_icon() {
		return 'fal fa-text';
	}
	
	public function get_categories() {
		return [ 'azin-file' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'TextBox', 'azin-file' ),
			]
		); 

		$this->add_control(
			'text_box',
			[
				'label' => __( 'Text', 'azin-file' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'placeholder' => __( 'Enter your text', 'azin-file' ),
			]
		);
        
		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
        <div class="shadow-box az-text-box">
            <div class="text-box-area"><?php echo do_shortcode( $settings['text_box'] ); ?></div>
        </div>
         <?php
	}
}